/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import java.util.ArrayList;
import java.util.List;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.support.llvm;
import org.llvm.support.simplify_type;

public final class CastingLlvmGlobals {
    private static final List<simplify_type> simplifiers = new ArrayList<simplify_type>();

    private static void initSimplifiers() {
        CastingLlvmGlobals.loadSimplifier("org.clang.ast.llvm.simplify_typeCanQual");
    }

    private static void loadSimplifier(String qualName) {
        try {
            Class<?> cls = Class.forName(qualName);
            simplifiers.add((simplify_type)cls.newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            llvm.errs().$out(ex.getMessage()).$out("\n");
        }
    }

    private static <T> T getSimplifiedValue(Object Val) {
        if (Val instanceof IntrusiveRefCntPtr) {
            return ((IntrusiveRefCntPtr)Val).get();
        }
        return (T)Val;
    }

    public static <X, Y> boolean isa(Class<X> cls, Y Val) {
        return cls.isInstance(CastingLlvmGlobals.getSimplifiedValue(Val));
    }

    public static <X, Y> X cast$NotSimpleType(Class<X> clsX, Y Val) {
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast<Ty>() argument of incompatible type!";
        return clsX.cast(CastingLlvmGlobals.getSimplifiedValue(Val));
    }

    public static <X, Y> X cast(Class<X> clsX, Y Val) {
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast<Ty>() argument of incompatible type!";
        return clsX.cast(CastingLlvmGlobals.getSimplifiedValue(Val));
    }

    public static <X, Y> X cast_or_null$NotSimpleType(Class<X> clsX, Y Val) {
        if (CastingLlvmGlobals.getSimplifiedValue(Val) == null) {
            return null;
        }
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast_or_null<Ty>() argument of incompatible type!";
        return CastingLlvmGlobals.cast(clsX, Val);
    }

    public static <X, Y> X cast_or_null(Class<X> clsX, Y Val) {
        if (CastingLlvmGlobals.getSimplifiedValue(Val) == null) {
            return null;
        }
        assert (CastingLlvmGlobals.isa(clsX, Val)) : "cast_or_null<Ty>() argument of incompatible type!";
        return CastingLlvmGlobals.cast(clsX, Val);
    }

    public static <X, Y> X dyn_cast$NotSimpleType(Class<X> clsX, Y Val) {
        return CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    public static <X, Y> X dyn_cast(Class<X> clsX, Y Val) {
        return CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    public static <X, Y> X dyn_cast_or_null$NotSimpleType(Class<X> clsX, Y Val) {
        return Val != null && CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    public static <X, Y> X dyn_cast_or_null(Class<X> clsX, Y Val) {
        return Val != null && CastingLlvmGlobals.isa(clsX, Val) ? (X)CastingLlvmGlobals.cast(clsX, Val) : null;
    }

    static {
        CastingLlvmGlobals.initSimplifiers();
    }
}

