/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JFileChooser
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 3162921138695327837L;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CUSTOM_DIALOG = 2;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String APPROVE_SELECTION = "ApproveSelection";
    public static final String APPROVE_BUTTON_TEXT_CHANGED_PROPERTY = "ApproveButtonTextChangedProperty";
    public static final String APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY = "ApproveButtonToolTipTextChangedProperty";
    public static final String APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY = "ApproveButtonMnemonicChangedProperty";
    public static final String CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY = "ControlButtonsAreShownChangedProperty";
    public static final String DIRECTORY_CHANGED_PROPERTY = "directoryChanged";
    public static final String SELECTED_FILE_CHANGED_PROPERTY = "SelectedFileChangedProperty";
    public static final String SELECTED_FILES_CHANGED_PROPERTY = "SelectedFilesChangedProperty";
    public static final String MULTI_SELECTION_ENABLED_CHANGED_PROPERTY = "MultiSelectionEnabledChangedProperty";
    public static final String FILE_SYSTEM_VIEW_CHANGED_PROPERTY = "FileSystemViewChanged";
    public static final String FILE_VIEW_CHANGED_PROPERTY = "fileViewChanged";
    public static final String FILE_HIDING_CHANGED_PROPERTY = "FileHidingChanged";
    public static final String FILE_FILTER_CHANGED_PROPERTY = "fileFilterChanged";
    public static final String FILE_SELECTION_MODE_CHANGED_PROPERTY = "fileSelectionChanged";
    public static final String ACCESSORY_CHANGED_PROPERTY = "AccessoryChangedProperty";
    public static final String ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY = "acceptAllFileFilterUsedChanged";
    public static final String DIALOG_TITLE_CHANGED_PROPERTY = "DialogTitleChangedProperty";
    public static final String DIALOG_TYPE_CHANGED_PROPERTY = "DialogTypeChangedProperty";
    public static final String CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY = "ChoosableFileFilterChangedProperty";
    protected AccessibleContext accessibleContext;
    private FileSystemView fsv;
    private JComponent accessory;
    private int approveButtonMnemonic;
    private String approveButtonText;
    private String approveButtonToolTipText;
    private ArrayList choosableFilters;
    private boolean isAcceptAll;
    private String dialogTitle;
    private int dialogType;
    private int retval;
    private boolean multiSelection;
    private boolean fileHiding;
    private int fileSelectionMode;
    private FileView fv;
    private boolean controlButtonsShown;
    private File currentDir;
    private FileFilter currentFilter;
    private File[] selectedFiles;
    private File selectedFile;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    protected void setup(FileSystemView view) {
        if (view == null) {
            view = FileSystemView.getFileSystemView();
        }
        this.setFileSystemView(view);
        this.updateUI();
    }

    public void setDragEnabled(boolean b) {
    }

    public boolean getDragEnabled() {
        return false;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(File file) {
        if (this.selectedFile != file) {
            File old = this.selectedFile;
            this.selectedFile = file;
            this.firePropertyChange(SELECTED_FILE_CHANGED_PROPERTY, old, this.selectedFile);
        }
    }

    public File[] getSelectedFiles() {
        if (this.selectedFiles != null) {
            return this.selectedFiles;
        }
        if (this.selectedFile != null) {
            return new File[]{this.selectedFile};
        }
        return null;
    }

    public void setSelectedFiles(File[] selectedFiles) {
        if (this.selectedFiles != selectedFiles) {
            File[] old = this.selectedFiles;
            this.selectedFiles = selectedFiles;
            this.firePropertyChange(SELECTED_FILES_CHANGED_PROPERTY, old, selectedFiles);
        }
        if (selectedFiles != null) {
            this.setSelectedFile(selectedFiles[0]);
        }
    }

    public File getCurrentDirectory() {
        return this.currentDir;
    }

    public void setCurrentDirectory(File dir) {
        if (this.currentDir != dir || dir == null) {
            if (dir == null) {
                dir = this.fsv.getDefaultDirectory();
            }
            File old = this.currentDir;
            this.currentDir = dir;
            this.firePropertyChange(DIRECTORY_CHANGED_PROPERTY, old, this.currentDir);
        }
    }

    public void changeToParentDirectory() {
        if (this.fsv.getParentDirectory(this.currentDir) != null) {
            this.setCurrentDirectory(this.fsv.getParentDirectory(this.currentDir));
        }
    }

    public void rescanCurrentDirectory() {
        this.getUI().rescanCurrentDirectory(this);
    }

    public void ensureFileIsVisible(File f) {
        this.getUI().ensureFileIsVisible(this, f);
    }

    public int showOpenDialog(Component parent) throws HeadlessException {
        JDialog d = this.createDialog(parent);
        d.setTitle("Open");
        this.setDialogType(0);
        this.retval = -1;
        d.pack();
        d.show();
        return this.retval;
    }

    public int showSaveDialog(Component parent) throws HeadlessException {
        JDialog d = this.createDialog(parent);
        this.setDialogType(1);
        this.retval = -1;
        d.pack();
        d.show();
        return this.retval;
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        JDialog d = this.createDialog(parent);
        this.setApproveButtonText(approveButtonText);
        this.setDialogType(2);
        this.retval = -1;
        d.pack();
        d.show();
        return this.retval;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        Frame toUse;
        Class clazz = class$java$awt$Frame;
        if (clazz == null) {
            clazz = class$java$awt$Frame = JFileChooser.class("[Ljava.awt.Frame;", false);
        }
        if ((toUse = (Frame)SwingUtilities.getAncestorOfClass(clazz, parent)) == null) {
            toUse = SwingUtilities.getOwnerFrame();
        }
        JDialog dialog = new JDialog(toUse);
        this.setSelectedFile(null);
        dialog.getContentPane().add(this);
        dialog.setModal(true);
        dialog.invalidate();
        dialog.repaint();
        return dialog;
    }

    public boolean getControlButtonsAreShown() {
        return this.controlButtonsShown;
    }

    public void setControlButtonsAreShown(boolean b) {
        if (this.controlButtonsShown != b) {
            this.controlButtonsShown = b;
            this.firePropertyChange(CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY, this.controlButtonsShown ^ true, this.controlButtonsShown);
        }
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int dialogType) {
        if (dialogType != 0 && dialogType != 1 && dialogType != 2) {
            throw new IllegalArgumentException("Choose allowable dialogType.");
        }
        if (this.dialogType != dialogType) {
            int old = this.dialogType;
            this.dialogType = dialogType;
            this.firePropertyChange(DIALOG_TYPE_CHANGED_PROPERTY, old, this.dialogType);
        }
    }

    public void setDialogTitle(String dialogTitle) {
        if (this.dialogTitle != dialogTitle) {
            String old = this.dialogTitle;
            this.dialogTitle = dialogTitle;
            this.firePropertyChange(DIALOG_TITLE_CHANGED_PROPERTY, old, this.dialogTitle);
        }
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setApproveButtonToolTipText(String toolTipText) {
        if (this.approveButtonToolTipText != toolTipText) {
            String oldText = this.approveButtonToolTipText;
            this.approveButtonToolTipText = toolTipText;
            this.firePropertyChange(APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY, oldText, this.approveButtonToolTipText);
        }
    }

    public String getApproveButtonToolTipText() {
        return this.approveButtonToolTipText;
    }

    public int getApproveButtonMnemonic() {
        return this.approveButtonMnemonic;
    }

    public void setApproveButtonMnemonic(int mnemonic) {
        if (this.approveButtonMnemonic != mnemonic) {
            int oldMnemonic = this.approveButtonMnemonic;
            this.approveButtonMnemonic = mnemonic;
            this.firePropertyChange(APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY, oldMnemonic, this.approveButtonMnemonic);
        }
    }

    public void setApproveButtonMnemonic(char mnemonic) {
        this.setApproveButtonMnemonic((int)Character.toUpperCase(mnemonic));
    }

    public void setApproveButtonText(String approveButtonText) {
        if (this.approveButtonText != approveButtonText) {
            String oldText = this.approveButtonText;
            this.approveButtonText = approveButtonText;
            this.firePropertyChange(APPROVE_BUTTON_TEXT_CHANGED_PROPERTY, oldText, this.approveButtonText);
        }
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public FileFilter[] getChoosableFileFilters() {
        return (FileFilter[])this.choosableFilters.toArray(new FileFilter[this.choosableFilters.size()]);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        FileFilter[] old = this.getChoosableFileFilters();
        this.choosableFilters.add(filter);
        FileFilter[] newFilters = this.getChoosableFileFilters();
        this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, old, newFilters);
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        FileFilter[] old = this.getChoosableFileFilters();
        if (!this.choosableFilters.remove(f)) {
            return false;
        }
        FileFilter[] newFilters = this.getChoosableFileFilters();
        this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, old, newFilters);
        return true;
    }

    public void resetChoosableFileFilters() {
        this.choosableFilters.clear();
        this.choosableFilters.add(this.getUI().getAcceptAllFileFilter(this));
        this.setFileFilter((FileFilter)this.choosableFilters.get(0));
    }

    public FileFilter getAcceptAllFileFilter() {
        return this.getUI().getAcceptAllFileFilter(this);
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.isAcceptAll;
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
        if (this.isAcceptAll != b) {
            this.isAcceptAll = b;
            this.firePropertyChange(ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY, this.isAcceptAll ^ true, this.isAcceptAll);
        }
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    public void setAccessory(JComponent newAccessory) {
        if (this.accessory != newAccessory) {
            JComponent old = this.accessory;
            this.accessory = newAccessory;
            this.firePropertyChange(ACCESSORY_CHANGED_PROPERTY, old, this.accessory);
        }
    }

    public void setFileSelectionMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Choose a correct file selection mode.");
        }
        if (this.fileSelectionMode != mode) {
            int old = this.fileSelectionMode;
            this.fileSelectionMode = mode;
            this.firePropertyChange(FILE_SELECTION_MODE_CHANGED_PROPERTY, old, this.fileSelectionMode);
        }
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public boolean isFileSelectionEnabled() {
        boolean bl = false;
        if (this.fileSelectionMode == 0 || this.fileSelectionMode == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isDirectorySelectionEnabled() {
        boolean bl = false;
        if (this.fileSelectionMode == 1 || this.fileSelectionMode == 2) {
            bl = true;
        }
        return bl;
    }

    public void setMultiSelectionEnabled(boolean b) {
        if (this.multiSelection != b) {
            this.multiSelection = b;
            this.firePropertyChange(MULTI_SELECTION_ENABLED_CHANGED_PROPERTY, this.multiSelection ^ true, this.multiSelection);
        }
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public boolean isFileHidingEnabled() {
        return this.fileHiding;
    }

    public void setFileHidingEnabled(boolean b) {
        if (this.fileHiding != b) {
            this.fileHiding = b;
            this.firePropertyChange(FILE_HIDING_CHANGED_PROPERTY, this.fileHiding ^ true, this.fileHiding);
        }
    }

    public void setFileFilter(FileFilter filter) {
        if (this.currentFilter != filter) {
            FileFilter old = this.currentFilter;
            this.currentFilter = filter;
            this.firePropertyChange(FILE_FILTER_CHANGED_PROPERTY, old, this.currentFilter);
        }
    }

    public FileFilter getFileFilter() {
        return this.currentFilter;
    }

    public void setFileView(FileView fileView) {
        if (this.fv != fileView) {
            FileView old = this.fv;
            this.fv = fileView;
            this.firePropertyChange(FILE_VIEW_CHANGED_PROPERTY, old, this.fv);
        }
    }

    public FileView getFileView() {
        return this.fv;
    }

    public String getName(File f) {
        String name = null;
        if (this.fv != null) {
            name = this.fv.getName(f);
        }
        if (name == null) {
            name = this.getUI().getFileView(this).getName(f);
        }
        return name;
    }

    public String getDescription(File f) {
        String result = null;
        if (this.fv != null) {
            result = this.fv.getDescription(f);
        }
        if (result == null) {
            result = this.getUI().getFileView(this).getDescription(f);
        }
        return result;
    }

    public String getTypeDescription(File f) {
        String result = null;
        if (this.fv != null) {
            result = this.getFileView().getTypeDescription(f);
        }
        if (result == null) {
            result = this.getUI().getFileView(this).getTypeDescription(f);
        }
        return result;
    }

    public Icon getIcon(File f) {
        Icon result = null;
        if (this.fv != null) {
            result = this.fv.getIcon(f);
        }
        if (result == null) {
            result = this.getUI().getFileView(this).getIcon(f);
        }
        return result;
    }

    public boolean isTraversable(File f) {
        return this.getFileSystemView().isTraversable(f);
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        return this.getFileFilter().accept(f);
    }

    public void setFileSystemView(FileSystemView fsv) {
        if (this.fsv != fsv) {
            FileSystemView old = this.fsv;
            this.fsv = fsv;
            this.firePropertyChange(FILE_SYSTEM_VIEW_CHANGED_PROPERTY, old, this.fsv);
        }
    }

    public FileSystemView getFileSystemView() {
        return this.fsv;
    }

    public void approveSelection() {
        this.retval = 0;
        this.fireActionPerformed(APPROVE_SELECTION);
    }

    public void cancelSelection() {
        this.retval = 1;
        this.fireActionPerformed(CANCEL_SELECTION);
    }

    public void addActionListener(ActionListener l) {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = JFileChooser.class("[Ljava.awt.event.ActionListener;", false);
        }
        this.listenerList.add(clazz, l);
    }

    public void removeActionListener(ActionListener l) {
        try {
            Class clazz = class$java$awt$event$ActionListener;
            if (clazz == null) {
                clazz = class$java$awt$event$ActionListener = JFileChooser.class("[Ljava.awt.event.ActionListener;", false);
            }
            this.listenerList.remove(clazz, l);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public ActionListener[] getActionListeners() {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = JFileChooser.class("[Ljava.awt.event.ActionListener;", false);
        }
        return (ActionListener[])this.getListeners(clazz);
    }

    protected void fireActionPerformed(String command) {
        ActionListener[] list2 = this.getActionListeners();
        ActionEvent event = new ActionEvent(this, 1001, command);
        int i = 0;
        while (i < list2.length) {
            list2[i].actionPerformed(event);
            ++i;
        }
    }

    public void updateUI() {
        this.setUI((FileChooserUI)UIManager.getUI(this));
        this.revalidate();
    }

    public String getUIClassID() {
        return "FileChooserUI";
    }

    public FileChooserUI getUI() {
        return (FileChooserUI)this.ui;
    }

    protected String paramString() {
        return "JFileChooser";
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJFileChooser();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.approveButtonMnemonic = 0;
        this.choosableFilters = new ArrayList();
        this.isAcceptAll = true;
        this.dialogType = 0;
        this.retval = -1;
        this.multiSelection = false;
        this.fileHiding = true;
        this.fileSelectionMode = 2;
        this.fv = null;
        this.controlButtonsShown = true;
        this.currentDir = null;
        this.currentFilter = null;
    }

    public JFileChooser() {
        this.this();
        this.setup(null);
        this.setCurrentDirectory(null);
    }

    public JFileChooser(String currentDirectoryPath) {
        this.this();
        this.setup(null);
        this.setCurrentDirectory(this.fsv.createFileObject(currentDirectoryPath));
    }

    public JFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        this.this();
        this.setup(fsv);
        this.setCurrentDirectory(fsv.createFileObject(currentDirectoryPath));
    }

    public JFileChooser(File currentDirectory) {
        this.this();
        this.setup(null);
        this.setCurrentDirectory(currentDirectory);
    }

    public JFileChooser(FileSystemView fsv) {
        this.this();
        this.setup(fsv);
        this.setCurrentDirectory(null);
    }

    public JFileChooser(File currentDirectory, FileSystemView fsv) {
        this.this();
        this.setup(fsv);
        this.setCurrentDirectory(currentDirectory);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJFileChooser
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILE_CHOOSER;
        }

        protected AccessibleJFileChooser() {
        }
    }
}

