package TDS::Customizer;

use strict qw(vars);
use vars qw(@ISA
	    $EnableOnCGI);

use TDS;;
use TDS::DirInfo;
use TDS::Customizer::Selector;
@ISA = qw(TDS::Customizer::Selector);

$EnableOnCGI = 0;

sub initialize($)
{
    my $self = shift;
    
    $self->SUPER::initialize;
    $self->name("TDS Customizer");
    $self->is_root(1);
    $self->filename(GetCustomizeDir() . "/customize.ph");
    
    # Ident Info
    my $ident = new TDS::Customizer::Selector(name=>"IdentInfo");
    $ident->AddItem(name=>"TDS::IdentInfo::Title",
		    comment=>"title of diary",
		    type=>"string");
    $ident->AddItem(name=>"TDS::IdentInfo::AuthorName",
		    comment=>"author name",
		    type=>"string");
    $ident->AddItem(name=>"TDS::IdentInfo::MailAddress",
		    comment=>"mail address",
		    type=>"mailaddress");
    $ident->AddItem(name=>"TDS::IdentInfo::DiaryURL",
		    comment=>"diary url",
		    type=>"string");
    $self->Add($ident);
    
    # Representation
    my $rep = new TDS::Customizer::Selector(name=>"Representation");
    $rep->AddItem(name=>"TDS::Collection::AllowAllMonthly",
		  comment=>"allow all monthly access",
		  type=>"bool");
    $rep->AddItem(name=>"TDS::Collection::RecentNum",
		  type=>'int',
		  comment=>"display number in recent output");
    $rep->AddItem(name=>"TDS::Collection::ReverseInRecent",
		   type=>'bool',
		   comment=>"reverse topic in recent mode");
    $rep->AddItem(name=>"TDS::Collection::NeighbourNum",
		  type=>'int',
		  comment=>"display neighbour number on access to specified day");
    $rep->AddItem(name=>"TDS::Category::SpecifiedCategory",
		  type=>'string',
		  comment=>"limit showing the category");
    # replace
    $rep->AddItem(name=>"TDS::Collection::AutoReplace",
		  type=>'bool',
		  comment=>"auto replace");
    $rep->AddItem(name=>"TDS::Replacer::Base::EnableEscape",
		  type=>'bool',
		  comment=>"enable escaping in replacing");
    $rep->AddItem(name=>"TDS::Replacer::Base::AdvancedReplacing",
		  type=>'bool',
		  comment=>"advanced replacing");

    # style
    $rep->AddItem(name=>"TDS::Style::Name",
		  type=>'string',
		  comment=>"style name",
		  comment2=>"if you don't use style, input 'undef'");
    $self->Add($rep);
    
    ################
    # Parsing
    # parser
    my $parsing = new TDS::Customizer::Selector(name=>"Parsing");
    $parsing->AddItem(name=>"TDS::Tdf::Parser::AutoHttpLink",
		      type=>'bool',
		      comment=>"auto hyper linking");
    $parsing->AddItem(name=>"TDS::Tdf::Parser::AutoListing",
		      type=>'bool',
		      comment=>"auto parse listing");
    $parsing->AddItem(name=>"TDS::Tdf::Parser::ContinueLineByEscape",
		      type=>'bool',
		      comment=>"continue line by /\\\$/");
    $parsing->AddItem(name=>"TDS::Tdf::Parser::WarnReserved",
		      type=>'bool',
		      comment=>"warn if reserved command used");
    # for backward-compatible
    my $tmp;
    if ($TDS::Tdf::Parser::WarnReservedToStderr ||
	$TDS::Tdf::Parser::WarnReservedOnSecret){
	$tmp = 1;
    }
    $parsing->AddItem(name=>"TDS::Tdf::Command::WARNING::ShowOnlyAuthor",
		      type=>'bool',
		      data=>$tmp,
		      comment=>"show warning only in author access");
    $self->Add($parsing);
    ################
    # i18n
    # jcode
    my $i18n = new TDS::Customizer::Selector(name=>"i18n");
    $i18n->AddItem(name=>"TDS::Collection::TdfJcode",
		   type=>'string',
		   comment=>"jcode of tdf file",
		   comment2=>"euc,jis,sjis,undef");
    $i18n->AddItem(name=>"Skelton::OutputJcode",
		   type=>'string',
		   comment=>"output jcode from skelton",
		   comment2=>"euc,jis,sjis");
    $i18n->AddItem(name=>"Skelton::InputJcode",
		   type=>'string',
		   comment=>"input jcode for skelton",
		   comment2=>"euc,jis,sjis");
    $self->Add($i18n);
    ################
    # Extend feartur
    # pim
    my $extend = new TDS::Customizer::Selector(name=>"Extend Fearture");
    $extend->AddItem(name=>"TDS::PIM::Todo::MaxNum",
		     type=>'int',
		     comment=>"max display number as Todo");
    $extend->AddItem(name=>"TDS::PIM::Schedule::MaxNum",
		     type=>'int',
		     comment=>"max display number as Schedule");
    $extend->AddItem(name=>"TDS::PIM::Schedule::FutureLimitMonth",
		     type=>'int',
		     comment=>"future limit on display");
    $extend->AddItem(name=>"TDS::PIM::Schedule::FutureLimitMonthAsta",
		     type=>'int',
		     comment=>"future limit on display (specified by asta)");
    # search
    $extend->AddItem(name=>"TDS::Search::AllowAllSearch",
		     type=>"bool",
		     comment=>"allow all search to non-author");
    $extend->AddItem(name=>"TDS::Search::UseSignatureMethod",
		     type=>'bool',
		     comment=>"use signature search method");
    $extend->AddItem(name=>"TDS::Search::SignatureDir",
		     type=>"path",
		     no_cgi=>1,
		     comment=>"signature directory");

    # mail2tdf
    $extend->AddItem(name=>"TDS::Mail2Tdf::SignatureStart",
		     type=>"string",
		     comment=>"mail2tdf: signature starting string");

    $extend->AddItem(name=>"TDS::Mail2Tdf::AdditionalAcceptFromString",
		     type=>"string",
		     comment=>"mail2tdf: additional acceptable mail-address(camma separated)");
    
    $self->Add($extend);
    
    ################
    # System Setting
    # static
    my $system = new TDS::Customizer::Selector(name=>"System Setting");
    $system->AddItem(name=>"TDS::Static::HtmlDir",
		     type=>"path",
		     no_cgi=>1,
		     comment=>"directory HTML file located");
    $system->AddItem(name=>"TDS::Static::HtmlSuffix",
		     type=>"string",
		     no_cgi=>1,
		     comment=>"html suffix");
    $system->AddItem(name=>"TDS::Static::RecentHtml",
		     type=>"path",
		     no_cgi=>1,
		     comment=>"filename of recent html");
    # dynamic
#    $system->AddItem(name=>"TDS::Dynamic::PushAntennaString",
#		     type=>'string',
#		     comment=>"antenna pushing to on update(camma separated)");

    # logging
    $system->AddItem(name=>"TDS::Status::HostnameLookup",
		     type=>'bool',
		     comment=>"hostname lookup");
    
    $system->AddItem(name=>"TDS::AccessLog::Logging::RejectLogFlag",
		     type=>'bool',
		     comment=>"logging rejected agent");
    $system->AddItem(name=>"TDS::AccessLog::Logging::RobotLogFlag",
		     type=>'bool',
		     comment=>"logging robot agent");
    $system->AddItem(name=>"TDS::AccessLog::Logging::UpdateLogFlag",
		     type=>'bool',
		     comment=>"logging updateing");

    # cookie
    $system->AddItem(name=>"TDS::Cookie::Expires",
		     type=>'string',
		     comment=>"cookie expire");
    # cache
    $system->AddItem(name=>"TDS::Cache::Daily::SurvivalDays",
		     type=>'int',
		     comment=>"cache survival period");

    # last modified
    $system->AddItem(name=>"TDS::LastModified::ReflectPimData",
		     type=>'bool',
		     comment=>"reflect PIM data files to last-modified");
    
    $system->AddItem(name=>"TDS::LastModified::ReflectCommentData",
		     type=>'bool',
		     comment=>"reflect comment data files to last-modified");
    
    $self->Add($system);

    ################
    # Admin
    my $admin = new TDS::Customizer::Selector(name=>"Admin Setting");
    # password
    $admin->AddItem(name=>"TDS::Admin::Authorize::EnablePassword_wo_AuthorizedID",
		    type=>'bool',
		    comment=>'enable administration by password without authorized cookie ID');
    $admin->AddItem(name=>"TDS::Customizer::CGI::Enable",
		    type=>'bool',
		    no_cgi=>1,
		    comment=>'enable customizer.cgi');
    $admin->AddItem(name=>"TDS::Admin::FTP::Server",
		    type=>'string',
		    comment=>'FTP server name');
    $admin->AddItem(name=>"TDS::Admin::FTP::ServerDiaryDir",
		    type=>'path',
		    comment=>'diary dir on server',
		    comment2=>'if undefined, rely on normal diary dir');
    $admin->AddItem(name=>"TDS::Admin::FTP::ServerWebDir",
		    type=>'path',
		    comment=>'web dir on server',
		    comment2=>'if undefined, rely on normal web dir');
    $admin->AddItem(name=>"TDS::Admin::FTP::ServerCustomizeDir",
		    type=>'path',
		    comment=>'customize dir on server',
		    comment2=>'if undefined, rely on normal customize dir');
    $admin->AddItem(name=>"TDS::Admin::FTP::UserName",
		    type=>'string',
		    comment=>'user name on ftp server');
#    $admin->AddItem(name=>"TDS::Admin::WriteServer::WriteMethod",
#		    type=>'string',
#		    comment=>"write method to server: 'auto', 'ftp', 'direct'");
    $self->Add($admin);
}

1;

