/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.LineTable;
import gnu.classpath.jdwp.util.VariableTable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class MethodCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeLineTable(bb, os);
                    break;
                }
                case 2: {
                    this.executeVariableTable(bb, os);
                    break;
                }
                case 3: {
                    this.executeByteCodes(bb, os);
                    break;
                }
                case 4: {
                    this.executeIsObsolete(bb, os);
                    break;
                }
                case 5: {
                    this.executeVariableTableWithGeneric(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in Method Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private final void executeLineTable(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        ObjectId oid = this.idMan.readObjectId(bb);
        Method method = (Method)oid.getObject();
        LineTable lt = VMVirtualMachine.getLineTable(clazz, method);
        lt.write(os);
    }

    private final void executeVariableTable(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        ObjectId oid = this.idMan.readObjectId(bb);
        Method method = (Method)oid.getObject();
        VariableTable vt = VMVirtualMachine.getVarTable(clazz, method);
        vt.write(os);
    }

    private final void executeByteCodes(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        throw new NotImplementedException("Command ByteCodes not implemented.");
    }

    private final void executeIsObsolete(ByteBuffer bb, DataOutputStream os) throws IOException {
        os.writeBoolean(false);
    }

    private final void executeVariableTableWithGeneric(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }
}

