# Copyright (C) 2002-2003 Hewlett Packard
# Copyright (C) 2005 Jay Beale
# Copyright (C) 2005 Charlie Long, Delphi Research
# Licensed under the GNU General Public License

# This is to be pulled into the API to define tests
# currently these only work for HP-UX
# Needed for access to API routines getDistro;

require Bastille::API;
import Bastille::API;


$GLOBAL_TEST{'MiscellaneousDaemons'}{'nfs_server'} = 
    sub { 
	if (! -e &getGlobal('FILE',"chkconfig_nfs_server")) {
	    return $SKIPQ;
	} else {
	    return &B_is_service_off('nfs_server');
	}
    };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'nfs_client'} = 
    sub { 
	if (! -e &getGlobal('FILE',"chkconfig_nfs_client")) {
	    return $SKIPQ;
	} else {
	    return &B_is_service_off('nfs_client');
	}
    };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_ptydaemon'} = 
    sub { 
	&B_is_service_off('ptydaemon');
    };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_pwgrd'} = 
    sub { 
	if (! -e &getGlobal('FILE',"chkconfig_pwgrd")) {
	    return $SKIPQ;
	} else {
	    return &B_is_service_off('pwgr');
	}
    };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_rbootd'} = 
    sub { if (! -e &getGlobal('FILE',"chkconfig_rbootd")) {
             return $SKIPQ;
          } else {
             return &B_is_service_off('rbootd'); 
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'nis_server'} = 
    sub { if (! -e &getGlobal('FILE',"ypserv")) {
             return $SKIPQ;
          } else {
             return &B_is_service_off('ypserv');
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'nis_client'} = 
    sub { if (! -e &getGlobal('FILE',"chkconfig_ypbind")) {
             return $SKIPQ;
          } else {
             $oldnisdomain=&B_get_rc("NIS_DOMAIN");
             if (($oldnisdomain eq "") or ($oldnisdomain eq "\"\"")) {
                return &B_is_service_off('nis_client');
             } else {
                return $ASKQ;
             }
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'snmpd'} = 
    sub { if (! -e &getGlobal('FILE',"chkconfig_snmpd")) {
             return $SKIPQ;
          } else {
             return &B_is_service_off('snmpd');
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'xaccess'} = 
    sub { 
	# location of the Xconfig file
	my $xconfig = &getGlobal('BFILE',"Xconfig");
	# location of Bastille's Xaccess file
	my $xaccess = &getGlobal('BFILE',"Xaccess.bastille");
	
	# if Bastille's Xaccess file is referenced in Dt's Xconfig and
	#    Bastille's Xaccess file exists then
	if( (-e $xconfig) && 
	    (-e $xaccess) && 
	    (&B_match_line($xconfig,"Dtlogin\.accessFile:\\s+$xaccess")) ){
	    # don't ask the question
	    return 1;
	}
	else {
	    # otherwise ask the question
	    return 0;
	}

    };


$GLOBAL_TEST{'MiscellaneousDaemons'}{'minimalism'} = 
    sub {
	if( &GetDistro =~ "^HP-UX") {
	    my $testResults=1;
	    foreach my $test (keys %{$GLOBAL_TEST{'MiscellaneousDaemons'} }) {
		if($test !~ /minimalism/ ) {
		    $testResults = $testResults & &{$GLOBAL_TEST{'MiscellaneousDaemons'}{$test}};
		}
	    }
	    
	    return $testResults;
	    
	}
	else {
	    return undef;
	}
    };


$GLOBAL_TEST{'MiscellaneousDaemons'}{'diagnostics_localonly'} = 
    sub {
	if( &GetDistro =~ "^HP-UX") {
	    
	    if( (-e &getGlobal('FILE',"local_only")) ||
		(! -e &getGlobal('BIN',"diagnostic")) ||
		(! -e &getGlobal('BIN',"toggle_switch")) ) {
		return  $SKIPQ;
 	    }
	    else {
		return $ASKQ;
	    }
	}
    };


$GLOBAL_TEST{'MiscellaneousDaemons'}{'syslog_localonly'} = 
    sub {
	if( &GetDistro =~ "^HP-UX") {
	    my $opts = &B_get_rc("SYSLOGD_OPTS");
	    if ($opts =~ /-N/) {
		return $SKIPQ;
	    }
	    else { 
		return $ASKQ;
	    }
	}
    };
	

# Added for Linux auditing

$GLOBAL_TEST{'MiscellaneousDaemons'}{'apmd'} =
        sub { 
	    # Start out with $SKIPQ, changing this if we
	    # find an activated apmd or acpid.

	    my $return = $SKIPQ;

	    # Is there an init script for apmd?
	    if ( -e &getGlobal('FILE',"initd_apmd")) {

		# Is apmd on?
		unless (&B_is_service_off('apmd')) {
		    $return = $ASKQ;
		}
	    }

	    # Is there an init script for acpid?
	    if ( -e &getGlobal('FILE',"initd_acpid")) {

		# Is acpid on?
		unless (&B_is_service_off('acpid')) {
		    $return = $ASKQ;
		}
	    }

	    return($return);
	    
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'remotefs'} =
    sub {
    if( &GetDistro =~ "^RHEL") {
       if (! -e &getGlobal('FILE',"initd_nfs")) {
        return $SKIPQ;
        }
        else {
        return &B_is_service_off('nfs');
        }
     }
    elsif( &GetDistro =~ "^SESLES") {
        if (! -e &getGlobal('FILE',"initd_nfs")) {
        return $SKIPQ;
        }
        else {
        return &B_is_service_off('nfsserver');
        }
      }
};

#pcmcia in SUSE or RedHat

$GLOBAL_TEST{'MiscellaneousDaemons'}{'pcmcia'} =
    sub { 
	if (! -e &getGlobal('FILE',"initd_pcmcia")) {
	    return $SKIPQ;
	}
	else {
	    return &B_is_service_off('pcmcia');
	}
    };


$GLOBAL_TEST{'MiscellaneousDaemons'}{'dhcpd'} =
    sub { 
	if (! -e &getGlobal('FILE',"initd_dhcpd")) {
	    return $SKIPQ;
	}
	else {
	    return &B_is_service_off('dhcpd');
	}
    };


$GLOBAL_TEST{'MiscellaneousDaemons'}{'gpm'} =
    sub { 
	if (! -e &getGlobal('FILE',"initd_gpm")) {
	    return $SKIPQ;
	}
	else {
	    return &B_is_service_off('gpm');
	}
    };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'hpoj'} =
    sub { 
	if (! -e &getGlobal('FILE',"initd_hpoj")) {
	    return $SKIPQ;			
	}
	else {
	    return &B_is_service_off('hpoj');
	}
    };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'innd'} =
    sub { 
	if (! -e &getGlobal('FILE',"initd_innd")) {
	    return $SKIPQ;			
	}
	else {
	    return &B_is_service_off('inn');
	}
    };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'isdn'} =
    sub { 
	if (! -e &getGlobal('FILE',"initd_isdn")) {
	    return $SKIPQ;			
	}
	else {
	    return &B_is_service_off('isdn');
	}
    };

# RedHat uses kudzu to check for new hardware 
$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_kudzu'} =
        sub { if (! -e &getGlobal('FILE',"initd_kudzu")) {
                return $SKIPQ;
                }
                else {
                return &B_is_service_off('kudzu');
                }
        };

#SUSE Linux uses hwscan instead of kudzu to check for new hardware

$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_routed'} =
        sub { if (! -e &getGlobal('FILE',"initd_routed")) {
                return $SKIPQ;
                }
                else {
                return &B_is_service_off('routed');
                }
        };
$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_gated'} =
        sub { if (! -e &getGlobal('FILE',"initd_gated")) {
                return $SKIPQ;
                }
                else {
                return &B_is_service_off('gated');
                }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'rendezvous'} = 
	sub { 
	    my $pass = 1;

	    if ( -e  &getGlobal('FILE',"initd_mDNSResponder")) {
		if (&B_is_service_off('mDNSResponder') == $ASKQ) {
		    return $ASKQ;
		}
	    }

	    # On Fedora Core 5 (released Q1 2006), mDNSResponder has
	    # been replaced by two programs from avahi.org.
	    if ( -e  &getGlobal('FILE',"initd_avahi-daemon")) {
		if (&B_is_service_off('avahi-daemon') == $ASKQ) {
		    return $ASKQ;
		}
	    }
            if ( -e  &getGlobal('FILE',"initd_avahi-dnsconfd")) {
                if (&B_is_service_off('avahi-dnsconfd') == $ASKQ) {
                    return $ASKQ;
                }
            }

            return $SKIPQ;
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_bluetooth'} = 
	sub { 
	    if (! -e  &getGlobal('FILE',"initd_bluetooth")) {
                return $SKIPQ;
	    }
	    else {
                return &B_is_service_off('bluetooth');
	    }
        };

1;
