/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util.metric;

import java.util.ArrayList;
import org.apache.activemq.apollo.util.metric.Metric;
import org.apache.activemq.apollo.util.metric.Period;

public class MetricAggregator
extends Metric {
    ArrayList<Metric> metrics = new ArrayList();

    public MetricAggregator name(String name) {
        return (MetricAggregator)super.name(name);
    }

    public MetricAggregator unit(String unit) {
        return (MetricAggregator)super.unit(unit);
    }

    public void add(Metric metric) {
        this.metrics.add(metric);
        if (this.getUnit() != null) {
            metric.setUnit(this.getUnit());
        }
    }

    public boolean remove(Metric metric) {
        return this.metrics.remove(metric);
    }

    public void removeAllMetrics() {
        this.metrics.clear();
    }

    public Float average() {
        if (this.metrics.isEmpty()) {
            return null;
        }
        long rc = 0L;
        int count = 0;
        for (Metric metric : this.metrics) {
            rc += metric.counter();
            ++count;
        }
        return Float.valueOf((float)rc * 1.0f / (float)count);
    }

    public Float deviation() {
        if (this.metrics.isEmpty()) {
            return null;
        }
        long[] values = new long[this.metrics.size()];
        long sum = 0L;
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.metrics.get(i).counter();
            sum += values[i];
        }
        double mean = 1.0 * (double)sum / (double)values.length;
        double rc = 0.0;
        for (long value : values) {
            double v = (double)value - mean;
            rc += v * v;
        }
        return Float.valueOf((float)Math.sqrt(rc / (double)values.length));
    }

    public Float total(Period p) {
        return p.rate(this.total());
    }

    public long total() {
        long rc = 0L;
        for (Metric metric : this.metrics) {
            rc += metric.counter();
        }
        return rc;
    }

    public Long min() {
        if (this.metrics.isEmpty()) {
            return null;
        }
        long rc = Long.MAX_VALUE;
        for (Metric metric : this.metrics) {
            long t = metric.counter();
            if (t >= rc) continue;
            rc = t;
        }
        return rc;
    }

    public Long max() {
        if (this.metrics.isEmpty()) {
            return null;
        }
        long rc = Long.MIN_VALUE;
        for (Metric metric : this.metrics) {
            long t = metric.counter();
            if (t <= rc) continue;
            rc = t;
        }
        return rc;
    }

    public long counter() {
        return this.total();
    }

    public String getRateSummary(Period period) {
        return String.format("%s: total=%(,.2f, avg=%(,.2f, min=%(,.2f, max=%(,.2f in %s/s", this.getName(), period.rate(this.total()), period.rate(this.average()), period.rate(this.min()), period.rate(this.max()), this.getUnit());
    }

    public String getChildRateSummary(Period period) {
        StringBuilder rc = new StringBuilder();
        rc.append("{\n");
        for (Metric metric : this.metrics) {
            rc.append("  ");
            rc.append(metric.getRateSummary(period));
            rc.append("\n");
        }
        rc.append("}");
        return rc.toString();
    }

    public long reset() {
        long rc = 0L;
        for (Metric metric : this.metrics) {
            rc += metric.reset();
        }
        return rc;
    }
}

