/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.persistent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.logging.Logged;
import scala.util.logging.Logged$class;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.TopScope$;
import scala.xml.XML$;
import scala.xml.parsing.ConstructingParser$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001Y4Q!\u0001\u0002\u0002\u0002%\u0011\u0011cQ1dQ\u0016$g)\u001b7f'R|'/Y4f\u0015\t\u0019A!\u0001\u0006qKJ\u001c\u0018n\u001d;f]RT!!\u0002\u0004\u0002\u0007alGNC\u0001\b\u0003\u0015\u00198-\u00197b\u0007\u0001\u0019B\u0001\u0001\u0006\u00135A\u00111\u0002E\u0007\u0002\u0019)\u0011QBD\u0001\u0005Y\u0006twMC\u0001\u0010\u0003\u0011Q\u0017M^1\n\u0005Ea!A\u0002+ie\u0016\fG\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u00059An\\4hS:<'BA\f\u0007\u0003\u0011)H/\u001b7\n\u0005e!\"A\u0002'pO\u001e,G\r\u0005\u0002\u001c95\ta!\u0003\u0002\u001e\r\tY1kY1mC>\u0013'.Z2u\u0011!y\u0002A!b\u0001\n\u0013\u0001\u0013!\u00024jY\u0016\fT#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011r\u0011AA5p\u0013\t13E\u0001\u0003GS2,\u0007\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\r\u0019LG.Z\u0019!\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u0019a\u0014N\\5u}Q\u0011AF\f\t\u0003[\u0001i\u0011A\u0001\u0005\u0006?%\u0002\r!\t\u0005\ba\u0001\u0011\r\u0011\"\u0003!\u0003\u00151\u0017\u000e\\33\u0011\u0019\u0011\u0004\u0001)A\u0005C\u00051a-\u001b7fe\u0001Bq\u0001\u000e\u0001A\u0002\u0013%\u0001%A\u0004uQ\u00164\u0015\u000e\\3\t\u000fY\u0002\u0001\u0019!C\u0005o\u0005YA\u000f[3GS2,w\fJ3r)\tA4\b\u0005\u0002\u001cs%\u0011!H\u0002\u0002\u0005+:LG\u000fC\u0004=k\u0005\u0005\t\u0019A\u0011\u0002\u0007a$\u0013\u0007\u0003\u0004?\u0001\u0001\u0006K!I\u0001\ti\",g)\u001b7fA!)\u0001\t\u0001C\u0005\u0003\u000611o^5uG\"$\u0012\u0001\u000f\u0005\b\u0007\u0002\u0001\r\u0011\"\u0005E\u0003\u0015!\u0017N\u001d;z+\u0005)\u0005CA\u000eG\u0013\t9eAA\u0004C_>dW-\u00198\t\u000f%\u0003\u0001\u0019!C\t\u0015\u0006IA-\u001b:us~#S-\u001d\u000b\u0003q-Cq\u0001\u0010%\u0002\u0002\u0003\u0007Q\t\u0003\u0004N\u0001\u0001\u0006K!R\u0001\u0007I&\u0014H/\u001f\u0011\t\u000f=\u0003!\u0019!C\t!\u0006A\u0011N\u001c;feZ\fG.F\u0001R!\tY\"+\u0003\u0002T\r\t\u0019\u0011J\u001c;\t\rU\u0003\u0001\u0015!\u0003R\u0003%Ig\u000e^3sm\u0006d\u0007\u0005C\u0003X\u0001\u0011E\u0001,\u0001\u0007j]&$\u0018.\u00197O_\u0012,7/F\u0001Z!\rQVlX\u0007\u00027*\u0011ALB\u0001\u000bG>dG.Z2uS>t\u0017B\u00010\\\u0005!IE/\u001a:bi>\u0014\bC\u00011b\u001b\u0005!\u0011B\u00012\u0005\u0005\u0011qu\u000eZ3\t\u000b\u0011\u0004a\u0011\u0001-\u0002\u000b9|G-Z:\t\u000b\u0019\u0004a\u0011A4\u0002\u0011\u0011\u0002H.^:%KF$\"\u0001\u000f5\t\u000b%,\u0007\u0019A0\u0002\u0003\u0015DQa\u001b\u0001\u0007\u00021\f\u0011\u0002J7j]V\u001cH%Z9\u0015\u0005aj\u0007\"B5k\u0001\u0004y\u0006\"B8\u0001\t\u0013A\u0016\u0001\u00027pC\u0012DQ!\u001d\u0001\u0005\n\u0005\u000bAa]1wK\")1\u000f\u0001C!\u0003\u0006\u0019!/\u001e8\t\u000bU\u0004A\u0011A!\u0002\u000b\u0019dWo\u001d5")
public abstract class CachedFileStorage
extends Thread
implements Logged,
ScalaObject {
    private final File file1;
    private final File file2;
    private File theFile;
    private boolean dirty;
    private final int interval;

    @Override
    public void log(String msg) {
        Logged$class.log(this, msg);
    }

    private File file1() {
        return this.file1;
    }

    private File file2() {
        return this.file2;
    }

    private File theFile() {
        return this.theFile;
    }

    private void theFile_$eq(File file) {
        this.theFile = file;
    }

    private void switch() {
        File file = this.theFile();
        File file2 = this.file1();
        this.theFile_$eq(!(file != null ? !((Object)file).equals(file2) : file2 != null) ? this.file2() : this.file1());
    }

    public boolean dirty() {
        return this.dirty;
    }

    public void dirty_$eq(boolean bl) {
        this.dirty = bl;
    }

    public int interval() {
        return this.interval;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Iterator<Node> initialNodes() {
        Iterator<Node> iterator2;
        Tuple2<Boolean, Boolean> tuple2 = new Tuple2<Boolean, Boolean>(BoxesRunTime.boxToBoolean(this.file1().exists()), BoxesRunTime.boxToBoolean(this.file2().exists()));
        if (tuple2 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean(tuple2._1());
            boolean bl2 = BoxesRunTime.unboxToBoolean(tuple2._2());
            if (!bl) {
                if (!bl2) {
                    this.theFile_$eq(this.file1());
                    iterator2 = Iterator$.MODULE$.empty();
                    return iterator2;
                }
            } else if (bl) {
                if (bl2 && this.gd1$1()) {
                    this.theFile_$eq(this.file2());
                    iterator2 = this.load();
                    return iterator2;
                }
                this.theFile_$eq(this.file1());
                iterator2 = this.load();
                return iterator2;
            }
        }
        this.theFile_$eq(this.file2());
        iterator2 = this.load();
        return iterator2;
    }

    public abstract Iterator<Node> nodes();

    public abstract void $plus$eq(Node var1);

    public abstract void $minus$eq(Node var1);

    private Iterator<Node> load() {
        this.log(new StringBuilder().append((Object)"[load]\nloading ").append(this.theFile()).toString());
        BufferedSource src = Source$.MODULE$.fromFile(this.theFile(), Codec$.MODULE$.fallbackSystemCodec());
        this.log(new StringBuilder().append((Object)"parsing ").append(this.theFile()).toString());
        Node res = ConstructingParser$.MODULE$.fromSource(src, false).document().docElem().apply(0);
        this.switch();
        this.log("[load done]");
        return res.child().iterator();
    }

    private void save() {
        if (this.dirty()) {
            this.log(new StringBuilder().append((Object)"[save]\ndeleting ").append(this.theFile()).toString());
            this.theFile().delete();
            this.log(new StringBuilder().append((Object)"creating new ").append(this.theFile()).toString());
            this.theFile().createNewFile();
            FileOutputStream fos = new FileOutputStream(this.theFile());
            FileChannel c = fos.getChannel();
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(this.nodes().toList());
            Elem storageNode = new Elem(null, "nodes", Null$.MODULE$, topScope$, $buf);
            Writer w = Channels.newWriter((WritableByteChannel)c, "utf-8");
            XML$.MODULE$.write(w, storageNode, "utf-8", true, null);
            this.log(new StringBuilder().append((Object)"writing to ").append(this.theFile()).toString());
            w.close();
            c.close();
            fos.close();
            this.dirty_$eq(false);
            this.switch();
            this.log("[save done]");
        }
    }

    @Override
    public void run() {
        this.log(new StringBuilder().append((Object)"[run]\nstarting storage thread, checking every ").append(BoxesRunTime.boxToInteger(this.interval())).append((Object)" ms").toString());
        while (true) {
            Thread.sleep(this.interval());
            this.save();
        }
    }

    public void flush() {
        this.dirty_$eq(true);
        this.save();
    }

    private final boolean gd1$1() {
        return this.file1().lastModified() < this.file2().lastModified();
    }

    public CachedFileStorage(File file1) {
        this.file1 = file1;
        Logged$class.$init$(this);
        this.file2 = new File(file1.getParent(), new StringBuilder().append((Object)file1.getName()).append((Object)"$").toString());
        this.theFile = null;
        this.dirty = false;
        this.interval = 1000;
    }
}

