/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.ima4.IMA4State;

public class IMA4 {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1998.";
    public static int[] indexTable = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
    public static int[] stepsizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    public static int[] diffLUT = new int[1424];

    static void encode(byte[] indata, int inOffset, byte[] outdata, int outOffset, int len, IMA4State state, int stride) {
        int outputbuffer = 0;
        int valpred = state.valprev;
        int index = state.index;
        int step = stepsizeTable[index];
        boolean bufferstep = true;
        while (len > 0) {
            int sign;
            int temp = indata[inOffset++] & 0xFF;
            int val = indata[inOffset++] << 8 | temp;
            inOffset += stride;
            int diff = val - valpred;
            if (diff < 0) {
                sign = 8;
                diff = -diff;
            } else {
                sign = 0;
            }
            int delta = 0;
            int vpdiff = step >> 3;
            if (diff >= step) {
                delta = 4;
                diff -= step;
                vpdiff += step;
            }
            if (diff >= (step >>= 1)) {
                delta |= 2;
                diff -= step;
                vpdiff += step;
            }
            if (diff >= (step >>= 1)) {
                delta |= 1;
                vpdiff += step;
            }
            valpred = sign != 0 ? (valpred -= vpdiff) : (valpred += vpdiff);
            if (valpred > Short.MAX_VALUE) {
                valpred = Short.MAX_VALUE;
            } else if (valpred < Short.MIN_VALUE) {
                valpred = Short.MIN_VALUE;
            }
            if ((index += indexTable[delta |= sign]) < 0) {
                index = 0;
            } else if (index > 88) {
                index = 88;
            }
            step = stepsizeTable[index];
            if (bufferstep) {
                outputbuffer = delta;
            } else {
                outdata[outOffset++] = (byte)(delta << 4 | outputbuffer);
            }
            bufferstep = !bufferstep;
            --len;
        }
        if (bufferstep) {
            outdata[outOffset++] = (byte)outputbuffer;
        }
        state.valprev = valpred;
        state.index = index;
    }

    public static void decode(byte[] indata, int inOffset, byte[] outdata, int outOffset, int len, IMA4State state, int stride) {
        int index;
        int inputbuffer = 0;
        boolean bufferstep = false;
        byte[] outp = outdata;
        byte[] inp = indata;
        int valpred = state.valprev;
        int lastIndex = index = state.index;
        while (len > 0) {
            int delta;
            if (bufferstep) {
                delta = inputbuffer >> 4 & 0xF;
            } else {
                inputbuffer = inp[inOffset++];
                delta = inputbuffer & 0xF;
            }
            boolean bl = bufferstep = !bufferstep;
            if ((index += indexTable[delta]) < 0) {
                index = 0;
            } else if (index > 88) {
                index = 88;
            }
            if ((valpred += diffLUT[(lastIndex << 4) + delta]) > Short.MAX_VALUE) {
                valpred = Short.MAX_VALUE;
            } else if (valpred < Short.MIN_VALUE) {
                valpred = Short.MIN_VALUE;
            }
            lastIndex = index;
            outp[outOffset++] = (byte)(valpred >> 8);
            outp[outOffset++] = (byte)valpred;
            outOffset += stride;
            --len;
        }
        state.valprev = valpred;
        state.index = index;
    }

    static {
        int delta = 0;
        while (delta < 16) {
            int lastIndex = 0;
            while (lastIndex <= 88) {
                int sign = delta & 8;
                int step = stepsizeTable[lastIndex];
                int vpdiff = step >> 3;
                if ((delta & 4) != 0) {
                    vpdiff += step;
                }
                if ((delta & 2) != 0) {
                    vpdiff += step >> 1;
                }
                if ((delta & 1) != 0) {
                    vpdiff += step >> 2;
                }
                if (sign != 0) {
                    vpdiff = -vpdiff;
                }
                IMA4.diffLUT[(lastIndex << 4) + delta] = vpdiff;
                ++lastIndex;
            }
            ++delta;
        }
    }
}

