/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;

public abstract class FreeColGameObject
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(FreeColGameObject.class.getName());
    private Game game;
    private boolean disposed = false;
    private boolean uninitialized;

    public FreeColGameObject(Game game) {
        if (game != null) {
            this.game = game;
            this.internId(this.getXMLTagName() + ":" + game.getNextId());
        } else if (this instanceof Game) {
            this.game = (Game)this;
            this.setId("0");
        } else {
            throw new IllegalArgumentException("FCGO with null game.");
        }
        this.uninitialized = this.getId() == null;
    }

    public FreeColGameObject(Game game, String id) {
        if (game == null) {
            throw new IllegalArgumentException("FCGO(id=" + id + ") with null game");
        }
        this.game = game;
        if (id != null) {
            this.internId(id);
        }
        this.uninitialized = true;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public boolean isUninitialized() {
        return this.uninitialized;
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    public List<FreeColGameObject> getDisposeList() {
        ArrayList<FreeColGameObject> fcgos = new ArrayList<FreeColGameObject>();
        fcgos.add(this);
        return fcgos;
    }

    public final void fundamentalDispose() {
        this.getGame().removeFreeColGameObject(this.getId(), "dispose");
        this.disposed = true;
    }

    public void disposeResources() {
        this.fundamentalDispose();
    }

    public final void dispose() {
        if (this.disposed) {
            return;
        }
        LogBuilder lb = new LogBuilder(64);
        lb.add("Destroying:");
        for (FreeColGameObject fcgo : this.getDisposeList()) {
            lb.add(" ", fcgo.getId());
            fcgo.disposeResources();
        }
        lb.log(logger, Level.INFO);
    }

    public <T extends FreeColGameObject> T cloneFreeColGameObject(Class<T> returnClass) {
        Game game = this.getGame();
        try {
            String xml = this.serialize();
            Field nextId = Game.class.getDeclaredField("nextId");
            nextId.setAccessible(true);
            int id = nextId.getInt(game);
            nextId.setInt(game, id + 1);
            xml = xml.replace(this.getId(), FreeColGameObject.getXMLElementTagName() + ":" + id);
            return (T)((FreeColGameObject)game.unserialize(xml, returnClass));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to clone " + this.getId(), e);
            return null;
        }
    }

    public FreeColGameObject getLinkTarget(Player player) {
        return null;
    }

    public int checkIntegrity(boolean fix) {
        return 1;
    }

    @Override
    public final void internId(String newId) {
        if (this.game != null && !(this instanceof Game)) {
            if (!newId.equals(this.getId())) {
                Object ret = null;
                if (this.getId() != null) {
                    this.game.removeFreeColGameObject(this.getId(), "override");
                }
                this.setId(newId);
                this.game.setFreeColGameObject(newId, this);
            }
        } else {
            this.setId(newId);
        }
    }

    @Override
    public Specification getSpecification() {
        return this.game == null ? null : this.game.getSpecification();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FreeColGameObject) {
            FreeColGameObject fco = (FreeColGameObject)o;
            return this.getGame() == fco.getGame() && super.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + Utils.hashCode(this.game);
    }

    @Override
    public final void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        this.uninitialized = false;
        super.readFromXML(xr);
    }

    public static String getXMLElementTagName() {
        return "unknown";
    }
}

