<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTube;

class ActivityContentDetailsRecommendation extends \Google\Model
{
  public $reason;
  protected $resourceIdType = ResourceId::class;
  protected $resourceIdDataType = '';
  protected $seedResourceIdType = ResourceId::class;
  protected $seedResourceIdDataType = '';

  public function setReason($reason)
  {
    $this->reason = $reason;
  }
  public function getReason()
  {
    return $this->reason;
  }
  /**
   * @param ResourceId
   */
  public function setResourceId(ResourceId $resourceId)
  {
    $this->resourceId = $resourceId;
  }
  /**
   * @return ResourceId
   */
  public function getResourceId()
  {
    return $this->resourceId;
  }
  /**
   * @param ResourceId
   */
  public function setSeedResourceId(ResourceId $seedResourceId)
  {
    $this->seedResourceId = $seedResourceId;
  }
  /**
   * @return ResourceId
   */
  public function getSeedResourceId()
  {
    return $this->seedResourceId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ActivityContentDetailsRecommendation::class, 'Google_Service_YouTube_ActivityContentDetailsRecommendation');
