/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupTable;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class LookupOp
implements BufferedImageOp,
RasterOp {
    private LookupTable lut;
    private RenderingHints hints;

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int[] dbuf;
        if (src.getColorModel() instanceof IndexColorModel) {
            throw new IllegalArgumentException("LookupOp.filter: IndexColorModel not allowed");
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, src.getColorModel());
        }
        BufferedImage tgt = dst.getColorModel().equals(src.getColorModel()) ? dst : this.createCompatibleDestImage(src, src.getColorModel());
        WritableRaster sr = src.getRaster();
        WritableRaster dr = tgt.getRaster();
        if (src.getColorModel().hasAlpha() && (this.lut.getNumComponents() == 1 || this.lut.getNumComponents() == src.getColorModel().getNumColorComponents())) {
            dbuf = new int[src.getColorModel().getNumComponents()];
            int tmpBands = src.getColorModel().getNumColorComponents();
            int[] tmp = new int[tmpBands];
            int y = src.getMinY();
            while (y < src.getHeight() + src.getMinY()) {
                int x = src.getMinX();
                while (x < src.getWidth() + src.getMinX()) {
                    sr.getPixel(x, y, dbuf);
                    System.arraycopy(dbuf, 0, tmp, 0, tmpBands);
                    dr.setPixel(x, y, this.lut.lookupPixel(tmp, dbuf));
                    ++x;
                }
                ++y;
            }
        } else if (this.lut.getNumComponents() != 1 && this.lut.getNumComponents() != src.getColorModel().getNumComponents()) {
            throw new IllegalArgumentException("LookupOp.filter: Incompatible lookup table and source image");
        }
        dbuf = new int[src.getColorModel().getNumComponents()];
        int y = src.getMinY();
        while (y < src.getHeight() + src.getMinY()) {
            int x = src.getMinX();
            while (x < src.getWidth() + src.getMinX()) {
                dr.setPixel(x, y, this.lut.lookupPixel(sr.getPixel(x, y, dbuf), dbuf));
                ++x;
            }
            ++y;
        }
        if (tgt != dst) {
            Graphics2D gg = dst.createGraphics();
            gg.setRenderingHints(this.hints);
            gg.drawImage((Image)tgt, 0, 0, null);
            gg.dispose();
        }
        return dst;
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        return new BufferedImage(dstCM, src.getRaster().createCompatibleWritableRaster(), src.isPremultiplied, null);
    }

    public Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            return (Point2D)src.clone();
        }
        dst.setLocation(src);
        return dst;
    }

    public LookupTable getTable() {
        return this.lut;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        } else if (src.getNumBands() != dest.getNumBands()) {
            throw new IllegalArgumentException();
        }
        if (this.lut.getNumComponents() != 1 && this.lut.getNumComponents() != src.getNumBands()) {
            throw new IllegalArgumentException();
        }
        int[] tmp = new int[src.getNumBands()];
        int y = src.getMinY();
        while (y < src.getHeight() + src.getMinY()) {
            int x = src.getMinX();
            while (x < src.getWidth() + src.getMinX()) {
                dest.setPixel(x, y, this.lut.lookupPixel(src.getPixel(x, y, tmp), tmp));
                ++x;
            }
            ++y;
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public LookupOp(LookupTable lookup, RenderingHints hints) {
        this.lut = lookup;
        this.hints = hints;
    }
}

