/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.VMStackWalker;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import java.util.StringTokenizer;

public class SecurityManager {
    static volatile SecurityManager current;
    protected boolean inCheck;

    public boolean getInCheck() {
        return this.inCheck;
    }

    protected Class[] getClassContext() {
        Class[] stack1 = VMStackWalker.getClassContext();
        Class[] stack2 = new Class[stack1.length - 1];
        System.arraycopy(stack1, 1, stack2, 0, stack1.length - 1);
        return stack2;
    }

    protected ClassLoader currentClassLoader() {
        Class cl = this.currentLoadedClass();
        return cl != null ? cl.getClassLoader() : null;
    }

    protected Class currentLoadedClass() {
        int i = this.classLoaderDepth();
        return i >= 0 ? this.getClassContext()[i] : null;
    }

    protected int classDepth(String className) {
        Class[] c = this.getClassContext();
        int i = 0;
        while (i < c.length) {
            if (className.equals(c[i].getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    protected int classLoaderDepth() {
        block4: {
            try {
                this.checkPermission(new AllPermission());
                break block4;
            }
            catch (SecurityException e) {
                c = this.getClassContext();
                i = 0;
                ** while (i < c.length)
            }
lbl-1000:
            // 1 sources

            {
                if (c[i].getClassLoader() != null) {
                    return i;
                }
                ++i;
                continue;
            }
        }
        return -1;
    }

    protected boolean inClass(String className) {
        boolean bl = false;
        if (this.classDepth(className) != -1) {
            bl = true;
        }
        return bl;
    }

    protected boolean inClassLoader() {
        boolean bl = false;
        if (this.classLoaderDepth() != -1) {
            bl = true;
        }
        return bl;
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    public void checkPermission(Permission perm) {
        AccessController.checkPermission(perm);
    }

    public void checkPermission(Permission perm, Object context) {
        if (!(context instanceof AccessControlContext)) {
            throw new SecurityException("Missing context");
        }
        ((AccessControlContext)context).checkPermission(perm);
    }

    public void checkCreateClassLoader() {
        this.checkPermission(new RuntimePermission("createClassLoader"));
    }

    public void checkAccess(Thread thread) {
        if (thread.getThreadGroup() != null && thread.getThreadGroup().getParent() != null) {
            this.checkPermission(new RuntimePermission("modifyThread"));
        }
    }

    public void checkAccess(ThreadGroup g) {
        if (g.getParent() != null) {
            this.checkPermission(new RuntimePermission("modifyThreadGroup"));
        }
    }

    public void checkExit(int status) {
        this.checkPermission(new RuntimePermission("exitVM"));
    }

    public void checkExec(String program) {
        if (!program.equals(new File(program).getAbsolutePath())) {
            program = "<<ALL FILES>>";
        }
        this.checkPermission(new FilePermission(program, "execute"));
    }

    public void checkLink(String filename) {
        this.checkPermission(new RuntimePermission("loadLibrary." + filename.toString()));
    }

    public void checkRead(FileDescriptor desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.checkPermission(new RuntimePermission("readFileDescriptor"));
    }

    public void checkRead(String filename) {
        this.checkPermission(new FilePermission(filename, "read"));
    }

    public void checkRead(String filename, Object context) {
        if (!(context instanceof AccessControlContext)) {
            throw new SecurityException("Missing context");
        }
        AccessControlContext ac = (AccessControlContext)context;
        ac.checkPermission(new FilePermission(filename, "read"));
    }

    public void checkWrite(FileDescriptor desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.checkPermission(new RuntimePermission("writeFileDescriptor"));
    }

    public void checkWrite(String filename) {
        this.checkPermission(new FilePermission(filename, "write"));
    }

    public void checkDelete(String filename) {
        this.checkPermission(new FilePermission(filename, "delete"));
    }

    public void checkConnect(String host, int port) {
        if (port == -1) {
            this.checkPermission(new SocketPermission(host, "resolve"));
        } else {
            this.checkPermission(new SocketPermission(host.toString() + ':' + port, "connect"));
        }
    }

    public void checkConnect(String host, int port, Object context) {
        if (!(context instanceof AccessControlContext)) {
            throw new SecurityException("Missing context");
        }
        AccessControlContext ac = (AccessControlContext)context;
        if (port == -1) {
            ac.checkPermission(new SocketPermission(host, "resolve"));
        } else {
            ac.checkPermission(new SocketPermission(host.toString() + ':' + port, "connect"));
        }
    }

    public void checkListen(int port) {
        this.checkPermission(new SocketPermission("localhost:" + (port == 0 ? "1024-" : "" + port), "listen"));
    }

    public void checkAccept(String host, int port) {
        this.checkPermission(new SocketPermission(host.toString() + ':' + port, "accept"));
    }

    public void checkMulticast(InetAddress addr) {
        this.checkPermission(new SocketPermission(addr.getHostAddress(), "accept,connect"));
    }

    public void checkMulticast(InetAddress addr, byte ttl) {
        this.checkPermission(new SocketPermission(addr.getHostAddress(), "accept,connect"));
    }

    public void checkPropertiesAccess() {
        this.checkPermission(new PropertyPermission("*", "read,write"));
    }

    public void checkPropertyAccess(String key) {
        this.checkPermission(new PropertyPermission(key, "read"));
    }

    public boolean checkTopLevelWindow(Object window) {
        if (window == null) {
            throw new NullPointerException();
        }
        try {
            this.checkPermission(new AWTPermission("showWindowWithoutWarningBanner"));
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public void checkPrintJobAccess() {
        this.checkPermission(new RuntimePermission("queuePrintJob"));
    }

    public void checkSystemClipboardAccess() {
        this.checkPermission(new AWTPermission("accessClipboard"));
    }

    public void checkAwtEventQueueAccess() {
        this.checkPermission(new AWTPermission("accessEventQueue"));
    }

    public void checkPackageAccess(String packageName) {
        this.checkPackageList(packageName, "package.access", "accessClassInPackage.");
    }

    public void checkPackageDefinition(String packageName) {
        this.checkPackageList(packageName, "package.definition", "defineClassInPackage.");
    }

    public void checkSetFactory() {
        this.checkPermission(new RuntimePermission("setFactory"));
    }

    public void checkMemberAccess(Class c, int memberType) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (memberType == 0) {
            return;
        }
        this.checkPermission(new RuntimePermission("accessDeclaredMembers"));
    }

    public void checkSecurityAccess(String action) {
        this.checkPermission(new SecurityPermission(action));
    }

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    void checkPackageList(String packageName, final String restriction, String permission) {
        if (packageName == null) {
            throw new NullPointerException();
        }
        String list2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return Security.getProperty(restriction);
            }
        });
        if (list2 == null || list2.equals("")) {
            return;
        }
        String packageNamePlusDot = packageName + '.';
        StringTokenizer st = new StringTokenizer(list2, ",");
        while (st.hasMoreTokens()) {
            if (!packageNamePlusDot.startsWith(st.nextToken())) continue;
            RuntimePermission p = new RuntimePermission(permission + packageName);
            this.checkPermission(p);
            return;
        }
    }

    public SecurityManager() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("createSecurityManager"));
        }
    }
}

