/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.File;
import java.util.LinkedList;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.Application;
import writer2latex.latex.Context;
import writer2latex.latex.LaTeXDocument;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.content.BlockConverter;
import writer2latex.latex.content.DrawConverter;
import writer2latex.latex.content.FieldConverter;
import writer2latex.latex.content.IndexConverter;
import writer2latex.latex.content.Info;
import writer2latex.latex.content.InlineConverter;
import writer2latex.latex.content.MathmlConverter;
import writer2latex.latex.content.NoteConverter;
import writer2latex.latex.style.CharStyleConverter;
import writer2latex.latex.style.I18n;
import writer2latex.latex.style.ListStyleConverter;
import writer2latex.latex.style.NoteConfigurationConverter;
import writer2latex.latex.style.PageStyleConverter;
import writer2latex.latex.style.ParStyleConverter;
import writer2latex.latex.style.SectionStyleConverter;
import writer2latex.latex.style.TableStyleConverter;
import writer2latex.office.ImageLoader;
import writer2latex.office.MetaData;
import writer2latex.office.ParStyle;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public final class ConverterPalette {
    private Config config;
    private ConvertData convertData;
    private LaTeXDocument texDoc;
    private SxwDocument sxwDoc;
    private String sOutFileName;
    private I18n i18n;
    private WriterStyleCollection wsc = new WriterStyleCollection();
    private CharStyleConverter charSc;
    private ListStyleConverter listSc;
    private ParStyleConverter parSc;
    private PageStyleConverter pageSc;
    private SectionStyleConverter sectionSc;
    private TableStyleConverter tableSc;
    private NoteConfigurationConverter noteCc;
    private BlockConverter blockCv;
    private IndexConverter indexCv;
    private NoteConverter noteCv;
    private InlineConverter inlineCv;
    private FieldConverter fieldCv;
    private DrawConverter drawCv;
    private MathmlConverter mathmlCv;
    private Info info;
    private Context mainContext;
    private MetaData metaData;
    private ImageLoader imageLoader;

    public ConverterPalette(SxwDocument sxwDoc, String sConfigFileName) {
        this.sOutFileName = sxwDoc.getName();
        this.config = new Config();
        if (sConfigFileName != null) {
            File f = new File(sConfigFileName);
            if (f.exists()) {
                this.config.read(sConfigFileName);
            } else {
                System.out.println("Oops - the configuration file " + sConfigFileName + " does not exist!");
            }
        }
        this.sxwDoc = sxwDoc;
        this.convertData = new ConvertData();
        this.metaData = new MetaData(sxwDoc);
        this.wsc.loadStylesFromDOM(sxwDoc.getStyleDOM(), sxwDoc.getContentDOM());
        this.i18n = new I18n(this.wsc, this.config, this);
        this.charSc = new CharStyleConverter(this.wsc, this.config, this);
        this.listSc = new ListStyleConverter(this.wsc, this.config, this);
        this.pageSc = new PageStyleConverter(this.wsc, this.config, this);
        this.parSc = new ParStyleConverter(this.wsc, this.config, this);
        this.sectionSc = new SectionStyleConverter(this.wsc, this.config, this);
        this.tableSc = new TableStyleConverter(this.wsc, this.config, this);
        this.noteCc = new NoteConfigurationConverter(this.wsc, this.config, this);
        this.blockCv = new BlockConverter(this.config, this);
        this.indexCv = new IndexConverter(this.config, this);
        this.noteCv = new NoteConverter(this.config, this);
        this.inlineCv = new InlineConverter(this.config, this);
        this.fieldCv = new FieldConverter(this.config, this);
        this.drawCv = new DrawConverter(this.config, this);
        this.mathmlCv = new MathmlConverter(this.config, this);
        this.info = new Info(this.config, this);
        if (this.config.debug()) {
            System.out.println();
            System.out.println("Loaded " + this.i18n.getCharCount() + " unicode symbols");
        }
    }

    public void setOutFileName(String s) {
        this.sOutFileName = Misc.trimDocumentName(s, ".tex");
    }

    public String getOutFileName() {
        return this.sOutFileName;
    }

    public I18n getI18n() {
        return this.i18n;
    }

    public CharStyleConverter getCharSc() {
        return this.charSc;
    }

    public ParStyleConverter getParSc() {
        return this.parSc;
    }

    public ListStyleConverter getListSc() {
        return this.listSc;
    }

    public PageStyleConverter getPageSc() {
        return this.pageSc;
    }

    public SectionStyleConverter getSectionSc() {
        return this.sectionSc;
    }

    public TableStyleConverter getTableSc() {
        return this.tableSc;
    }

    public NoteConfigurationConverter getNoteCc() {
        return this.noteCc;
    }

    public BlockConverter getBlockCv() {
        return this.blockCv;
    }

    public IndexConverter getIndexCv() {
        return this.indexCv;
    }

    public NoteConverter getNoteCv() {
        return this.noteCv;
    }

    public InlineConverter getInlineCv() {
        return this.inlineCv;
    }

    public FieldConverter getFieldCv() {
        return this.fieldCv;
    }

    public DrawConverter getDrawCv() {
        return this.drawCv;
    }

    public MathmlConverter getMathmlCv() {
        return this.mathmlCv;
    }

    public Info getInfo() {
        return this.info;
    }

    public boolean isPackage() {
        return this.sxwDoc.getStyleDOM() == null;
    }

    public Context getMainContext() {
        return this.mainContext;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void addDocument(Document doc) {
        this.convertData.addDocument(doc);
    }

    public EmbeddedObject getEmbeddedObject(String sHref) {
        if (sHref.startsWith("#")) {
            if ((sHref = sHref.substring(1)).startsWith("./")) {
                sHref = sHref.substring(2);
            }
            return this.sxwDoc.getEmbeddedObject(sHref);
        }
        return null;
    }

    public ConvertData convert() {
        this.imageLoader = new ImageLoader(this.sxwDoc, this.sOutFileName, true);
        this.texDoc = new LaTeXDocument(this.sOutFileName);
        this.texDoc.setEncoding(I18n.writeJavaEncoding(this.config.getInputencoding()));
        org.w3c.dom.Document styles = this.sxwDoc.getStyleDOM();
        org.w3c.dom.Document doc = this.sxwDoc.getContentDOM();
        this.i18n.setDefaultLanguage(this.i18n.getMajorityLanguage());
        this.mainContext = new Context();
        this.mainContext.resetFormattingFromStyle(this.wsc.getDefaultParStyle());
        LaTeXDocumentPortion packages = new LaTeXDocumentPortion(false);
        LaTeXDocumentPortion declarations = new LaTeXDocumentPortion(false);
        LaTeXDocumentPortion body = new LaTeXDocumentPortion(true);
        NodeList list = doc.getElementsByTagName("office:body");
        int nLen = list.getLength();
        if (nLen > 0) {
            Element node = (Element)list.item(0);
            this.prepass(node);
            this.blockCv.traverseBlockText(node, body, this.mainContext);
            this.noteCv.insertEndnotes(body);
        }
        this.i18n.appendDeclarations(packages, declarations);
        this.charSc.appendDeclarations(packages, declarations);
        this.parSc.appendDeclarations(packages, declarations);
        this.listSc.appendDeclarations(packages, declarations);
        this.pageSc.appendDeclarations(packages, declarations);
        this.sectionSc.appendDeclarations(packages, declarations);
        this.tableSc.appendDeclarations(packages, declarations);
        this.noteCc.appendDeclarations(packages, declarations);
        this.blockCv.appendDeclarations(packages, declarations);
        this.indexCv.appendDeclarations(packages, declarations);
        this.noteCv.appendDeclarations(packages, declarations);
        this.inlineCv.appendDeclarations(packages, declarations);
        this.fieldCv.appendDeclarations(packages, declarations);
        this.drawCv.appendDeclarations(packages, declarations);
        this.mathmlCv.appendDeclarations(packages, declarations);
        LinkedList customPreamble = this.config.getCustomPreamble();
        int nCPLen = customPreamble.size();
        int i = 0;
        while (i < nCPLen) {
            declarations.append((String)customPreamble.get(i)).nl();
            ++i;
        }
        this.createMeta("title", this.metaData.getTitle(), declarations);
        CSVList docOptions = new CSVList(',');
        ParStyle dpStyle = this.wsc.getDefaultParStyle();
        if (dpStyle != null) {
            String s = dpStyle.getProperty("fo:font-size");
            if ("10pt".equals(s)) {
                docOptions.addValue("10pt");
            }
            if ("11pt".equals(s)) {
                docOptions.addValue("11pt");
            }
            if ("12pt".equals(s)) {
                docOptions.addValue("12pt");
            }
        }
        if (this.config.pageFormatting() != 0) {
            docOptions.addValue("twoside");
        }
        if (this.config.getGlobalOptions().length() > 0) {
            docOptions.addValue(this.config.getGlobalOptions());
        }
        LaTeXDocumentPortion result = this.texDoc.getContents();
        if (!this.config.noPreamble()) {
            result.append("% This file was converted to LaTeX by Writer2LaTeX ver. " + Application.getVersion()).nl().append("% see http://www.hj-gym.dk/~hj/writer2latex for more info").nl();
            result.append("\\documentclass");
            if (!docOptions.isEmpty()) {
                result.append("[").append(docOptions.toString()).append("]");
            }
            result.append("{").append(this.config.getDocumentclass()).append("}").nl();
            result.append(packages).append(declarations).append("\\begin{document}").nl();
        }
        result.append(body);
        if (!this.config.noPreamble()) {
            result.append("\\end{document}").nl();
        }
        this.convertData.addDocument(this.texDoc);
        if (this.indexCv.getBibTeXDocument() != null) {
            this.convertData.addDocument(this.indexCv.getBibTeXDocument());
        }
        return this.convertData;
    }

    private void createMeta(String sName, String sValue, LaTeXDocumentPortion ldp) {
        if (sValue == null) {
            return;
        }
        ldp.append("\\" + sName + "{" + this.i18n.convert(sValue, false, this.mainContext.getLang()) + "}").nl();
    }

    private void prepass(Node node) {
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int nLen = list.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = list.item(i);
                if (child.getNodeType() == 1) {
                    String sHref;
                    String sRefName;
                    String sName = child.getNodeName();
                    if (sName.equals("text:footnote-ref")) {
                        sRefName = Misc.getAttribute(child, "text:ref-name");
                        if (sRefName != null) {
                            this.noteCv.addFootnoteName(sRefName);
                        }
                    } else if (sName.equals("text:endnote-ref")) {
                        sRefName = Misc.getAttribute(child, "text:ref-name");
                        if (sRefName != null) {
                            this.noteCv.addEndnoteName(sRefName);
                        }
                    } else if (sName.equals("text:sequence-ref")) {
                        sRefName = Misc.getAttribute(child, "text:ref-name");
                        if (sRefName != null) {
                            this.fieldCv.addSequenceName(sRefName);
                        }
                    } else if (sName.equals("text:bookmark-ref")) {
                        sRefName = Misc.getAttribute(child, "text:ref-name");
                        if (sRefName != null) {
                            this.fieldCv.addBookmarkName(sRefName);
                        }
                    } else if (sName.equals("text:a") && (sHref = Misc.getAttribute(child, "xlink:href")) != null && sHref.startsWith("#")) {
                        this.fieldCv.addTargetName(sHref.substring(1));
                    }
                    this.prepass(child);
                }
                ++i;
            }
        }
    }
}

