/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PumpThread
extends Thread {
    private final InputStream in;
    private final OutputStream out;
    private final byte[] buffer;
    private IOException exception;

    public PumpThread(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, 2048);
    }

    public PumpThread(InputStream inputStream, OutputStream outputStream, int n) {
        this(inputStream, outputStream, new byte[n]);
    }

    public PumpThread(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        this.in = inputStream;
        this.out = outputStream;
        this.buffer = byArray;
    }

    public void run() {
        try {
            while (true) {
                int n;
                if ((n = this.in.read(this.buffer)) <= 0) {
                    return;
                }
                this.out.write(this.buffer, 0, n);
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return;
        }
    }

    public IOException getException() {
        if (this.isAlive()) {
            throw new IllegalStateException("The thread is still alive");
        }
        return this.exception;
    }
}

