/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.jsr250;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.ProviderInstanceBinding;
import com.mycila.guice.ext.closeable.CloseableInjector;
import com.mycila.guice.ext.closeable.InjectorCloseListener;
import com.mycila.guice.ext.injection.MBinder;
import com.mycila.guice.ext.injection.MethodHandler;
import com.mycila.guice.ext.injection.Reflect;
import com.mycila.guice.ext.jsr250.Jsr250KeyProvider;
import com.mycila.guice.ext.jsr250.Jsr250PostConstructHandler;
import com.mycila.guice.ext.jsr250.Jsr250PreDestroyHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.inject.Provider;

public class Jsr250Module
extends AbstractModule {
    @Override
    public void configure() {
        this.requireBinding(CloseableInjector.class);
        MyJsr250Destroyer destroyer = new MyJsr250Destroyer();
        this.requestInjection(destroyer);
        this.bind(MyJsr250Destroyer.class).toInstance(destroyer);
        this.bind(Jsr250KeyProvider.class).in(Singleton.class);
        this.bind(Jsr250PostConstructHandler.class).in(Singleton.class);
        this.bind(new TypeLiteral<MethodHandler<PreDestroy>>(){}).to(Jsr250PreDestroyHandler.class).in(Singleton.class);
        MBinder.wrap(this.binder()).bindAnnotationInjector(Resource.class, Jsr250KeyProvider.class).handleMethodAfterInjection(PostConstruct.class, Jsr250PostConstructHandler.class);
    }

    static class MyJsr250Destroyer
    implements InjectorCloseListener {
        @Inject
        Injector injector;
        @Inject
        MethodHandler<PreDestroy> destroyer;

        MyJsr250Destroyer() {
        }

        @Override
        public void onInjectorClosing() {
            Map<Key<?>, Binding<?>> bindings = this.injector.getAllBindings();
            SetMultimap<Binding<?>, Binding<?>> dependants = Multimaps.newSetMultimap(new IdentityHashMap(), new Supplier<Set<Binding<?>>>(){

                @Override
                public Set<Binding<?>> get() {
                    return new HashSet();
                }
            });
            for (Binding<?> binding : bindings.values()) {
                if (!(binding instanceof HasDependencies)) continue;
                for (Dependency<?> dependency : ((HasDependencies)((Object)binding)).getDependencies()) {
                    if (!bindings.containsKey(dependency.getKey())) continue;
                    dependants.put(this.injector.getBinding(dependency.getKey()), binding);
                }
            }
            IdentityHashMap<Object, Object> done = new IdentityHashMap<Object, Object>(bindings.size());
            for (Binding<?> binding : bindings.values()) {
                if (!Scopes.isSingleton(binding)) continue;
                this.close(binding, done, dependants);
            }
            for (Scope scope : this.injector.getScopeBindings().values()) {
                this.preDestroy(scope);
            }
        }

        private void close(Binding<?> binding, Map<Object, Object> done, Multimap<Binding<?>, Binding<?>> dependants) {
            if (!done.containsKey(binding)) {
                done.put(binding, Void.TYPE);
                for (Binding<?> dependant : dependants.get(binding)) {
                    this.close(dependant, done, dependants);
                }
                try {
                    Provider<Object> o;
                    if (binding instanceof ProviderInstanceBinding) {
                        o = ((ProviderInstanceBinding)binding).getUserSuppliedProvider();
                        if (!done.containsKey(o)) {
                            this.preDestroy(o);
                            done.put(o, Void.TYPE);
                        }
                    } else if (Scopes.isSingleton(binding) && !done.containsKey(o = binding.getProvider().get())) {
                        this.preDestroy(o);
                        done.put(o, Void.TYPE);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void preDestroy(Object instance) {
            TypeLiteral<?> type = TypeLiteral.get(Reflect.getTargetClass(instance));
            for (Method method : Reflect.findAllAnnotatedMethods(type.getRawType(), PreDestroy.class)) {
                this.destroyer.handle(type, instance, method, method.getAnnotation(PreDestroy.class));
            }
        }
    }
}

