/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    static final long serialVersionUID = 3288129636638950196L;
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList;
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel;
    protected int selectionMode;
    protected TreePath leadPath;
    protected int leadIndex;
    protected int leadRow;
    static /* synthetic */ Class class$javax$swing$event$TreeSelectionListener;

    public Object clone() throws CloneNotSupportedException {
        return null;
    }

    public String toString() {
        return null;
    }

    private final void writeObject(ObjectOutputStream value0) throws IOException {
    }

    private final void readObject(ObjectInputStream value0) throws IOException, ClassNotFoundException {
    }

    public void setRowMapper(RowMapper rowMapper) {
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionPath(TreePath path) {
        this.selection = new TreePath[]{path};
    }

    public void setSelectionPaths(TreePath[] paths) {
    }

    public void addSelectionPath(TreePath path) {
        if (!this.isPathSelected(path)) {
            if (this.isSelectionEmpty()) {
                this.setSelectionPath(path);
            } else {
                TreePath[] temp = new TreePath[this.selection.length + 1];
                System.arraycopy(this.selection, 0, temp, 0, this.selection.length);
                temp[temp.length - 1] = path;
                this.selection = new TreePath[temp.length];
                System.arraycopy(temp, 0, this.selection, 0, temp.length);
            }
            this.leadPath = path;
            this.fireValueChanged(new TreeSelectionEvent((Object)this, path, true, this.leadPath, path));
        }
    }

    public void addSelectionPaths(TreePath[] paths) {
        if (paths != null) {
            TreePath v0 = null;
            int i = 0;
            while (i < paths.length) {
                v0 = paths[i];
                if (!this.isPathSelected(v0)) {
                    if (this.isSelectionEmpty()) {
                        this.setSelectionPath(v0);
                    } else {
                        TreePath[] temp = new TreePath[this.selection.length + 1];
                        System.arraycopy(this.selection, 0, temp, 0, this.selection.length);
                        temp[temp.length - 1] = v0;
                        this.selection = new TreePath[temp.length];
                        System.arraycopy(temp, 0, this.selection, 0, temp.length);
                    }
                    this.leadPath = paths[paths.length - 1];
                    this.fireValueChanged(new TreeSelectionEvent((Object)this, v0, true, this.leadPath, paths[0]));
                }
                ++i;
            }
        }
    }

    public void removeSelectionPath(TreePath path) {
        int index = -1;
        if (this.isPathSelected(path)) {
            int i = 0;
            while (i < this.selection.length) {
                if (this.selection[i].equals(path)) {
                    index = i;
                    break;
                }
                ++i;
            }
            TreePath[] temp = new TreePath[this.selection.length - 1];
            System.arraycopy(this.selection, 0, temp, 0, index);
            System.arraycopy(this.selection, index + 1, temp, index, this.selection.length - index - 1);
            this.selection = new TreePath[temp.length];
            System.arraycopy(temp, 0, this.selection, 0, temp.length);
            this.fireValueChanged(new TreeSelectionEvent((Object)this, path, false, this.leadPath, path));
        }
    }

    public void removeSelectionPaths(TreePath[] paths) {
        if (paths != null) {
            int index = -1;
            TreePath v0 = null;
            int i = 0;
            while (i < paths.length) {
                v0 = paths[i];
                if (this.isPathSelected(v0)) {
                    int x = 0;
                    while (x < this.selection.length) {
                        if (this.selection[i].equals(v0)) {
                            index = x;
                            break;
                        }
                        ++x;
                    }
                    TreePath[] temp = new TreePath[this.selection.length - 1];
                    System.arraycopy(this.selection, 0, temp, 0, index);
                    System.arraycopy(this.selection, index + 1, temp, index, this.selection.length - index - 1);
                    this.selection = new TreePath[temp.length];
                    System.arraycopy(temp, 0, this.selection, 0, temp.length);
                    this.fireValueChanged(new TreeSelectionEvent((Object)this, v0, false, this.leadPath, paths[0]));
                }
                ++i;
            }
        }
    }

    public TreePath getSelectionPath() {
        if (this.selection == null || this.selection.length == 0) {
            return null;
        }
        return this.selection[0];
    }

    public TreePath[] getSelectionPaths() {
        return this.selection;
    }

    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.length;
    }

    public boolean isPathSelected(TreePath path) {
        if (this.selection == null) {
            return false;
        }
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i].equals(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSelectionEmpty() {
        boolean bl = false;
        if (this.selection == null || this.selection.length == 0) {
            bl = true;
        }
        return bl;
    }

    public void clearSelection() {
        this.leadPath = null;
        this.selection = null;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        return (TreeSelectionListener[])this.getListeners(clazz);
    }

    protected void fireValueChanged(TreeSelectionEvent event) {
        TreeSelectionListener[] listeners = this.getTreeSelectionListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueChanged(event);
            ++i;
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public int[] getSelectionRows() {
        if (this.rowMapper == null) {
            return null;
        }
        return this.rowMapper.getRowsForPaths(this.selection);
    }

    public int getMinSelectionRow() {
        if (this.rowMapper == null || this.selection == null || this.selection.length == 0) {
            return -1;
        }
        int[] rows = this.rowMapper.getRowsForPaths(this.selection);
        int minRow = Integer.MAX_VALUE;
        int index = 0;
        while (index < rows.length) {
            minRow = Math.min(minRow, rows[index]);
            ++index;
        }
        return minRow;
    }

    public int getMaxSelectionRow() {
        if (this.rowMapper == null || this.selection == null || this.selection.length == 0) {
            return -1;
        }
        int[] rows = this.rowMapper.getRowsForPaths(this.selection);
        int maxRow = -1;
        int index = 0;
        while (index < rows.length) {
            maxRow = Math.max(maxRow, rows[index]);
            ++index;
        }
        return maxRow;
    }

    public boolean isRowSelected(int row) {
        return false;
    }

    public void resetRowSelection() {
    }

    public int getLeadSelectionRow() {
        if (this.rowMapper == null || this.leadPath == null) {
            return -1;
        }
        return this.rowMapper.getRowsForPaths(new TreePath[]{this.leadPath})[0];
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void insureRowContinuity() {
    }

    protected boolean arePathsContiguous(TreePath[] paths) {
        return false;
    }

    protected boolean canPathsBeAdded(TreePath[] paths) {
        return false;
    }

    protected boolean canPathsBeRemoved(TreePath[] paths) {
        return false;
    }

    protected void notifyPathChange(Vector value0, TreePath value1) {
    }

    protected void updateLeadIndex() {
    }

    protected void insureUniqueness() {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public DefaultTreeSelectionModel() {
        this.setSelectionMode(1);
        this.listenerList = new EventListenerList();
    }
}

