/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.DomDocument;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplatesImpl;
import gnu.xml.transform.TransformerImpl;
import gnu.xml.transform.TransformerOutputProperties;
import gnu.xml.transform.XSLURIResolver;
import gnu.xml.xpath.XPathFactoryImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformerFactoryImpl
extends TransformerFactory {
    final XPathFactory xpathFactory = new XPathFactoryImpl();
    final XSLURIResolver resolver = new XSLURIResolver();
    ErrorListener userListener;
    URIResolver userResolver;

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        TransformerImpl transformerImpl;
        Stylesheet stylesheet = this.newStylesheet(source, 0, null);
        TransformerOutputProperties transformerOutputProperties = new TransformerOutputProperties(stylesheet);
        stylesheet.transformer = transformerImpl = new TransformerImpl(this, stylesheet, transformerOutputProperties);
        return transformerImpl;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerImpl(this, null, new Properties());
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Stylesheet stylesheet = this.newStylesheet(source, 0, null);
        return new TemplatesImpl(this, stylesheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Stylesheet newStylesheet(Source source, int n, Stylesheet stylesheet) throws TransformerConfigurationException {
        Document document = null;
        String string = null;
        if (source == null) return new Stylesheet(this, stylesheet, document, string, n);
        try {
            Node node2;
            DOMSource dOMSource;
            block5: {
                XSLURIResolver xSLURIResolver = this.resolver;
                synchronized (xSLURIResolver) {
                    this.resolver.setUserResolver(this.userResolver);
                    this.resolver.setUserListener(this.userListener);
                    dOMSource = this.resolver.resolveDOM(source, null, null);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var7_6
                    node2 = dOMSource.getNode();
                    if (node2 != null) break block5;
                    throw new TransformerConfigurationException("no source document");
                }
            }
            document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
            string = dOMSource.getSystemId();
            return new Stylesheet(this, stylesheet, document, string, n);
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        try {
            Object object;
            Object object2;
            Object object3;
            Node node2;
            block14: {
                XSLURIResolver xSLURIResolver = this.resolver;
                synchronized (xSLURIResolver) {
                    this.resolver.setUserResolver(this.userResolver);
                    this.resolver.setUserListener(this.userListener);
                    DOMSource dOMSource = this.resolver.resolveDOM(source, null, null);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var6_5
                    node2 = dOMSource.getNode();
                    if (node2 != null) break block14;
                    throw new TransformerConfigurationException("no source document");
                }
            }
            Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
            LinkedList linkedList = new LinkedList();
            node2 = document.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 7 && "xml-stylesheet".equals(node2.getNodeName())) {
                    object3 = this.parseParameters(node2.getNodeValue());
                    if (!(string != null && !string.equals(object3.get("media")) || string2 != null && !string2.equals(object3.get("title")) || string3 != null && !string3.equals(object3.get("charset")))) {
                        object2 = (String)object3.get("href");
                        object = this.resolver.resolveURL(null, node2.getBaseURI(), (String)object2);
                        linkedList.add(object);
                    }
                }
                node2 = node2.getNextSibling();
            }
            switch (linkedList.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new StreamSource(((URL)linkedList.getFirst()).toString());
                }
            }
            object3 = new DomDocument();
            ((DomDocument)object3).setBuilding(true);
            object2 = ((DomDocument)object3).createElementNS("http://www.w3.org/1999/XSL/Transform", "stylesheet");
            object = ((DomDocument)object3).createAttributeNS(null, "version");
            object.setNodeValue("1.0");
            object2.getAttributes().setNamedItemNS((Node)object);
            ((DomDocument)object3).appendChild((Node)object2);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                Element element = ((DomDocument)object3).createElementNS("http://www.w3.org/1999/XSL/Transform", "import");
                Attr attr = ((DomDocument)object3).createAttributeNS(null, "href");
                attr.setNodeValue(uRL.toString());
                element.getAttributes().setNamedItemNS(attr);
                object2.appendChild(element);
            }
            ((DomDocument)object3).setBuilding(false);
            return new DOMSource((Node)object3);
        }
        catch (IOException iOException) {
            throw new TransformerConfigurationException(iOException);
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }

    Map parseParameters(String string) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        int n = string.length();
        String string2 = null;
        int n2 = 0;
        char c = '\u0000';
        int n3 = 0;
        while (n3 < n) {
            char c2 = string.charAt(n3);
            if (c == '\u0000' && c2 == ' ') {
                if (string2 == null && n2 < n3) {
                    string2 = string.substring(n2, n3);
                } else {
                    String string3 = this.unquote(string.substring(n2, n3).trim());
                    linkedHashMap.put(string2, string3);
                    string2 = null;
                }
                n2 = n3 + 1;
            } else if (c2 == '\"') {
                char c3 = '\u0000';
                if (c != c2) {
                    c3 = c2;
                }
                c = c3;
            } else if (c2 == '\'') {
                char c4 = '\u0000';
                if (c != c2) {
                    c4 = c2;
                }
                c = c4;
            }
            ++n3;
        }
        if (n2 < n && string2 != null) {
            String string4 = this.unquote(string.substring(n2, n).trim());
            linkedHashMap.put(string2, string4);
        }
        return linkedHashMap;
    }

    String unquote(String string) {
        int n = string.length() - 1;
        if (string.charAt(0) == '\'' && string.charAt(n) == '\'') {
            return string.substring(1, n);
        }
        if (string.charAt(0) == '\"' && string.charAt(n) == '\"') {
            return string.substring(1, n);
        }
        return string;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.userResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.userResolver;
    }

    public void setFeature(String string, boolean bl) throws TransformerConfigurationException {
        throw new TransformerConfigurationException("not supported");
    }

    public boolean getFeature(String string) {
        return "http://javax.xml.transform.sax.SAXSource/feature".equals(string) || "http://javax.xml.transform.sax.SAXResult/feature".equals(string) || "http://javax.xml.transform.stream.StreamSource/feature".equals(string) || "http://javax.xml.transform.stream.StreamResult/feature".equals(string) || "http://javax.xml.transform.dom.DOMSource/feature".equals(string) || "http://javax.xml.transform.dom.DOMResult/feature".equals(string);
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException("not supported");
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("not supported");
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.userListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.userListener;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        OutputStream outputStream;
        InputStream inputStream;
        block11: {
            InputStream inputStream2 = null;
            inputStream = null;
            outputStream = null;
            try {
                if (stringArray.length > 0) {
                    inputStream2 = new FileInputStream(stringArray[0]);
                    if (stringArray.length > 1) {
                        inputStream = new FileInputStream(stringArray[1]);
                        if (stringArray.length > 2) {
                            outputStream = new FileOutputStream(stringArray[2]);
                        }
                    }
                }
                if (inputStream == null) {
                    inputStream = System.in;
                }
                if (outputStream == null) {
                    outputStream = System.out;
                }
                TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
                Transformer transformer2 = inputStream2 != null ? ((TransformerFactory)transformerFactoryImpl).newTransformer(new StreamSource(inputStream2)) : ((TransformerFactory)transformerFactoryImpl).newTransformer();
                transformer2.transform(new StreamSource(inputStream), new StreamResult(outputStream));
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                if (inputStream != null && inputStream instanceof FileInputStream) {
                    inputStream.close();
                }
                if (outputStream == null) throw throwable;
                if (!(outputStream instanceof FileOutputStream)) throw throwable;
                outputStream.close();
                throw throwable;
            }
            {
                Object var5_8 = null;
                if (inputStream2 == null) break block11;
            }
            inputStream2.close();
        }
        if (inputStream != null && inputStream instanceof FileInputStream) {
            inputStream.close();
        }
        if (outputStream == null) return;
        if (!(outputStream instanceof FileOutputStream)) return;
        outputStream.close();
    }
}

