/*
 * Decompiled with CFR 0.152.
 */
package imp;

import imp.StateProbs;
import ints.IntList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import vcf.RefGT;
import vcf.RefGTRec;

public class RefHapHash {
    private final int targMarker;
    private final RefGT refGT;
    private final int[] i2hap;
    private final IntList[] altAlleles;
    private final int[] i2hash;
    private final int start;
    private final int end;

    public RefHapHash(AtomicReferenceArray<StateProbs> atomicReferenceArray, int n2, RefGT refGT, int n3, int n4) {
        if (n3 < 0 || n3 >= n4) {
            throw new IllegalArgumentException(String.valueOf(n3));
        }
        if (n4 > refGT.nMarkers()) {
            throw new IllegalArgumentException(String.valueOf(n4));
        }
        this.targMarker = n2;
        this.refGT = refGT;
        this.i2hap = RefHapHash.i2hap(atomicReferenceArray, n2);
        this.i2hash = new int[this.i2hap.length];
        this.start = n3;
        this.end = n4;
        this.altAlleles = (IntList[])IntStream.range(0, this.i2hap.length).mapToObj(n -> new IntList(6)).toArray(IntList[]::new);
        this.setHashAndAltAlleles();
    }

    private void setHashAndAltAlleles() {
        Random random = new Random(this.start);
        for (int i = this.start; i < this.end; ++i) {
            RefGTRec refGTRec = this.refGT.get(i);
            int n = i - this.start;
            if (refGTRec.isAlleleCoded() && refGTRec.majorAllele() == 0) {
                this.lowAltFreqUpdate(refGTRec, n, random);
                continue;
            }
            this.standardUpdate(refGTRec, n, random);
        }
    }

    private void lowAltFreqUpdate(RefGTRec refGTRec, int n, Random random) {
        int n2 = refGTRec.marker().nAlleles();
        assert (refGTRec.majorAllele() == 0);
        for (int i = 1; i < n2; ++i) {
            int n3;
            int n4 = random.nextInt();
            int n5 = refGTRec.alleleCount(i);
            if (this.i2hap.length < n5) {
                for (n3 = 0; n3 < this.i2hap.length; ++n3) {
                    if (!refGTRec.isCarrier(i, this.i2hap[n3])) continue;
                    int n6 = n3;
                    this.i2hash[n6] = this.i2hash[n6] + n4;
                    this.altAlleles[n3].add(n);
                    this.altAlleles[n3].add(i);
                }
                continue;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                int n7 = refGTRec.hapIndex(i, n3);
                int n8 = Arrays.binarySearch(this.i2hap, n7);
                if (n8 < 0) continue;
                int n9 = n8;
                this.i2hash[n9] = this.i2hash[n9] + n4;
                this.altAlleles[n8].add(n);
                this.altAlleles[n8].add(i);
            }
        }
    }

    private void standardUpdate(RefGTRec refGTRec, int n, Random random) {
        int n2;
        int[] nArray = new int[refGTRec.marker().nAlleles()];
        for (n2 = 1; n2 < nArray.length; ++n2) {
            nArray[n2] = random.nextInt();
        }
        for (n2 = 0; n2 < this.i2hap.length; ++n2) {
            int n3 = refGTRec.get(this.i2hap[n2]);
            if (n3 == 0) continue;
            int n4 = n2;
            this.i2hash[n4] = this.i2hash[n4] + nArray[n3];
            this.altAlleles[n2].add(n);
            this.altAlleles[n2].add(n3);
        }
    }

    private static int[] i2hap(AtomicReferenceArray<StateProbs> atomicReferenceArray, int n) {
        IntList intList = new IntList(10 * atomicReferenceArray.length());
        int n2 = atomicReferenceArray.length();
        for (int i = 0; i < n2; ++i) {
            StateProbs stateProbs = atomicReferenceArray.get(i);
            int n3 = stateProbs.nStates(n);
            for (int j = 0; j < n3; ++j) {
                intList.add(stateProbs.refHap(n, j));
            }
        }
        return intList.stream().sorted().distinct().toArray();
    }

    public int targMarker() {
        return this.targMarker;
    }

    public RefGT refGT() {
        return this.refGT;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public void setAlleles(int n, int[] nArray) {
        Arrays.fill(nArray, 0, this.end - this.start, 0);
        IntList intList = this.altAlleles[n];
        int n2 = intList.size();
        for (int i = 0; i < n2; i += 2) {
            nArray[intList.get((int)i)] = intList.get(i + 1);
        }
    }

    public int nHaps() {
        return this.i2hap.length;
    }

    public int hap2Index(int n) {
        return Arrays.binarySearch(this.i2hap, n);
    }

    public int hap(int n) {
        return this.i2hap[n];
    }

    public int hash(int n) {
        return this.i2hash[n];
    }
}

