/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.logging;

import java.util.Formatter;
import java.util.HashMap;
import org.xmlresolver.logging.ResolverLogger;

public abstract class AbstractLogger
implements ResolverLogger {
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String TRACE = "trace";
    public static final String ERROR = "error";
    public static final String CACHE = "cache";
    public static final String CONFIG = "config";
    public static final String WARNING = "warning";
    protected static final int DEBUG = 1;
    protected static final int INFO = 2;
    protected static final int WARN = 3;
    protected static final int NONE = 4;
    protected final HashMap<String, Integer> categories = new HashMap();
    protected String catalogLogging = null;

    @Override
    public String getCategory(String cat) {
        if (this.categories.containsKey(cat)) {
            switch (this.categories.get(cat)) {
                case 2: {
                    return "info";
                }
                case 3: {
                    return "warn";
                }
                case 4: {
                    return "none";
                }
                case 1: {
                    return "debug";
                }
            }
        }
        return "debug";
    }

    @Override
    public void setCategory(String cat, String level) {
        switch (level) {
            case "info": {
                this.categories.put(cat, 2);
                break;
            }
            case "warn": {
                this.categories.put(cat, 3);
                break;
            }
            case "debug": {
                this.categories.put(cat, 1);
                break;
            }
            case "none": {
                this.categories.put(cat, 4);
                break;
            }
            default: {
                this.categories.put(cat, 1);
                this.info("Incorrect logging level specified: " + level + " treated as 'debug'");
            }
        }
    }

    protected String logMessage(String cat, String message, Object ... params) {
        StringBuilder sb = new StringBuilder();
        sb.append(cat);
        sb.append(": ");
        Formatter formatter = new Formatter(sb);
        if (params.length == 0) {
            formatter.format("%s", message);
        } else {
            formatter.format(message, params);
        }
        return sb.toString();
    }

    @Override
    public void log(String cat, String message, Object ... params) {
        this.updateLoggingCategories();
        Integer deflevel = this.categories.getOrDefault("*", 1);
        Integer level = this.categories.getOrDefault(cat, deflevel);
        switch (level) {
            case 4: {
                break;
            }
            case 3: {
                this.warn(this.logMessage(cat, message, params));
                break;
            }
            case 2: {
                this.info(this.logMessage(cat, message, params));
                break;
            }
            default: {
                this.debug(this.logMessage(cat, message, params));
            }
        }
    }

    private void updateLoggingCategories() {
        String property = System.getProperty("xml.catalog.logging");
        if (property == null && this.catalogLogging == null) {
            return;
        }
        if (property == null) {
            this.categories.clear();
            return;
        }
        if (property.equals(this.catalogLogging)) {
            return;
        }
        this.catalogLogging = property;
        this.categories.clear();
        for (String prop : property.split(",\\s*")) {
            int pos = prop.indexOf(":");
            if (pos <= 0) continue;
            String cat = prop.substring(0, pos).trim();
            String level = prop.substring(pos + 1).trim();
            this.setCategory(cat, level);
        }
    }
}

