/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.Vector;
import net.claribole.zvtm.engine.CameraPortal;

public class RoundCameraPortal
extends CameraPortal {
    Ellipse2D clippingShape;

    public RoundCameraPortal(int x, int y, int w, int h, Camera c) {
        super(x, y, w, h, c);
        this.clippingShape = new Ellipse2D.Float(x, y, w, h);
    }

    public long[] getVisibleRegion() {
        return super.getVisibleRegion();
    }

    public boolean coordInside(int cx, int cy) {
        return this.clippingShape.contains(cx, cy);
    }

    public void move(int dx, int dy) {
        super.move(dx, dy);
        this.clippingShape.setFrame(this.x, this.y, this.w, this.h);
    }

    public void moveTo(int x, int y) {
        super.moveTo(x, y);
        this.clippingShape.setFrame(x, y, this.w, this.h);
    }

    public void updateDimensions() {
        this.size.setSize(this.w, this.h);
        if (this.clippingShape != null) {
            this.clippingShape.setFrame(this.x, this.y, this.w, this.h);
        } else {
            this.clippingShape = new Ellipse2D.Float(this.x, this.y, this.w, this.h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (!this.visible) {
            return;
        }
        g2d.setClip(this.clippingShape);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fill(this.clippingShape);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        Vector vector = this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = (long)((float)this.camera.posx - (float)(this.w / 2) * this.uncoef);
            this.viewNC = (long)((float)this.camera.posy + (float)(this.h / 2) * this.uncoef);
            this.viewEC = (long)((float)this.camera.posx + (float)(this.w / 2) * this.uncoef);
            this.viewSC = (long)((float)this.camera.posy - (float)(this.h / 2) * this.uncoef);
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInRegion(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camIndex)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                    }
                    continue;
                }
            }
        }
        g2d.setClip(0, 0, viewWidth, viewHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.draw(this.clippingShape);
        }
    }
}

