/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkContainerPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GtkWindowPeer
extends GtkContainerPeer
implements WindowPeer {
    protected static final int GDK_WINDOW_TYPE_HINT_NORMAL = 0;
    protected static final int GDK_WINDOW_TYPE_HINT_DIALOG = 1;
    protected static final int GDK_WINDOW_TYPE_HINT_MENU = 2;
    protected static final int GDK_WINDOW_TYPE_HINT_TOOLBAR = 3;
    protected static final int GDK_WINDOW_TYPE_HINT_SPLASHSCREEN = 4;
    protected static final int GDK_WINDOW_TYPE_HINT_UTILITY = 5;
    protected static final int GDK_WINDOW_TYPE_HINT_DOCK = 6;
    protected static final int GDK_WINDOW_TYPE_HINT_DESKTOP = 7;
    private boolean hasBeenShown;
    private int oldState;

    native void gtkWindowSetTitle(String var1);

    native void gtkWindowSetResizable(boolean var1);

    native void gtkWindowSetModal(boolean var1);

    native void realize();

    int getWidth() {
        return this.awtComponent.getWidth();
    }

    int getHeight() {
        return this.awtComponent.getHeight();
    }

    native void create(int var1, boolean var2, GtkWindowPeer var3);

    void create(int type, boolean decorated) {
        GtkWindowPeer parent_peer = null;
        Container parent = this.awtComponent.getParent();
        if (parent != null) {
            parent_peer = (GtkWindowPeer)this.awtComponent.getParent().getPeer();
        }
        this.create(type, decorated, parent_peer);
    }

    void create() {
        this.create(0, false);
    }

    void setParent() {
        this.setVisible(this.awtComponent.isVisible());
        this.setEnabled(this.awtComponent.isEnabled());
    }

    void setVisibleAndEnabled() {
    }

    public native void setVisibleNative(boolean var1);

    public native void setVisibleNativeUnlocked(boolean var1);

    native void connectSignals();

    public native void toBack();

    public native void toFront();

    native void nativeSetBounds(int var1, int var2, int var3, int var4);

    native void nativeSetBoundsUnlocked(int var1, int var2, int var3, int var4);

    public void setBounds(int x, int y, int width, int height) {
        if (Thread.currentThread() == GtkToolkit.mainThread) {
            return;
        }
        this.nativeSetBounds(x, y, width - this.insets.left - this.insets.right, height - this.insets.top - this.insets.bottom);
    }

    public void setBoundsUnlocked(int x, int y, int width, int height) {
        this.nativeSetBoundsUnlocked(x, y, width - this.insets.left - this.insets.right, height - this.insets.top - this.insets.bottom);
    }

    public void setTitle(String title) {
        this.gtkWindowSetTitle(title);
    }

    native void setSize(int var1, int var2);

    public void setResizable(boolean resizable) {
        this.setSize(this.awtComponent.getWidth() - this.insets.left - this.insets.right, this.awtComponent.getHeight() - this.insets.top - this.insets.bottom);
        this.gtkWindowSetResizable(resizable);
    }

    protected void postInsetsChangedEvent(int top, int left, int bottom, int right) {
        this.insets.top = top;
        this.insets.left = left;
        this.insets.bottom = bottom;
        this.insets.right = right;
    }

    protected void postConfigureEvent(int x, int y, int width, int height) {
        int frame_width = width + this.insets.left + this.insets.right;
        int frame_height = height + this.insets.top + this.insets.bottom;
        if (frame_width != this.awtComponent.getWidth() || frame_height != this.awtComponent.getHeight()) {
            this.awtComponent.setSize(frame_width, frame_height);
        }
        int frame_x = x - this.insets.left;
        int frame_y = y - this.insets.top;
        if (frame_x == this.awtComponent.getX()) {
            this.awtComponent.getY();
        }
    }

    public void show() {
        this.setBounds(this.awtComponent.getX(), this.awtComponent.getY(), this.awtComponent.getWidth(), this.awtComponent.getHeight());
        this.setVisible(true);
    }

    void postWindowEvent(int id, Window opposite, int newState) {
        if (id == 200) {
            if (!this.hasBeenShown) {
                GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, id, opposite));
                this.hasBeenShown = true;
            }
        } else if (id == 209) {
            if (this.oldState != newState) {
                GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, id, opposite, this.oldState, newState));
                this.oldState = newState;
            }
        } else {
            GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, id, opposite));
        }
    }

    public void updateAlwaysOnTop() {
    }

    public boolean requestWindowFocus() {
        return false;
    }

    private final /* synthetic */ void this() {
        this.hasBeenShown = false;
        this.oldState = 0;
    }

    public GtkWindowPeer(Window window) {
        super(window);
        this.this();
    }
}

