/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.multi;

import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class MultiLookAndFeel
extends LookAndFeel {
    public String getName() {
        return "Multiplexing Look and Feel";
    }

    public String getID() {
        return "Multiplex";
    }

    public String getDescription() {
        return "Allows multiple UI instances per component instance";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public UIDefaults getDefaults() {
        UIDefaults defaults = new UIDefaults();
        defaults.put("ButtonUI", "javax.swing.plaf.multi.MultiButtonUI");
        defaults.put("CheckBoxUI", "javax.swing.plaf.multi.MultiButtonUI");
        defaults.put("CheckBoxMenuItemUI", "javax.swing.plaf.multi.MultiMenuItemUI");
        defaults.put("ColorChooserUI", "javax.swing.plaf.multi.MultiColorChooserUI");
        defaults.put("ComboBoxUI", "javax.swing.plaf.multi.MultiComboBoxUI");
        defaults.put("DesktopPaneUI", "javax.swing.plaf.multi.MultiDesktopPaneUI");
        defaults.put("DesktopIconUI", "javax.swing.plaf.multi.MultiDesktopIconUI");
        defaults.put("EditorPaneUI", "javax.swing.plaf.multi.MultiTextUI");
        defaults.put("FileChooserUI", "javax.swing.plaf.multi.MultiFileChooserUI");
        defaults.put("FormattedTextFieldUI", "javax.swing.plaf.multi.MultiTextUI");
        defaults.put("InternalFrameUI", "javax.swing.plaf.multi.MultiInternalFrameUI");
        defaults.put("LabelUI", "javax.swing.plaf.multi.MultiLabelUI");
        defaults.put("ListUI", "javax.swing.plaf.multi.MultiListUI");
        defaults.put("MenuItemUI", "javax.swing.plaf.multi.MultiMenuItemUI");
        defaults.put("MenuUI", "javax.swing.plaf.multi.MultiMenuItemUI");
        defaults.put("MenuBarUI", "javax.swing.plaf.multi.MultiMenuBarUI");
        defaults.put("OptionPaneUI", "javax.swing.plaf.multi.MultiOptionPaneUI");
        defaults.put("PanelUI", "javax.swing.plaf.multi.MultiPanelUI");
        defaults.put("PasswordFieldUI", "javax.swing.plaf.multi.MultiTextUI");
        defaults.put("PopupMenuUI", "javax.swing.plaf.multi.MultiPopupMenuUI");
        defaults.put("PopupMenuSeparatorUI", "javax.swing.plaf.multi.MultiSeparatorUI");
        defaults.put("ProgressBarUI", "javax.swing.plaf.multi.MultiProgressBarUI");
        defaults.put("RadioButtonUI", "javax.swing.plaf.multi.MultiButtonUI");
        defaults.put("RadioButtonMenuItemUI", "javax.swing.plaf.multi.MultiMenuItemUI");
        defaults.put("RootPaneUI", "javax.swing.plaf.multi.MultiRootPaneUI");
        defaults.put("ScrollBarUI", "javax.swing.plaf.multi.MultiScrollBarUI");
        defaults.put("ScrollPaneUI", "javax.swing.plaf.multi.MultiScrollPaneUI");
        defaults.put("SeparatorUI", "javax.swing.plaf.multi.MultiSeparatorUI");
        defaults.put("SliderUI", "javax.swing.plaf.multi.MultiSliderUI");
        defaults.put("SpinnerUI", "javax.swing.plaf.multi.MultiSpinnerUI");
        defaults.put("SplitPaneUI", "javax.swing.plaf.multi.MultiSplitPaneUI");
        defaults.put("TabbedPaneUI", "javax.swing.plaf.multi.MultiTabbedPaneUI");
        defaults.put("TableHeaderUI", "javax.swing.plaf.multi.MultiTableHeaderUI");
        defaults.put("TableUI", "javax.swing.plaf.multi.MultiTableUI");
        defaults.put("TextAreaUI", "javax.swing.plaf.multi.MultiTextUI");
        defaults.put("TextFieldUI", "javax.swing.plaf.multi.MultiTextUI");
        defaults.put("TextPaneUI", "javax.swing.plaf.multi.MultiTextUI");
        defaults.put("ToggleButtonUI", "javax.swing.plaf.multi.MultiButtonUI");
        defaults.put("ToolBarSeparatorUI", "javax.swing.plaf.multi.MultiSeparatorUI");
        defaults.put("ToolBarUI", "javax.swing.plaf.multi.MultiToolBarUI");
        defaults.put("ToolTipUI", "javax.swing.plaf.multi.MultiToolTipUI");
        defaults.put("ViewportUI", "javax.swing.plaf.multi.MultiViewportUI");
        return defaults;
    }

    public static ComponentUI createUIs(ComponentUI mui, Vector uis, JComponent target) {
        ComponentUI ui = null;
        LookAndFeel primary = UIManager.getLookAndFeel();
        if (primary != null) {
            ui = UIManager.getUI(target);
            uis.add(ui);
        }
        LookAndFeel[] auxlafs = UIManager.getAuxiliaryLookAndFeels();
        int i = 0;
        while (i < auxlafs.length) {
            LookAndFeel auxlaf = auxlafs[i];
            UIDefaults defaults = auxlaf.getDefaults();
            ui = defaults.getUI(target);
            if (ui != null) {
                uis.add(ui);
            }
            ++i;
        }
        if (uis.size() > 1) {
            return mui;
        }
        return ui;
    }

    protected static ComponentUI[] uisToArray(Vector uis) {
        if (uis == null) {
            return new ComponentUI[0];
        }
        int size = uis.size();
        if (size == 0) {
            return null;
        }
        Object[] result = new ComponentUI[size];
        uis.copyInto(result);
        return result;
    }
}

