/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wiztools.restclient.persistence.XMLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLIndentUtil {
    private XMLIndentUtil() {
    }

    public static String getIndented(String inXml) throws IOException {
        try {
            InputSource src = new InputSource(new StringReader(inXml));
            Document domDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src);
            String encoding = domDoc.getXmlEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            Element document = domDoc.getDocumentElement();
            boolean keepDeclaration = inXml.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.setNewLine("\n");
            writer.getDomConfig().setParameter("format-pretty-print", true);
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            LSOutput lsOutput = impl.createLSOutput();
            lsOutput.setEncoding(encoding);
            StringWriter stringWriter = new StringWriter();
            lsOutput.setCharacterStream(stringWriter);
            writer.write(document, lsOutput);
            return ((Object)stringWriter).toString();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | ParserConfigurationException | SAXException ex) {
            throw new XMLException(null, ex);
        }
    }
}

