## Uconv/CP51932
## Copyright 2012 by yoshidam
##


require 'uconv'

module Uconv

  CP51932_UCS_MAP = {
    "\xa1\xc0"=>0xff3c,
    "\xa1\xc1"=>0xff5e,
    "\xa1\xc2"=>0x2225,
    "\xa1\xdd"=>0xff0d,
    "\xa1\xf1"=>0xffe0,
    "\xa1\xf2"=>0xffe1,
    "\xa2\xcc"=>0xffe2,
    "\xad\xa1"=>0x2460,
    "\xad\xa2"=>0x2461,
    "\xad\xa3"=>0x2462,
    "\xad\xa4"=>0x2463,
    "\xad\xa5"=>0x2464,
    "\xad\xa6"=>0x2465,
    "\xad\xa7"=>0x2466,
    "\xad\xa8"=>0x2467,
    "\xad\xa9"=>0x2468,
    "\xad\xaa"=>0x2469,
    "\xad\xab"=>0x246a,
    "\xad\xac"=>0x246b,
    "\xad\xad"=>0x246c,
    "\xad\xae"=>0x246d,
    "\xad\xaf"=>0x246e,
    "\xad\xb0"=>0x246f,
    "\xad\xb1"=>0x2470,
    "\xad\xb2"=>0x2471,
    "\xad\xb3"=>0x2472,
    "\xad\xb4"=>0x2473,
    "\xad\xb5"=>0x2160,
    "\xad\xb6"=>0x2161,
    "\xad\xb7"=>0x2162,
    "\xad\xb8"=>0x2163,
    "\xad\xb9"=>0x2164,
    "\xad\xba"=>0x2165,
    "\xad\xbb"=>0x2166,
    "\xad\xbc"=>0x2167,
    "\xad\xbd"=>0x2168,
    "\xad\xbe"=>0x2169,
    "\xad\xc0"=>0x3349,
    "\xad\xc1"=>0x3314,
    "\xad\xc2"=>0x3322,
    "\xad\xc3"=>0x334d,
    "\xad\xc4"=>0x3318,
    "\xad\xc5"=>0x3327,
    "\xad\xc6"=>0x3303,
    "\xad\xc7"=>0x3336,
    "\xad\xc8"=>0x3351,
    "\xad\xc9"=>0x3357,
    "\xad\xca"=>0x330d,
    "\xad\xcb"=>0x3326,
    "\xad\xcc"=>0x3323,
    "\xad\xcd"=>0x332b,
    "\xad\xce"=>0x334a,
    "\xad\xcf"=>0x333b,
    "\xad\xd0"=>0x339c,
    "\xad\xd1"=>0x339d,
    "\xad\xd2"=>0x339e,
    "\xad\xd3"=>0x338e,
    "\xad\xd4"=>0x338f,
    "\xad\xd5"=>0x33c4,
    "\xad\xd6"=>0x33a1,
    "\xad\xdf"=>0x337b,
    "\xad\xe0"=>0x301d,
    "\xad\xe1"=>0x301f,
    "\xad\xe2"=>0x2116,
    "\xad\xe3"=>0x33cd,
    "\xad\xe4"=>0x2121,
    "\xad\xe5"=>0x32a4,
    "\xad\xe6"=>0x32a5,
    "\xad\xe7"=>0x32a6,
    "\xad\xe8"=>0x32a7,
    "\xad\xe9"=>0x32a8,
    "\xad\xea"=>0x3231,
    "\xad\xeb"=>0x3232,
    "\xad\xec"=>0x3239,
    "\xad\xed"=>0x337e,
    "\xad\xee"=>0x337d,
    "\xad\xef"=>0x337c,
    "\xad\xf0"=>0x2252,
    "\xad\xf1"=>0x2261,
    "\xad\xf2"=>0x222b,
    "\xad\xf3"=>0x222e,
    "\xad\xf4"=>0x2211,
    "\xad\xf5"=>0x221a,
    "\xad\xf6"=>0x22a5,
    "\xad\xf7"=>0x2220,
    "\xad\xf8"=>0x221f,
    "\xad\xf9"=>0x22bf,
    "\xad\xfa"=>0x2235,
    "\xad\xfb"=>0x2229,
    "\xad\xfc"=>0x222a,
    "\xf9\xa1"=>0x7e8a,
    "\xf9\xa2"=>0x891c,
    "\xf9\xa3"=>0x9348,
    "\xf9\xa4"=>0x9288,
    "\xf9\xa5"=>0x84dc,
    "\xf9\xa6"=>0x4fc9,
    "\xf9\xa7"=>0x70bb,
    "\xf9\xa8"=>0x6631,
    "\xf9\xa9"=>0x68c8,
    "\xf9\xaa"=>0x92f9,
    "\xf9\xab"=>0x66fb,
    "\xf9\xac"=>0x5f45,
    "\xf9\xad"=>0x4e28,
    "\xf9\xae"=>0x4ee1,
    "\xf9\xaf"=>0x4efc,
    "\xf9\xb0"=>0x4f00,
    "\xf9\xb1"=>0x4f03,
    "\xf9\xb2"=>0x4f39,
    "\xf9\xb3"=>0x4f56,
    "\xf9\xb4"=>0x4f92,
    "\xf9\xb5"=>0x4f8a,
    "\xf9\xb6"=>0x4f9a,
    "\xf9\xb7"=>0x4f94,
    "\xf9\xb8"=>0x4fcd,
    "\xf9\xb9"=>0x5040,
    "\xf9\xba"=>0x5022,
    "\xf9\xbb"=>0x4fff,
    "\xf9\xbc"=>0x501e,
    "\xf9\xbd"=>0x5046,
    "\xf9\xbe"=>0x5070,
    "\xf9\xbf"=>0x5042,
    "\xf9\xc0"=>0x5094,
    "\xf9\xc1"=>0x50f4,
    "\xf9\xc2"=>0x50d8,
    "\xf9\xc3"=>0x514a,
    "\xf9\xc4"=>0x5164,
    "\xf9\xc5"=>0x519d,
    "\xf9\xc6"=>0x51be,
    "\xf9\xc7"=>0x51ec,
    "\xf9\xc8"=>0x5215,
    "\xf9\xc9"=>0x529c,
    "\xf9\xca"=>0x52a6,
    "\xf9\xcb"=>0x52c0,
    "\xf9\xcc"=>0x52db,
    "\xf9\xcd"=>0x5300,
    "\xf9\xce"=>0x5307,
    "\xf9\xcf"=>0x5324,
    "\xf9\xd0"=>0x5372,
    "\xf9\xd1"=>0x5393,
    "\xf9\xd2"=>0x53b2,
    "\xf9\xd3"=>0x53dd,
    "\xf9\xd4"=>0xfa0e,
    "\xf9\xd5"=>0x549c,
    "\xf9\xd6"=>0x548a,
    "\xf9\xd7"=>0x54a9,
    "\xf9\xd8"=>0x54ff,
    "\xf9\xd9"=>0x5586,
    "\xf9\xda"=>0x5759,
    "\xf9\xdb"=>0x5765,
    "\xf9\xdc"=>0x57ac,
    "\xf9\xdd"=>0x57c8,
    "\xf9\xde"=>0x57c7,
    "\xf9\xdf"=>0xfa0f,
    "\xf9\xe0"=>0xfa10,
    "\xf9\xe1"=>0x589e,
    "\xf9\xe2"=>0x58b2,
    "\xf9\xe3"=>0x590b,
    "\xf9\xe4"=>0x5953,
    "\xf9\xe5"=>0x595b,
    "\xf9\xe6"=>0x595d,
    "\xf9\xe7"=>0x5963,
    "\xf9\xe8"=>0x59a4,
    "\xf9\xe9"=>0x59ba,
    "\xf9\xea"=>0x5b56,
    "\xf9\xeb"=>0x5bc0,
    "\xf9\xec"=>0x752f,
    "\xf9\xed"=>0x5bd8,
    "\xf9\xee"=>0x5bec,
    "\xf9\xef"=>0x5c1e,
    "\xf9\xf0"=>0x5ca6,
    "\xf9\xf1"=>0x5cba,
    "\xf9\xf2"=>0x5cf5,
    "\xf9\xf3"=>0x5d27,
    "\xf9\xf4"=>0x5d53,
    "\xf9\xf5"=>0xfa11,
    "\xf9\xf6"=>0x5d42,
    "\xf9\xf7"=>0x5d6d,
    "\xf9\xf8"=>0x5db8,
    "\xf9\xf9"=>0x5db9,
    "\xf9\xfa"=>0x5dd0,
    "\xf9\xfb"=>0x5f21,
    "\xf9\xfc"=>0x5f34,
    "\xf9\xfd"=>0x5f67,
    "\xf9\xfe"=>0x5fb7,
    "\xfa\xa1"=>0x5fde,
    "\xfa\xa2"=>0x605d,
    "\xfa\xa3"=>0x6085,
    "\xfa\xa4"=>0x608a,
    "\xfa\xa5"=>0x60de,
    "\xfa\xa6"=>0x60d5,
    "\xfa\xa7"=>0x6120,
    "\xfa\xa8"=>0x60f2,
    "\xfa\xa9"=>0x6111,
    "\xfa\xaa"=>0x6137,
    "\xfa\xab"=>0x6130,
    "\xfa\xac"=>0x6198,
    "\xfa\xad"=>0x6213,
    "\xfa\xae"=>0x62a6,
    "\xfa\xaf"=>0x63f5,
    "\xfa\xb0"=>0x6460,
    "\xfa\xb1"=>0x649d,
    "\xfa\xb2"=>0x64ce,
    "\xfa\xb3"=>0x654e,
    "\xfa\xb4"=>0x6600,
    "\xfa\xb5"=>0x6615,
    "\xfa\xb6"=>0x663b,
    "\xfa\xb7"=>0x6609,
    "\xfa\xb8"=>0x662e,
    "\xfa\xb9"=>0x661e,
    "\xfa\xba"=>0x6624,
    "\xfa\xbb"=>0x6665,
    "\xfa\xbc"=>0x6657,
    "\xfa\xbd"=>0x6659,
    "\xfa\xbe"=>0xfa12,
    "\xfa\xbf"=>0x6673,
    "\xfa\xc0"=>0x6699,
    "\xfa\xc1"=>0x66a0,
    "\xfa\xc2"=>0x66b2,
    "\xfa\xc3"=>0x66bf,
    "\xfa\xc4"=>0x66fa,
    "\xfa\xc5"=>0x670e,
    "\xfa\xc6"=>0xf929,
    "\xfa\xc7"=>0x6766,
    "\xfa\xc8"=>0x67bb,
    "\xfa\xc9"=>0x6852,
    "\xfa\xca"=>0x67c0,
    "\xfa\xcb"=>0x6801,
    "\xfa\xcc"=>0x6844,
    "\xfa\xcd"=>0x68cf,
    "\xfa\xce"=>0xfa13,
    "\xfa\xcf"=>0x6968,
    "\xfa\xd0"=>0xfa14,
    "\xfa\xd1"=>0x6998,
    "\xfa\xd2"=>0x69e2,
    "\xfa\xd3"=>0x6a30,
    "\xfa\xd4"=>0x6a6b,
    "\xfa\xd5"=>0x6a46,
    "\xfa\xd6"=>0x6a73,
    "\xfa\xd7"=>0x6a7e,
    "\xfa\xd8"=>0x6ae2,
    "\xfa\xd9"=>0x6ae4,
    "\xfa\xda"=>0x6bd6,
    "\xfa\xdb"=>0x6c3f,
    "\xfa\xdc"=>0x6c5c,
    "\xfa\xdd"=>0x6c86,
    "\xfa\xde"=>0x6c6f,
    "\xfa\xdf"=>0x6cda,
    "\xfa\xe0"=>0x6d04,
    "\xfa\xe1"=>0x6d87,
    "\xfa\xe2"=>0x6d6f,
    "\xfa\xe3"=>0x6d96,
    "\xfa\xe4"=>0x6dac,
    "\xfa\xe5"=>0x6dcf,
    "\xfa\xe6"=>0x6df8,
    "\xfa\xe7"=>0x6df2,
    "\xfa\xe8"=>0x6dfc,
    "\xfa\xe9"=>0x6e39,
    "\xfa\xea"=>0x6e5c,
    "\xfa\xeb"=>0x6e27,
    "\xfa\xec"=>0x6e3c,
    "\xfa\xed"=>0x6ebf,
    "\xfa\xee"=>0x6f88,
    "\xfa\xef"=>0x6fb5,
    "\xfa\xf0"=>0x6ff5,
    "\xfa\xf1"=>0x7005,
    "\xfa\xf2"=>0x7007,
    "\xfa\xf3"=>0x7028,
    "\xfa\xf4"=>0x7085,
    "\xfa\xf5"=>0x70ab,
    "\xfa\xf6"=>0x710f,
    "\xfa\xf7"=>0x7104,
    "\xfa\xf8"=>0x715c,
    "\xfa\xf9"=>0x7146,
    "\xfa\xfa"=>0x7147,
    "\xfa\xfb"=>0xfa15,
    "\xfa\xfc"=>0x71c1,
    "\xfa\xfd"=>0x71fe,
    "\xfa\xfe"=>0x72b1,
    "\xfb\xa1"=>0x72be,
    "\xfb\xa2"=>0x7324,
    "\xfb\xa3"=>0xfa16,
    "\xfb\xa4"=>0x7377,
    "\xfb\xa5"=>0x73bd,
    "\xfb\xa6"=>0x73c9,
    "\xfb\xa7"=>0x73d6,
    "\xfb\xa8"=>0x73e3,
    "\xfb\xa9"=>0x73d2,
    "\xfb\xaa"=>0x7407,
    "\xfb\xab"=>0x73f5,
    "\xfb\xac"=>0x7426,
    "\xfb\xad"=>0x742a,
    "\xfb\xae"=>0x7429,
    "\xfb\xaf"=>0x742e,
    "\xfb\xb0"=>0x7462,
    "\xfb\xb1"=>0x7489,
    "\xfb\xb2"=>0x749f,
    "\xfb\xb3"=>0x7501,
    "\xfb\xb4"=>0x756f,
    "\xfb\xb5"=>0x7682,
    "\xfb\xb6"=>0x769c,
    "\xfb\xb7"=>0x769e,
    "\xfb\xb8"=>0x769b,
    "\xfb\xb9"=>0x76a6,
    "\xfb\xba"=>0xfa17,
    "\xfb\xbb"=>0x7746,
    "\xfb\xbc"=>0x52af,
    "\xfb\xbd"=>0x7821,
    "\xfb\xbe"=>0x784e,
    "\xfb\xbf"=>0x7864,
    "\xfb\xc0"=>0x787a,
    "\xfb\xc1"=>0x7930,
    "\xfb\xc2"=>0xfa18,
    "\xfb\xc3"=>0xfa19,
    "\xfb\xc4"=>0xfa1a,
    "\xfb\xc5"=>0x7994,
    "\xfb\xc6"=>0xfa1b,
    "\xfb\xc7"=>0x799b,
    "\xfb\xc8"=>0x7ad1,
    "\xfb\xc9"=>0x7ae7,
    "\xfb\xca"=>0xfa1c,
    "\xfb\xcb"=>0x7aeb,
    "\xfb\xcc"=>0x7b9e,
    "\xfb\xcd"=>0xfa1d,
    "\xfb\xce"=>0x7d48,
    "\xfb\xcf"=>0x7d5c,
    "\xfb\xd0"=>0x7db7,
    "\xfb\xd1"=>0x7da0,
    "\xfb\xd2"=>0x7dd6,
    "\xfb\xd3"=>0x7e52,
    "\xfb\xd4"=>0x7f47,
    "\xfb\xd5"=>0x7fa1,
    "\xfb\xd6"=>0xfa1e,
    "\xfb\xd7"=>0x8301,
    "\xfb\xd8"=>0x8362,
    "\xfb\xd9"=>0x837f,
    "\xfb\xda"=>0x83c7,
    "\xfb\xdb"=>0x83f6,
    "\xfb\xdc"=>0x8448,
    "\xfb\xdd"=>0x84b4,
    "\xfb\xde"=>0x8553,
    "\xfb\xdf"=>0x8559,
    "\xfb\xe0"=>0x856b,
    "\xfb\xe1"=>0xfa1f,
    "\xfb\xe2"=>0x85b0,
    "\xfb\xe3"=>0xfa20,
    "\xfb\xe4"=>0xfa21,
    "\xfb\xe5"=>0x8807,
    "\xfb\xe6"=>0x88f5,
    "\xfb\xe7"=>0x8a12,
    "\xfb\xe8"=>0x8a37,
    "\xfb\xe9"=>0x8a79,
    "\xfb\xea"=>0x8aa7,
    "\xfb\xeb"=>0x8abe,
    "\xfb\xec"=>0x8adf,
    "\xfb\xed"=>0xfa22,
    "\xfb\xee"=>0x8af6,
    "\xfb\xef"=>0x8b53,
    "\xfb\xf0"=>0x8b7f,
    "\xfb\xf1"=>0x8cf0,
    "\xfb\xf2"=>0x8cf4,
    "\xfb\xf3"=>0x8d12,
    "\xfb\xf4"=>0x8d76,
    "\xfb\xf5"=>0xfa23,
    "\xfb\xf6"=>0x8ecf,
    "\xfb\xf7"=>0xfa24,
    "\xfb\xf8"=>0xfa25,
    "\xfb\xf9"=>0x9067,
    "\xfb\xfa"=>0x90de,
    "\xfb\xfb"=>0xfa26,
    "\xfb\xfc"=>0x9115,
    "\xfb\xfd"=>0x9127,
    "\xfb\xfe"=>0x91da,
    "\xfc\xa1"=>0x91d7,
    "\xfc\xa2"=>0x91de,
    "\xfc\xa3"=>0x91ed,
    "\xfc\xa4"=>0x91ee,
    "\xfc\xa5"=>0x91e4,
    "\xfc\xa6"=>0x91e5,
    "\xfc\xa7"=>0x9206,
    "\xfc\xa8"=>0x9210,
    "\xfc\xa9"=>0x920a,
    "\xfc\xaa"=>0x923a,
    "\xfc\xab"=>0x9240,
    "\xfc\xac"=>0x923c,
    "\xfc\xad"=>0x924e,
    "\xfc\xae"=>0x9259,
    "\xfc\xaf"=>0x9251,
    "\xfc\xb0"=>0x9239,
    "\xfc\xb1"=>0x9267,
    "\xfc\xb2"=>0x92a7,
    "\xfc\xb3"=>0x9277,
    "\xfc\xb4"=>0x9278,
    "\xfc\xb5"=>0x92e7,
    "\xfc\xb6"=>0x92d7,
    "\xfc\xb7"=>0x92d9,
    "\xfc\xb8"=>0x92d0,
    "\xfc\xb9"=>0xfa27,
    "\xfc\xba"=>0x92d5,
    "\xfc\xbb"=>0x92e0,
    "\xfc\xbc"=>0x92d3,
    "\xfc\xbd"=>0x9325,
    "\xfc\xbe"=>0x9321,
    "\xfc\xbf"=>0x92fb,
    "\xfc\xc0"=>0xfa28,
    "\xfc\xc1"=>0x931e,
    "\xfc\xc2"=>0x92ff,
    "\xfc\xc3"=>0x931d,
    "\xfc\xc4"=>0x9302,
    "\xfc\xc5"=>0x9370,
    "\xfc\xc6"=>0x9357,
    "\xfc\xc7"=>0x93a4,
    "\xfc\xc8"=>0x93c6,
    "\xfc\xc9"=>0x93de,
    "\xfc\xca"=>0x93f8,
    "\xfc\xcb"=>0x9431,
    "\xfc\xcc"=>0x9445,
    "\xfc\xcd"=>0x9448,
    "\xfc\xce"=>0x9592,
    "\xfc\xcf"=>0xf9dc,
    "\xfc\xd0"=>0xfa29,
    "\xfc\xd1"=>0x969d,
    "\xfc\xd2"=>0x96af,
    "\xfc\xd3"=>0x9733,
    "\xfc\xd4"=>0x973b,
    "\xfc\xd5"=>0x9743,
    "\xfc\xd6"=>0x974d,
    "\xfc\xd7"=>0x974f,
    "\xfc\xd8"=>0x9751,
    "\xfc\xd9"=>0x9755,
    "\xfc\xda"=>0x9857,
    "\xfc\xdb"=>0x9865,
    "\xfc\xdc"=>0xfa2a,
    "\xfc\xdd"=>0xfa2b,
    "\xfc\xde"=>0x9927,
    "\xfc\xdf"=>0xfa2c,
    "\xfc\xe0"=>0x999e,
    "\xfc\xe1"=>0x9a4e,
    "\xfc\xe2"=>0x9ad9,
    "\xfc\xe3"=>0x9adc,
    "\xfc\xe4"=>0x9b75,
    "\xfc\xe5"=>0x9b72,
    "\xfc\xe6"=>0x9b8f,
    "\xfc\xe7"=>0x9bb1,
    "\xfc\xe8"=>0x9bbb,
    "\xfc\xe9"=>0x9c00,
    "\xfc\xea"=>0x9d70,
    "\xfc\xeb"=>0x9d6b,
    "\xfc\xec"=>0xfa2d,
    "\xfc\xed"=>0x9e19,
    "\xfc\xee"=>0x9ed1,
    "\xfc\xf1"=>0x2170,
    "\xfc\xf2"=>0x2171,
    "\xfc\xf3"=>0x2172,
    "\xfc\xf4"=>0x2173,
    "\xfc\xf5"=>0x2174,
    "\xfc\xf6"=>0x2175,
    "\xfc\xf7"=>0x2176,
    "\xfc\xf8"=>0x2177,
    "\xfc\xf9"=>0x2178,
    "\xfc\xfa"=>0x2179,
    "\xfc\xfb"=>0xffe2,
    "\xfc\xfc"=>0xffe4,
    "\xfc\xfd"=>0xff07,
    "\xfc\xfe"=>0xff02,
    "\x8f\xa2\xaf"=>0,
    "\x8f\xa2\xb0"=>0,
    "\x8f\xa2\xb1"=>0,
    "\x8f\xa2\xb2"=>0,
    "\x8f\xa2\xb3"=>0,
    "\x8f\xa2\xb4"=>0,
    "\x8f\xa2\xb5"=>0,
    "\x8f\xa2\xb6"=>0,
    "\x8f\xa2\xb7"=>0,
    "\x8f\xa2\xb8"=>0,
    "\x8f\xa2\xb9"=>0,
    "\x8f\xa2\xc2"=>0,
    "\x8f\xa2\xc3"=>0,
    "\x8f\xa2\xc4"=>0,
    "\x8f\xa2\xeb"=>0,
    "\x8f\xa2\xec"=>0,
    "\x8f\xa2\xed"=>0,
    "\x8f\xa2\xee"=>0,
    "\x8f\xa2\xef"=>0,
    "\x8f\xa2\xf0"=>0,
    "\x8f\xa2\xf1"=>0,
    "\x8f\xa6\xe1"=>0,
    "\x8f\xa6\xe2"=>0,
    "\x8f\xa6\xe3"=>0,
    "\x8f\xa6\xe4"=>0,
    "\x8f\xa6\xe5"=>0,
    "\x8f\xa6\xe7"=>0,
    "\x8f\xa6\xe9"=>0,
    "\x8f\xa6\xea"=>0,
    "\x8f\xa6\xec"=>0,
    "\x8f\xa6\xf1"=>0,
    "\x8f\xa6\xf2"=>0,
    "\x8f\xa6\xf3"=>0,
    "\x8f\xa6\xf4"=>0,
    "\x8f\xa6\xf5"=>0,
    "\x8f\xa6\xf6"=>0,
    "\x8f\xa6\xf7"=>0,
    "\x8f\xa6\xf8"=>0,
    "\x8f\xa6\xf9"=>0,
    "\x8f\xa6\xfa"=>0,
    "\x8f\xa6\xfb"=>0,
    "\x8f\xa6\xfc"=>0,
    "\x8f\xa7\xc2"=>0,
    "\x8f\xa7\xc3"=>0,
    "\x8f\xa7\xc4"=>0,
    "\x8f\xa7\xc5"=>0,
    "\x8f\xa7\xc6"=>0,
    "\x8f\xa7\xc7"=>0,
    "\x8f\xa7\xc8"=>0,
    "\x8f\xa7\xc9"=>0,
    "\x8f\xa7\xca"=>0,
    "\x8f\xa7\xcb"=>0,
    "\x8f\xa7\xcc"=>0,
    "\x8f\xa7\xcd"=>0,
    "\x8f\xa7\xce"=>0,
    "\x8f\xa7\xf2"=>0,
    "\x8f\xa7\xf3"=>0,
    "\x8f\xa7\xf4"=>0,
    "\x8f\xa7\xf5"=>0,
    "\x8f\xa7\xf6"=>0,
    "\x8f\xa7\xf7"=>0,
    "\x8f\xa7\xf8"=>0,
    "\x8f\xa7\xf9"=>0,
    "\x8f\xa7\xfa"=>0,
    "\x8f\xa7\xfb"=>0,
    "\x8f\xa7\xfc"=>0,
    "\x8f\xa7\xfd"=>0,
    "\x8f\xa7\xfe"=>0,
    "\x8f\xa9\xa1"=>0,
    "\x8f\xa9\xa2"=>0,
    "\x8f\xa9\xa4"=>0,
    "\x8f\xa9\xa6"=>0,
    "\x8f\xa9\xa8"=>0,
    "\x8f\xa9\xa9"=>0,
    "\x8f\xa9\xab"=>0,
    "\x8f\xa9\xac"=>0,
    "\x8f\xa9\xad"=>0,
    "\x8f\xa9\xaf"=>0,
    "\x8f\xa9\xb0"=>0,
    "\x8f\xa9\xc1"=>0,
    "\x8f\xa9\xc2"=>0,
    "\x8f\xa9\xc3"=>0,
    "\x8f\xa9\xc4"=>0,
    "\x8f\xa9\xc5"=>0,
    "\x8f\xa9\xc6"=>0,
    "\x8f\xa9\xc7"=>0,
    "\x8f\xa9\xc8"=>0,
    "\x8f\xa9\xc9"=>0,
    "\x8f\xa9\xca"=>0,
    "\x8f\xa9\xcb"=>0,
    "\x8f\xa9\xcc"=>0,
    "\x8f\xa9\xcd"=>0,
    "\x8f\xa9\xce"=>0,
    "\x8f\xa9\xcf"=>0,
    "\x8f\xa9\xd0"=>0,
    "\x8f\xaa\xa1"=>0,
    "\x8f\xaa\xa2"=>0,
    "\x8f\xaa\xa3"=>0,
    "\x8f\xaa\xa4"=>0,
    "\x8f\xaa\xa5"=>0,
    "\x8f\xaa\xa6"=>0,
    "\x8f\xaa\xa7"=>0,
    "\x8f\xaa\xa8"=>0,
    "\x8f\xaa\xa9"=>0,
    "\x8f\xaa\xaa"=>0,
    "\x8f\xaa\xab"=>0,
    "\x8f\xaa\xac"=>0,
    "\x8f\xaa\xad"=>0,
    "\x8f\xaa\xae"=>0,
    "\x8f\xaa\xaf"=>0,
    "\x8f\xaa\xb0"=>0,
    "\x8f\xaa\xb1"=>0,
    "\x8f\xaa\xb2"=>0,
    "\x8f\xaa\xb3"=>0,
    "\x8f\xaa\xb4"=>0,
    "\x8f\xaa\xb5"=>0,
    "\x8f\xaa\xb6"=>0,
    "\x8f\xaa\xb7"=>0,
    "\x8f\xaa\xb8"=>0,
    "\x8f\xaa\xba"=>0,
    "\x8f\xaa\xbb"=>0,
    "\x8f\xaa\xbc"=>0,
    "\x8f\xaa\xbd"=>0,
    "\x8f\xaa\xbe"=>0,
    "\x8f\xaa\xbf"=>0,
    "\x8f\xaa\xc0"=>0,
    "\x8f\xaa\xc1"=>0,
    "\x8f\xaa\xc2"=>0,
    "\x8f\xaa\xc3"=>0,
    "\x8f\xaa\xc4"=>0,
    "\x8f\xaa\xc5"=>0,
    "\x8f\xaa\xc6"=>0,
    "\x8f\xaa\xc7"=>0,
    "\x8f\xaa\xc8"=>0,
    "\x8f\xaa\xc9"=>0,
    "\x8f\xaa\xca"=>0,
    "\x8f\xaa\xcb"=>0,
    "\x8f\xaa\xcc"=>0,
    "\x8f\xaa\xcd"=>0,
    "\x8f\xaa\xce"=>0,
    "\x8f\xaa\xcf"=>0,
    "\x8f\xaa\xd0"=>0,
    "\x8f\xaa\xd1"=>0,
    "\x8f\xaa\xd2"=>0,
    "\x8f\xaa\xd3"=>0,
    "\x8f\xaa\xd4"=>0,
    "\x8f\xaa\xd5"=>0,
    "\x8f\xaa\xd6"=>0,
    "\x8f\xaa\xd7"=>0,
    "\x8f\xaa\xd8"=>0,
    "\x8f\xaa\xd9"=>0,
    "\x8f\xaa\xda"=>0,
    "\x8f\xaa\xdb"=>0,
    "\x8f\xaa\xdc"=>0,
    "\x8f\xaa\xdd"=>0,
    "\x8f\xaa\xde"=>0,
    "\x8f\xaa\xdf"=>0,
    "\x8f\xaa\xe0"=>0,
    "\x8f\xaa\xe1"=>0,
    "\x8f\xaa\xe2"=>0,
    "\x8f\xaa\xe3"=>0,
    "\x8f\xaa\xe4"=>0,
    "\x8f\xaa\xe5"=>0,
    "\x8f\xaa\xe6"=>0,
    "\x8f\xaa\xe7"=>0,
    "\x8f\xaa\xe8"=>0,
    "\x8f\xaa\xe9"=>0,
    "\x8f\xaa\xea"=>0,
    "\x8f\xaa\xeb"=>0,
    "\x8f\xaa\xec"=>0,
    "\x8f\xaa\xed"=>0,
    "\x8f\xaa\xee"=>0,
    "\x8f\xaa\xef"=>0,
    "\x8f\xaa\xf0"=>0,
    "\x8f\xaa\xf1"=>0,
    "\x8f\xaa\xf2"=>0,
    "\x8f\xaa\xf3"=>0,
    "\x8f\xaa\xf4"=>0,
    "\x8f\xaa\xf5"=>0,
    "\x8f\xaa\xf6"=>0,
    "\x8f\xaa\xf7"=>0,
    "\x8f\xab\xa1"=>0,
    "\x8f\xab\xa2"=>0,
    "\x8f\xab\xa3"=>0,
    "\x8f\xab\xa4"=>0,
    "\x8f\xab\xa5"=>0,
    "\x8f\xab\xa6"=>0,
    "\x8f\xab\xa7"=>0,
    "\x8f\xab\xa8"=>0,
    "\x8f\xab\xa9"=>0,
    "\x8f\xab\xaa"=>0,
    "\x8f\xab\xab"=>0,
    "\x8f\xab\xac"=>0,
    "\x8f\xab\xad"=>0,
    "\x8f\xab\xae"=>0,
    "\x8f\xab\xaf"=>0,
    "\x8f\xab\xb0"=>0,
    "\x8f\xab\xb1"=>0,
    "\x8f\xab\xb2"=>0,
    "\x8f\xab\xb3"=>0,
    "\x8f\xab\xb4"=>0,
    "\x8f\xab\xb5"=>0,
    "\x8f\xab\xb6"=>0,
    "\x8f\xab\xb7"=>0,
    "\x8f\xab\xb8"=>0,
    "\x8f\xab\xb9"=>0,
    "\x8f\xab\xba"=>0,
    "\x8f\xab\xbb"=>0,
    "\x8f\xab\xbd"=>0,
    "\x8f\xab\xbe"=>0,
    "\x8f\xab\xbf"=>0,
    "\x8f\xab\xc0"=>0,
    "\x8f\xab\xc1"=>0,
    "\x8f\xab\xc2"=>0,
    "\x8f\xab\xc3"=>0,
    "\x8f\xab\xc5"=>0,
    "\x8f\xab\xc6"=>0,
    "\x8f\xab\xc7"=>0,
    "\x8f\xab\xc8"=>0,
    "\x8f\xab\xc9"=>0,
    "\x8f\xab\xca"=>0,
    "\x8f\xab\xcb"=>0,
    "\x8f\xab\xcc"=>0,
    "\x8f\xab\xcd"=>0,
    "\x8f\xab\xce"=>0,
    "\x8f\xab\xcf"=>0,
    "\x8f\xab\xd0"=>0,
    "\x8f\xab\xd1"=>0,
    "\x8f\xab\xd2"=>0,
    "\x8f\xab\xd3"=>0,
    "\x8f\xab\xd4"=>0,
    "\x8f\xab\xd5"=>0,
    "\x8f\xab\xd6"=>0,
    "\x8f\xab\xd7"=>0,
    "\x8f\xab\xd8"=>0,
    "\x8f\xab\xd9"=>0,
    "\x8f\xab\xda"=>0,
    "\x8f\xab\xdb"=>0,
    "\x8f\xab\xdc"=>0,
    "\x8f\xab\xdd"=>0,
    "\x8f\xab\xde"=>0,
    "\x8f\xab\xdf"=>0,
    "\x8f\xab\xe0"=>0,
    "\x8f\xab\xe1"=>0,
    "\x8f\xab\xe2"=>0,
    "\x8f\xab\xe3"=>0,
    "\x8f\xab\xe4"=>0,
    "\x8f\xab\xe5"=>0,
    "\x8f\xab\xe6"=>0,
    "\x8f\xab\xe7"=>0,
    "\x8f\xab\xe8"=>0,
    "\x8f\xab\xe9"=>0,
    "\x8f\xab\xea"=>0,
    "\x8f\xab\xeb"=>0,
    "\x8f\xab\xec"=>0,
    "\x8f\xab\xed"=>0,
    "\x8f\xab\xee"=>0,
    "\x8f\xab\xef"=>0,
    "\x8f\xab\xf0"=>0,
    "\x8f\xab\xf1"=>0,
    "\x8f\xab\xf2"=>0,
    "\x8f\xab\xf3"=>0,
    "\x8f\xab\xf4"=>0,
    "\x8f\xab\xf5"=>0,
    "\x8f\xab\xf6"=>0,
    "\x8f\xab\xf7"=>0,
    "\x8f\xb0\xa1"=>0,
    "\x8f\xb0\xa2"=>0,
    "\x8f\xb0\xa3"=>0,
    "\x8f\xb0\xa4"=>0,
    "\x8f\xb0\xa5"=>0,
    "\x8f\xb0\xa6"=>0,
    "\x8f\xb0\xa7"=>0,
    "\x8f\xb0\xa8"=>0,
    "\x8f\xb0\xa9"=>0,
    "\x8f\xb0\xaa"=>0,
    "\x8f\xb0\xab"=>0,
    "\x8f\xb0\xac"=>0,
    "\x8f\xb0\xad"=>0,
    "\x8f\xb0\xae"=>0,
    "\x8f\xb0\xaf"=>0,
    "\x8f\xb0\xb0"=>0,
    "\x8f\xb0\xb1"=>0,
    "\x8f\xb0\xb2"=>0,
    "\x8f\xb0\xb3"=>0,
    "\x8f\xb0\xb4"=>0,
    "\x8f\xb0\xb5"=>0,
    "\x8f\xb0\xb6"=>0,
    "\x8f\xb0\xb7"=>0,
    "\x8f\xb0\xb8"=>0,
    "\x8f\xb0\xb9"=>0,
    "\x8f\xb0\xba"=>0,
    "\x8f\xb0\xbb"=>0,
    "\x8f\xb0\xbc"=>0,
    "\x8f\xb0\xbd"=>0,
    "\x8f\xb0\xbe"=>0,
    "\x8f\xb0\xbf"=>0,
    "\x8f\xb0\xc0"=>0,
    "\x8f\xb0\xc1"=>0,
    "\x8f\xb0\xc2"=>0,
    "\x8f\xb0\xc3"=>0,
    "\x8f\xb0\xc4"=>0,
    "\x8f\xb0\xc5"=>0,
    "\x8f\xb0\xc6"=>0,
    "\x8f\xb0\xc7"=>0,
    "\x8f\xb0\xc8"=>0,
    "\x8f\xb0\xc9"=>0,
    "\x8f\xb0\xca"=>0,
    "\x8f\xb0\xcb"=>0,
    "\x8f\xb0\xcc"=>0,
    "\x8f\xb0\xcd"=>0,
    "\x8f\xb0\xce"=>0,
    "\x8f\xb0\xcf"=>0,
    "\x8f\xb0\xd0"=>0,
    "\x8f\xb0\xd1"=>0,
    "\x8f\xb0\xd2"=>0,
    "\x8f\xb0\xd3"=>0,
    "\x8f\xb0\xd4"=>0,
    "\x8f\xb0\xd5"=>0,
    "\x8f\xb0\xd6"=>0,
    "\x8f\xb0\xd7"=>0,
    "\x8f\xb0\xd8"=>0,
    "\x8f\xb0\xd9"=>0,
    "\x8f\xb0\xda"=>0,
    "\x8f\xb0\xdb"=>0,
    "\x8f\xb0\xdc"=>0,
    "\x8f\xb0\xdd"=>0,
    "\x8f\xb0\xde"=>0,
    "\x8f\xb0\xdf"=>0,
    "\x8f\xb0\xe0"=>0,
    "\x8f\xb0\xe1"=>0,
    "\x8f\xb0\xe2"=>0,
    "\x8f\xb0\xe3"=>0,
    "\x8f\xb0\xe4"=>0,
    "\x8f\xb0\xe5"=>0,
    "\x8f\xb0\xe6"=>0,
    "\x8f\xb0\xe7"=>0,
    "\x8f\xb0\xe8"=>0,
    "\x8f\xb0\xe9"=>0,
    "\x8f\xb0\xea"=>0,
    "\x8f\xb0\xeb"=>0,
    "\x8f\xb0\xec"=>0,
    "\x8f\xb0\xed"=>0,
    "\x8f\xb0\xee"=>0,
    "\x8f\xb0\xef"=>0,
    "\x8f\xb0\xf0"=>0,
    "\x8f\xb0\xf1"=>0,
    "\x8f\xb0\xf2"=>0,
    "\x8f\xb0\xf3"=>0,
    "\x8f\xb0\xf4"=>0,
    "\x8f\xb0\xf5"=>0,
    "\x8f\xb0\xf6"=>0,
    "\x8f\xb0\xf7"=>0,
    "\x8f\xb0\xf8"=>0,
    "\x8f\xb0\xf9"=>0,
    "\x8f\xb0\xfa"=>0,
    "\x8f\xb0\xfb"=>0,
    "\x8f\xb0\xfc"=>0,
    "\x8f\xb0\xfd"=>0,
    "\x8f\xb0\xfe"=>0,
    "\x8f\xb1\xa1"=>0,
    "\x8f\xb1\xa2"=>0,
    "\x8f\xb1\xa3"=>0,
    "\x8f\xb1\xa4"=>0,
    "\x8f\xb1\xa5"=>0,
    "\x8f\xb1\xa6"=>0,
    "\x8f\xb1\xa7"=>0,
    "\x8f\xb1\xa8"=>0,
    "\x8f\xb1\xa9"=>0,
    "\x8f\xb1\xaa"=>0,
    "\x8f\xb1\xab"=>0,
    "\x8f\xb1\xac"=>0,
    "\x8f\xb1\xad"=>0,
    "\x8f\xb1\xae"=>0,
    "\x8f\xb1\xaf"=>0,
    "\x8f\xb1\xb0"=>0,
    "\x8f\xb1\xb1"=>0,
    "\x8f\xb1\xb2"=>0,
    "\x8f\xb1\xb3"=>0,
    "\x8f\xb1\xb4"=>0,
    "\x8f\xb1\xb5"=>0,
    "\x8f\xb1\xb6"=>0,
    "\x8f\xb1\xb7"=>0,
    "\x8f\xb1\xb8"=>0,
    "\x8f\xb1\xb9"=>0,
    "\x8f\xb1\xba"=>0,
    "\x8f\xb1\xbb"=>0,
    "\x8f\xb1\xbc"=>0,
    "\x8f\xb1\xbd"=>0,
    "\x8f\xb1\xbe"=>0,
    "\x8f\xb1\xbf"=>0,
    "\x8f\xb1\xc0"=>0,
    "\x8f\xb1\xc1"=>0,
    "\x8f\xb1\xc2"=>0,
    "\x8f\xb1\xc3"=>0,
    "\x8f\xb1\xc4"=>0,
    "\x8f\xb1\xc5"=>0,
    "\x8f\xb1\xc6"=>0,
    "\x8f\xb1\xc7"=>0,
    "\x8f\xb1\xc8"=>0,
    "\x8f\xb1\xc9"=>0,
    "\x8f\xb1\xca"=>0,
    "\x8f\xb1\xcb"=>0,
    "\x8f\xb1\xcc"=>0,
    "\x8f\xb1\xcd"=>0,
    "\x8f\xb1\xce"=>0,
    "\x8f\xb1\xcf"=>0,
    "\x8f\xb1\xd0"=>0,
    "\x8f\xb1\xd1"=>0,
    "\x8f\xb1\xd2"=>0,
    "\x8f\xb1\xd3"=>0,
    "\x8f\xb1\xd4"=>0,
    "\x8f\xb1\xd5"=>0,
    "\x8f\xb1\xd6"=>0,
    "\x8f\xb1\xd7"=>0,
    "\x8f\xb1\xd8"=>0,
    "\x8f\xb1\xd9"=>0,
    "\x8f\xb1\xda"=>0,
    "\x8f\xb1\xdb"=>0,
    "\x8f\xb1\xdc"=>0,
    "\x8f\xb1\xdd"=>0,
    "\x8f\xb1\xde"=>0,
    "\x8f\xb1\xdf"=>0,
    "\x8f\xb1\xe0"=>0,
    "\x8f\xb1\xe1"=>0,
    "\x8f\xb1\xe2"=>0,
    "\x8f\xb1\xe3"=>0,
    "\x8f\xb1\xe4"=>0,
    "\x8f\xb1\xe5"=>0,
    "\x8f\xb1\xe6"=>0,
    "\x8f\xb1\xe7"=>0,
    "\x8f\xb1\xe8"=>0,
    "\x8f\xb1\xe9"=>0,
    "\x8f\xb1\xea"=>0,
    "\x8f\xb1\xeb"=>0,
    "\x8f\xb1\xec"=>0,
    "\x8f\xb1\xed"=>0,
    "\x8f\xb1\xee"=>0,
    "\x8f\xb1\xef"=>0,
    "\x8f\xb1\xf0"=>0,
    "\x8f\xb1\xf1"=>0,
    "\x8f\xb1\xf2"=>0,
    "\x8f\xb1\xf3"=>0,
    "\x8f\xb1\xf4"=>0,
    "\x8f\xb1\xf5"=>0,
    "\x8f\xb1\xf6"=>0,
    "\x8f\xb1\xf7"=>0,
    "\x8f\xb1\xf8"=>0,
    "\x8f\xb1\xf9"=>0,
    "\x8f\xb1\xfa"=>0,
    "\x8f\xb1\xfb"=>0,
    "\x8f\xb1\xfc"=>0,
    "\x8f\xb1\xfd"=>0,
    "\x8f\xb1\xfe"=>0,
    "\x8f\xb2\xa1"=>0,
    "\x8f\xb2\xa2"=>0,
    "\x8f\xb2\xa3"=>0,
    "\x8f\xb2\xa4"=>0,
    "\x8f\xb2\xa5"=>0,
    "\x8f\xb2\xa6"=>0,
    "\x8f\xb2\xa7"=>0,
    "\x8f\xb2\xa8"=>0,
    "\x8f\xb2\xa9"=>0,
    "\x8f\xb2\xaa"=>0,
    "\x8f\xb2\xab"=>0,
    "\x8f\xb2\xac"=>0,
    "\x8f\xb2\xad"=>0,
    "\x8f\xb2\xae"=>0,
    "\x8f\xb2\xaf"=>0,
    "\x8f\xb2\xb0"=>0,
    "\x8f\xb2\xb1"=>0,
    "\x8f\xb2\xb2"=>0,
    "\x8f\xb2\xb3"=>0,
    "\x8f\xb2\xb4"=>0,
    "\x8f\xb2\xb5"=>0,
    "\x8f\xb2\xb6"=>0,
    "\x8f\xb2\xb7"=>0,
    "\x8f\xb2\xb8"=>0,
    "\x8f\xb2\xb9"=>0,
    "\x8f\xb2\xba"=>0,
    "\x8f\xb2\xbb"=>0,
    "\x8f\xb2\xbc"=>0,
    "\x8f\xb2\xbd"=>0,
    "\x8f\xb2\xbe"=>0,
    "\x8f\xb2\xbf"=>0,
    "\x8f\xb2\xc0"=>0,
    "\x8f\xb2\xc1"=>0,
    "\x8f\xb2\xc2"=>0,
    "\x8f\xb2\xc3"=>0,
    "\x8f\xb2\xc4"=>0,
    "\x8f\xb2\xc5"=>0,
    "\x8f\xb2\xc6"=>0,
    "\x8f\xb2\xc7"=>0,
    "\x8f\xb2\xc8"=>0,
    "\x8f\xb2\xc9"=>0,
    "\x8f\xb2\xca"=>0,
    "\x8f\xb2\xcb"=>0,
    "\x8f\xb2\xcc"=>0,
    "\x8f\xb2\xcd"=>0,
    "\x8f\xb2\xce"=>0,
    "\x8f\xb2\xcf"=>0,
    "\x8f\xb2\xd0"=>0,
    "\x8f\xb2\xd1"=>0,
    "\x8f\xb2\xd2"=>0,
    "\x8f\xb2\xd3"=>0,
    "\x8f\xb2\xd4"=>0,
    "\x8f\xb2\xd5"=>0,
    "\x8f\xb2\xd6"=>0,
    "\x8f\xb2\xd7"=>0,
    "\x8f\xb2\xd8"=>0,
    "\x8f\xb2\xd9"=>0,
    "\x8f\xb2\xda"=>0,
    "\x8f\xb2\xdb"=>0,
    "\x8f\xb2\xdc"=>0,
    "\x8f\xb2\xdd"=>0,
    "\x8f\xb2\xde"=>0,
    "\x8f\xb2\xdf"=>0,
    "\x8f\xb2\xe0"=>0,
    "\x8f\xb2\xe1"=>0,
    "\x8f\xb2\xe2"=>0,
    "\x8f\xb2\xe3"=>0,
    "\x8f\xb2\xe4"=>0,
    "\x8f\xb2\xe5"=>0,
    "\x8f\xb2\xe6"=>0,
    "\x8f\xb2\xe7"=>0,
    "\x8f\xb2\xe8"=>0,
    "\x8f\xb2\xe9"=>0,
    "\x8f\xb2\xea"=>0,
    "\x8f\xb2\xeb"=>0,
    "\x8f\xb2\xec"=>0,
    "\x8f\xb2\xed"=>0,
    "\x8f\xb2\xee"=>0,
    "\x8f\xb2\xef"=>0,
    "\x8f\xb2\xf0"=>0,
    "\x8f\xb2\xf1"=>0,
    "\x8f\xb2\xf2"=>0,
    "\x8f\xb2\xf3"=>0,
    "\x8f\xb2\xf4"=>0,
    "\x8f\xb2\xf5"=>0,
    "\x8f\xb2\xf6"=>0,
    "\x8f\xb2\xf7"=>0,
    "\x8f\xb2\xf8"=>0,
    "\x8f\xb2\xf9"=>0,
    "\x8f\xb2\xfa"=>0,
    "\x8f\xb2\xfb"=>0,
    "\x8f\xb2\xfc"=>0,
    "\x8f\xb2\xfd"=>0,
    "\x8f\xb2\xfe"=>0,
    "\x8f\xb3\xa1"=>0,
    "\x8f\xb3\xa2"=>0,
    "\x8f\xb3\xa3"=>0,
    "\x8f\xb3\xa4"=>0,
    "\x8f\xb3\xa5"=>0,
    "\x8f\xb3\xa6"=>0,
    "\x8f\xb3\xa7"=>0,
    "\x8f\xb3\xa8"=>0,
    "\x8f\xb3\xa9"=>0,
    "\x8f\xb3\xaa"=>0,
    "\x8f\xb3\xab"=>0,
    "\x8f\xb3\xac"=>0,
    "\x8f\xb3\xad"=>0,
    "\x8f\xb3\xae"=>0,
    "\x8f\xb3\xaf"=>0,
    "\x8f\xb3\xb0"=>0,
    "\x8f\xb3\xb1"=>0,
    "\x8f\xb3\xb2"=>0,
    "\x8f\xb3\xb3"=>0,
    "\x8f\xb3\xb4"=>0,
    "\x8f\xb3\xb5"=>0,
    "\x8f\xb3\xb6"=>0,
    "\x8f\xb3\xb7"=>0,
    "\x8f\xb3\xb8"=>0,
    "\x8f\xb3\xb9"=>0,
    "\x8f\xb3\xba"=>0,
    "\x8f\xb3\xbb"=>0,
    "\x8f\xb3\xbc"=>0,
    "\x8f\xb3\xbd"=>0,
    "\x8f\xb3\xbe"=>0,
    "\x8f\xb3\xbf"=>0,
    "\x8f\xb3\xc0"=>0,
    "\x8f\xb3\xc1"=>0,
    "\x8f\xb3\xc2"=>0,
    "\x8f\xb3\xc3"=>0,
    "\x8f\xb3\xc4"=>0,
    "\x8f\xb3\xc5"=>0,
    "\x8f\xb3\xc6"=>0,
    "\x8f\xb3\xc7"=>0,
    "\x8f\xb3\xc8"=>0,
    "\x8f\xb3\xc9"=>0,
    "\x8f\xb3\xca"=>0,
    "\x8f\xb3\xcb"=>0,
    "\x8f\xb3\xcc"=>0,
    "\x8f\xb3\xcd"=>0,
    "\x8f\xb3\xce"=>0,
    "\x8f\xb3\xcf"=>0,
    "\x8f\xb3\xd0"=>0,
    "\x8f\xb3\xd1"=>0,
    "\x8f\xb3\xd2"=>0,
    "\x8f\xb3\xd3"=>0,
    "\x8f\xb3\xd4"=>0,
    "\x8f\xb3\xd5"=>0,
    "\x8f\xb3\xd6"=>0,
    "\x8f\xb3\xd7"=>0,
    "\x8f\xb3\xd8"=>0,
    "\x8f\xb3\xd9"=>0,
    "\x8f\xb3\xda"=>0,
    "\x8f\xb3\xdb"=>0,
    "\x8f\xb3\xdc"=>0,
    "\x8f\xb3\xdd"=>0,
    "\x8f\xb3\xde"=>0,
    "\x8f\xb3\xdf"=>0,
    "\x8f\xb3\xe0"=>0,
    "\x8f\xb3\xe1"=>0,
    "\x8f\xb3\xe2"=>0,
    "\x8f\xb3\xe3"=>0,
    "\x8f\xb3\xe4"=>0,
    "\x8f\xb3\xe5"=>0,
    "\x8f\xb3\xe6"=>0,
    "\x8f\xb3\xe7"=>0,
    "\x8f\xb3\xe8"=>0,
    "\x8f\xb3\xe9"=>0,
    "\x8f\xb3\xea"=>0,
    "\x8f\xb3\xeb"=>0,
    "\x8f\xb3\xec"=>0,
    "\x8f\xb3\xed"=>0,
    "\x8f\xb3\xee"=>0,
    "\x8f\xb3\xef"=>0,
    "\x8f\xb3\xf0"=>0,
    "\x8f\xb3\xf1"=>0,
    "\x8f\xb3\xf2"=>0,
    "\x8f\xb3\xf3"=>0,
    "\x8f\xb3\xf4"=>0,
    "\x8f\xb3\xf5"=>0,
    "\x8f\xb3\xf6"=>0,
    "\x8f\xb3\xf7"=>0,
    "\x8f\xb3\xf8"=>0,
    "\x8f\xb3\xf9"=>0,
    "\x8f\xb3\xfa"=>0,
    "\x8f\xb3\xfb"=>0,
    "\x8f\xb3\xfc"=>0,
    "\x8f\xb3\xfd"=>0,
    "\x8f\xb3\xfe"=>0,
    "\x8f\xb4\xa1"=>0,
    "\x8f\xb4\xa2"=>0,
    "\x8f\xb4\xa3"=>0,
    "\x8f\xb4\xa4"=>0,
    "\x8f\xb4\xa5"=>0,
    "\x8f\xb4\xa6"=>0,
    "\x8f\xb4\xa7"=>0,
    "\x8f\xb4\xa8"=>0,
    "\x8f\xb4\xa9"=>0,
    "\x8f\xb4\xaa"=>0,
    "\x8f\xb4\xab"=>0,
    "\x8f\xb4\xac"=>0,
    "\x8f\xb4\xad"=>0,
    "\x8f\xb4\xae"=>0,
    "\x8f\xb4\xaf"=>0,
    "\x8f\xb4\xb0"=>0,
    "\x8f\xb4\xb1"=>0,
    "\x8f\xb4\xb2"=>0,
    "\x8f\xb4\xb3"=>0,
    "\x8f\xb4\xb4"=>0,
    "\x8f\xb4\xb5"=>0,
    "\x8f\xb4\xb6"=>0,
    "\x8f\xb4\xb7"=>0,
    "\x8f\xb4\xb8"=>0,
    "\x8f\xb4\xb9"=>0,
    "\x8f\xb4\xba"=>0,
    "\x8f\xb4\xbb"=>0,
    "\x8f\xb4\xbc"=>0,
    "\x8f\xb4\xbd"=>0,
    "\x8f\xb4\xbe"=>0,
    "\x8f\xb4\xbf"=>0,
    "\x8f\xb4\xc0"=>0,
    "\x8f\xb4\xc1"=>0,
    "\x8f\xb4\xc2"=>0,
    "\x8f\xb4\xc3"=>0,
    "\x8f\xb4\xc4"=>0,
    "\x8f\xb4\xc5"=>0,
    "\x8f\xb4\xc6"=>0,
    "\x8f\xb4\xc7"=>0,
    "\x8f\xb4\xc8"=>0,
    "\x8f\xb4\xc9"=>0,
    "\x8f\xb4\xca"=>0,
    "\x8f\xb4\xcb"=>0,
    "\x8f\xb4\xcc"=>0,
    "\x8f\xb4\xcd"=>0,
    "\x8f\xb4\xce"=>0,
    "\x8f\xb4\xcf"=>0,
    "\x8f\xb4\xd0"=>0,
    "\x8f\xb4\xd1"=>0,
    "\x8f\xb4\xd2"=>0,
    "\x8f\xb4\xd3"=>0,
    "\x8f\xb4\xd4"=>0,
    "\x8f\xb4\xd5"=>0,
    "\x8f\xb4\xd6"=>0,
    "\x8f\xb4\xd7"=>0,
    "\x8f\xb4\xd8"=>0,
    "\x8f\xb4\xd9"=>0,
    "\x8f\xb4\xda"=>0,
    "\x8f\xb4\xdb"=>0,
    "\x8f\xb4\xdc"=>0,
    "\x8f\xb4\xdd"=>0,
    "\x8f\xb4\xde"=>0,
    "\x8f\xb4\xdf"=>0,
    "\x8f\xb4\xe0"=>0,
    "\x8f\xb4\xe1"=>0,
    "\x8f\xb4\xe2"=>0,
    "\x8f\xb4\xe3"=>0,
    "\x8f\xb4\xe4"=>0,
    "\x8f\xb4\xe5"=>0,
    "\x8f\xb4\xe6"=>0,
    "\x8f\xb4\xe7"=>0,
    "\x8f\xb4\xe8"=>0,
    "\x8f\xb4\xe9"=>0,
    "\x8f\xb4\xea"=>0,
    "\x8f\xb4\xeb"=>0,
    "\x8f\xb4\xec"=>0,
    "\x8f\xb4\xed"=>0,
    "\x8f\xb4\xee"=>0,
    "\x8f\xb4\xef"=>0,
    "\x8f\xb4\xf0"=>0,
    "\x8f\xb4\xf1"=>0,
    "\x8f\xb4\xf2"=>0,
    "\x8f\xb4\xf3"=>0,
    "\x8f\xb4\xf4"=>0,
    "\x8f\xb4\xf5"=>0,
    "\x8f\xb4\xf6"=>0,
    "\x8f\xb4\xf7"=>0,
    "\x8f\xb4\xf8"=>0,
    "\x8f\xb4\xf9"=>0,
    "\x8f\xb4\xfa"=>0,
    "\x8f\xb4\xfb"=>0,
    "\x8f\xb4\xfc"=>0,
    "\x8f\xb4\xfd"=>0,
    "\x8f\xb4\xfe"=>0,
    "\x8f\xb5\xa1"=>0,
    "\x8f\xb5\xa2"=>0,
    "\x8f\xb5\xa3"=>0,
    "\x8f\xb5\xa4"=>0,
    "\x8f\xb5\xa5"=>0,
    "\x8f\xb5\xa6"=>0,
    "\x8f\xb5\xa7"=>0,
    "\x8f\xb5\xa8"=>0,
    "\x8f\xb5\xa9"=>0,
    "\x8f\xb5\xaa"=>0,
    "\x8f\xb5\xab"=>0,
    "\x8f\xb5\xac"=>0,
    "\x8f\xb5\xad"=>0,
    "\x8f\xb5\xae"=>0,
    "\x8f\xb5\xaf"=>0,
    "\x8f\xb5\xb0"=>0,
    "\x8f\xb5\xb1"=>0,
    "\x8f\xb5\xb2"=>0,
    "\x8f\xb5\xb3"=>0,
    "\x8f\xb5\xb4"=>0,
    "\x8f\xb5\xb5"=>0,
    "\x8f\xb5\xb6"=>0,
    "\x8f\xb5\xb7"=>0,
    "\x8f\xb5\xb8"=>0,
    "\x8f\xb5\xb9"=>0,
    "\x8f\xb5\xba"=>0,
    "\x8f\xb5\xbb"=>0,
    "\x8f\xb5\xbc"=>0,
    "\x8f\xb5\xbd"=>0,
    "\x8f\xb5\xbe"=>0,
    "\x8f\xb5\xbf"=>0,
    "\x8f\xb5\xc0"=>0,
    "\x8f\xb5\xc1"=>0,
    "\x8f\xb5\xc2"=>0,
    "\x8f\xb5\xc3"=>0,
    "\x8f\xb5\xc4"=>0,
    "\x8f\xb5\xc5"=>0,
    "\x8f\xb5\xc6"=>0,
    "\x8f\xb5\xc7"=>0,
    "\x8f\xb5\xc8"=>0,
    "\x8f\xb5\xc9"=>0,
    "\x8f\xb5\xca"=>0,
    "\x8f\xb5\xcb"=>0,
    "\x8f\xb5\xcc"=>0,
    "\x8f\xb5\xcd"=>0,
    "\x8f\xb5\xce"=>0,
    "\x8f\xb5\xcf"=>0,
    "\x8f\xb5\xd0"=>0,
    "\x8f\xb5\xd1"=>0,
    "\x8f\xb5\xd2"=>0,
    "\x8f\xb5\xd3"=>0,
    "\x8f\xb5\xd4"=>0,
    "\x8f\xb5\xd5"=>0,
    "\x8f\xb5\xd6"=>0,
    "\x8f\xb5\xd7"=>0,
    "\x8f\xb5\xd8"=>0,
    "\x8f\xb5\xd9"=>0,
    "\x8f\xb5\xda"=>0,
    "\x8f\xb5\xdb"=>0,
    "\x8f\xb5\xdc"=>0,
    "\x8f\xb5\xdd"=>0,
    "\x8f\xb5\xde"=>0,
    "\x8f\xb5\xdf"=>0,
    "\x8f\xb5\xe0"=>0,
    "\x8f\xb5\xe1"=>0,
    "\x8f\xb5\xe2"=>0,
    "\x8f\xb5\xe3"=>0,
    "\x8f\xb5\xe4"=>0,
    "\x8f\xb5\xe5"=>0,
    "\x8f\xb5\xe6"=>0,
    "\x8f\xb5\xe7"=>0,
    "\x8f\xb5\xe8"=>0,
    "\x8f\xb5\xe9"=>0,
    "\x8f\xb5\xea"=>0,
    "\x8f\xb5\xeb"=>0,
    "\x8f\xb5\xec"=>0,
    "\x8f\xb5\xed"=>0,
    "\x8f\xb5\xee"=>0,
    "\x8f\xb5\xef"=>0,
    "\x8f\xb5\xf0"=>0,
    "\x8f\xb5\xf1"=>0,
    "\x8f\xb5\xf2"=>0,
    "\x8f\xb5\xf3"=>0,
    "\x8f\xb5\xf4"=>0,
    "\x8f\xb5\xf5"=>0,
    "\x8f\xb5\xf6"=>0,
    "\x8f\xb5\xf7"=>0,
    "\x8f\xb5\xf8"=>0,
    "\x8f\xb5\xf9"=>0,
    "\x8f\xb5\xfa"=>0,
    "\x8f\xb5\xfb"=>0,
    "\x8f\xb5\xfc"=>0,
    "\x8f\xb5\xfd"=>0,
    "\x8f\xb5\xfe"=>0,
    "\x8f\xb6\xa1"=>0,
    "\x8f\xb6\xa2"=>0,
    "\x8f\xb6\xa3"=>0,
    "\x8f\xb6\xa4"=>0,
    "\x8f\xb6\xa5"=>0,
    "\x8f\xb6\xa6"=>0,
    "\x8f\xb6\xa7"=>0,
    "\x8f\xb6\xa8"=>0,
    "\x8f\xb6\xa9"=>0,
    "\x8f\xb6\xaa"=>0,
    "\x8f\xb6\xab"=>0,
    "\x8f\xb6\xac"=>0,
    "\x8f\xb6\xad"=>0,
    "\x8f\xb6\xae"=>0,
    "\x8f\xb6\xaf"=>0,
    "\x8f\xb6\xb0"=>0,
    "\x8f\xb6\xb1"=>0,
    "\x8f\xb6\xb2"=>0,
    "\x8f\xb6\xb3"=>0,
    "\x8f\xb6\xb4"=>0,
    "\x8f\xb6\xb5"=>0,
    "\x8f\xb6\xb6"=>0,
    "\x8f\xb6\xb7"=>0,
    "\x8f\xb6\xb8"=>0,
    "\x8f\xb6\xb9"=>0,
    "\x8f\xb6\xba"=>0,
    "\x8f\xb6\xbb"=>0,
    "\x8f\xb6\xbc"=>0,
    "\x8f\xb6\xbd"=>0,
    "\x8f\xb6\xbe"=>0,
    "\x8f\xb6\xbf"=>0,
    "\x8f\xb6\xc0"=>0,
    "\x8f\xb6\xc1"=>0,
    "\x8f\xb6\xc2"=>0,
    "\x8f\xb6\xc3"=>0,
    "\x8f\xb6\xc4"=>0,
    "\x8f\xb6\xc5"=>0,
    "\x8f\xb6\xc6"=>0,
    "\x8f\xb6\xc7"=>0,
    "\x8f\xb6\xc8"=>0,
    "\x8f\xb6\xc9"=>0,
    "\x8f\xb6\xca"=>0,
    "\x8f\xb6\xcb"=>0,
    "\x8f\xb6\xcc"=>0,
    "\x8f\xb6\xcd"=>0,
    "\x8f\xb6\xce"=>0,
    "\x8f\xb6\xcf"=>0,
    "\x8f\xb6\xd0"=>0,
    "\x8f\xb6\xd1"=>0,
    "\x8f\xb6\xd2"=>0,
    "\x8f\xb6\xd3"=>0,
    "\x8f\xb6\xd4"=>0,
    "\x8f\xb6\xd5"=>0,
    "\x8f\xb6\xd6"=>0,
    "\x8f\xb6\xd7"=>0,
    "\x8f\xb6\xd8"=>0,
    "\x8f\xb6\xd9"=>0,
    "\x8f\xb6\xda"=>0,
    "\x8f\xb6\xdb"=>0,
    "\x8f\xb6\xdc"=>0,
    "\x8f\xb6\xdd"=>0,
    "\x8f\xb6\xde"=>0,
    "\x8f\xb6\xdf"=>0,
    "\x8f\xb6\xe0"=>0,
    "\x8f\xb6\xe1"=>0,
    "\x8f\xb6\xe2"=>0,
    "\x8f\xb6\xe3"=>0,
    "\x8f\xb6\xe4"=>0,
    "\x8f\xb6\xe5"=>0,
    "\x8f\xb6\xe6"=>0,
    "\x8f\xb6\xe7"=>0,
    "\x8f\xb6\xe8"=>0,
    "\x8f\xb6\xe9"=>0,
    "\x8f\xb6\xea"=>0,
    "\x8f\xb6\xeb"=>0,
    "\x8f\xb6\xec"=>0,
    "\x8f\xb6\xed"=>0,
    "\x8f\xb6\xee"=>0,
    "\x8f\xb6\xef"=>0,
    "\x8f\xb6\xf0"=>0,
    "\x8f\xb6\xf1"=>0,
    "\x8f\xb6\xf2"=>0,
    "\x8f\xb6\xf3"=>0,
    "\x8f\xb6\xf4"=>0,
    "\x8f\xb6\xf5"=>0,
    "\x8f\xb6\xf6"=>0,
    "\x8f\xb6\xf7"=>0,
    "\x8f\xb6\xf8"=>0,
    "\x8f\xb6\xf9"=>0,
    "\x8f\xb6\xfa"=>0,
    "\x8f\xb6\xfb"=>0,
    "\x8f\xb6\xfc"=>0,
    "\x8f\xb6\xfd"=>0,
    "\x8f\xb6\xfe"=>0,
    "\x8f\xb7\xa1"=>0,
    "\x8f\xb7\xa2"=>0,
    "\x8f\xb7\xa3"=>0,
    "\x8f\xb7\xa4"=>0,
    "\x8f\xb7\xa5"=>0,
    "\x8f\xb7\xa6"=>0,
    "\x8f\xb7\xa7"=>0,
    "\x8f\xb7\xa8"=>0,
    "\x8f\xb7\xa9"=>0,
    "\x8f\xb7\xaa"=>0,
    "\x8f\xb7\xab"=>0,
    "\x8f\xb7\xac"=>0,
    "\x8f\xb7\xad"=>0,
    "\x8f\xb7\xae"=>0,
    "\x8f\xb7\xaf"=>0,
    "\x8f\xb7\xb0"=>0,
    "\x8f\xb7\xb1"=>0,
    "\x8f\xb7\xb2"=>0,
    "\x8f\xb7\xb3"=>0,
    "\x8f\xb7\xb4"=>0,
    "\x8f\xb7\xb5"=>0,
    "\x8f\xb7\xb6"=>0,
    "\x8f\xb7\xb7"=>0,
    "\x8f\xb7\xb8"=>0,
    "\x8f\xb7\xb9"=>0,
    "\x8f\xb7\xba"=>0,
    "\x8f\xb7\xbb"=>0,
    "\x8f\xb7\xbc"=>0,
    "\x8f\xb7\xbd"=>0,
    "\x8f\xb7\xbe"=>0,
    "\x8f\xb7\xbf"=>0,
    "\x8f\xb7\xc0"=>0,
    "\x8f\xb7\xc1"=>0,
    "\x8f\xb7\xc2"=>0,
    "\x8f\xb7\xc3"=>0,
    "\x8f\xb7\xc4"=>0,
    "\x8f\xb7\xc5"=>0,
    "\x8f\xb7\xc6"=>0,
    "\x8f\xb7\xc7"=>0,
    "\x8f\xb7\xc8"=>0,
    "\x8f\xb7\xc9"=>0,
    "\x8f\xb7\xca"=>0,
    "\x8f\xb7\xcb"=>0,
    "\x8f\xb7\xcc"=>0,
    "\x8f\xb7\xcd"=>0,
    "\x8f\xb7\xce"=>0,
    "\x8f\xb7\xcf"=>0,
    "\x8f\xb7\xd0"=>0,
    "\x8f\xb7\xd1"=>0,
    "\x8f\xb7\xd2"=>0,
    "\x8f\xb7\xd3"=>0,
    "\x8f\xb7\xd4"=>0,
    "\x8f\xb7\xd5"=>0,
    "\x8f\xb7\xd6"=>0,
    "\x8f\xb7\xd7"=>0,
    "\x8f\xb7\xd8"=>0,
    "\x8f\xb7\xd9"=>0,
    "\x8f\xb7\xda"=>0,
    "\x8f\xb7\xdb"=>0,
    "\x8f\xb7\xdc"=>0,
    "\x8f\xb7\xdd"=>0,
    "\x8f\xb7\xde"=>0,
    "\x8f\xb7\xdf"=>0,
    "\x8f\xb7\xe0"=>0,
    "\x8f\xb7\xe1"=>0,
    "\x8f\xb7\xe2"=>0,
    "\x8f\xb7\xe3"=>0,
    "\x8f\xb7\xe4"=>0,
    "\x8f\xb7\xe5"=>0,
    "\x8f\xb7\xe6"=>0,
    "\x8f\xb7\xe7"=>0,
    "\x8f\xb7\xe8"=>0,
    "\x8f\xb7\xe9"=>0,
    "\x8f\xb7\xea"=>0,
    "\x8f\xb7\xeb"=>0,
    "\x8f\xb7\xec"=>0,
    "\x8f\xb7\xed"=>0,
    "\x8f\xb7\xee"=>0,
    "\x8f\xb7\xef"=>0,
    "\x8f\xb7\xf0"=>0,
    "\x8f\xb7\xf1"=>0,
    "\x8f\xb7\xf2"=>0,
    "\x8f\xb7\xf3"=>0,
    "\x8f\xb7\xf4"=>0,
    "\x8f\xb7\xf5"=>0,
    "\x8f\xb7\xf6"=>0,
    "\x8f\xb7\xf7"=>0,
    "\x8f\xb7\xf8"=>0,
    "\x8f\xb7\xf9"=>0,
    "\x8f\xb7\xfa"=>0,
    "\x8f\xb7\xfb"=>0,
    "\x8f\xb7\xfc"=>0,
    "\x8f\xb7\xfd"=>0,
    "\x8f\xb7\xfe"=>0,
    "\x8f\xb8\xa1"=>0,
    "\x8f\xb8\xa2"=>0,
    "\x8f\xb8\xa3"=>0,
    "\x8f\xb8\xa4"=>0,
    "\x8f\xb8\xa5"=>0,
    "\x8f\xb8\xa6"=>0,
    "\x8f\xb8\xa7"=>0,
    "\x8f\xb8\xa8"=>0,
    "\x8f\xb8\xa9"=>0,
    "\x8f\xb8\xaa"=>0,
    "\x8f\xb8\xab"=>0,
    "\x8f\xb8\xac"=>0,
    "\x8f\xb8\xad"=>0,
    "\x8f\xb8\xae"=>0,
    "\x8f\xb8\xaf"=>0,
    "\x8f\xb8\xb0"=>0,
    "\x8f\xb8\xb1"=>0,
    "\x8f\xb8\xb2"=>0,
    "\x8f\xb8\xb3"=>0,
    "\x8f\xb8\xb4"=>0,
    "\x8f\xb8\xb5"=>0,
    "\x8f\xb8\xb6"=>0,
    "\x8f\xb8\xb7"=>0,
    "\x8f\xb8\xb8"=>0,
    "\x8f\xb8\xb9"=>0,
    "\x8f\xb8\xba"=>0,
    "\x8f\xb8\xbb"=>0,
    "\x8f\xb8\xbc"=>0,
    "\x8f\xb8\xbd"=>0,
    "\x8f\xb8\xbe"=>0,
    "\x8f\xb8\xbf"=>0,
    "\x8f\xb8\xc0"=>0,
    "\x8f\xb8\xc1"=>0,
    "\x8f\xb8\xc2"=>0,
    "\x8f\xb8\xc3"=>0,
    "\x8f\xb8\xc4"=>0,
    "\x8f\xb8\xc5"=>0,
    "\x8f\xb8\xc6"=>0,
    "\x8f\xb8\xc7"=>0,
    "\x8f\xb8\xc8"=>0,
    "\x8f\xb8\xc9"=>0,
    "\x8f\xb8\xca"=>0,
    "\x8f\xb8\xcb"=>0,
    "\x8f\xb8\xcc"=>0,
    "\x8f\xb8\xcd"=>0,
    "\x8f\xb8\xce"=>0,
    "\x8f\xb8\xcf"=>0,
    "\x8f\xb8\xd0"=>0,
    "\x8f\xb8\xd1"=>0,
    "\x8f\xb8\xd2"=>0,
    "\x8f\xb8\xd3"=>0,
    "\x8f\xb8\xd4"=>0,
    "\x8f\xb8\xd5"=>0,
    "\x8f\xb8\xd6"=>0,
    "\x8f\xb8\xd7"=>0,
    "\x8f\xb8\xd8"=>0,
    "\x8f\xb8\xd9"=>0,
    "\x8f\xb8\xda"=>0,
    "\x8f\xb8\xdb"=>0,
    "\x8f\xb8\xdc"=>0,
    "\x8f\xb8\xdd"=>0,
    "\x8f\xb8\xde"=>0,
    "\x8f\xb8\xdf"=>0,
    "\x8f\xb8\xe0"=>0,
    "\x8f\xb8\xe1"=>0,
    "\x8f\xb8\xe2"=>0,
    "\x8f\xb8\xe3"=>0,
    "\x8f\xb8\xe4"=>0,
    "\x8f\xb8\xe5"=>0,
    "\x8f\xb8\xe6"=>0,
    "\x8f\xb8\xe7"=>0,
    "\x8f\xb8\xe8"=>0,
    "\x8f\xb8\xe9"=>0,
    "\x8f\xb8\xea"=>0,
    "\x8f\xb8\xeb"=>0,
    "\x8f\xb8\xec"=>0,
    "\x8f\xb8\xed"=>0,
    "\x8f\xb8\xee"=>0,
    "\x8f\xb8\xef"=>0,
    "\x8f\xb8\xf0"=>0,
    "\x8f\xb8\xf1"=>0,
    "\x8f\xb8\xf2"=>0,
    "\x8f\xb8\xf3"=>0,
    "\x8f\xb8\xf4"=>0,
    "\x8f\xb8\xf5"=>0,
    "\x8f\xb8\xf6"=>0,
    "\x8f\xb8\xf7"=>0,
    "\x8f\xb8\xf8"=>0,
    "\x8f\xb8\xf9"=>0,
    "\x8f\xb8\xfa"=>0,
    "\x8f\xb8\xfb"=>0,
    "\x8f\xb8\xfc"=>0,
    "\x8f\xb8\xfd"=>0,
    "\x8f\xb8\xfe"=>0,
    "\x8f\xb9\xa1"=>0,
    "\x8f\xb9\xa2"=>0,
    "\x8f\xb9\xa3"=>0,
    "\x8f\xb9\xa4"=>0,
    "\x8f\xb9\xa5"=>0,
    "\x8f\xb9\xa6"=>0,
    "\x8f\xb9\xa7"=>0,
    "\x8f\xb9\xa8"=>0,
    "\x8f\xb9\xa9"=>0,
    "\x8f\xb9\xaa"=>0,
    "\x8f\xb9\xab"=>0,
    "\x8f\xb9\xac"=>0,
    "\x8f\xb9\xad"=>0,
    "\x8f\xb9\xae"=>0,
    "\x8f\xb9\xaf"=>0,
    "\x8f\xb9\xb0"=>0,
    "\x8f\xb9\xb1"=>0,
    "\x8f\xb9\xb2"=>0,
    "\x8f\xb9\xb3"=>0,
    "\x8f\xb9\xb4"=>0,
    "\x8f\xb9\xb5"=>0,
    "\x8f\xb9\xb6"=>0,
    "\x8f\xb9\xb7"=>0,
    "\x8f\xb9\xb8"=>0,
    "\x8f\xb9\xb9"=>0,
    "\x8f\xb9\xba"=>0,
    "\x8f\xb9\xbb"=>0,
    "\x8f\xb9\xbc"=>0,
    "\x8f\xb9\xbd"=>0,
    "\x8f\xb9\xbe"=>0,
    "\x8f\xb9\xbf"=>0,
    "\x8f\xb9\xc0"=>0,
    "\x8f\xb9\xc1"=>0,
    "\x8f\xb9\xc2"=>0,
    "\x8f\xb9\xc3"=>0,
    "\x8f\xb9\xc4"=>0,
    "\x8f\xb9\xc5"=>0,
    "\x8f\xb9\xc6"=>0,
    "\x8f\xb9\xc7"=>0,
    "\x8f\xb9\xc8"=>0,
    "\x8f\xb9\xc9"=>0,
    "\x8f\xb9\xca"=>0,
    "\x8f\xb9\xcb"=>0,
    "\x8f\xb9\xcc"=>0,
    "\x8f\xb9\xcd"=>0,
    "\x8f\xb9\xce"=>0,
    "\x8f\xb9\xcf"=>0,
    "\x8f\xb9\xd0"=>0,
    "\x8f\xb9\xd1"=>0,
    "\x8f\xb9\xd2"=>0,
    "\x8f\xb9\xd3"=>0,
    "\x8f\xb9\xd4"=>0,
    "\x8f\xb9\xd5"=>0,
    "\x8f\xb9\xd6"=>0,
    "\x8f\xb9\xd7"=>0,
    "\x8f\xb9\xd8"=>0,
    "\x8f\xb9\xd9"=>0,
    "\x8f\xb9\xda"=>0,
    "\x8f\xb9\xdb"=>0,
    "\x8f\xb9\xdc"=>0,
    "\x8f\xb9\xdd"=>0,
    "\x8f\xb9\xde"=>0,
    "\x8f\xb9\xdf"=>0,
    "\x8f\xb9\xe0"=>0,
    "\x8f\xb9\xe1"=>0,
    "\x8f\xb9\xe2"=>0,
    "\x8f\xb9\xe3"=>0,
    "\x8f\xb9\xe4"=>0,
    "\x8f\xb9\xe5"=>0,
    "\x8f\xb9\xe6"=>0,
    "\x8f\xb9\xe7"=>0,
    "\x8f\xb9\xe8"=>0,
    "\x8f\xb9\xe9"=>0,
    "\x8f\xb9\xea"=>0,
    "\x8f\xb9\xeb"=>0,
    "\x8f\xb9\xec"=>0,
    "\x8f\xb9\xed"=>0,
    "\x8f\xb9\xee"=>0,
    "\x8f\xb9\xef"=>0,
    "\x8f\xb9\xf0"=>0,
    "\x8f\xb9\xf1"=>0,
    "\x8f\xb9\xf2"=>0,
    "\x8f\xb9\xf3"=>0,
    "\x8f\xb9\xf4"=>0,
    "\x8f\xb9\xf5"=>0,
    "\x8f\xb9\xf6"=>0,
    "\x8f\xb9\xf7"=>0,
    "\x8f\xb9\xf8"=>0,
    "\x8f\xb9\xf9"=>0,
    "\x8f\xb9\xfa"=>0,
    "\x8f\xb9\xfb"=>0,
    "\x8f\xb9\xfc"=>0,
    "\x8f\xb9\xfd"=>0,
    "\x8f\xb9\xfe"=>0,
    "\x8f\xba\xa1"=>0,
    "\x8f\xba\xa2"=>0,
    "\x8f\xba\xa3"=>0,
    "\x8f\xba\xa4"=>0,
    "\x8f\xba\xa5"=>0,
    "\x8f\xba\xa6"=>0,
    "\x8f\xba\xa7"=>0,
    "\x8f\xba\xa8"=>0,
    "\x8f\xba\xa9"=>0,
    "\x8f\xba\xaa"=>0,
    "\x8f\xba\xab"=>0,
    "\x8f\xba\xac"=>0,
    "\x8f\xba\xad"=>0,
    "\x8f\xba\xae"=>0,
    "\x8f\xba\xaf"=>0,
    "\x8f\xba\xb0"=>0,
    "\x8f\xba\xb1"=>0,
    "\x8f\xba\xb2"=>0,
    "\x8f\xba\xb3"=>0,
    "\x8f\xba\xb4"=>0,
    "\x8f\xba\xb5"=>0,
    "\x8f\xba\xb6"=>0,
    "\x8f\xba\xb7"=>0,
    "\x8f\xba\xb8"=>0,
    "\x8f\xba\xb9"=>0,
    "\x8f\xba\xba"=>0,
    "\x8f\xba\xbb"=>0,
    "\x8f\xba\xbc"=>0,
    "\x8f\xba\xbd"=>0,
    "\x8f\xba\xbe"=>0,
    "\x8f\xba\xbf"=>0,
    "\x8f\xba\xc0"=>0,
    "\x8f\xba\xc1"=>0,
    "\x8f\xba\xc2"=>0,
    "\x8f\xba\xc3"=>0,
    "\x8f\xba\xc4"=>0,
    "\x8f\xba\xc5"=>0,
    "\x8f\xba\xc6"=>0,
    "\x8f\xba\xc7"=>0,
    "\x8f\xba\xc8"=>0,
    "\x8f\xba\xc9"=>0,
    "\x8f\xba\xca"=>0,
    "\x8f\xba\xcb"=>0,
    "\x8f\xba\xcc"=>0,
    "\x8f\xba\xcd"=>0,
    "\x8f\xba\xce"=>0,
    "\x8f\xba\xcf"=>0,
    "\x8f\xba\xd0"=>0,
    "\x8f\xba\xd1"=>0,
    "\x8f\xba\xd2"=>0,
    "\x8f\xba\xd3"=>0,
    "\x8f\xba\xd4"=>0,
    "\x8f\xba\xd5"=>0,
    "\x8f\xba\xd6"=>0,
    "\x8f\xba\xd7"=>0,
    "\x8f\xba\xd8"=>0,
    "\x8f\xba\xd9"=>0,
    "\x8f\xba\xda"=>0,
    "\x8f\xba\xdb"=>0,
    "\x8f\xba\xdc"=>0,
    "\x8f\xba\xdd"=>0,
    "\x8f\xba\xde"=>0,
    "\x8f\xba\xdf"=>0,
    "\x8f\xba\xe0"=>0,
    "\x8f\xba\xe1"=>0,
    "\x8f\xba\xe2"=>0,
    "\x8f\xba\xe3"=>0,
    "\x8f\xba\xe4"=>0,
    "\x8f\xba\xe5"=>0,
    "\x8f\xba\xe6"=>0,
    "\x8f\xba\xe7"=>0,
    "\x8f\xba\xe8"=>0,
    "\x8f\xba\xe9"=>0,
    "\x8f\xba\xea"=>0,
    "\x8f\xba\xeb"=>0,
    "\x8f\xba\xec"=>0,
    "\x8f\xba\xed"=>0,
    "\x8f\xba\xee"=>0,
    "\x8f\xba\xef"=>0,
    "\x8f\xba\xf0"=>0,
    "\x8f\xba\xf1"=>0,
    "\x8f\xba\xf2"=>0,
    "\x8f\xba\xf3"=>0,
    "\x8f\xba\xf4"=>0,
    "\x8f\xba\xf5"=>0,
    "\x8f\xba\xf6"=>0,
    "\x8f\xba\xf7"=>0,
    "\x8f\xba\xf8"=>0,
    "\x8f\xba\xf9"=>0,
    "\x8f\xba\xfa"=>0,
    "\x8f\xba\xfb"=>0,
    "\x8f\xba\xfc"=>0,
    "\x8f\xba\xfd"=>0,
    "\x8f\xba\xfe"=>0,
    "\x8f\xbb\xa1"=>0,
    "\x8f\xbb\xa2"=>0,
    "\x8f\xbb\xa3"=>0,
    "\x8f\xbb\xa4"=>0,
    "\x8f\xbb\xa5"=>0,
    "\x8f\xbb\xa6"=>0,
    "\x8f\xbb\xa7"=>0,
    "\x8f\xbb\xa8"=>0,
    "\x8f\xbb\xa9"=>0,
    "\x8f\xbb\xaa"=>0,
    "\x8f\xbb\xab"=>0,
    "\x8f\xbb\xac"=>0,
    "\x8f\xbb\xad"=>0,
    "\x8f\xbb\xae"=>0,
    "\x8f\xbb\xaf"=>0,
    "\x8f\xbb\xb0"=>0,
    "\x8f\xbb\xb1"=>0,
    "\x8f\xbb\xb2"=>0,
    "\x8f\xbb\xb3"=>0,
    "\x8f\xbb\xb4"=>0,
    "\x8f\xbb\xb5"=>0,
    "\x8f\xbb\xb6"=>0,
    "\x8f\xbb\xb7"=>0,
    "\x8f\xbb\xb8"=>0,
    "\x8f\xbb\xb9"=>0,
    "\x8f\xbb\xba"=>0,
    "\x8f\xbb\xbb"=>0,
    "\x8f\xbb\xbc"=>0,
    "\x8f\xbb\xbd"=>0,
    "\x8f\xbb\xbe"=>0,
    "\x8f\xbb\xbf"=>0,
    "\x8f\xbb\xc0"=>0,
    "\x8f\xbb\xc1"=>0,
    "\x8f\xbb\xc2"=>0,
    "\x8f\xbb\xc3"=>0,
    "\x8f\xbb\xc4"=>0,
    "\x8f\xbb\xc5"=>0,
    "\x8f\xbb\xc6"=>0,
    "\x8f\xbb\xc7"=>0,
    "\x8f\xbb\xc8"=>0,
    "\x8f\xbb\xc9"=>0,
    "\x8f\xbb\xca"=>0,
    "\x8f\xbb\xcb"=>0,
    "\x8f\xbb\xcc"=>0,
    "\x8f\xbb\xcd"=>0,
    "\x8f\xbb\xce"=>0,
    "\x8f\xbb\xcf"=>0,
    "\x8f\xbb\xd0"=>0,
    "\x8f\xbb\xd1"=>0,
    "\x8f\xbb\xd2"=>0,
    "\x8f\xbb\xd3"=>0,
    "\x8f\xbb\xd4"=>0,
    "\x8f\xbb\xd5"=>0,
    "\x8f\xbb\xd6"=>0,
    "\x8f\xbb\xd7"=>0,
    "\x8f\xbb\xd8"=>0,
    "\x8f\xbb\xd9"=>0,
    "\x8f\xbb\xda"=>0,
    "\x8f\xbb\xdb"=>0,
    "\x8f\xbb\xdc"=>0,
    "\x8f\xbb\xdd"=>0,
    "\x8f\xbb\xde"=>0,
    "\x8f\xbb\xdf"=>0,
    "\x8f\xbb\xe0"=>0,
    "\x8f\xbb\xe1"=>0,
    "\x8f\xbb\xe2"=>0,
    "\x8f\xbb\xe3"=>0,
    "\x8f\xbb\xe4"=>0,
    "\x8f\xbb\xe5"=>0,
    "\x8f\xbb\xe6"=>0,
    "\x8f\xbb\xe7"=>0,
    "\x8f\xbb\xe8"=>0,
    "\x8f\xbb\xe9"=>0,
    "\x8f\xbb\xea"=>0,
    "\x8f\xbb\xeb"=>0,
    "\x8f\xbb\xec"=>0,
    "\x8f\xbb\xed"=>0,
    "\x8f\xbb\xee"=>0,
    "\x8f\xbb\xef"=>0,
    "\x8f\xbb\xf0"=>0,
    "\x8f\xbb\xf1"=>0,
    "\x8f\xbb\xf2"=>0,
    "\x8f\xbb\xf3"=>0,
    "\x8f\xbb\xf4"=>0,
    "\x8f\xbb\xf5"=>0,
    "\x8f\xbb\xf6"=>0,
    "\x8f\xbb\xf7"=>0,
    "\x8f\xbb\xf8"=>0,
    "\x8f\xbb\xf9"=>0,
    "\x8f\xbb\xfa"=>0,
    "\x8f\xbb\xfb"=>0,
    "\x8f\xbb\xfc"=>0,
    "\x8f\xbb\xfd"=>0,
    "\x8f\xbb\xfe"=>0,
    "\x8f\xbc\xa1"=>0,
    "\x8f\xbc\xa2"=>0,
    "\x8f\xbc\xa3"=>0,
    "\x8f\xbc\xa4"=>0,
    "\x8f\xbc\xa5"=>0,
    "\x8f\xbc\xa6"=>0,
    "\x8f\xbc\xa7"=>0,
    "\x8f\xbc\xa8"=>0,
    "\x8f\xbc\xa9"=>0,
    "\x8f\xbc\xaa"=>0,
    "\x8f\xbc\xab"=>0,
    "\x8f\xbc\xac"=>0,
    "\x8f\xbc\xad"=>0,
    "\x8f\xbc\xae"=>0,
    "\x8f\xbc\xaf"=>0,
    "\x8f\xbc\xb0"=>0,
    "\x8f\xbc\xb1"=>0,
    "\x8f\xbc\xb2"=>0,
    "\x8f\xbc\xb3"=>0,
    "\x8f\xbc\xb4"=>0,
    "\x8f\xbc\xb5"=>0,
    "\x8f\xbc\xb6"=>0,
    "\x8f\xbc\xb7"=>0,
    "\x8f\xbc\xb8"=>0,
    "\x8f\xbc\xb9"=>0,
    "\x8f\xbc\xba"=>0,
    "\x8f\xbc\xbb"=>0,
    "\x8f\xbc\xbc"=>0,
    "\x8f\xbc\xbd"=>0,
    "\x8f\xbc\xbe"=>0,
    "\x8f\xbc\xbf"=>0,
    "\x8f\xbc\xc0"=>0,
    "\x8f\xbc\xc1"=>0,
    "\x8f\xbc\xc2"=>0,
    "\x8f\xbc\xc3"=>0,
    "\x8f\xbc\xc4"=>0,
    "\x8f\xbc\xc5"=>0,
    "\x8f\xbc\xc6"=>0,
    "\x8f\xbc\xc7"=>0,
    "\x8f\xbc\xc8"=>0,
    "\x8f\xbc\xc9"=>0,
    "\x8f\xbc\xca"=>0,
    "\x8f\xbc\xcb"=>0,
    "\x8f\xbc\xcc"=>0,
    "\x8f\xbc\xcd"=>0,
    "\x8f\xbc\xce"=>0,
    "\x8f\xbc\xcf"=>0,
    "\x8f\xbc\xd0"=>0,
    "\x8f\xbc\xd1"=>0,
    "\x8f\xbc\xd2"=>0,
    "\x8f\xbc\xd3"=>0,
    "\x8f\xbc\xd4"=>0,
    "\x8f\xbc\xd5"=>0,
    "\x8f\xbc\xd6"=>0,
    "\x8f\xbc\xd7"=>0,
    "\x8f\xbc\xd8"=>0,
    "\x8f\xbc\xd9"=>0,
    "\x8f\xbc\xda"=>0,
    "\x8f\xbc\xdb"=>0,
    "\x8f\xbc\xdc"=>0,
    "\x8f\xbc\xdd"=>0,
    "\x8f\xbc\xde"=>0,
    "\x8f\xbc\xdf"=>0,
    "\x8f\xbc\xe0"=>0,
    "\x8f\xbc\xe1"=>0,
    "\x8f\xbc\xe2"=>0,
    "\x8f\xbc\xe3"=>0,
    "\x8f\xbc\xe4"=>0,
    "\x8f\xbc\xe5"=>0,
    "\x8f\xbc\xe6"=>0,
    "\x8f\xbc\xe7"=>0,
    "\x8f\xbc\xe8"=>0,
    "\x8f\xbc\xe9"=>0,
    "\x8f\xbc\xea"=>0,
    "\x8f\xbc\xeb"=>0,
    "\x8f\xbc\xec"=>0,
    "\x8f\xbc\xed"=>0,
    "\x8f\xbc\xee"=>0,
    "\x8f\xbc\xef"=>0,
    "\x8f\xbc\xf0"=>0,
    "\x8f\xbc\xf1"=>0,
    "\x8f\xbc\xf2"=>0,
    "\x8f\xbc\xf3"=>0,
    "\x8f\xbc\xf4"=>0,
    "\x8f\xbc\xf5"=>0,
    "\x8f\xbc\xf6"=>0,
    "\x8f\xbc\xf7"=>0,
    "\x8f\xbc\xf8"=>0,
    "\x8f\xbc\xf9"=>0,
    "\x8f\xbc\xfa"=>0,
    "\x8f\xbc\xfb"=>0,
    "\x8f\xbc\xfc"=>0,
    "\x8f\xbc\xfd"=>0,
    "\x8f\xbc\xfe"=>0,
    "\x8f\xbd\xa1"=>0,
    "\x8f\xbd\xa2"=>0,
    "\x8f\xbd\xa3"=>0,
    "\x8f\xbd\xa4"=>0,
    "\x8f\xbd\xa5"=>0,
    "\x8f\xbd\xa6"=>0,
    "\x8f\xbd\xa7"=>0,
    "\x8f\xbd\xa8"=>0,
    "\x8f\xbd\xa9"=>0,
    "\x8f\xbd\xaa"=>0,
    "\x8f\xbd\xab"=>0,
    "\x8f\xbd\xac"=>0,
    "\x8f\xbd\xad"=>0,
    "\x8f\xbd\xae"=>0,
    "\x8f\xbd\xaf"=>0,
    "\x8f\xbd\xb0"=>0,
    "\x8f\xbd\xb1"=>0,
    "\x8f\xbd\xb2"=>0,
    "\x8f\xbd\xb3"=>0,
    "\x8f\xbd\xb4"=>0,
    "\x8f\xbd\xb5"=>0,
    "\x8f\xbd\xb6"=>0,
    "\x8f\xbd\xb7"=>0,
    "\x8f\xbd\xb8"=>0,
    "\x8f\xbd\xb9"=>0,
    "\x8f\xbd\xba"=>0,
    "\x8f\xbd\xbb"=>0,
    "\x8f\xbd\xbc"=>0,
    "\x8f\xbd\xbd"=>0,
    "\x8f\xbd\xbe"=>0,
    "\x8f\xbd\xbf"=>0,
    "\x8f\xbd\xc0"=>0,
    "\x8f\xbd\xc1"=>0,
    "\x8f\xbd\xc2"=>0,
    "\x8f\xbd\xc3"=>0,
    "\x8f\xbd\xc4"=>0,
    "\x8f\xbd\xc5"=>0,
    "\x8f\xbd\xc6"=>0,
    "\x8f\xbd\xc7"=>0,
    "\x8f\xbd\xc8"=>0,
    "\x8f\xbd\xc9"=>0,
    "\x8f\xbd\xca"=>0,
    "\x8f\xbd\xcb"=>0,
    "\x8f\xbd\xcc"=>0,
    "\x8f\xbd\xcd"=>0,
    "\x8f\xbd\xce"=>0,
    "\x8f\xbd\xcf"=>0,
    "\x8f\xbd\xd0"=>0,
    "\x8f\xbd\xd1"=>0,
    "\x8f\xbd\xd2"=>0,
    "\x8f\xbd\xd3"=>0,
    "\x8f\xbd\xd4"=>0,
    "\x8f\xbd\xd5"=>0,
    "\x8f\xbd\xd6"=>0,
    "\x8f\xbd\xd7"=>0,
    "\x8f\xbd\xd8"=>0,
    "\x8f\xbd\xd9"=>0,
    "\x8f\xbd\xda"=>0,
    "\x8f\xbd\xdb"=>0,
    "\x8f\xbd\xdc"=>0,
    "\x8f\xbd\xdd"=>0,
    "\x8f\xbd\xde"=>0,
    "\x8f\xbd\xdf"=>0,
    "\x8f\xbd\xe0"=>0,
    "\x8f\xbd\xe1"=>0,
    "\x8f\xbd\xe2"=>0,
    "\x8f\xbd\xe3"=>0,
    "\x8f\xbd\xe4"=>0,
    "\x8f\xbd\xe5"=>0,
    "\x8f\xbd\xe6"=>0,
    "\x8f\xbd\xe7"=>0,
    "\x8f\xbd\xe8"=>0,
    "\x8f\xbd\xe9"=>0,
    "\x8f\xbd\xea"=>0,
    "\x8f\xbd\xeb"=>0,
    "\x8f\xbd\xec"=>0,
    "\x8f\xbd\xed"=>0,
    "\x8f\xbd\xee"=>0,
    "\x8f\xbd\xef"=>0,
    "\x8f\xbd\xf0"=>0,
    "\x8f\xbd\xf1"=>0,
    "\x8f\xbd\xf2"=>0,
    "\x8f\xbd\xf3"=>0,
    "\x8f\xbd\xf4"=>0,
    "\x8f\xbd\xf5"=>0,
    "\x8f\xbd\xf6"=>0,
    "\x8f\xbd\xf7"=>0,
    "\x8f\xbd\xf8"=>0,
    "\x8f\xbd\xf9"=>0,
    "\x8f\xbd\xfa"=>0,
    "\x8f\xbd\xfb"=>0,
    "\x8f\xbd\xfc"=>0,
    "\x8f\xbd\xfd"=>0,
    "\x8f\xbd\xfe"=>0,
    "\x8f\xbe\xa1"=>0,
    "\x8f\xbe\xa2"=>0,
    "\x8f\xbe\xa3"=>0,
    "\x8f\xbe\xa4"=>0,
    "\x8f\xbe\xa5"=>0,
    "\x8f\xbe\xa6"=>0,
    "\x8f\xbe\xa7"=>0,
    "\x8f\xbe\xa8"=>0,
    "\x8f\xbe\xa9"=>0,
    "\x8f\xbe\xaa"=>0,
    "\x8f\xbe\xab"=>0,
    "\x8f\xbe\xac"=>0,
    "\x8f\xbe\xad"=>0,
    "\x8f\xbe\xae"=>0,
    "\x8f\xbe\xaf"=>0,
    "\x8f\xbe\xb0"=>0,
    "\x8f\xbe\xb1"=>0,
    "\x8f\xbe\xb2"=>0,
    "\x8f\xbe\xb3"=>0,
    "\x8f\xbe\xb4"=>0,
    "\x8f\xbe\xb5"=>0,
    "\x8f\xbe\xb6"=>0,
    "\x8f\xbe\xb7"=>0,
    "\x8f\xbe\xb8"=>0,
    "\x8f\xbe\xb9"=>0,
    "\x8f\xbe\xba"=>0,
    "\x8f\xbe\xbb"=>0,
    "\x8f\xbe\xbc"=>0,
    "\x8f\xbe\xbd"=>0,
    "\x8f\xbe\xbe"=>0,
    "\x8f\xbe\xbf"=>0,
    "\x8f\xbe\xc0"=>0,
    "\x8f\xbe\xc1"=>0,
    "\x8f\xbe\xc2"=>0,
    "\x8f\xbe\xc3"=>0,
    "\x8f\xbe\xc4"=>0,
    "\x8f\xbe\xc5"=>0,
    "\x8f\xbe\xc6"=>0,
    "\x8f\xbe\xc7"=>0,
    "\x8f\xbe\xc8"=>0,
    "\x8f\xbe\xc9"=>0,
    "\x8f\xbe\xca"=>0,
    "\x8f\xbe\xcb"=>0,
    "\x8f\xbe\xcc"=>0,
    "\x8f\xbe\xcd"=>0,
    "\x8f\xbe\xce"=>0,
    "\x8f\xbe\xcf"=>0,
    "\x8f\xbe\xd0"=>0,
    "\x8f\xbe\xd1"=>0,
    "\x8f\xbe\xd2"=>0,
    "\x8f\xbe\xd3"=>0,
    "\x8f\xbe\xd4"=>0,
    "\x8f\xbe\xd5"=>0,
    "\x8f\xbe\xd6"=>0,
    "\x8f\xbe\xd7"=>0,
    "\x8f\xbe\xd8"=>0,
    "\x8f\xbe\xd9"=>0,
    "\x8f\xbe\xda"=>0,
    "\x8f\xbe\xdb"=>0,
    "\x8f\xbe\xdc"=>0,
    "\x8f\xbe\xdd"=>0,
    "\x8f\xbe\xde"=>0,
    "\x8f\xbe\xdf"=>0,
    "\x8f\xbe\xe0"=>0,
    "\x8f\xbe\xe1"=>0,
    "\x8f\xbe\xe2"=>0,
    "\x8f\xbe\xe3"=>0,
    "\x8f\xbe\xe4"=>0,
    "\x8f\xbe\xe5"=>0,
    "\x8f\xbe\xe6"=>0,
    "\x8f\xbe\xe7"=>0,
    "\x8f\xbe\xe8"=>0,
    "\x8f\xbe\xe9"=>0,
    "\x8f\xbe\xea"=>0,
    "\x8f\xbe\xeb"=>0,
    "\x8f\xbe\xec"=>0,
    "\x8f\xbe\xed"=>0,
    "\x8f\xbe\xee"=>0,
    "\x8f\xbe\xef"=>0,
    "\x8f\xbe\xf0"=>0,
    "\x8f\xbe\xf1"=>0,
    "\x8f\xbe\xf2"=>0,
    "\x8f\xbe\xf3"=>0,
    "\x8f\xbe\xf4"=>0,
    "\x8f\xbe\xf5"=>0,
    "\x8f\xbe\xf6"=>0,
    "\x8f\xbe\xf7"=>0,
    "\x8f\xbe\xf8"=>0,
    "\x8f\xbe\xf9"=>0,
    "\x8f\xbe\xfa"=>0,
    "\x8f\xbe\xfb"=>0,
    "\x8f\xbe\xfc"=>0,
    "\x8f\xbe\xfd"=>0,
    "\x8f\xbe\xfe"=>0,
    "\x8f\xbf\xa1"=>0,
    "\x8f\xbf\xa2"=>0,
    "\x8f\xbf\xa3"=>0,
    "\x8f\xbf\xa4"=>0,
    "\x8f\xbf\xa5"=>0,
    "\x8f\xbf\xa6"=>0,
    "\x8f\xbf\xa7"=>0,
    "\x8f\xbf\xa8"=>0,
    "\x8f\xbf\xa9"=>0,
    "\x8f\xbf\xaa"=>0,
    "\x8f\xbf\xab"=>0,
    "\x8f\xbf\xac"=>0,
    "\x8f\xbf\xad"=>0,
    "\x8f\xbf\xae"=>0,
    "\x8f\xbf\xaf"=>0,
    "\x8f\xbf\xb0"=>0,
    "\x8f\xbf\xb1"=>0,
    "\x8f\xbf\xb2"=>0,
    "\x8f\xbf\xb3"=>0,
    "\x8f\xbf\xb4"=>0,
    "\x8f\xbf\xb5"=>0,
    "\x8f\xbf\xb6"=>0,
    "\x8f\xbf\xb7"=>0,
    "\x8f\xbf\xb8"=>0,
    "\x8f\xbf\xb9"=>0,
    "\x8f\xbf\xba"=>0,
    "\x8f\xbf\xbb"=>0,
    "\x8f\xbf\xbc"=>0,
    "\x8f\xbf\xbd"=>0,
    "\x8f\xbf\xbe"=>0,
    "\x8f\xbf\xbf"=>0,
    "\x8f\xbf\xc0"=>0,
    "\x8f\xbf\xc1"=>0,
    "\x8f\xbf\xc2"=>0,
    "\x8f\xbf\xc3"=>0,
    "\x8f\xbf\xc4"=>0,
    "\x8f\xbf\xc5"=>0,
    "\x8f\xbf\xc6"=>0,
    "\x8f\xbf\xc7"=>0,
    "\x8f\xbf\xc8"=>0,
    "\x8f\xbf\xc9"=>0,
    "\x8f\xbf\xca"=>0,
    "\x8f\xbf\xcb"=>0,
    "\x8f\xbf\xcc"=>0,
    "\x8f\xbf\xcd"=>0,
    "\x8f\xbf\xce"=>0,
    "\x8f\xbf\xcf"=>0,
    "\x8f\xbf\xd0"=>0,
    "\x8f\xbf\xd1"=>0,
    "\x8f\xbf\xd2"=>0,
    "\x8f\xbf\xd3"=>0,
    "\x8f\xbf\xd4"=>0,
    "\x8f\xbf\xd5"=>0,
    "\x8f\xbf\xd6"=>0,
    "\x8f\xbf\xd7"=>0,
    "\x8f\xbf\xd8"=>0,
    "\x8f\xbf\xd9"=>0,
    "\x8f\xbf\xda"=>0,
    "\x8f\xbf\xdb"=>0,
    "\x8f\xbf\xdc"=>0,
    "\x8f\xbf\xdd"=>0,
    "\x8f\xbf\xde"=>0,
    "\x8f\xbf\xdf"=>0,
    "\x8f\xbf\xe0"=>0,
    "\x8f\xbf\xe1"=>0,
    "\x8f\xbf\xe2"=>0,
    "\x8f\xbf\xe3"=>0,
    "\x8f\xbf\xe4"=>0,
    "\x8f\xbf\xe5"=>0,
    "\x8f\xbf\xe6"=>0,
    "\x8f\xbf\xe7"=>0,
    "\x8f\xbf\xe8"=>0,
    "\x8f\xbf\xe9"=>0,
    "\x8f\xbf\xea"=>0,
    "\x8f\xbf\xeb"=>0,
    "\x8f\xbf\xec"=>0,
    "\x8f\xbf\xed"=>0,
    "\x8f\xbf\xee"=>0,
    "\x8f\xbf\xef"=>0,
    "\x8f\xbf\xf0"=>0,
    "\x8f\xbf\xf1"=>0,
    "\x8f\xbf\xf2"=>0,
    "\x8f\xbf\xf3"=>0,
    "\x8f\xbf\xf4"=>0,
    "\x8f\xbf\xf5"=>0,
    "\x8f\xbf\xf6"=>0,
    "\x8f\xbf\xf7"=>0,
    "\x8f\xbf\xf8"=>0,
    "\x8f\xbf\xf9"=>0,
    "\x8f\xbf\xfa"=>0,
    "\x8f\xbf\xfb"=>0,
    "\x8f\xbf\xfc"=>0,
    "\x8f\xbf\xfd"=>0,
    "\x8f\xbf\xfe"=>0,
    "\x8f\xc0\xa1"=>0,
    "\x8f\xc0\xa2"=>0,
    "\x8f\xc0\xa3"=>0,
    "\x8f\xc0\xa4"=>0,
    "\x8f\xc0\xa5"=>0,
    "\x8f\xc0\xa6"=>0,
    "\x8f\xc0\xa7"=>0,
    "\x8f\xc0\xa8"=>0,
    "\x8f\xc0\xa9"=>0,
    "\x8f\xc0\xaa"=>0,
    "\x8f\xc0\xab"=>0,
    "\x8f\xc0\xac"=>0,
    "\x8f\xc0\xad"=>0,
    "\x8f\xc0\xae"=>0,
    "\x8f\xc0\xaf"=>0,
    "\x8f\xc0\xb0"=>0,
    "\x8f\xc0\xb1"=>0,
    "\x8f\xc0\xb2"=>0,
    "\x8f\xc0\xb3"=>0,
    "\x8f\xc0\xb4"=>0,
    "\x8f\xc0\xb5"=>0,
    "\x8f\xc0\xb6"=>0,
    "\x8f\xc0\xb7"=>0,
    "\x8f\xc0\xb8"=>0,
    "\x8f\xc0\xb9"=>0,
    "\x8f\xc0\xba"=>0,
    "\x8f\xc0\xbb"=>0,
    "\x8f\xc0\xbc"=>0,
    "\x8f\xc0\xbd"=>0,
    "\x8f\xc0\xbe"=>0,
    "\x8f\xc0\xbf"=>0,
    "\x8f\xc0\xc0"=>0,
    "\x8f\xc0\xc1"=>0,
    "\x8f\xc0\xc2"=>0,
    "\x8f\xc0\xc3"=>0,
    "\x8f\xc0\xc4"=>0,
    "\x8f\xc0\xc5"=>0,
    "\x8f\xc0\xc6"=>0,
    "\x8f\xc0\xc7"=>0,
    "\x8f\xc0\xc8"=>0,
    "\x8f\xc0\xc9"=>0,
    "\x8f\xc0\xca"=>0,
    "\x8f\xc0\xcb"=>0,
    "\x8f\xc0\xcc"=>0,
    "\x8f\xc0\xcd"=>0,
    "\x8f\xc0\xce"=>0,
    "\x8f\xc0\xcf"=>0,
    "\x8f\xc0\xd0"=>0,
    "\x8f\xc0\xd1"=>0,
    "\x8f\xc0\xd2"=>0,
    "\x8f\xc0\xd3"=>0,
    "\x8f\xc0\xd4"=>0,
    "\x8f\xc0\xd5"=>0,
    "\x8f\xc0\xd6"=>0,
    "\x8f\xc0\xd7"=>0,
    "\x8f\xc0\xd8"=>0,
    "\x8f\xc0\xd9"=>0,
    "\x8f\xc0\xda"=>0,
    "\x8f\xc0\xdb"=>0,
    "\x8f\xc0\xdc"=>0,
    "\x8f\xc0\xdd"=>0,
    "\x8f\xc0\xde"=>0,
    "\x8f\xc0\xdf"=>0,
    "\x8f\xc0\xe0"=>0,
    "\x8f\xc0\xe1"=>0,
    "\x8f\xc0\xe2"=>0,
    "\x8f\xc0\xe3"=>0,
    "\x8f\xc0\xe4"=>0,
    "\x8f\xc0\xe5"=>0,
    "\x8f\xc0\xe6"=>0,
    "\x8f\xc0\xe7"=>0,
    "\x8f\xc0\xe8"=>0,
    "\x8f\xc0\xe9"=>0,
    "\x8f\xc0\xea"=>0,
    "\x8f\xc0\xeb"=>0,
    "\x8f\xc0\xec"=>0,
    "\x8f\xc0\xed"=>0,
    "\x8f\xc0\xee"=>0,
    "\x8f\xc0\xef"=>0,
    "\x8f\xc0\xf0"=>0,
    "\x8f\xc0\xf1"=>0,
    "\x8f\xc0\xf2"=>0,
    "\x8f\xc0\xf3"=>0,
    "\x8f\xc0\xf4"=>0,
    "\x8f\xc0\xf5"=>0,
    "\x8f\xc0\xf6"=>0,
    "\x8f\xc0\xf7"=>0,
    "\x8f\xc0\xf8"=>0,
    "\x8f\xc0\xf9"=>0,
    "\x8f\xc0\xfa"=>0,
    "\x8f\xc0\xfb"=>0,
    "\x8f\xc0\xfc"=>0,
    "\x8f\xc0\xfd"=>0,
    "\x8f\xc0\xfe"=>0,
    "\x8f\xc1\xa1"=>0,
    "\x8f\xc1\xa2"=>0,
    "\x8f\xc1\xa3"=>0,
    "\x8f\xc1\xa4"=>0,
    "\x8f\xc1\xa5"=>0,
    "\x8f\xc1\xa6"=>0,
    "\x8f\xc1\xa7"=>0,
    "\x8f\xc1\xa8"=>0,
    "\x8f\xc1\xa9"=>0,
    "\x8f\xc1\xaa"=>0,
    "\x8f\xc1\xab"=>0,
    "\x8f\xc1\xac"=>0,
    "\x8f\xc1\xad"=>0,
    "\x8f\xc1\xae"=>0,
    "\x8f\xc1\xaf"=>0,
    "\x8f\xc1\xb0"=>0,
    "\x8f\xc1\xb1"=>0,
    "\x8f\xc1\xb2"=>0,
    "\x8f\xc1\xb3"=>0,
    "\x8f\xc1\xb4"=>0,
    "\x8f\xc1\xb5"=>0,
    "\x8f\xc1\xb6"=>0,
    "\x8f\xc1\xb7"=>0,
    "\x8f\xc1\xb8"=>0,
    "\x8f\xc1\xb9"=>0,
    "\x8f\xc1\xba"=>0,
    "\x8f\xc1\xbb"=>0,
    "\x8f\xc1\xbc"=>0,
    "\x8f\xc1\xbd"=>0,
    "\x8f\xc1\xbe"=>0,
    "\x8f\xc1\xbf"=>0,
    "\x8f\xc1\xc0"=>0,
    "\x8f\xc1\xc1"=>0,
    "\x8f\xc1\xc2"=>0,
    "\x8f\xc1\xc3"=>0,
    "\x8f\xc1\xc4"=>0,
    "\x8f\xc1\xc5"=>0,
    "\x8f\xc1\xc6"=>0,
    "\x8f\xc1\xc7"=>0,
    "\x8f\xc1\xc8"=>0,
    "\x8f\xc1\xc9"=>0,
    "\x8f\xc1\xca"=>0,
    "\x8f\xc1\xcb"=>0,
    "\x8f\xc1\xcc"=>0,
    "\x8f\xc1\xcd"=>0,
    "\x8f\xc1\xce"=>0,
    "\x8f\xc1\xcf"=>0,
    "\x8f\xc1\xd0"=>0,
    "\x8f\xc1\xd1"=>0,
    "\x8f\xc1\xd2"=>0,
    "\x8f\xc1\xd3"=>0,
    "\x8f\xc1\xd4"=>0,
    "\x8f\xc1\xd5"=>0,
    "\x8f\xc1\xd6"=>0,
    "\x8f\xc1\xd7"=>0,
    "\x8f\xc1\xd8"=>0,
    "\x8f\xc1\xd9"=>0,
    "\x8f\xc1\xda"=>0,
    "\x8f\xc1\xdb"=>0,
    "\x8f\xc1\xdc"=>0,
    "\x8f\xc1\xdd"=>0,
    "\x8f\xc1\xde"=>0,
    "\x8f\xc1\xdf"=>0,
    "\x8f\xc1\xe0"=>0,
    "\x8f\xc1\xe1"=>0,
    "\x8f\xc1\xe2"=>0,
    "\x8f\xc1\xe3"=>0,
    "\x8f\xc1\xe4"=>0,
    "\x8f\xc1\xe5"=>0,
    "\x8f\xc1\xe6"=>0,
    "\x8f\xc1\xe7"=>0,
    "\x8f\xc1\xe8"=>0,
    "\x8f\xc1\xe9"=>0,
    "\x8f\xc1\xea"=>0,
    "\x8f\xc1\xeb"=>0,
    "\x8f\xc1\xec"=>0,
    "\x8f\xc1\xed"=>0,
    "\x8f\xc1\xee"=>0,
    "\x8f\xc1\xef"=>0,
    "\x8f\xc1\xf0"=>0,
    "\x8f\xc1\xf1"=>0,
    "\x8f\xc1\xf2"=>0,
    "\x8f\xc1\xf3"=>0,
    "\x8f\xc1\xf4"=>0,
    "\x8f\xc1\xf5"=>0,
    "\x8f\xc1\xf6"=>0,
    "\x8f\xc1\xf7"=>0,
    "\x8f\xc1\xf8"=>0,
    "\x8f\xc1\xf9"=>0,
    "\x8f\xc1\xfa"=>0,
    "\x8f\xc1\xfb"=>0,
    "\x8f\xc1\xfc"=>0,
    "\x8f\xc1\xfd"=>0,
    "\x8f\xc1\xfe"=>0,
    "\x8f\xc2\xa1"=>0,
    "\x8f\xc2\xa2"=>0,
    "\x8f\xc2\xa3"=>0,
    "\x8f\xc2\xa4"=>0,
    "\x8f\xc2\xa5"=>0,
    "\x8f\xc2\xa6"=>0,
    "\x8f\xc2\xa7"=>0,
    "\x8f\xc2\xa8"=>0,
    "\x8f\xc2\xa9"=>0,
    "\x8f\xc2\xaa"=>0,
    "\x8f\xc2\xab"=>0,
    "\x8f\xc2\xac"=>0,
    "\x8f\xc2\xad"=>0,
    "\x8f\xc2\xae"=>0,
    "\x8f\xc2\xaf"=>0,
    "\x8f\xc2\xb0"=>0,
    "\x8f\xc2\xb1"=>0,
    "\x8f\xc2\xb2"=>0,
    "\x8f\xc2\xb3"=>0,
    "\x8f\xc2\xb4"=>0,
    "\x8f\xc2\xb5"=>0,
    "\x8f\xc2\xb6"=>0,
    "\x8f\xc2\xb7"=>0,
    "\x8f\xc2\xb8"=>0,
    "\x8f\xc2\xb9"=>0,
    "\x8f\xc2\xba"=>0,
    "\x8f\xc2\xbb"=>0,
    "\x8f\xc2\xbc"=>0,
    "\x8f\xc2\xbd"=>0,
    "\x8f\xc2\xbe"=>0,
    "\x8f\xc2\xbf"=>0,
    "\x8f\xc2\xc0"=>0,
    "\x8f\xc2\xc1"=>0,
    "\x8f\xc2\xc2"=>0,
    "\x8f\xc2\xc3"=>0,
    "\x8f\xc2\xc4"=>0,
    "\x8f\xc2\xc5"=>0,
    "\x8f\xc2\xc6"=>0,
    "\x8f\xc2\xc7"=>0,
    "\x8f\xc2\xc8"=>0,
    "\x8f\xc2\xc9"=>0,
    "\x8f\xc2\xca"=>0,
    "\x8f\xc2\xcb"=>0,
    "\x8f\xc2\xcc"=>0,
    "\x8f\xc2\xcd"=>0,
    "\x8f\xc2\xce"=>0,
    "\x8f\xc2\xcf"=>0,
    "\x8f\xc2\xd0"=>0,
    "\x8f\xc2\xd1"=>0,
    "\x8f\xc2\xd2"=>0,
    "\x8f\xc2\xd3"=>0,
    "\x8f\xc2\xd4"=>0,
    "\x8f\xc2\xd5"=>0,
    "\x8f\xc2\xd6"=>0,
    "\x8f\xc2\xd7"=>0,
    "\x8f\xc2\xd8"=>0,
    "\x8f\xc2\xd9"=>0,
    "\x8f\xc2\xda"=>0,
    "\x8f\xc2\xdb"=>0,
    "\x8f\xc2\xdc"=>0,
    "\x8f\xc2\xdd"=>0,
    "\x8f\xc2\xde"=>0,
    "\x8f\xc2\xdf"=>0,
    "\x8f\xc2\xe0"=>0,
    "\x8f\xc2\xe1"=>0,
    "\x8f\xc2\xe2"=>0,
    "\x8f\xc2\xe3"=>0,
    "\x8f\xc2\xe4"=>0,
    "\x8f\xc2\xe5"=>0,
    "\x8f\xc2\xe6"=>0,
    "\x8f\xc2\xe7"=>0,
    "\x8f\xc2\xe8"=>0,
    "\x8f\xc2\xe9"=>0,
    "\x8f\xc2\xea"=>0,
    "\x8f\xc2\xeb"=>0,
    "\x8f\xc2\xec"=>0,
    "\x8f\xc2\xed"=>0,
    "\x8f\xc2\xee"=>0,
    "\x8f\xc2\xef"=>0,
    "\x8f\xc2\xf0"=>0,
    "\x8f\xc2\xf1"=>0,
    "\x8f\xc2\xf2"=>0,
    "\x8f\xc2\xf3"=>0,
    "\x8f\xc2\xf4"=>0,
    "\x8f\xc2\xf5"=>0,
    "\x8f\xc2\xf6"=>0,
    "\x8f\xc2\xf7"=>0,
    "\x8f\xc2\xf8"=>0,
    "\x8f\xc2\xf9"=>0,
    "\x8f\xc2\xfa"=>0,
    "\x8f\xc2\xfb"=>0,
    "\x8f\xc2\xfc"=>0,
    "\x8f\xc2\xfd"=>0,
    "\x8f\xc2\xfe"=>0,
    "\x8f\xc3\xa1"=>0,
    "\x8f\xc3\xa2"=>0,
    "\x8f\xc3\xa3"=>0,
    "\x8f\xc3\xa4"=>0,
    "\x8f\xc3\xa5"=>0,
    "\x8f\xc3\xa6"=>0,
    "\x8f\xc3\xa7"=>0,
    "\x8f\xc3\xa8"=>0,
    "\x8f\xc3\xa9"=>0,
    "\x8f\xc3\xaa"=>0,
    "\x8f\xc3\xab"=>0,
    "\x8f\xc3\xac"=>0,
    "\x8f\xc3\xad"=>0,
    "\x8f\xc3\xae"=>0,
    "\x8f\xc3\xaf"=>0,
    "\x8f\xc3\xb0"=>0,
    "\x8f\xc3\xb1"=>0,
    "\x8f\xc3\xb2"=>0,
    "\x8f\xc3\xb3"=>0,
    "\x8f\xc3\xb4"=>0,
    "\x8f\xc3\xb5"=>0,
    "\x8f\xc3\xb6"=>0,
    "\x8f\xc3\xb7"=>0,
    "\x8f\xc3\xb8"=>0,
    "\x8f\xc3\xb9"=>0,
    "\x8f\xc3\xba"=>0,
    "\x8f\xc3\xbb"=>0,
    "\x8f\xc3\xbc"=>0,
    "\x8f\xc3\xbd"=>0,
    "\x8f\xc3\xbe"=>0,
    "\x8f\xc3\xbf"=>0,
    "\x8f\xc3\xc0"=>0,
    "\x8f\xc3\xc1"=>0,
    "\x8f\xc3\xc2"=>0,
    "\x8f\xc3\xc3"=>0,
    "\x8f\xc3\xc4"=>0,
    "\x8f\xc3\xc5"=>0,
    "\x8f\xc3\xc6"=>0,
    "\x8f\xc3\xc7"=>0,
    "\x8f\xc3\xc8"=>0,
    "\x8f\xc3\xc9"=>0,
    "\x8f\xc3\xca"=>0,
    "\x8f\xc3\xcb"=>0,
    "\x8f\xc3\xcc"=>0,
    "\x8f\xc3\xcd"=>0,
    "\x8f\xc3\xce"=>0,
    "\x8f\xc3\xcf"=>0,
    "\x8f\xc3\xd0"=>0,
    "\x8f\xc3\xd1"=>0,
    "\x8f\xc3\xd2"=>0,
    "\x8f\xc3\xd3"=>0,
    "\x8f\xc3\xd4"=>0,
    "\x8f\xc3\xd5"=>0,
    "\x8f\xc3\xd6"=>0,
    "\x8f\xc3\xd7"=>0,
    "\x8f\xc3\xd8"=>0,
    "\x8f\xc3\xd9"=>0,
    "\x8f\xc3\xda"=>0,
    "\x8f\xc3\xdb"=>0,
    "\x8f\xc3\xdc"=>0,
    "\x8f\xc3\xdd"=>0,
    "\x8f\xc3\xde"=>0,
    "\x8f\xc3\xdf"=>0,
    "\x8f\xc3\xe0"=>0,
    "\x8f\xc3\xe1"=>0,
    "\x8f\xc3\xe2"=>0,
    "\x8f\xc3\xe3"=>0,
    "\x8f\xc3\xe4"=>0,
    "\x8f\xc3\xe5"=>0,
    "\x8f\xc3\xe6"=>0,
    "\x8f\xc3\xe7"=>0,
    "\x8f\xc3\xe8"=>0,
    "\x8f\xc3\xe9"=>0,
    "\x8f\xc3\xea"=>0,
    "\x8f\xc3\xeb"=>0,
    "\x8f\xc3\xec"=>0,
    "\x8f\xc3\xed"=>0,
    "\x8f\xc3\xee"=>0,
    "\x8f\xc3\xef"=>0,
    "\x8f\xc3\xf0"=>0,
    "\x8f\xc3\xf1"=>0,
    "\x8f\xc3\xf2"=>0,
    "\x8f\xc3\xf3"=>0,
    "\x8f\xc3\xf4"=>0,
    "\x8f\xc3\xf5"=>0,
    "\x8f\xc3\xf6"=>0,
    "\x8f\xc3\xf7"=>0,
    "\x8f\xc3\xf8"=>0,
    "\x8f\xc3\xf9"=>0,
    "\x8f\xc3\xfa"=>0,
    "\x8f\xc3\xfb"=>0,
    "\x8f\xc3\xfc"=>0,
    "\x8f\xc3\xfd"=>0,
    "\x8f\xc3\xfe"=>0,
    "\x8f\xc4\xa1"=>0,
    "\x8f\xc4\xa2"=>0,
    "\x8f\xc4\xa3"=>0,
    "\x8f\xc4\xa4"=>0,
    "\x8f\xc4\xa5"=>0,
    "\x8f\xc4\xa6"=>0,
    "\x8f\xc4\xa7"=>0,
    "\x8f\xc4\xa8"=>0,
    "\x8f\xc4\xa9"=>0,
    "\x8f\xc4\xaa"=>0,
    "\x8f\xc4\xab"=>0,
    "\x8f\xc4\xac"=>0,
    "\x8f\xc4\xad"=>0,
    "\x8f\xc4\xae"=>0,
    "\x8f\xc4\xaf"=>0,
    "\x8f\xc4\xb0"=>0,
    "\x8f\xc4\xb1"=>0,
    "\x8f\xc4\xb2"=>0,
    "\x8f\xc4\xb3"=>0,
    "\x8f\xc4\xb4"=>0,
    "\x8f\xc4\xb5"=>0,
    "\x8f\xc4\xb6"=>0,
    "\x8f\xc4\xb7"=>0,
    "\x8f\xc4\xb8"=>0,
    "\x8f\xc4\xb9"=>0,
    "\x8f\xc4\xba"=>0,
    "\x8f\xc4\xbb"=>0,
    "\x8f\xc4\xbc"=>0,
    "\x8f\xc4\xbd"=>0,
    "\x8f\xc4\xbe"=>0,
    "\x8f\xc4\xbf"=>0,
    "\x8f\xc4\xc0"=>0,
    "\x8f\xc4\xc1"=>0,
    "\x8f\xc4\xc2"=>0,
    "\x8f\xc4\xc3"=>0,
    "\x8f\xc4\xc4"=>0,
    "\x8f\xc4\xc5"=>0,
    "\x8f\xc4\xc6"=>0,
    "\x8f\xc4\xc7"=>0,
    "\x8f\xc4\xc8"=>0,
    "\x8f\xc4\xc9"=>0,
    "\x8f\xc4\xca"=>0,
    "\x8f\xc4\xcb"=>0,
    "\x8f\xc4\xcc"=>0,
    "\x8f\xc4\xcd"=>0,
    "\x8f\xc4\xce"=>0,
    "\x8f\xc4\xcf"=>0,
    "\x8f\xc4\xd0"=>0,
    "\x8f\xc4\xd1"=>0,
    "\x8f\xc4\xd2"=>0,
    "\x8f\xc4\xd3"=>0,
    "\x8f\xc4\xd4"=>0,
    "\x8f\xc4\xd5"=>0,
    "\x8f\xc4\xd6"=>0,
    "\x8f\xc4\xd7"=>0,
    "\x8f\xc4\xd8"=>0,
    "\x8f\xc4\xd9"=>0,
    "\x8f\xc4\xda"=>0,
    "\x8f\xc4\xdb"=>0,
    "\x8f\xc4\xdc"=>0,
    "\x8f\xc4\xdd"=>0,
    "\x8f\xc4\xde"=>0,
    "\x8f\xc4\xdf"=>0,
    "\x8f\xc4\xe0"=>0,
    "\x8f\xc4\xe1"=>0,
    "\x8f\xc4\xe2"=>0,
    "\x8f\xc4\xe3"=>0,
    "\x8f\xc4\xe4"=>0,
    "\x8f\xc4\xe5"=>0,
    "\x8f\xc4\xe6"=>0,
    "\x8f\xc4\xe7"=>0,
    "\x8f\xc4\xe8"=>0,
    "\x8f\xc4\xe9"=>0,
    "\x8f\xc4\xea"=>0,
    "\x8f\xc4\xeb"=>0,
    "\x8f\xc4\xec"=>0,
    "\x8f\xc4\xed"=>0,
    "\x8f\xc4\xee"=>0,
    "\x8f\xc4\xef"=>0,
    "\x8f\xc4\xf0"=>0,
    "\x8f\xc4\xf1"=>0,
    "\x8f\xc4\xf2"=>0,
    "\x8f\xc4\xf3"=>0,
    "\x8f\xc4\xf4"=>0,
    "\x8f\xc4\xf5"=>0,
    "\x8f\xc4\xf6"=>0,
    "\x8f\xc4\xf7"=>0,
    "\x8f\xc4\xf8"=>0,
    "\x8f\xc4\xf9"=>0,
    "\x8f\xc4\xfa"=>0,
    "\x8f\xc4\xfb"=>0,
    "\x8f\xc4\xfc"=>0,
    "\x8f\xc4\xfd"=>0,
    "\x8f\xc4\xfe"=>0,
    "\x8f\xc5\xa1"=>0,
    "\x8f\xc5\xa2"=>0,
    "\x8f\xc5\xa3"=>0,
    "\x8f\xc5\xa4"=>0,
    "\x8f\xc5\xa5"=>0,
    "\x8f\xc5\xa6"=>0,
    "\x8f\xc5\xa7"=>0,
    "\x8f\xc5\xa8"=>0,
    "\x8f\xc5\xa9"=>0,
    "\x8f\xc5\xaa"=>0,
    "\x8f\xc5\xab"=>0,
    "\x8f\xc5\xac"=>0,
    "\x8f\xc5\xad"=>0,
    "\x8f\xc5\xae"=>0,
    "\x8f\xc5\xaf"=>0,
    "\x8f\xc5\xb0"=>0,
    "\x8f\xc5\xb1"=>0,
    "\x8f\xc5\xb2"=>0,
    "\x8f\xc5\xb3"=>0,
    "\x8f\xc5\xb4"=>0,
    "\x8f\xc5\xb5"=>0,
    "\x8f\xc5\xb6"=>0,
    "\x8f\xc5\xb7"=>0,
    "\x8f\xc5\xb8"=>0,
    "\x8f\xc5\xb9"=>0,
    "\x8f\xc5\xba"=>0,
    "\x8f\xc5\xbb"=>0,
    "\x8f\xc5\xbc"=>0,
    "\x8f\xc5\xbd"=>0,
    "\x8f\xc5\xbe"=>0,
    "\x8f\xc5\xbf"=>0,
    "\x8f\xc5\xc0"=>0,
    "\x8f\xc5\xc1"=>0,
    "\x8f\xc5\xc2"=>0,
    "\x8f\xc5\xc3"=>0,
    "\x8f\xc5\xc4"=>0,
    "\x8f\xc5\xc5"=>0,
    "\x8f\xc5\xc6"=>0,
    "\x8f\xc5\xc7"=>0,
    "\x8f\xc5\xc8"=>0,
    "\x8f\xc5\xc9"=>0,
    "\x8f\xc5\xca"=>0,
    "\x8f\xc5\xcb"=>0,
    "\x8f\xc5\xcc"=>0,
    "\x8f\xc5\xcd"=>0,
    "\x8f\xc5\xce"=>0,
    "\x8f\xc5\xcf"=>0,
    "\x8f\xc5\xd0"=>0,
    "\x8f\xc5\xd1"=>0,
    "\x8f\xc5\xd2"=>0,
    "\x8f\xc5\xd3"=>0,
    "\x8f\xc5\xd4"=>0,
    "\x8f\xc5\xd5"=>0,
    "\x8f\xc5\xd6"=>0,
    "\x8f\xc5\xd7"=>0,
    "\x8f\xc5\xd8"=>0,
    "\x8f\xc5\xd9"=>0,
    "\x8f\xc5\xda"=>0,
    "\x8f\xc5\xdb"=>0,
    "\x8f\xc5\xdc"=>0,
    "\x8f\xc5\xdd"=>0,
    "\x8f\xc5\xde"=>0,
    "\x8f\xc5\xdf"=>0,
    "\x8f\xc5\xe0"=>0,
    "\x8f\xc5\xe1"=>0,
    "\x8f\xc5\xe2"=>0,
    "\x8f\xc5\xe3"=>0,
    "\x8f\xc5\xe4"=>0,
    "\x8f\xc5\xe5"=>0,
    "\x8f\xc5\xe6"=>0,
    "\x8f\xc5\xe7"=>0,
    "\x8f\xc5\xe8"=>0,
    "\x8f\xc5\xe9"=>0,
    "\x8f\xc5\xea"=>0,
    "\x8f\xc5\xeb"=>0,
    "\x8f\xc5\xec"=>0,
    "\x8f\xc5\xed"=>0,
    "\x8f\xc5\xee"=>0,
    "\x8f\xc5\xef"=>0,
    "\x8f\xc5\xf0"=>0,
    "\x8f\xc5\xf1"=>0,
    "\x8f\xc5\xf2"=>0,
    "\x8f\xc5\xf3"=>0,
    "\x8f\xc5\xf4"=>0,
    "\x8f\xc5\xf5"=>0,
    "\x8f\xc5\xf6"=>0,
    "\x8f\xc5\xf7"=>0,
    "\x8f\xc5\xf8"=>0,
    "\x8f\xc5\xf9"=>0,
    "\x8f\xc5\xfa"=>0,
    "\x8f\xc5\xfb"=>0,
    "\x8f\xc5\xfc"=>0,
    "\x8f\xc5\xfd"=>0,
    "\x8f\xc5\xfe"=>0,
    "\x8f\xc6\xa1"=>0,
    "\x8f\xc6\xa2"=>0,
    "\x8f\xc6\xa3"=>0,
    "\x8f\xc6\xa4"=>0,
    "\x8f\xc6\xa5"=>0,
    "\x8f\xc6\xa6"=>0,
    "\x8f\xc6\xa7"=>0,
    "\x8f\xc6\xa8"=>0,
    "\x8f\xc6\xa9"=>0,
    "\x8f\xc6\xaa"=>0,
    "\x8f\xc6\xab"=>0,
    "\x8f\xc6\xac"=>0,
    "\x8f\xc6\xad"=>0,
    "\x8f\xc6\xae"=>0,
    "\x8f\xc6\xaf"=>0,
    "\x8f\xc6\xb0"=>0,
    "\x8f\xc6\xb1"=>0,
    "\x8f\xc6\xb2"=>0,
    "\x8f\xc6\xb3"=>0,
    "\x8f\xc6\xb4"=>0,
    "\x8f\xc6\xb5"=>0,
    "\x8f\xc6\xb6"=>0,
    "\x8f\xc6\xb7"=>0,
    "\x8f\xc6\xb8"=>0,
    "\x8f\xc6\xb9"=>0,
    "\x8f\xc6\xba"=>0,
    "\x8f\xc6\xbb"=>0,
    "\x8f\xc6\xbc"=>0,
    "\x8f\xc6\xbd"=>0,
    "\x8f\xc6\xbe"=>0,
    "\x8f\xc6\xbf"=>0,
    "\x8f\xc6\xc0"=>0,
    "\x8f\xc6\xc1"=>0,
    "\x8f\xc6\xc2"=>0,
    "\x8f\xc6\xc3"=>0,
    "\x8f\xc6\xc4"=>0,
    "\x8f\xc6\xc5"=>0,
    "\x8f\xc6\xc6"=>0,
    "\x8f\xc6\xc7"=>0,
    "\x8f\xc6\xc8"=>0,
    "\x8f\xc6\xc9"=>0,
    "\x8f\xc6\xca"=>0,
    "\x8f\xc6\xcb"=>0,
    "\x8f\xc6\xcc"=>0,
    "\x8f\xc6\xcd"=>0,
    "\x8f\xc6\xce"=>0,
    "\x8f\xc6\xcf"=>0,
    "\x8f\xc6\xd0"=>0,
    "\x8f\xc6\xd1"=>0,
    "\x8f\xc6\xd2"=>0,
    "\x8f\xc6\xd3"=>0,
    "\x8f\xc6\xd4"=>0,
    "\x8f\xc6\xd5"=>0,
    "\x8f\xc6\xd6"=>0,
    "\x8f\xc6\xd7"=>0,
    "\x8f\xc6\xd8"=>0,
    "\x8f\xc6\xd9"=>0,
    "\x8f\xc6\xda"=>0,
    "\x8f\xc6\xdb"=>0,
    "\x8f\xc6\xdc"=>0,
    "\x8f\xc6\xdd"=>0,
    "\x8f\xc6\xde"=>0,
    "\x8f\xc6\xdf"=>0,
    "\x8f\xc6\xe0"=>0,
    "\x8f\xc6\xe1"=>0,
    "\x8f\xc6\xe2"=>0,
    "\x8f\xc6\xe3"=>0,
    "\x8f\xc6\xe4"=>0,
    "\x8f\xc6\xe5"=>0,
    "\x8f\xc6\xe6"=>0,
    "\x8f\xc6\xe7"=>0,
    "\x8f\xc6\xe8"=>0,
    "\x8f\xc6\xe9"=>0,
    "\x8f\xc6\xea"=>0,
    "\x8f\xc6\xeb"=>0,
    "\x8f\xc6\xec"=>0,
    "\x8f\xc6\xed"=>0,
    "\x8f\xc6\xee"=>0,
    "\x8f\xc6\xef"=>0,
    "\x8f\xc6\xf0"=>0,
    "\x8f\xc6\xf1"=>0,
    "\x8f\xc6\xf2"=>0,
    "\x8f\xc6\xf3"=>0,
    "\x8f\xc6\xf4"=>0,
    "\x8f\xc6\xf5"=>0,
    "\x8f\xc6\xf6"=>0,
    "\x8f\xc6\xf7"=>0,
    "\x8f\xc6\xf8"=>0,
    "\x8f\xc6\xf9"=>0,
    "\x8f\xc6\xfa"=>0,
    "\x8f\xc6\xfb"=>0,
    "\x8f\xc6\xfc"=>0,
    "\x8f\xc6\xfd"=>0,
    "\x8f\xc6\xfe"=>0,
    "\x8f\xc7\xa1"=>0,
    "\x8f\xc7\xa2"=>0,
    "\x8f\xc7\xa3"=>0,
    "\x8f\xc7\xa4"=>0,
    "\x8f\xc7\xa5"=>0,
    "\x8f\xc7\xa6"=>0,
    "\x8f\xc7\xa7"=>0,
    "\x8f\xc7\xa8"=>0,
    "\x8f\xc7\xa9"=>0,
    "\x8f\xc7\xaa"=>0,
    "\x8f\xc7\xab"=>0,
    "\x8f\xc7\xac"=>0,
    "\x8f\xc7\xad"=>0,
    "\x8f\xc7\xae"=>0,
    "\x8f\xc7\xaf"=>0,
    "\x8f\xc7\xb0"=>0,
    "\x8f\xc7\xb1"=>0,
    "\x8f\xc7\xb2"=>0,
    "\x8f\xc7\xb3"=>0,
    "\x8f\xc7\xb4"=>0,
    "\x8f\xc7\xb5"=>0,
    "\x8f\xc7\xb6"=>0,
    "\x8f\xc7\xb7"=>0,
    "\x8f\xc7\xb8"=>0,
    "\x8f\xc7\xb9"=>0,
    "\x8f\xc7\xba"=>0,
    "\x8f\xc7\xbb"=>0,
    "\x8f\xc7\xbc"=>0,
    "\x8f\xc7\xbd"=>0,
    "\x8f\xc7\xbe"=>0,
    "\x8f\xc7\xbf"=>0,
    "\x8f\xc7\xc0"=>0,
    "\x8f\xc7\xc1"=>0,
    "\x8f\xc7\xc2"=>0,
    "\x8f\xc7\xc3"=>0,
    "\x8f\xc7\xc4"=>0,
    "\x8f\xc7\xc5"=>0,
    "\x8f\xc7\xc6"=>0,
    "\x8f\xc7\xc7"=>0,
    "\x8f\xc7\xc8"=>0,
    "\x8f\xc7\xc9"=>0,
    "\x8f\xc7\xca"=>0,
    "\x8f\xc7\xcb"=>0,
    "\x8f\xc7\xcc"=>0,
    "\x8f\xc7\xcd"=>0,
    "\x8f\xc7\xce"=>0,
    "\x8f\xc7\xcf"=>0,
    "\x8f\xc7\xd0"=>0,
    "\x8f\xc7\xd1"=>0,
    "\x8f\xc7\xd2"=>0,
    "\x8f\xc7\xd3"=>0,
    "\x8f\xc7\xd4"=>0,
    "\x8f\xc7\xd5"=>0,
    "\x8f\xc7\xd6"=>0,
    "\x8f\xc7\xd7"=>0,
    "\x8f\xc7\xd8"=>0,
    "\x8f\xc7\xd9"=>0,
    "\x8f\xc7\xda"=>0,
    "\x8f\xc7\xdb"=>0,
    "\x8f\xc7\xdc"=>0,
    "\x8f\xc7\xdd"=>0,
    "\x8f\xc7\xde"=>0,
    "\x8f\xc7\xdf"=>0,
    "\x8f\xc7\xe0"=>0,
    "\x8f\xc7\xe1"=>0,
    "\x8f\xc7\xe2"=>0,
    "\x8f\xc7\xe3"=>0,
    "\x8f\xc7\xe4"=>0,
    "\x8f\xc7\xe5"=>0,
    "\x8f\xc7\xe6"=>0,
    "\x8f\xc7\xe7"=>0,
    "\x8f\xc7\xe8"=>0,
    "\x8f\xc7\xe9"=>0,
    "\x8f\xc7\xea"=>0,
    "\x8f\xc7\xeb"=>0,
    "\x8f\xc7\xec"=>0,
    "\x8f\xc7\xed"=>0,
    "\x8f\xc7\xee"=>0,
    "\x8f\xc7\xef"=>0,
    "\x8f\xc7\xf0"=>0,
    "\x8f\xc7\xf1"=>0,
    "\x8f\xc7\xf2"=>0,
    "\x8f\xc7\xf3"=>0,
    "\x8f\xc7\xf4"=>0,
    "\x8f\xc7\xf5"=>0,
    "\x8f\xc7\xf6"=>0,
    "\x8f\xc7\xf7"=>0,
    "\x8f\xc7\xf8"=>0,
    "\x8f\xc7\xf9"=>0,
    "\x8f\xc7\xfa"=>0,
    "\x8f\xc7\xfb"=>0,
    "\x8f\xc7\xfc"=>0,
    "\x8f\xc7\xfd"=>0,
    "\x8f\xc7\xfe"=>0,
    "\x8f\xc8\xa1"=>0,
    "\x8f\xc8\xa2"=>0,
    "\x8f\xc8\xa3"=>0,
    "\x8f\xc8\xa4"=>0,
    "\x8f\xc8\xa5"=>0,
    "\x8f\xc8\xa6"=>0,
    "\x8f\xc8\xa7"=>0,
    "\x8f\xc8\xa8"=>0,
    "\x8f\xc8\xa9"=>0,
    "\x8f\xc8\xaa"=>0,
    "\x8f\xc8\xab"=>0,
    "\x8f\xc8\xac"=>0,
    "\x8f\xc8\xad"=>0,
    "\x8f\xc8\xae"=>0,
    "\x8f\xc8\xaf"=>0,
    "\x8f\xc8\xb0"=>0,
    "\x8f\xc8\xb1"=>0,
    "\x8f\xc8\xb2"=>0,
    "\x8f\xc8\xb3"=>0,
    "\x8f\xc8\xb4"=>0,
    "\x8f\xc8\xb5"=>0,
    "\x8f\xc8\xb6"=>0,
    "\x8f\xc8\xb7"=>0,
    "\x8f\xc8\xb8"=>0,
    "\x8f\xc8\xb9"=>0,
    "\x8f\xc8\xba"=>0,
    "\x8f\xc8\xbb"=>0,
    "\x8f\xc8\xbc"=>0,
    "\x8f\xc8\xbd"=>0,
    "\x8f\xc8\xbe"=>0,
    "\x8f\xc8\xbf"=>0,
    "\x8f\xc8\xc0"=>0,
    "\x8f\xc8\xc1"=>0,
    "\x8f\xc8\xc2"=>0,
    "\x8f\xc8\xc3"=>0,
    "\x8f\xc8\xc4"=>0,
    "\x8f\xc8\xc5"=>0,
    "\x8f\xc8\xc6"=>0,
    "\x8f\xc8\xc7"=>0,
    "\x8f\xc8\xc8"=>0,
    "\x8f\xc8\xc9"=>0,
    "\x8f\xc8\xca"=>0,
    "\x8f\xc8\xcb"=>0,
    "\x8f\xc8\xcc"=>0,
    "\x8f\xc8\xcd"=>0,
    "\x8f\xc8\xce"=>0,
    "\x8f\xc8\xcf"=>0,
    "\x8f\xc8\xd0"=>0,
    "\x8f\xc8\xd1"=>0,
    "\x8f\xc8\xd2"=>0,
    "\x8f\xc8\xd3"=>0,
    "\x8f\xc8\xd4"=>0,
    "\x8f\xc8\xd5"=>0,
    "\x8f\xc8\xd6"=>0,
    "\x8f\xc8\xd7"=>0,
    "\x8f\xc8\xd8"=>0,
    "\x8f\xc8\xd9"=>0,
    "\x8f\xc8\xda"=>0,
    "\x8f\xc8\xdb"=>0,
    "\x8f\xc8\xdc"=>0,
    "\x8f\xc8\xdd"=>0,
    "\x8f\xc8\xde"=>0,
    "\x8f\xc8\xdf"=>0,
    "\x8f\xc8\xe0"=>0,
    "\x8f\xc8\xe1"=>0,
    "\x8f\xc8\xe2"=>0,
    "\x8f\xc8\xe3"=>0,
    "\x8f\xc8\xe4"=>0,
    "\x8f\xc8\xe5"=>0,
    "\x8f\xc8\xe6"=>0,
    "\x8f\xc8\xe7"=>0,
    "\x8f\xc8\xe8"=>0,
    "\x8f\xc8\xe9"=>0,
    "\x8f\xc8\xea"=>0,
    "\x8f\xc8\xeb"=>0,
    "\x8f\xc8\xec"=>0,
    "\x8f\xc8\xed"=>0,
    "\x8f\xc8\xee"=>0,
    "\x8f\xc8\xef"=>0,
    "\x8f\xc8\xf0"=>0,
    "\x8f\xc8\xf1"=>0,
    "\x8f\xc8\xf2"=>0,
    "\x8f\xc8\xf3"=>0,
    "\x8f\xc8\xf4"=>0,
    "\x8f\xc8\xf5"=>0,
    "\x8f\xc8\xf6"=>0,
    "\x8f\xc8\xf7"=>0,
    "\x8f\xc8\xf8"=>0,
    "\x8f\xc8\xf9"=>0,
    "\x8f\xc8\xfa"=>0,
    "\x8f\xc8\xfb"=>0,
    "\x8f\xc8\xfc"=>0,
    "\x8f\xc8\xfd"=>0,
    "\x8f\xc8\xfe"=>0,
    "\x8f\xc9\xa1"=>0,
    "\x8f\xc9\xa2"=>0,
    "\x8f\xc9\xa3"=>0,
    "\x8f\xc9\xa4"=>0,
    "\x8f\xc9\xa5"=>0,
    "\x8f\xc9\xa6"=>0,
    "\x8f\xc9\xa7"=>0,
    "\x8f\xc9\xa8"=>0,
    "\x8f\xc9\xa9"=>0,
    "\x8f\xc9\xaa"=>0,
    "\x8f\xc9\xab"=>0,
    "\x8f\xc9\xac"=>0,
    "\x8f\xc9\xad"=>0,
    "\x8f\xc9\xae"=>0,
    "\x8f\xc9\xaf"=>0,
    "\x8f\xc9\xb0"=>0,
    "\x8f\xc9\xb1"=>0,
    "\x8f\xc9\xb2"=>0,
    "\x8f\xc9\xb3"=>0,
    "\x8f\xc9\xb4"=>0,
    "\x8f\xc9\xb5"=>0,
    "\x8f\xc9\xb6"=>0,
    "\x8f\xc9\xb7"=>0,
    "\x8f\xc9\xb8"=>0,
    "\x8f\xc9\xb9"=>0,
    "\x8f\xc9\xba"=>0,
    "\x8f\xc9\xbb"=>0,
    "\x8f\xc9\xbc"=>0,
    "\x8f\xc9\xbd"=>0,
    "\x8f\xc9\xbe"=>0,
    "\x8f\xc9\xbf"=>0,
    "\x8f\xc9\xc0"=>0,
    "\x8f\xc9\xc1"=>0,
    "\x8f\xc9\xc2"=>0,
    "\x8f\xc9\xc3"=>0,
    "\x8f\xc9\xc4"=>0,
    "\x8f\xc9\xc5"=>0,
    "\x8f\xc9\xc6"=>0,
    "\x8f\xc9\xc7"=>0,
    "\x8f\xc9\xc8"=>0,
    "\x8f\xc9\xc9"=>0,
    "\x8f\xc9\xca"=>0,
    "\x8f\xc9\xcb"=>0,
    "\x8f\xc9\xcc"=>0,
    "\x8f\xc9\xcd"=>0,
    "\x8f\xc9\xce"=>0,
    "\x8f\xc9\xcf"=>0,
    "\x8f\xc9\xd0"=>0,
    "\x8f\xc9\xd1"=>0,
    "\x8f\xc9\xd2"=>0,
    "\x8f\xc9\xd3"=>0,
    "\x8f\xc9\xd4"=>0,
    "\x8f\xc9\xd5"=>0,
    "\x8f\xc9\xd6"=>0,
    "\x8f\xc9\xd7"=>0,
    "\x8f\xc9\xd8"=>0,
    "\x8f\xc9\xd9"=>0,
    "\x8f\xc9\xda"=>0,
    "\x8f\xc9\xdb"=>0,
    "\x8f\xc9\xdc"=>0,
    "\x8f\xc9\xdd"=>0,
    "\x8f\xc9\xde"=>0,
    "\x8f\xc9\xdf"=>0,
    "\x8f\xc9\xe0"=>0,
    "\x8f\xc9\xe1"=>0,
    "\x8f\xc9\xe2"=>0,
    "\x8f\xc9\xe3"=>0,
    "\x8f\xc9\xe4"=>0,
    "\x8f\xc9\xe5"=>0,
    "\x8f\xc9\xe6"=>0,
    "\x8f\xc9\xe7"=>0,
    "\x8f\xc9\xe8"=>0,
    "\x8f\xc9\xe9"=>0,
    "\x8f\xc9\xea"=>0,
    "\x8f\xc9\xeb"=>0,
    "\x8f\xc9\xec"=>0,
    "\x8f\xc9\xed"=>0,
    "\x8f\xc9\xee"=>0,
    "\x8f\xc9\xef"=>0,
    "\x8f\xc9\xf0"=>0,
    "\x8f\xc9\xf1"=>0,
    "\x8f\xc9\xf2"=>0,
    "\x8f\xc9\xf3"=>0,
    "\x8f\xc9\xf4"=>0,
    "\x8f\xc9\xf5"=>0,
    "\x8f\xc9\xf6"=>0,
    "\x8f\xc9\xf7"=>0,
    "\x8f\xc9\xf8"=>0,
    "\x8f\xc9\xf9"=>0,
    "\x8f\xc9\xfa"=>0,
    "\x8f\xc9\xfb"=>0,
    "\x8f\xc9\xfc"=>0,
    "\x8f\xc9\xfd"=>0,
    "\x8f\xc9\xfe"=>0,
    "\x8f\xca\xa1"=>0,
    "\x8f\xca\xa2"=>0,
    "\x8f\xca\xa3"=>0,
    "\x8f\xca\xa4"=>0,
    "\x8f\xca\xa5"=>0,
    "\x8f\xca\xa6"=>0,
    "\x8f\xca\xa7"=>0,
    "\x8f\xca\xa8"=>0,
    "\x8f\xca\xa9"=>0,
    "\x8f\xca\xaa"=>0,
    "\x8f\xca\xab"=>0,
    "\x8f\xca\xac"=>0,
    "\x8f\xca\xad"=>0,
    "\x8f\xca\xae"=>0,
    "\x8f\xca\xaf"=>0,
    "\x8f\xca\xb0"=>0,
    "\x8f\xca\xb1"=>0,
    "\x8f\xca\xb2"=>0,
    "\x8f\xca\xb3"=>0,
    "\x8f\xca\xb4"=>0,
    "\x8f\xca\xb5"=>0,
    "\x8f\xca\xb6"=>0,
    "\x8f\xca\xb7"=>0,
    "\x8f\xca\xb8"=>0,
    "\x8f\xca\xb9"=>0,
    "\x8f\xca\xba"=>0,
    "\x8f\xca\xbb"=>0,
    "\x8f\xca\xbc"=>0,
    "\x8f\xca\xbd"=>0,
    "\x8f\xca\xbe"=>0,
    "\x8f\xca\xbf"=>0,
    "\x8f\xca\xc0"=>0,
    "\x8f\xca\xc1"=>0,
    "\x8f\xca\xc2"=>0,
    "\x8f\xca\xc3"=>0,
    "\x8f\xca\xc4"=>0,
    "\x8f\xca\xc5"=>0,
    "\x8f\xca\xc6"=>0,
    "\x8f\xca\xc7"=>0,
    "\x8f\xca\xc8"=>0,
    "\x8f\xca\xc9"=>0,
    "\x8f\xca\xca"=>0,
    "\x8f\xca\xcb"=>0,
    "\x8f\xca\xcc"=>0,
    "\x8f\xca\xcd"=>0,
    "\x8f\xca\xce"=>0,
    "\x8f\xca\xcf"=>0,
    "\x8f\xca\xd0"=>0,
    "\x8f\xca\xd1"=>0,
    "\x8f\xca\xd2"=>0,
    "\x8f\xca\xd3"=>0,
    "\x8f\xca\xd4"=>0,
    "\x8f\xca\xd5"=>0,
    "\x8f\xca\xd6"=>0,
    "\x8f\xca\xd7"=>0,
    "\x8f\xca\xd8"=>0,
    "\x8f\xca\xd9"=>0,
    "\x8f\xca\xda"=>0,
    "\x8f\xca\xdb"=>0,
    "\x8f\xca\xdc"=>0,
    "\x8f\xca\xdd"=>0,
    "\x8f\xca\xde"=>0,
    "\x8f\xca\xdf"=>0,
    "\x8f\xca\xe0"=>0,
    "\x8f\xca\xe1"=>0,
    "\x8f\xca\xe2"=>0,
    "\x8f\xca\xe3"=>0,
    "\x8f\xca\xe4"=>0,
    "\x8f\xca\xe5"=>0,
    "\x8f\xca\xe6"=>0,
    "\x8f\xca\xe7"=>0,
    "\x8f\xca\xe8"=>0,
    "\x8f\xca\xe9"=>0,
    "\x8f\xca\xea"=>0,
    "\x8f\xca\xeb"=>0,
    "\x8f\xca\xec"=>0,
    "\x8f\xca\xed"=>0,
    "\x8f\xca\xee"=>0,
    "\x8f\xca\xef"=>0,
    "\x8f\xca\xf0"=>0,
    "\x8f\xca\xf1"=>0,
    "\x8f\xca\xf2"=>0,
    "\x8f\xca\xf3"=>0,
    "\x8f\xca\xf4"=>0,
    "\x8f\xca\xf5"=>0,
    "\x8f\xca\xf6"=>0,
    "\x8f\xca\xf7"=>0,
    "\x8f\xca\xf8"=>0,
    "\x8f\xca\xf9"=>0,
    "\x8f\xca\xfa"=>0,
    "\x8f\xca\xfb"=>0,
    "\x8f\xca\xfc"=>0,
    "\x8f\xca\xfd"=>0,
    "\x8f\xca\xfe"=>0,
    "\x8f\xcb\xa1"=>0,
    "\x8f\xcb\xa2"=>0,
    "\x8f\xcb\xa3"=>0,
    "\x8f\xcb\xa4"=>0,
    "\x8f\xcb\xa5"=>0,
    "\x8f\xcb\xa6"=>0,
    "\x8f\xcb\xa7"=>0,
    "\x8f\xcb\xa8"=>0,
    "\x8f\xcb\xa9"=>0,
    "\x8f\xcb\xaa"=>0,
    "\x8f\xcb\xab"=>0,
    "\x8f\xcb\xac"=>0,
    "\x8f\xcb\xad"=>0,
    "\x8f\xcb\xae"=>0,
    "\x8f\xcb\xaf"=>0,
    "\x8f\xcb\xb0"=>0,
    "\x8f\xcb\xb1"=>0,
    "\x8f\xcb\xb2"=>0,
    "\x8f\xcb\xb3"=>0,
    "\x8f\xcb\xb4"=>0,
    "\x8f\xcb\xb5"=>0,
    "\x8f\xcb\xb6"=>0,
    "\x8f\xcb\xb7"=>0,
    "\x8f\xcb\xb8"=>0,
    "\x8f\xcb\xb9"=>0,
    "\x8f\xcb\xba"=>0,
    "\x8f\xcb\xbb"=>0,
    "\x8f\xcb\xbc"=>0,
    "\x8f\xcb\xbd"=>0,
    "\x8f\xcb\xbe"=>0,
    "\x8f\xcb\xbf"=>0,
    "\x8f\xcb\xc0"=>0,
    "\x8f\xcb\xc1"=>0,
    "\x8f\xcb\xc2"=>0,
    "\x8f\xcb\xc3"=>0,
    "\x8f\xcb\xc4"=>0,
    "\x8f\xcb\xc5"=>0,
    "\x8f\xcb\xc6"=>0,
    "\x8f\xcb\xc7"=>0,
    "\x8f\xcb\xc8"=>0,
    "\x8f\xcb\xc9"=>0,
    "\x8f\xcb\xca"=>0,
    "\x8f\xcb\xcb"=>0,
    "\x8f\xcb\xcc"=>0,
    "\x8f\xcb\xcd"=>0,
    "\x8f\xcb\xce"=>0,
    "\x8f\xcb\xcf"=>0,
    "\x8f\xcb\xd0"=>0,
    "\x8f\xcb\xd1"=>0,
    "\x8f\xcb\xd2"=>0,
    "\x8f\xcb\xd3"=>0,
    "\x8f\xcb\xd4"=>0,
    "\x8f\xcb\xd5"=>0,
    "\x8f\xcb\xd6"=>0,
    "\x8f\xcb\xd7"=>0,
    "\x8f\xcb\xd8"=>0,
    "\x8f\xcb\xd9"=>0,
    "\x8f\xcb\xda"=>0,
    "\x8f\xcb\xdb"=>0,
    "\x8f\xcb\xdc"=>0,
    "\x8f\xcb\xdd"=>0,
    "\x8f\xcb\xde"=>0,
    "\x8f\xcb\xdf"=>0,
    "\x8f\xcb\xe0"=>0,
    "\x8f\xcb\xe1"=>0,
    "\x8f\xcb\xe2"=>0,
    "\x8f\xcb\xe3"=>0,
    "\x8f\xcb\xe4"=>0,
    "\x8f\xcb\xe5"=>0,
    "\x8f\xcb\xe6"=>0,
    "\x8f\xcb\xe7"=>0,
    "\x8f\xcb\xe8"=>0,
    "\x8f\xcb\xe9"=>0,
    "\x8f\xcb\xea"=>0,
    "\x8f\xcb\xeb"=>0,
    "\x8f\xcb\xec"=>0,
    "\x8f\xcb\xed"=>0,
    "\x8f\xcb\xee"=>0,
    "\x8f\xcb\xef"=>0,
    "\x8f\xcb\xf0"=>0,
    "\x8f\xcb\xf1"=>0,
    "\x8f\xcb\xf2"=>0,
    "\x8f\xcb\xf3"=>0,
    "\x8f\xcb\xf4"=>0,
    "\x8f\xcb\xf5"=>0,
    "\x8f\xcb\xf6"=>0,
    "\x8f\xcb\xf7"=>0,
    "\x8f\xcb\xf8"=>0,
    "\x8f\xcb\xf9"=>0,
    "\x8f\xcb\xfa"=>0,
    "\x8f\xcb\xfb"=>0,
    "\x8f\xcb\xfc"=>0,
    "\x8f\xcb\xfd"=>0,
    "\x8f\xcb\xfe"=>0,
    "\x8f\xcc\xa1"=>0,
    "\x8f\xcc\xa2"=>0,
    "\x8f\xcc\xa3"=>0,
    "\x8f\xcc\xa4"=>0,
    "\x8f\xcc\xa5"=>0,
    "\x8f\xcc\xa6"=>0,
    "\x8f\xcc\xa7"=>0,
    "\x8f\xcc\xa8"=>0,
    "\x8f\xcc\xa9"=>0,
    "\x8f\xcc\xaa"=>0,
    "\x8f\xcc\xab"=>0,
    "\x8f\xcc\xac"=>0,
    "\x8f\xcc\xad"=>0,
    "\x8f\xcc\xae"=>0,
    "\x8f\xcc\xaf"=>0,
    "\x8f\xcc\xb0"=>0,
    "\x8f\xcc\xb1"=>0,
    "\x8f\xcc\xb2"=>0,
    "\x8f\xcc\xb3"=>0,
    "\x8f\xcc\xb4"=>0,
    "\x8f\xcc\xb5"=>0,
    "\x8f\xcc\xb6"=>0,
    "\x8f\xcc\xb7"=>0,
    "\x8f\xcc\xb8"=>0,
    "\x8f\xcc\xb9"=>0,
    "\x8f\xcc\xba"=>0,
    "\x8f\xcc\xbb"=>0,
    "\x8f\xcc\xbc"=>0,
    "\x8f\xcc\xbd"=>0,
    "\x8f\xcc\xbe"=>0,
    "\x8f\xcc\xbf"=>0,
    "\x8f\xcc\xc0"=>0,
    "\x8f\xcc\xc1"=>0,
    "\x8f\xcc\xc2"=>0,
    "\x8f\xcc\xc3"=>0,
    "\x8f\xcc\xc4"=>0,
    "\x8f\xcc\xc5"=>0,
    "\x8f\xcc\xc6"=>0,
    "\x8f\xcc\xc7"=>0,
    "\x8f\xcc\xc8"=>0,
    "\x8f\xcc\xc9"=>0,
    "\x8f\xcc\xca"=>0,
    "\x8f\xcc\xcb"=>0,
    "\x8f\xcc\xcc"=>0,
    "\x8f\xcc\xcd"=>0,
    "\x8f\xcc\xce"=>0,
    "\x8f\xcc\xcf"=>0,
    "\x8f\xcc\xd0"=>0,
    "\x8f\xcc\xd1"=>0,
    "\x8f\xcc\xd2"=>0,
    "\x8f\xcc\xd3"=>0,
    "\x8f\xcc\xd4"=>0,
    "\x8f\xcc\xd5"=>0,
    "\x8f\xcc\xd6"=>0,
    "\x8f\xcc\xd7"=>0,
    "\x8f\xcc\xd8"=>0,
    "\x8f\xcc\xd9"=>0,
    "\x8f\xcc\xda"=>0,
    "\x8f\xcc\xdb"=>0,
    "\x8f\xcc\xdc"=>0,
    "\x8f\xcc\xdd"=>0,
    "\x8f\xcc\xde"=>0,
    "\x8f\xcc\xdf"=>0,
    "\x8f\xcc\xe0"=>0,
    "\x8f\xcc\xe1"=>0,
    "\x8f\xcc\xe2"=>0,
    "\x8f\xcc\xe3"=>0,
    "\x8f\xcc\xe4"=>0,
    "\x8f\xcc\xe5"=>0,
    "\x8f\xcc\xe6"=>0,
    "\x8f\xcc\xe7"=>0,
    "\x8f\xcc\xe8"=>0,
    "\x8f\xcc\xe9"=>0,
    "\x8f\xcc\xea"=>0,
    "\x8f\xcc\xeb"=>0,
    "\x8f\xcc\xec"=>0,
    "\x8f\xcc\xed"=>0,
    "\x8f\xcc\xee"=>0,
    "\x8f\xcc\xef"=>0,
    "\x8f\xcc\xf0"=>0,
    "\x8f\xcc\xf1"=>0,
    "\x8f\xcc\xf2"=>0,
    "\x8f\xcc\xf3"=>0,
    "\x8f\xcc\xf4"=>0,
    "\x8f\xcc\xf5"=>0,
    "\x8f\xcc\xf6"=>0,
    "\x8f\xcc\xf7"=>0,
    "\x8f\xcc\xf8"=>0,
    "\x8f\xcc\xf9"=>0,
    "\x8f\xcc\xfa"=>0,
    "\x8f\xcc\xfb"=>0,
    "\x8f\xcc\xfc"=>0,
    "\x8f\xcc\xfd"=>0,
    "\x8f\xcc\xfe"=>0,
    "\x8f\xcd\xa1"=>0,
    "\x8f\xcd\xa2"=>0,
    "\x8f\xcd\xa3"=>0,
    "\x8f\xcd\xa4"=>0,
    "\x8f\xcd\xa5"=>0,
    "\x8f\xcd\xa6"=>0,
    "\x8f\xcd\xa7"=>0,
    "\x8f\xcd\xa8"=>0,
    "\x8f\xcd\xa9"=>0,
    "\x8f\xcd\xaa"=>0,
    "\x8f\xcd\xab"=>0,
    "\x8f\xcd\xac"=>0,
    "\x8f\xcd\xad"=>0,
    "\x8f\xcd\xae"=>0,
    "\x8f\xcd\xaf"=>0,
    "\x8f\xcd\xb0"=>0,
    "\x8f\xcd\xb1"=>0,
    "\x8f\xcd\xb2"=>0,
    "\x8f\xcd\xb3"=>0,
    "\x8f\xcd\xb4"=>0,
    "\x8f\xcd\xb5"=>0,
    "\x8f\xcd\xb6"=>0,
    "\x8f\xcd\xb7"=>0,
    "\x8f\xcd\xb8"=>0,
    "\x8f\xcd\xb9"=>0,
    "\x8f\xcd\xba"=>0,
    "\x8f\xcd\xbb"=>0,
    "\x8f\xcd\xbc"=>0,
    "\x8f\xcd\xbd"=>0,
    "\x8f\xcd\xbe"=>0,
    "\x8f\xcd\xbf"=>0,
    "\x8f\xcd\xc0"=>0,
    "\x8f\xcd\xc1"=>0,
    "\x8f\xcd\xc2"=>0,
    "\x8f\xcd\xc3"=>0,
    "\x8f\xcd\xc4"=>0,
    "\x8f\xcd\xc5"=>0,
    "\x8f\xcd\xc6"=>0,
    "\x8f\xcd\xc7"=>0,
    "\x8f\xcd\xc8"=>0,
    "\x8f\xcd\xc9"=>0,
    "\x8f\xcd\xca"=>0,
    "\x8f\xcd\xcb"=>0,
    "\x8f\xcd\xcc"=>0,
    "\x8f\xcd\xcd"=>0,
    "\x8f\xcd\xce"=>0,
    "\x8f\xcd\xcf"=>0,
    "\x8f\xcd\xd0"=>0,
    "\x8f\xcd\xd1"=>0,
    "\x8f\xcd\xd2"=>0,
    "\x8f\xcd\xd3"=>0,
    "\x8f\xcd\xd4"=>0,
    "\x8f\xcd\xd5"=>0,
    "\x8f\xcd\xd6"=>0,
    "\x8f\xcd\xd7"=>0,
    "\x8f\xcd\xd8"=>0,
    "\x8f\xcd\xd9"=>0,
    "\x8f\xcd\xda"=>0,
    "\x8f\xcd\xdb"=>0,
    "\x8f\xcd\xdc"=>0,
    "\x8f\xcd\xdd"=>0,
    "\x8f\xcd\xde"=>0,
    "\x8f\xcd\xdf"=>0,
    "\x8f\xcd\xe0"=>0,
    "\x8f\xcd\xe1"=>0,
    "\x8f\xcd\xe2"=>0,
    "\x8f\xcd\xe3"=>0,
    "\x8f\xcd\xe4"=>0,
    "\x8f\xcd\xe5"=>0,
    "\x8f\xcd\xe6"=>0,
    "\x8f\xcd\xe7"=>0,
    "\x8f\xcd\xe8"=>0,
    "\x8f\xcd\xe9"=>0,
    "\x8f\xcd\xea"=>0,
    "\x8f\xcd\xeb"=>0,
    "\x8f\xcd\xec"=>0,
    "\x8f\xcd\xed"=>0,
    "\x8f\xcd\xee"=>0,
    "\x8f\xcd\xef"=>0,
    "\x8f\xcd\xf0"=>0,
    "\x8f\xcd\xf1"=>0,
    "\x8f\xcd\xf2"=>0,
    "\x8f\xcd\xf3"=>0,
    "\x8f\xcd\xf4"=>0,
    "\x8f\xcd\xf5"=>0,
    "\x8f\xcd\xf6"=>0,
    "\x8f\xcd\xf7"=>0,
    "\x8f\xcd\xf8"=>0,
    "\x8f\xcd\xf9"=>0,
    "\x8f\xcd\xfa"=>0,
    "\x8f\xcd\xfb"=>0,
    "\x8f\xcd\xfc"=>0,
    "\x8f\xcd\xfd"=>0,
    "\x8f\xcd\xfe"=>0,
    "\x8f\xce\xa1"=>0,
    "\x8f\xce\xa2"=>0,
    "\x8f\xce\xa3"=>0,
    "\x8f\xce\xa4"=>0,
    "\x8f\xce\xa5"=>0,
    "\x8f\xce\xa6"=>0,
    "\x8f\xce\xa7"=>0,
    "\x8f\xce\xa8"=>0,
    "\x8f\xce\xa9"=>0,
    "\x8f\xce\xaa"=>0,
    "\x8f\xce\xab"=>0,
    "\x8f\xce\xac"=>0,
    "\x8f\xce\xad"=>0,
    "\x8f\xce\xae"=>0,
    "\x8f\xce\xaf"=>0,
    "\x8f\xce\xb0"=>0,
    "\x8f\xce\xb1"=>0,
    "\x8f\xce\xb2"=>0,
    "\x8f\xce\xb3"=>0,
    "\x8f\xce\xb4"=>0,
    "\x8f\xce\xb5"=>0,
    "\x8f\xce\xb6"=>0,
    "\x8f\xce\xb7"=>0,
    "\x8f\xce\xb8"=>0,
    "\x8f\xce\xb9"=>0,
    "\x8f\xce\xba"=>0,
    "\x8f\xce\xbb"=>0,
    "\x8f\xce\xbc"=>0,
    "\x8f\xce\xbd"=>0,
    "\x8f\xce\xbe"=>0,
    "\x8f\xce\xbf"=>0,
    "\x8f\xce\xc0"=>0,
    "\x8f\xce\xc1"=>0,
    "\x8f\xce\xc2"=>0,
    "\x8f\xce\xc3"=>0,
    "\x8f\xce\xc4"=>0,
    "\x8f\xce\xc5"=>0,
    "\x8f\xce\xc6"=>0,
    "\x8f\xce\xc7"=>0,
    "\x8f\xce\xc8"=>0,
    "\x8f\xce\xc9"=>0,
    "\x8f\xce\xca"=>0,
    "\x8f\xce\xcb"=>0,
    "\x8f\xce\xcc"=>0,
    "\x8f\xce\xcd"=>0,
    "\x8f\xce\xce"=>0,
    "\x8f\xce\xcf"=>0,
    "\x8f\xce\xd0"=>0,
    "\x8f\xce\xd1"=>0,
    "\x8f\xce\xd2"=>0,
    "\x8f\xce\xd3"=>0,
    "\x8f\xce\xd4"=>0,
    "\x8f\xce\xd5"=>0,
    "\x8f\xce\xd6"=>0,
    "\x8f\xce\xd7"=>0,
    "\x8f\xce\xd8"=>0,
    "\x8f\xce\xd9"=>0,
    "\x8f\xce\xda"=>0,
    "\x8f\xce\xdb"=>0,
    "\x8f\xce\xdc"=>0,
    "\x8f\xce\xdd"=>0,
    "\x8f\xce\xde"=>0,
    "\x8f\xce\xdf"=>0,
    "\x8f\xce\xe0"=>0,
    "\x8f\xce\xe1"=>0,
    "\x8f\xce\xe2"=>0,
    "\x8f\xce\xe3"=>0,
    "\x8f\xce\xe4"=>0,
    "\x8f\xce\xe5"=>0,
    "\x8f\xce\xe6"=>0,
    "\x8f\xce\xe7"=>0,
    "\x8f\xce\xe8"=>0,
    "\x8f\xce\xe9"=>0,
    "\x8f\xce\xea"=>0,
    "\x8f\xce\xeb"=>0,
    "\x8f\xce\xec"=>0,
    "\x8f\xce\xed"=>0,
    "\x8f\xce\xee"=>0,
    "\x8f\xce\xef"=>0,
    "\x8f\xce\xf0"=>0,
    "\x8f\xce\xf1"=>0,
    "\x8f\xce\xf2"=>0,
    "\x8f\xce\xf3"=>0,
    "\x8f\xce\xf4"=>0,
    "\x8f\xce\xf5"=>0,
    "\x8f\xce\xf6"=>0,
    "\x8f\xce\xf7"=>0,
    "\x8f\xce\xf8"=>0,
    "\x8f\xce\xf9"=>0,
    "\x8f\xce\xfa"=>0,
    "\x8f\xce\xfb"=>0,
    "\x8f\xce\xfc"=>0,
    "\x8f\xce\xfd"=>0,
    "\x8f\xce\xfe"=>0,
    "\x8f\xcf\xa1"=>0,
    "\x8f\xcf\xa2"=>0,
    "\x8f\xcf\xa3"=>0,
    "\x8f\xcf\xa4"=>0,
    "\x8f\xcf\xa5"=>0,
    "\x8f\xcf\xa6"=>0,
    "\x8f\xcf\xa7"=>0,
    "\x8f\xcf\xa8"=>0,
    "\x8f\xcf\xa9"=>0,
    "\x8f\xcf\xaa"=>0,
    "\x8f\xcf\xab"=>0,
    "\x8f\xcf\xac"=>0,
    "\x8f\xcf\xad"=>0,
    "\x8f\xcf\xae"=>0,
    "\x8f\xcf\xaf"=>0,
    "\x8f\xcf\xb0"=>0,
    "\x8f\xcf\xb1"=>0,
    "\x8f\xcf\xb2"=>0,
    "\x8f\xcf\xb3"=>0,
    "\x8f\xcf\xb4"=>0,
    "\x8f\xcf\xb5"=>0,
    "\x8f\xcf\xb6"=>0,
    "\x8f\xcf\xb7"=>0,
    "\x8f\xcf\xb8"=>0,
    "\x8f\xcf\xb9"=>0,
    "\x8f\xcf\xba"=>0,
    "\x8f\xcf\xbb"=>0,
    "\x8f\xcf\xbc"=>0,
    "\x8f\xcf\xbd"=>0,
    "\x8f\xcf\xbe"=>0,
    "\x8f\xcf\xbf"=>0,
    "\x8f\xcf\xc0"=>0,
    "\x8f\xcf\xc1"=>0,
    "\x8f\xcf\xc2"=>0,
    "\x8f\xcf\xc3"=>0,
    "\x8f\xcf\xc4"=>0,
    "\x8f\xcf\xc5"=>0,
    "\x8f\xcf\xc6"=>0,
    "\x8f\xcf\xc7"=>0,
    "\x8f\xcf\xc8"=>0,
    "\x8f\xcf\xc9"=>0,
    "\x8f\xcf\xca"=>0,
    "\x8f\xcf\xcb"=>0,
    "\x8f\xcf\xcc"=>0,
    "\x8f\xcf\xcd"=>0,
    "\x8f\xcf\xce"=>0,
    "\x8f\xcf\xcf"=>0,
    "\x8f\xcf\xd0"=>0,
    "\x8f\xcf\xd1"=>0,
    "\x8f\xcf\xd2"=>0,
    "\x8f\xcf\xd3"=>0,
    "\x8f\xcf\xd4"=>0,
    "\x8f\xcf\xd5"=>0,
    "\x8f\xcf\xd6"=>0,
    "\x8f\xcf\xd7"=>0,
    "\x8f\xcf\xd8"=>0,
    "\x8f\xcf\xd9"=>0,
    "\x8f\xcf\xda"=>0,
    "\x8f\xcf\xdb"=>0,
    "\x8f\xcf\xdc"=>0,
    "\x8f\xcf\xdd"=>0,
    "\x8f\xcf\xde"=>0,
    "\x8f\xcf\xdf"=>0,
    "\x8f\xcf\xe0"=>0,
    "\x8f\xcf\xe1"=>0,
    "\x8f\xcf\xe2"=>0,
    "\x8f\xcf\xe3"=>0,
    "\x8f\xcf\xe4"=>0,
    "\x8f\xcf\xe5"=>0,
    "\x8f\xcf\xe6"=>0,
    "\x8f\xcf\xe7"=>0,
    "\x8f\xcf\xe8"=>0,
    "\x8f\xcf\xe9"=>0,
    "\x8f\xcf\xea"=>0,
    "\x8f\xcf\xeb"=>0,
    "\x8f\xcf\xec"=>0,
    "\x8f\xcf\xed"=>0,
    "\x8f\xcf\xee"=>0,
    "\x8f\xcf\xef"=>0,
    "\x8f\xcf\xf0"=>0,
    "\x8f\xcf\xf1"=>0,
    "\x8f\xcf\xf2"=>0,
    "\x8f\xcf\xf3"=>0,
    "\x8f\xcf\xf4"=>0,
    "\x8f\xcf\xf5"=>0,
    "\x8f\xcf\xf6"=>0,
    "\x8f\xcf\xf7"=>0,
    "\x8f\xcf\xf8"=>0,
    "\x8f\xcf\xf9"=>0,
    "\x8f\xcf\xfa"=>0,
    "\x8f\xcf\xfb"=>0,
    "\x8f\xcf\xfc"=>0,
    "\x8f\xcf\xfd"=>0,
    "\x8f\xcf\xfe"=>0,
    "\x8f\xd0\xa1"=>0,
    "\x8f\xd0\xa2"=>0,
    "\x8f\xd0\xa3"=>0,
    "\x8f\xd0\xa4"=>0,
    "\x8f\xd0\xa5"=>0,
    "\x8f\xd0\xa6"=>0,
    "\x8f\xd0\xa7"=>0,
    "\x8f\xd0\xa8"=>0,
    "\x8f\xd0\xa9"=>0,
    "\x8f\xd0\xaa"=>0,
    "\x8f\xd0\xab"=>0,
    "\x8f\xd0\xac"=>0,
    "\x8f\xd0\xad"=>0,
    "\x8f\xd0\xae"=>0,
    "\x8f\xd0\xaf"=>0,
    "\x8f\xd0\xb0"=>0,
    "\x8f\xd0\xb1"=>0,
    "\x8f\xd0\xb2"=>0,
    "\x8f\xd0\xb3"=>0,
    "\x8f\xd0\xb4"=>0,
    "\x8f\xd0\xb5"=>0,
    "\x8f\xd0\xb6"=>0,
    "\x8f\xd0\xb7"=>0,
    "\x8f\xd0\xb8"=>0,
    "\x8f\xd0\xb9"=>0,
    "\x8f\xd0\xba"=>0,
    "\x8f\xd0\xbb"=>0,
    "\x8f\xd0\xbc"=>0,
    "\x8f\xd0\xbd"=>0,
    "\x8f\xd0\xbe"=>0,
    "\x8f\xd0\xbf"=>0,
    "\x8f\xd0\xc0"=>0,
    "\x8f\xd0\xc1"=>0,
    "\x8f\xd0\xc2"=>0,
    "\x8f\xd0\xc3"=>0,
    "\x8f\xd0\xc4"=>0,
    "\x8f\xd0\xc5"=>0,
    "\x8f\xd0\xc6"=>0,
    "\x8f\xd0\xc7"=>0,
    "\x8f\xd0\xc8"=>0,
    "\x8f\xd0\xc9"=>0,
    "\x8f\xd0\xca"=>0,
    "\x8f\xd0\xcb"=>0,
    "\x8f\xd0\xcc"=>0,
    "\x8f\xd0\xcd"=>0,
    "\x8f\xd0\xce"=>0,
    "\x8f\xd0\xcf"=>0,
    "\x8f\xd0\xd0"=>0,
    "\x8f\xd0\xd1"=>0,
    "\x8f\xd0\xd2"=>0,
    "\x8f\xd0\xd3"=>0,
    "\x8f\xd0\xd4"=>0,
    "\x8f\xd0\xd5"=>0,
    "\x8f\xd0\xd6"=>0,
    "\x8f\xd0\xd7"=>0,
    "\x8f\xd0\xd8"=>0,
    "\x8f\xd0\xd9"=>0,
    "\x8f\xd0\xda"=>0,
    "\x8f\xd0\xdb"=>0,
    "\x8f\xd0\xdc"=>0,
    "\x8f\xd0\xdd"=>0,
    "\x8f\xd0\xde"=>0,
    "\x8f\xd0\xdf"=>0,
    "\x8f\xd0\xe0"=>0,
    "\x8f\xd0\xe1"=>0,
    "\x8f\xd0\xe2"=>0,
    "\x8f\xd0\xe3"=>0,
    "\x8f\xd0\xe4"=>0,
    "\x8f\xd0\xe5"=>0,
    "\x8f\xd0\xe6"=>0,
    "\x8f\xd0\xe7"=>0,
    "\x8f\xd0\xe8"=>0,
    "\x8f\xd0\xe9"=>0,
    "\x8f\xd0\xea"=>0,
    "\x8f\xd0\xeb"=>0,
    "\x8f\xd0\xec"=>0,
    "\x8f\xd0\xed"=>0,
    "\x8f\xd0\xee"=>0,
    "\x8f\xd0\xef"=>0,
    "\x8f\xd0\xf0"=>0,
    "\x8f\xd0\xf1"=>0,
    "\x8f\xd0\xf2"=>0,
    "\x8f\xd0\xf3"=>0,
    "\x8f\xd0\xf4"=>0,
    "\x8f\xd0\xf5"=>0,
    "\x8f\xd0\xf6"=>0,
    "\x8f\xd0\xf7"=>0,
    "\x8f\xd0\xf8"=>0,
    "\x8f\xd0\xf9"=>0,
    "\x8f\xd0\xfa"=>0,
    "\x8f\xd0\xfb"=>0,
    "\x8f\xd0\xfc"=>0,
    "\x8f\xd0\xfd"=>0,
    "\x8f\xd0\xfe"=>0,
    "\x8f\xd1\xa1"=>0,
    "\x8f\xd1\xa2"=>0,
    "\x8f\xd1\xa3"=>0,
    "\x8f\xd1\xa4"=>0,
    "\x8f\xd1\xa5"=>0,
    "\x8f\xd1\xa6"=>0,
    "\x8f\xd1\xa7"=>0,
    "\x8f\xd1\xa8"=>0,
    "\x8f\xd1\xa9"=>0,
    "\x8f\xd1\xaa"=>0,
    "\x8f\xd1\xab"=>0,
    "\x8f\xd1\xac"=>0,
    "\x8f\xd1\xad"=>0,
    "\x8f\xd1\xae"=>0,
    "\x8f\xd1\xaf"=>0,
    "\x8f\xd1\xb0"=>0,
    "\x8f\xd1\xb1"=>0,
    "\x8f\xd1\xb2"=>0,
    "\x8f\xd1\xb3"=>0,
    "\x8f\xd1\xb4"=>0,
    "\x8f\xd1\xb5"=>0,
    "\x8f\xd1\xb6"=>0,
    "\x8f\xd1\xb7"=>0,
    "\x8f\xd1\xb8"=>0,
    "\x8f\xd1\xb9"=>0,
    "\x8f\xd1\xba"=>0,
    "\x8f\xd1\xbb"=>0,
    "\x8f\xd1\xbc"=>0,
    "\x8f\xd1\xbd"=>0,
    "\x8f\xd1\xbe"=>0,
    "\x8f\xd1\xbf"=>0,
    "\x8f\xd1\xc0"=>0,
    "\x8f\xd1\xc1"=>0,
    "\x8f\xd1\xc2"=>0,
    "\x8f\xd1\xc3"=>0,
    "\x8f\xd1\xc4"=>0,
    "\x8f\xd1\xc5"=>0,
    "\x8f\xd1\xc6"=>0,
    "\x8f\xd1\xc7"=>0,
    "\x8f\xd1\xc8"=>0,
    "\x8f\xd1\xc9"=>0,
    "\x8f\xd1\xca"=>0,
    "\x8f\xd1\xcb"=>0,
    "\x8f\xd1\xcc"=>0,
    "\x8f\xd1\xcd"=>0,
    "\x8f\xd1\xce"=>0,
    "\x8f\xd1\xcf"=>0,
    "\x8f\xd1\xd0"=>0,
    "\x8f\xd1\xd1"=>0,
    "\x8f\xd1\xd2"=>0,
    "\x8f\xd1\xd3"=>0,
    "\x8f\xd1\xd4"=>0,
    "\x8f\xd1\xd5"=>0,
    "\x8f\xd1\xd6"=>0,
    "\x8f\xd1\xd7"=>0,
    "\x8f\xd1\xd8"=>0,
    "\x8f\xd1\xd9"=>0,
    "\x8f\xd1\xda"=>0,
    "\x8f\xd1\xdb"=>0,
    "\x8f\xd1\xdc"=>0,
    "\x8f\xd1\xdd"=>0,
    "\x8f\xd1\xde"=>0,
    "\x8f\xd1\xdf"=>0,
    "\x8f\xd1\xe0"=>0,
    "\x8f\xd1\xe1"=>0,
    "\x8f\xd1\xe2"=>0,
    "\x8f\xd1\xe3"=>0,
    "\x8f\xd1\xe4"=>0,
    "\x8f\xd1\xe5"=>0,
    "\x8f\xd1\xe6"=>0,
    "\x8f\xd1\xe7"=>0,
    "\x8f\xd1\xe8"=>0,
    "\x8f\xd1\xe9"=>0,
    "\x8f\xd1\xea"=>0,
    "\x8f\xd1\xeb"=>0,
    "\x8f\xd1\xec"=>0,
    "\x8f\xd1\xed"=>0,
    "\x8f\xd1\xee"=>0,
    "\x8f\xd1\xef"=>0,
    "\x8f\xd1\xf0"=>0,
    "\x8f\xd1\xf1"=>0,
    "\x8f\xd1\xf2"=>0,
    "\x8f\xd1\xf3"=>0,
    "\x8f\xd1\xf4"=>0,
    "\x8f\xd1\xf5"=>0,
    "\x8f\xd1\xf6"=>0,
    "\x8f\xd1\xf7"=>0,
    "\x8f\xd1\xf8"=>0,
    "\x8f\xd1\xf9"=>0,
    "\x8f\xd1\xfa"=>0,
    "\x8f\xd1\xfb"=>0,
    "\x8f\xd1\xfc"=>0,
    "\x8f\xd1\xfd"=>0,
    "\x8f\xd1\xfe"=>0,
    "\x8f\xd2\xa1"=>0,
    "\x8f\xd2\xa2"=>0,
    "\x8f\xd2\xa3"=>0,
    "\x8f\xd2\xa4"=>0,
    "\x8f\xd2\xa5"=>0,
    "\x8f\xd2\xa6"=>0,
    "\x8f\xd2\xa7"=>0,
    "\x8f\xd2\xa8"=>0,
    "\x8f\xd2\xa9"=>0,
    "\x8f\xd2\xaa"=>0,
    "\x8f\xd2\xab"=>0,
    "\x8f\xd2\xac"=>0,
    "\x8f\xd2\xad"=>0,
    "\x8f\xd2\xae"=>0,
    "\x8f\xd2\xaf"=>0,
    "\x8f\xd2\xb0"=>0,
    "\x8f\xd2\xb1"=>0,
    "\x8f\xd2\xb2"=>0,
    "\x8f\xd2\xb3"=>0,
    "\x8f\xd2\xb4"=>0,
    "\x8f\xd2\xb5"=>0,
    "\x8f\xd2\xb6"=>0,
    "\x8f\xd2\xb7"=>0,
    "\x8f\xd2\xb8"=>0,
    "\x8f\xd2\xb9"=>0,
    "\x8f\xd2\xba"=>0,
    "\x8f\xd2\xbb"=>0,
    "\x8f\xd2\xbc"=>0,
    "\x8f\xd2\xbd"=>0,
    "\x8f\xd2\xbe"=>0,
    "\x8f\xd2\xbf"=>0,
    "\x8f\xd2\xc0"=>0,
    "\x8f\xd2\xc1"=>0,
    "\x8f\xd2\xc2"=>0,
    "\x8f\xd2\xc3"=>0,
    "\x8f\xd2\xc4"=>0,
    "\x8f\xd2\xc5"=>0,
    "\x8f\xd2\xc6"=>0,
    "\x8f\xd2\xc7"=>0,
    "\x8f\xd2\xc8"=>0,
    "\x8f\xd2\xc9"=>0,
    "\x8f\xd2\xca"=>0,
    "\x8f\xd2\xcb"=>0,
    "\x8f\xd2\xcc"=>0,
    "\x8f\xd2\xcd"=>0,
    "\x8f\xd2\xce"=>0,
    "\x8f\xd2\xcf"=>0,
    "\x8f\xd2\xd0"=>0,
    "\x8f\xd2\xd1"=>0,
    "\x8f\xd2\xd2"=>0,
    "\x8f\xd2\xd3"=>0,
    "\x8f\xd2\xd4"=>0,
    "\x8f\xd2\xd5"=>0,
    "\x8f\xd2\xd6"=>0,
    "\x8f\xd2\xd7"=>0,
    "\x8f\xd2\xd8"=>0,
    "\x8f\xd2\xd9"=>0,
    "\x8f\xd2\xda"=>0,
    "\x8f\xd2\xdb"=>0,
    "\x8f\xd2\xdc"=>0,
    "\x8f\xd2\xdd"=>0,
    "\x8f\xd2\xde"=>0,
    "\x8f\xd2\xdf"=>0,
    "\x8f\xd2\xe0"=>0,
    "\x8f\xd2\xe1"=>0,
    "\x8f\xd2\xe2"=>0,
    "\x8f\xd2\xe3"=>0,
    "\x8f\xd2\xe4"=>0,
    "\x8f\xd2\xe5"=>0,
    "\x8f\xd2\xe6"=>0,
    "\x8f\xd2\xe7"=>0,
    "\x8f\xd2\xe8"=>0,
    "\x8f\xd2\xe9"=>0,
    "\x8f\xd2\xea"=>0,
    "\x8f\xd2\xeb"=>0,
    "\x8f\xd2\xec"=>0,
    "\x8f\xd2\xed"=>0,
    "\x8f\xd2\xee"=>0,
    "\x8f\xd2\xef"=>0,
    "\x8f\xd2\xf0"=>0,
    "\x8f\xd2\xf1"=>0,
    "\x8f\xd2\xf2"=>0,
    "\x8f\xd2\xf3"=>0,
    "\x8f\xd2\xf4"=>0,
    "\x8f\xd2\xf5"=>0,
    "\x8f\xd2\xf6"=>0,
    "\x8f\xd2\xf7"=>0,
    "\x8f\xd2\xf8"=>0,
    "\x8f\xd2\xf9"=>0,
    "\x8f\xd2\xfa"=>0,
    "\x8f\xd2\xfb"=>0,
    "\x8f\xd2\xfc"=>0,
    "\x8f\xd2\xfd"=>0,
    "\x8f\xd2\xfe"=>0,
    "\x8f\xd3\xa1"=>0,
    "\x8f\xd3\xa2"=>0,
    "\x8f\xd3\xa3"=>0,
    "\x8f\xd3\xa4"=>0,
    "\x8f\xd3\xa5"=>0,
    "\x8f\xd3\xa6"=>0,
    "\x8f\xd3\xa7"=>0,
    "\x8f\xd3\xa8"=>0,
    "\x8f\xd3\xa9"=>0,
    "\x8f\xd3\xaa"=>0,
    "\x8f\xd3\xab"=>0,
    "\x8f\xd3\xac"=>0,
    "\x8f\xd3\xad"=>0,
    "\x8f\xd3\xae"=>0,
    "\x8f\xd3\xaf"=>0,
    "\x8f\xd3\xb0"=>0,
    "\x8f\xd3\xb1"=>0,
    "\x8f\xd3\xb2"=>0,
    "\x8f\xd3\xb3"=>0,
    "\x8f\xd3\xb4"=>0,
    "\x8f\xd3\xb5"=>0,
    "\x8f\xd3\xb6"=>0,
    "\x8f\xd3\xb7"=>0,
    "\x8f\xd3\xb8"=>0,
    "\x8f\xd3\xb9"=>0,
    "\x8f\xd3\xba"=>0,
    "\x8f\xd3\xbb"=>0,
    "\x8f\xd3\xbc"=>0,
    "\x8f\xd3\xbd"=>0,
    "\x8f\xd3\xbe"=>0,
    "\x8f\xd3\xbf"=>0,
    "\x8f\xd3\xc0"=>0,
    "\x8f\xd3\xc1"=>0,
    "\x8f\xd3\xc2"=>0,
    "\x8f\xd3\xc3"=>0,
    "\x8f\xd3\xc4"=>0,
    "\x8f\xd3\xc5"=>0,
    "\x8f\xd3\xc6"=>0,
    "\x8f\xd3\xc7"=>0,
    "\x8f\xd3\xc8"=>0,
    "\x8f\xd3\xc9"=>0,
    "\x8f\xd3\xca"=>0,
    "\x8f\xd3\xcb"=>0,
    "\x8f\xd3\xcc"=>0,
    "\x8f\xd3\xcd"=>0,
    "\x8f\xd3\xce"=>0,
    "\x8f\xd3\xcf"=>0,
    "\x8f\xd3\xd0"=>0,
    "\x8f\xd3\xd1"=>0,
    "\x8f\xd3\xd2"=>0,
    "\x8f\xd3\xd3"=>0,
    "\x8f\xd3\xd4"=>0,
    "\x8f\xd3\xd5"=>0,
    "\x8f\xd3\xd6"=>0,
    "\x8f\xd3\xd7"=>0,
    "\x8f\xd3\xd8"=>0,
    "\x8f\xd3\xd9"=>0,
    "\x8f\xd3\xda"=>0,
    "\x8f\xd3\xdb"=>0,
    "\x8f\xd3\xdc"=>0,
    "\x8f\xd3\xdd"=>0,
    "\x8f\xd3\xde"=>0,
    "\x8f\xd3\xdf"=>0,
    "\x8f\xd3\xe0"=>0,
    "\x8f\xd3\xe1"=>0,
    "\x8f\xd3\xe2"=>0,
    "\x8f\xd3\xe3"=>0,
    "\x8f\xd3\xe4"=>0,
    "\x8f\xd3\xe5"=>0,
    "\x8f\xd3\xe6"=>0,
    "\x8f\xd3\xe7"=>0,
    "\x8f\xd3\xe8"=>0,
    "\x8f\xd3\xe9"=>0,
    "\x8f\xd3\xea"=>0,
    "\x8f\xd3\xeb"=>0,
    "\x8f\xd3\xec"=>0,
    "\x8f\xd3\xed"=>0,
    "\x8f\xd3\xee"=>0,
    "\x8f\xd3\xef"=>0,
    "\x8f\xd3\xf0"=>0,
    "\x8f\xd3\xf1"=>0,
    "\x8f\xd3\xf2"=>0,
    "\x8f\xd3\xf3"=>0,
    "\x8f\xd3\xf4"=>0,
    "\x8f\xd3\xf5"=>0,
    "\x8f\xd3\xf6"=>0,
    "\x8f\xd3\xf7"=>0,
    "\x8f\xd3\xf8"=>0,
    "\x8f\xd3\xf9"=>0,
    "\x8f\xd3\xfa"=>0,
    "\x8f\xd3\xfb"=>0,
    "\x8f\xd3\xfc"=>0,
    "\x8f\xd3\xfd"=>0,
    "\x8f\xd3\xfe"=>0,
    "\x8f\xd4\xa1"=>0,
    "\x8f\xd4\xa2"=>0,
    "\x8f\xd4\xa3"=>0,
    "\x8f\xd4\xa4"=>0,
    "\x8f\xd4\xa5"=>0,
    "\x8f\xd4\xa6"=>0,
    "\x8f\xd4\xa7"=>0,
    "\x8f\xd4\xa8"=>0,
    "\x8f\xd4\xa9"=>0,
    "\x8f\xd4\xaa"=>0,
    "\x8f\xd4\xab"=>0,
    "\x8f\xd4\xac"=>0,
    "\x8f\xd4\xad"=>0,
    "\x8f\xd4\xae"=>0,
    "\x8f\xd4\xaf"=>0,
    "\x8f\xd4\xb0"=>0,
    "\x8f\xd4\xb1"=>0,
    "\x8f\xd4\xb2"=>0,
    "\x8f\xd4\xb3"=>0,
    "\x8f\xd4\xb4"=>0,
    "\x8f\xd4\xb5"=>0,
    "\x8f\xd4\xb6"=>0,
    "\x8f\xd4\xb7"=>0,
    "\x8f\xd4\xb8"=>0,
    "\x8f\xd4\xb9"=>0,
    "\x8f\xd4\xba"=>0,
    "\x8f\xd4\xbb"=>0,
    "\x8f\xd4\xbc"=>0,
    "\x8f\xd4\xbd"=>0,
    "\x8f\xd4\xbe"=>0,
    "\x8f\xd4\xbf"=>0,
    "\x8f\xd4\xc0"=>0,
    "\x8f\xd4\xc1"=>0,
    "\x8f\xd4\xc2"=>0,
    "\x8f\xd4\xc3"=>0,
    "\x8f\xd4\xc4"=>0,
    "\x8f\xd4\xc5"=>0,
    "\x8f\xd4\xc6"=>0,
    "\x8f\xd4\xc7"=>0,
    "\x8f\xd4\xc8"=>0,
    "\x8f\xd4\xc9"=>0,
    "\x8f\xd4\xca"=>0,
    "\x8f\xd4\xcb"=>0,
    "\x8f\xd4\xcc"=>0,
    "\x8f\xd4\xcd"=>0,
    "\x8f\xd4\xce"=>0,
    "\x8f\xd4\xcf"=>0,
    "\x8f\xd4\xd0"=>0,
    "\x8f\xd4\xd1"=>0,
    "\x8f\xd4\xd2"=>0,
    "\x8f\xd4\xd3"=>0,
    "\x8f\xd4\xd4"=>0,
    "\x8f\xd4\xd5"=>0,
    "\x8f\xd4\xd6"=>0,
    "\x8f\xd4\xd7"=>0,
    "\x8f\xd4\xd8"=>0,
    "\x8f\xd4\xd9"=>0,
    "\x8f\xd4\xda"=>0,
    "\x8f\xd4\xdb"=>0,
    "\x8f\xd4\xdc"=>0,
    "\x8f\xd4\xdd"=>0,
    "\x8f\xd4\xde"=>0,
    "\x8f\xd4\xdf"=>0,
    "\x8f\xd4\xe0"=>0,
    "\x8f\xd4\xe1"=>0,
    "\x8f\xd4\xe2"=>0,
    "\x8f\xd4\xe3"=>0,
    "\x8f\xd4\xe4"=>0,
    "\x8f\xd4\xe5"=>0,
    "\x8f\xd4\xe6"=>0,
    "\x8f\xd4\xe7"=>0,
    "\x8f\xd4\xe8"=>0,
    "\x8f\xd4\xe9"=>0,
    "\x8f\xd4\xea"=>0,
    "\x8f\xd4\xeb"=>0,
    "\x8f\xd4\xec"=>0,
    "\x8f\xd4\xed"=>0,
    "\x8f\xd4\xee"=>0,
    "\x8f\xd4\xef"=>0,
    "\x8f\xd4\xf0"=>0,
    "\x8f\xd4\xf1"=>0,
    "\x8f\xd4\xf2"=>0,
    "\x8f\xd4\xf3"=>0,
    "\x8f\xd4\xf4"=>0,
    "\x8f\xd4\xf5"=>0,
    "\x8f\xd4\xf6"=>0,
    "\x8f\xd4\xf7"=>0,
    "\x8f\xd4\xf8"=>0,
    "\x8f\xd4\xf9"=>0,
    "\x8f\xd4\xfa"=>0,
    "\x8f\xd4\xfb"=>0,
    "\x8f\xd4\xfc"=>0,
    "\x8f\xd4\xfd"=>0,
    "\x8f\xd4\xfe"=>0,
    "\x8f\xd5\xa1"=>0,
    "\x8f\xd5\xa2"=>0,
    "\x8f\xd5\xa3"=>0,
    "\x8f\xd5\xa4"=>0,
    "\x8f\xd5\xa5"=>0,
    "\x8f\xd5\xa6"=>0,
    "\x8f\xd5\xa7"=>0,
    "\x8f\xd5\xa8"=>0,
    "\x8f\xd5\xa9"=>0,
    "\x8f\xd5\xaa"=>0,
    "\x8f\xd5\xab"=>0,
    "\x8f\xd5\xac"=>0,
    "\x8f\xd5\xad"=>0,
    "\x8f\xd5\xae"=>0,
    "\x8f\xd5\xaf"=>0,
    "\x8f\xd5\xb0"=>0,
    "\x8f\xd5\xb1"=>0,
    "\x8f\xd5\xb2"=>0,
    "\x8f\xd5\xb3"=>0,
    "\x8f\xd5\xb4"=>0,
    "\x8f\xd5\xb5"=>0,
    "\x8f\xd5\xb6"=>0,
    "\x8f\xd5\xb7"=>0,
    "\x8f\xd5\xb8"=>0,
    "\x8f\xd5\xb9"=>0,
    "\x8f\xd5\xba"=>0,
    "\x8f\xd5\xbb"=>0,
    "\x8f\xd5\xbc"=>0,
    "\x8f\xd5\xbd"=>0,
    "\x8f\xd5\xbe"=>0,
    "\x8f\xd5\xbf"=>0,
    "\x8f\xd5\xc0"=>0,
    "\x8f\xd5\xc1"=>0,
    "\x8f\xd5\xc2"=>0,
    "\x8f\xd5\xc3"=>0,
    "\x8f\xd5\xc4"=>0,
    "\x8f\xd5\xc5"=>0,
    "\x8f\xd5\xc6"=>0,
    "\x8f\xd5\xc7"=>0,
    "\x8f\xd5\xc8"=>0,
    "\x8f\xd5\xc9"=>0,
    "\x8f\xd5\xca"=>0,
    "\x8f\xd5\xcb"=>0,
    "\x8f\xd5\xcc"=>0,
    "\x8f\xd5\xcd"=>0,
    "\x8f\xd5\xce"=>0,
    "\x8f\xd5\xcf"=>0,
    "\x8f\xd5\xd0"=>0,
    "\x8f\xd5\xd1"=>0,
    "\x8f\xd5\xd2"=>0,
    "\x8f\xd5\xd3"=>0,
    "\x8f\xd5\xd4"=>0,
    "\x8f\xd5\xd5"=>0,
    "\x8f\xd5\xd6"=>0,
    "\x8f\xd5\xd7"=>0,
    "\x8f\xd5\xd8"=>0,
    "\x8f\xd5\xd9"=>0,
    "\x8f\xd5\xda"=>0,
    "\x8f\xd5\xdb"=>0,
    "\x8f\xd5\xdc"=>0,
    "\x8f\xd5\xdd"=>0,
    "\x8f\xd5\xde"=>0,
    "\x8f\xd5\xdf"=>0,
    "\x8f\xd5\xe0"=>0,
    "\x8f\xd5\xe1"=>0,
    "\x8f\xd5\xe2"=>0,
    "\x8f\xd5\xe3"=>0,
    "\x8f\xd5\xe4"=>0,
    "\x8f\xd5\xe5"=>0,
    "\x8f\xd5\xe6"=>0,
    "\x8f\xd5\xe7"=>0,
    "\x8f\xd5\xe8"=>0,
    "\x8f\xd5\xe9"=>0,
    "\x8f\xd5\xea"=>0,
    "\x8f\xd5\xeb"=>0,
    "\x8f\xd5\xec"=>0,
    "\x8f\xd5\xed"=>0,
    "\x8f\xd5\xee"=>0,
    "\x8f\xd5\xef"=>0,
    "\x8f\xd5\xf0"=>0,
    "\x8f\xd5\xf1"=>0,
    "\x8f\xd5\xf2"=>0,
    "\x8f\xd5\xf3"=>0,
    "\x8f\xd5\xf4"=>0,
    "\x8f\xd5\xf5"=>0,
    "\x8f\xd5\xf6"=>0,
    "\x8f\xd5\xf7"=>0,
    "\x8f\xd5\xf8"=>0,
    "\x8f\xd5\xf9"=>0,
    "\x8f\xd5\xfa"=>0,
    "\x8f\xd5\xfb"=>0,
    "\x8f\xd5\xfc"=>0,
    "\x8f\xd5\xfd"=>0,
    "\x8f\xd5\xfe"=>0,
    "\x8f\xd6\xa1"=>0,
    "\x8f\xd6\xa2"=>0,
    "\x8f\xd6\xa3"=>0,
    "\x8f\xd6\xa4"=>0,
    "\x8f\xd6\xa5"=>0,
    "\x8f\xd6\xa6"=>0,
    "\x8f\xd6\xa7"=>0,
    "\x8f\xd6\xa8"=>0,
    "\x8f\xd6\xa9"=>0,
    "\x8f\xd6\xaa"=>0,
    "\x8f\xd6\xab"=>0,
    "\x8f\xd6\xac"=>0,
    "\x8f\xd6\xad"=>0,
    "\x8f\xd6\xae"=>0,
    "\x8f\xd6\xaf"=>0,
    "\x8f\xd6\xb0"=>0,
    "\x8f\xd6\xb1"=>0,
    "\x8f\xd6\xb2"=>0,
    "\x8f\xd6\xb3"=>0,
    "\x8f\xd6\xb4"=>0,
    "\x8f\xd6\xb5"=>0,
    "\x8f\xd6\xb6"=>0,
    "\x8f\xd6\xb7"=>0,
    "\x8f\xd6\xb8"=>0,
    "\x8f\xd6\xb9"=>0,
    "\x8f\xd6\xba"=>0,
    "\x8f\xd6\xbb"=>0,
    "\x8f\xd6\xbc"=>0,
    "\x8f\xd6\xbd"=>0,
    "\x8f\xd6\xbe"=>0,
    "\x8f\xd6\xbf"=>0,
    "\x8f\xd6\xc0"=>0,
    "\x8f\xd6\xc1"=>0,
    "\x8f\xd6\xc2"=>0,
    "\x8f\xd6\xc3"=>0,
    "\x8f\xd6\xc4"=>0,
    "\x8f\xd6\xc5"=>0,
    "\x8f\xd6\xc6"=>0,
    "\x8f\xd6\xc7"=>0,
    "\x8f\xd6\xc8"=>0,
    "\x8f\xd6\xc9"=>0,
    "\x8f\xd6\xca"=>0,
    "\x8f\xd6\xcb"=>0,
    "\x8f\xd6\xcc"=>0,
    "\x8f\xd6\xcd"=>0,
    "\x8f\xd6\xce"=>0,
    "\x8f\xd6\xcf"=>0,
    "\x8f\xd6\xd0"=>0,
    "\x8f\xd6\xd1"=>0,
    "\x8f\xd6\xd2"=>0,
    "\x8f\xd6\xd3"=>0,
    "\x8f\xd6\xd4"=>0,
    "\x8f\xd6\xd5"=>0,
    "\x8f\xd6\xd6"=>0,
    "\x8f\xd6\xd7"=>0,
    "\x8f\xd6\xd8"=>0,
    "\x8f\xd6\xd9"=>0,
    "\x8f\xd6\xda"=>0,
    "\x8f\xd6\xdb"=>0,
    "\x8f\xd6\xdc"=>0,
    "\x8f\xd6\xdd"=>0,
    "\x8f\xd6\xde"=>0,
    "\x8f\xd6\xdf"=>0,
    "\x8f\xd6\xe0"=>0,
    "\x8f\xd6\xe1"=>0,
    "\x8f\xd6\xe2"=>0,
    "\x8f\xd6\xe3"=>0,
    "\x8f\xd6\xe4"=>0,
    "\x8f\xd6\xe5"=>0,
    "\x8f\xd6\xe6"=>0,
    "\x8f\xd6\xe7"=>0,
    "\x8f\xd6\xe8"=>0,
    "\x8f\xd6\xe9"=>0,
    "\x8f\xd6\xea"=>0,
    "\x8f\xd6\xeb"=>0,
    "\x8f\xd6\xec"=>0,
    "\x8f\xd6\xed"=>0,
    "\x8f\xd6\xee"=>0,
    "\x8f\xd6\xef"=>0,
    "\x8f\xd6\xf0"=>0,
    "\x8f\xd6\xf1"=>0,
    "\x8f\xd6\xf2"=>0,
    "\x8f\xd6\xf3"=>0,
    "\x8f\xd6\xf4"=>0,
    "\x8f\xd6\xf5"=>0,
    "\x8f\xd6\xf6"=>0,
    "\x8f\xd6\xf7"=>0,
    "\x8f\xd6\xf8"=>0,
    "\x8f\xd6\xf9"=>0,
    "\x8f\xd6\xfa"=>0,
    "\x8f\xd6\xfb"=>0,
    "\x8f\xd6\xfc"=>0,
    "\x8f\xd6\xfd"=>0,
    "\x8f\xd6\xfe"=>0,
    "\x8f\xd7\xa1"=>0,
    "\x8f\xd7\xa2"=>0,
    "\x8f\xd7\xa3"=>0,
    "\x8f\xd7\xa4"=>0,
    "\x8f\xd7\xa5"=>0,
    "\x8f\xd7\xa6"=>0,
    "\x8f\xd7\xa7"=>0,
    "\x8f\xd7\xa8"=>0,
    "\x8f\xd7\xa9"=>0,
    "\x8f\xd7\xaa"=>0,
    "\x8f\xd7\xab"=>0,
    "\x8f\xd7\xac"=>0,
    "\x8f\xd7\xad"=>0,
    "\x8f\xd7\xae"=>0,
    "\x8f\xd7\xaf"=>0,
    "\x8f\xd7\xb0"=>0,
    "\x8f\xd7\xb1"=>0,
    "\x8f\xd7\xb2"=>0,
    "\x8f\xd7\xb3"=>0,
    "\x8f\xd7\xb4"=>0,
    "\x8f\xd7\xb5"=>0,
    "\x8f\xd7\xb6"=>0,
    "\x8f\xd7\xb7"=>0,
    "\x8f\xd7\xb8"=>0,
    "\x8f\xd7\xb9"=>0,
    "\x8f\xd7\xba"=>0,
    "\x8f\xd7\xbb"=>0,
    "\x8f\xd7\xbc"=>0,
    "\x8f\xd7\xbd"=>0,
    "\x8f\xd7\xbe"=>0,
    "\x8f\xd7\xbf"=>0,
    "\x8f\xd7\xc0"=>0,
    "\x8f\xd7\xc1"=>0,
    "\x8f\xd7\xc2"=>0,
    "\x8f\xd7\xc3"=>0,
    "\x8f\xd7\xc4"=>0,
    "\x8f\xd7\xc5"=>0,
    "\x8f\xd7\xc6"=>0,
    "\x8f\xd7\xc7"=>0,
    "\x8f\xd7\xc8"=>0,
    "\x8f\xd7\xc9"=>0,
    "\x8f\xd7\xca"=>0,
    "\x8f\xd7\xcb"=>0,
    "\x8f\xd7\xcc"=>0,
    "\x8f\xd7\xcd"=>0,
    "\x8f\xd7\xce"=>0,
    "\x8f\xd7\xcf"=>0,
    "\x8f\xd7\xd0"=>0,
    "\x8f\xd7\xd1"=>0,
    "\x8f\xd7\xd2"=>0,
    "\x8f\xd7\xd3"=>0,
    "\x8f\xd7\xd4"=>0,
    "\x8f\xd7\xd5"=>0,
    "\x8f\xd7\xd6"=>0,
    "\x8f\xd7\xd7"=>0,
    "\x8f\xd7\xd8"=>0,
    "\x8f\xd7\xd9"=>0,
    "\x8f\xd7\xda"=>0,
    "\x8f\xd7\xdb"=>0,
    "\x8f\xd7\xdc"=>0,
    "\x8f\xd7\xdd"=>0,
    "\x8f\xd7\xde"=>0,
    "\x8f\xd7\xdf"=>0,
    "\x8f\xd7\xe0"=>0,
    "\x8f\xd7\xe1"=>0,
    "\x8f\xd7\xe2"=>0,
    "\x8f\xd7\xe3"=>0,
    "\x8f\xd7\xe4"=>0,
    "\x8f\xd7\xe5"=>0,
    "\x8f\xd7\xe6"=>0,
    "\x8f\xd7\xe7"=>0,
    "\x8f\xd7\xe8"=>0,
    "\x8f\xd7\xe9"=>0,
    "\x8f\xd7\xea"=>0,
    "\x8f\xd7\xeb"=>0,
    "\x8f\xd7\xec"=>0,
    "\x8f\xd7\xed"=>0,
    "\x8f\xd7\xee"=>0,
    "\x8f\xd7\xef"=>0,
    "\x8f\xd7\xf0"=>0,
    "\x8f\xd7\xf1"=>0,
    "\x8f\xd7\xf2"=>0,
    "\x8f\xd7\xf3"=>0,
    "\x8f\xd7\xf4"=>0,
    "\x8f\xd7\xf5"=>0,
    "\x8f\xd7\xf6"=>0,
    "\x8f\xd7\xf7"=>0,
    "\x8f\xd7\xf8"=>0,
    "\x8f\xd7\xf9"=>0,
    "\x8f\xd7\xfa"=>0,
    "\x8f\xd7\xfb"=>0,
    "\x8f\xd7\xfc"=>0,
    "\x8f\xd7\xfd"=>0,
    "\x8f\xd7\xfe"=>0,
    "\x8f\xd8\xa1"=>0,
    "\x8f\xd8\xa2"=>0,
    "\x8f\xd8\xa3"=>0,
    "\x8f\xd8\xa4"=>0,
    "\x8f\xd8\xa5"=>0,
    "\x8f\xd8\xa6"=>0,
    "\x8f\xd8\xa7"=>0,
    "\x8f\xd8\xa8"=>0,
    "\x8f\xd8\xa9"=>0,
    "\x8f\xd8\xaa"=>0,
    "\x8f\xd8\xab"=>0,
    "\x8f\xd8\xac"=>0,
    "\x8f\xd8\xad"=>0,
    "\x8f\xd8\xae"=>0,
    "\x8f\xd8\xaf"=>0,
    "\x8f\xd8\xb0"=>0,
    "\x8f\xd8\xb1"=>0,
    "\x8f\xd8\xb2"=>0,
    "\x8f\xd8\xb3"=>0,
    "\x8f\xd8\xb4"=>0,
    "\x8f\xd8\xb5"=>0,
    "\x8f\xd8\xb6"=>0,
    "\x8f\xd8\xb7"=>0,
    "\x8f\xd8\xb8"=>0,
    "\x8f\xd8\xb9"=>0,
    "\x8f\xd8\xba"=>0,
    "\x8f\xd8\xbb"=>0,
    "\x8f\xd8\xbc"=>0,
    "\x8f\xd8\xbd"=>0,
    "\x8f\xd8\xbe"=>0,
    "\x8f\xd8\xbf"=>0,
    "\x8f\xd8\xc0"=>0,
    "\x8f\xd8\xc1"=>0,
    "\x8f\xd8\xc2"=>0,
    "\x8f\xd8\xc3"=>0,
    "\x8f\xd8\xc4"=>0,
    "\x8f\xd8\xc5"=>0,
    "\x8f\xd8\xc6"=>0,
    "\x8f\xd8\xc7"=>0,
    "\x8f\xd8\xc8"=>0,
    "\x8f\xd8\xc9"=>0,
    "\x8f\xd8\xca"=>0,
    "\x8f\xd8\xcb"=>0,
    "\x8f\xd8\xcc"=>0,
    "\x8f\xd8\xcd"=>0,
    "\x8f\xd8\xce"=>0,
    "\x8f\xd8\xcf"=>0,
    "\x8f\xd8\xd0"=>0,
    "\x8f\xd8\xd1"=>0,
    "\x8f\xd8\xd2"=>0,
    "\x8f\xd8\xd3"=>0,
    "\x8f\xd8\xd4"=>0,
    "\x8f\xd8\xd5"=>0,
    "\x8f\xd8\xd6"=>0,
    "\x8f\xd8\xd7"=>0,
    "\x8f\xd8\xd8"=>0,
    "\x8f\xd8\xd9"=>0,
    "\x8f\xd8\xda"=>0,
    "\x8f\xd8\xdb"=>0,
    "\x8f\xd8\xdc"=>0,
    "\x8f\xd8\xdd"=>0,
    "\x8f\xd8\xde"=>0,
    "\x8f\xd8\xdf"=>0,
    "\x8f\xd8\xe0"=>0,
    "\x8f\xd8\xe1"=>0,
    "\x8f\xd8\xe2"=>0,
    "\x8f\xd8\xe3"=>0,
    "\x8f\xd8\xe4"=>0,
    "\x8f\xd8\xe5"=>0,
    "\x8f\xd8\xe6"=>0,
    "\x8f\xd8\xe7"=>0,
    "\x8f\xd8\xe8"=>0,
    "\x8f\xd8\xe9"=>0,
    "\x8f\xd8\xea"=>0,
    "\x8f\xd8\xeb"=>0,
    "\x8f\xd8\xec"=>0,
    "\x8f\xd8\xed"=>0,
    "\x8f\xd8\xee"=>0,
    "\x8f\xd8\xef"=>0,
    "\x8f\xd8\xf0"=>0,
    "\x8f\xd8\xf1"=>0,
    "\x8f\xd8\xf2"=>0,
    "\x8f\xd8\xf3"=>0,
    "\x8f\xd8\xf4"=>0,
    "\x8f\xd8\xf5"=>0,
    "\x8f\xd8\xf6"=>0,
    "\x8f\xd8\xf7"=>0,
    "\x8f\xd8\xf8"=>0,
    "\x8f\xd8\xf9"=>0,
    "\x8f\xd8\xfa"=>0,
    "\x8f\xd8\xfb"=>0,
    "\x8f\xd8\xfc"=>0,
    "\x8f\xd8\xfd"=>0,
    "\x8f\xd8\xfe"=>0,
    "\x8f\xd9\xa1"=>0,
    "\x8f\xd9\xa2"=>0,
    "\x8f\xd9\xa3"=>0,
    "\x8f\xd9\xa4"=>0,
    "\x8f\xd9\xa5"=>0,
    "\x8f\xd9\xa6"=>0,
    "\x8f\xd9\xa7"=>0,
    "\x8f\xd9\xa8"=>0,
    "\x8f\xd9\xa9"=>0,
    "\x8f\xd9\xaa"=>0,
    "\x8f\xd9\xab"=>0,
    "\x8f\xd9\xac"=>0,
    "\x8f\xd9\xad"=>0,
    "\x8f\xd9\xae"=>0,
    "\x8f\xd9\xaf"=>0,
    "\x8f\xd9\xb0"=>0,
    "\x8f\xd9\xb1"=>0,
    "\x8f\xd9\xb2"=>0,
    "\x8f\xd9\xb3"=>0,
    "\x8f\xd9\xb4"=>0,
    "\x8f\xd9\xb5"=>0,
    "\x8f\xd9\xb6"=>0,
    "\x8f\xd9\xb7"=>0,
    "\x8f\xd9\xb8"=>0,
    "\x8f\xd9\xb9"=>0,
    "\x8f\xd9\xba"=>0,
    "\x8f\xd9\xbb"=>0,
    "\x8f\xd9\xbc"=>0,
    "\x8f\xd9\xbd"=>0,
    "\x8f\xd9\xbe"=>0,
    "\x8f\xd9\xbf"=>0,
    "\x8f\xd9\xc0"=>0,
    "\x8f\xd9\xc1"=>0,
    "\x8f\xd9\xc2"=>0,
    "\x8f\xd9\xc3"=>0,
    "\x8f\xd9\xc4"=>0,
    "\x8f\xd9\xc5"=>0,
    "\x8f\xd9\xc6"=>0,
    "\x8f\xd9\xc7"=>0,
    "\x8f\xd9\xc8"=>0,
    "\x8f\xd9\xc9"=>0,
    "\x8f\xd9\xca"=>0,
    "\x8f\xd9\xcb"=>0,
    "\x8f\xd9\xcc"=>0,
    "\x8f\xd9\xcd"=>0,
    "\x8f\xd9\xce"=>0,
    "\x8f\xd9\xcf"=>0,
    "\x8f\xd9\xd0"=>0,
    "\x8f\xd9\xd1"=>0,
    "\x8f\xd9\xd2"=>0,
    "\x8f\xd9\xd3"=>0,
    "\x8f\xd9\xd4"=>0,
    "\x8f\xd9\xd5"=>0,
    "\x8f\xd9\xd6"=>0,
    "\x8f\xd9\xd7"=>0,
    "\x8f\xd9\xd8"=>0,
    "\x8f\xd9\xd9"=>0,
    "\x8f\xd9\xda"=>0,
    "\x8f\xd9\xdb"=>0,
    "\x8f\xd9\xdc"=>0,
    "\x8f\xd9\xdd"=>0,
    "\x8f\xd9\xde"=>0,
    "\x8f\xd9\xdf"=>0,
    "\x8f\xd9\xe0"=>0,
    "\x8f\xd9\xe1"=>0,
    "\x8f\xd9\xe2"=>0,
    "\x8f\xd9\xe3"=>0,
    "\x8f\xd9\xe4"=>0,
    "\x8f\xd9\xe5"=>0,
    "\x8f\xd9\xe6"=>0,
    "\x8f\xd9\xe7"=>0,
    "\x8f\xd9\xe8"=>0,
    "\x8f\xd9\xe9"=>0,
    "\x8f\xd9\xea"=>0,
    "\x8f\xd9\xeb"=>0,
    "\x8f\xd9\xec"=>0,
    "\x8f\xd9\xed"=>0,
    "\x8f\xd9\xee"=>0,
    "\x8f\xd9\xef"=>0,
    "\x8f\xd9\xf0"=>0,
    "\x8f\xd9\xf1"=>0,
    "\x8f\xd9\xf2"=>0,
    "\x8f\xd9\xf3"=>0,
    "\x8f\xd9\xf4"=>0,
    "\x8f\xd9\xf5"=>0,
    "\x8f\xd9\xf6"=>0,
    "\x8f\xd9\xf7"=>0,
    "\x8f\xd9\xf8"=>0,
    "\x8f\xd9\xf9"=>0,
    "\x8f\xd9\xfa"=>0,
    "\x8f\xd9\xfb"=>0,
    "\x8f\xd9\xfc"=>0,
    "\x8f\xd9\xfd"=>0,
    "\x8f\xd9\xfe"=>0,
    "\x8f\xda\xa1"=>0,
    "\x8f\xda\xa2"=>0,
    "\x8f\xda\xa3"=>0,
    "\x8f\xda\xa4"=>0,
    "\x8f\xda\xa5"=>0,
    "\x8f\xda\xa6"=>0,
    "\x8f\xda\xa7"=>0,
    "\x8f\xda\xa8"=>0,
    "\x8f\xda\xa9"=>0,
    "\x8f\xda\xaa"=>0,
    "\x8f\xda\xab"=>0,
    "\x8f\xda\xac"=>0,
    "\x8f\xda\xad"=>0,
    "\x8f\xda\xae"=>0,
    "\x8f\xda\xaf"=>0,
    "\x8f\xda\xb0"=>0,
    "\x8f\xda\xb1"=>0,
    "\x8f\xda\xb2"=>0,
    "\x8f\xda\xb3"=>0,
    "\x8f\xda\xb4"=>0,
    "\x8f\xda\xb5"=>0,
    "\x8f\xda\xb6"=>0,
    "\x8f\xda\xb7"=>0,
    "\x8f\xda\xb8"=>0,
    "\x8f\xda\xb9"=>0,
    "\x8f\xda\xba"=>0,
    "\x8f\xda\xbb"=>0,
    "\x8f\xda\xbc"=>0,
    "\x8f\xda\xbd"=>0,
    "\x8f\xda\xbe"=>0,
    "\x8f\xda\xbf"=>0,
    "\x8f\xda\xc0"=>0,
    "\x8f\xda\xc1"=>0,
    "\x8f\xda\xc2"=>0,
    "\x8f\xda\xc3"=>0,
    "\x8f\xda\xc4"=>0,
    "\x8f\xda\xc5"=>0,
    "\x8f\xda\xc6"=>0,
    "\x8f\xda\xc7"=>0,
    "\x8f\xda\xc8"=>0,
    "\x8f\xda\xc9"=>0,
    "\x8f\xda\xca"=>0,
    "\x8f\xda\xcb"=>0,
    "\x8f\xda\xcc"=>0,
    "\x8f\xda\xcd"=>0,
    "\x8f\xda\xce"=>0,
    "\x8f\xda\xcf"=>0,
    "\x8f\xda\xd0"=>0,
    "\x8f\xda\xd1"=>0,
    "\x8f\xda\xd2"=>0,
    "\x8f\xda\xd3"=>0,
    "\x8f\xda\xd4"=>0,
    "\x8f\xda\xd5"=>0,
    "\x8f\xda\xd6"=>0,
    "\x8f\xda\xd7"=>0,
    "\x8f\xda\xd8"=>0,
    "\x8f\xda\xd9"=>0,
    "\x8f\xda\xda"=>0,
    "\x8f\xda\xdb"=>0,
    "\x8f\xda\xdc"=>0,
    "\x8f\xda\xdd"=>0,
    "\x8f\xda\xde"=>0,
    "\x8f\xda\xdf"=>0,
    "\x8f\xda\xe0"=>0,
    "\x8f\xda\xe1"=>0,
    "\x8f\xda\xe2"=>0,
    "\x8f\xda\xe3"=>0,
    "\x8f\xda\xe4"=>0,
    "\x8f\xda\xe5"=>0,
    "\x8f\xda\xe6"=>0,
    "\x8f\xda\xe7"=>0,
    "\x8f\xda\xe8"=>0,
    "\x8f\xda\xe9"=>0,
    "\x8f\xda\xea"=>0,
    "\x8f\xda\xeb"=>0,
    "\x8f\xda\xec"=>0,
    "\x8f\xda\xed"=>0,
    "\x8f\xda\xee"=>0,
    "\x8f\xda\xef"=>0,
    "\x8f\xda\xf0"=>0,
    "\x8f\xda\xf1"=>0,
    "\x8f\xda\xf2"=>0,
    "\x8f\xda\xf3"=>0,
    "\x8f\xda\xf4"=>0,
    "\x8f\xda\xf5"=>0,
    "\x8f\xda\xf6"=>0,
    "\x8f\xda\xf7"=>0,
    "\x8f\xda\xf8"=>0,
    "\x8f\xda\xf9"=>0,
    "\x8f\xda\xfa"=>0,
    "\x8f\xda\xfb"=>0,
    "\x8f\xda\xfc"=>0,
    "\x8f\xda\xfd"=>0,
    "\x8f\xda\xfe"=>0,
    "\x8f\xdb\xa1"=>0,
    "\x8f\xdb\xa2"=>0,
    "\x8f\xdb\xa3"=>0,
    "\x8f\xdb\xa4"=>0,
    "\x8f\xdb\xa5"=>0,
    "\x8f\xdb\xa6"=>0,
    "\x8f\xdb\xa7"=>0,
    "\x8f\xdb\xa8"=>0,
    "\x8f\xdb\xa9"=>0,
    "\x8f\xdb\xaa"=>0,
    "\x8f\xdb\xab"=>0,
    "\x8f\xdb\xac"=>0,
    "\x8f\xdb\xad"=>0,
    "\x8f\xdb\xae"=>0,
    "\x8f\xdb\xaf"=>0,
    "\x8f\xdb\xb0"=>0,
    "\x8f\xdb\xb1"=>0,
    "\x8f\xdb\xb2"=>0,
    "\x8f\xdb\xb3"=>0,
    "\x8f\xdb\xb4"=>0,
    "\x8f\xdb\xb5"=>0,
    "\x8f\xdb\xb6"=>0,
    "\x8f\xdb\xb7"=>0,
    "\x8f\xdb\xb8"=>0,
    "\x8f\xdb\xb9"=>0,
    "\x8f\xdb\xba"=>0,
    "\x8f\xdb\xbb"=>0,
    "\x8f\xdb\xbc"=>0,
    "\x8f\xdb\xbd"=>0,
    "\x8f\xdb\xbe"=>0,
    "\x8f\xdb\xbf"=>0,
    "\x8f\xdb\xc0"=>0,
    "\x8f\xdb\xc1"=>0,
    "\x8f\xdb\xc2"=>0,
    "\x8f\xdb\xc3"=>0,
    "\x8f\xdb\xc4"=>0,
    "\x8f\xdb\xc5"=>0,
    "\x8f\xdb\xc6"=>0,
    "\x8f\xdb\xc7"=>0,
    "\x8f\xdb\xc8"=>0,
    "\x8f\xdb\xc9"=>0,
    "\x8f\xdb\xca"=>0,
    "\x8f\xdb\xcb"=>0,
    "\x8f\xdb\xcc"=>0,
    "\x8f\xdb\xcd"=>0,
    "\x8f\xdb\xce"=>0,
    "\x8f\xdb\xcf"=>0,
    "\x8f\xdb\xd0"=>0,
    "\x8f\xdb\xd1"=>0,
    "\x8f\xdb\xd2"=>0,
    "\x8f\xdb\xd3"=>0,
    "\x8f\xdb\xd4"=>0,
    "\x8f\xdb\xd5"=>0,
    "\x8f\xdb\xd6"=>0,
    "\x8f\xdb\xd7"=>0,
    "\x8f\xdb\xd8"=>0,
    "\x8f\xdb\xd9"=>0,
    "\x8f\xdb\xda"=>0,
    "\x8f\xdb\xdb"=>0,
    "\x8f\xdb\xdc"=>0,
    "\x8f\xdb\xdd"=>0,
    "\x8f\xdb\xde"=>0,
    "\x8f\xdb\xdf"=>0,
    "\x8f\xdb\xe0"=>0,
    "\x8f\xdb\xe1"=>0,
    "\x8f\xdb\xe2"=>0,
    "\x8f\xdb\xe3"=>0,
    "\x8f\xdb\xe4"=>0,
    "\x8f\xdb\xe5"=>0,
    "\x8f\xdb\xe6"=>0,
    "\x8f\xdb\xe7"=>0,
    "\x8f\xdb\xe8"=>0,
    "\x8f\xdb\xe9"=>0,
    "\x8f\xdb\xea"=>0,
    "\x8f\xdb\xeb"=>0,
    "\x8f\xdb\xec"=>0,
    "\x8f\xdb\xed"=>0,
    "\x8f\xdb\xee"=>0,
    "\x8f\xdb\xef"=>0,
    "\x8f\xdb\xf0"=>0,
    "\x8f\xdb\xf1"=>0,
    "\x8f\xdb\xf2"=>0,
    "\x8f\xdb\xf3"=>0,
    "\x8f\xdb\xf4"=>0,
    "\x8f\xdb\xf5"=>0,
    "\x8f\xdb\xf6"=>0,
    "\x8f\xdb\xf7"=>0,
    "\x8f\xdb\xf8"=>0,
    "\x8f\xdb\xf9"=>0,
    "\x8f\xdb\xfa"=>0,
    "\x8f\xdb\xfb"=>0,
    "\x8f\xdb\xfc"=>0,
    "\x8f\xdb\xfd"=>0,
    "\x8f\xdb\xfe"=>0,
    "\x8f\xdc\xa1"=>0,
    "\x8f\xdc\xa2"=>0,
    "\x8f\xdc\xa3"=>0,
    "\x8f\xdc\xa4"=>0,
    "\x8f\xdc\xa5"=>0,
    "\x8f\xdc\xa6"=>0,
    "\x8f\xdc\xa7"=>0,
    "\x8f\xdc\xa8"=>0,
    "\x8f\xdc\xa9"=>0,
    "\x8f\xdc\xaa"=>0,
    "\x8f\xdc\xab"=>0,
    "\x8f\xdc\xac"=>0,
    "\x8f\xdc\xad"=>0,
    "\x8f\xdc\xae"=>0,
    "\x8f\xdc\xaf"=>0,
    "\x8f\xdc\xb0"=>0,
    "\x8f\xdc\xb1"=>0,
    "\x8f\xdc\xb2"=>0,
    "\x8f\xdc\xb3"=>0,
    "\x8f\xdc\xb4"=>0,
    "\x8f\xdc\xb5"=>0,
    "\x8f\xdc\xb6"=>0,
    "\x8f\xdc\xb7"=>0,
    "\x8f\xdc\xb8"=>0,
    "\x8f\xdc\xb9"=>0,
    "\x8f\xdc\xba"=>0,
    "\x8f\xdc\xbb"=>0,
    "\x8f\xdc\xbc"=>0,
    "\x8f\xdc\xbd"=>0,
    "\x8f\xdc\xbe"=>0,
    "\x8f\xdc\xbf"=>0,
    "\x8f\xdc\xc0"=>0,
    "\x8f\xdc\xc1"=>0,
    "\x8f\xdc\xc2"=>0,
    "\x8f\xdc\xc3"=>0,
    "\x8f\xdc\xc4"=>0,
    "\x8f\xdc\xc5"=>0,
    "\x8f\xdc\xc6"=>0,
    "\x8f\xdc\xc7"=>0,
    "\x8f\xdc\xc8"=>0,
    "\x8f\xdc\xc9"=>0,
    "\x8f\xdc\xca"=>0,
    "\x8f\xdc\xcb"=>0,
    "\x8f\xdc\xcc"=>0,
    "\x8f\xdc\xcd"=>0,
    "\x8f\xdc\xce"=>0,
    "\x8f\xdc\xcf"=>0,
    "\x8f\xdc\xd0"=>0,
    "\x8f\xdc\xd1"=>0,
    "\x8f\xdc\xd2"=>0,
    "\x8f\xdc\xd3"=>0,
    "\x8f\xdc\xd4"=>0,
    "\x8f\xdc\xd5"=>0,
    "\x8f\xdc\xd6"=>0,
    "\x8f\xdc\xd7"=>0,
    "\x8f\xdc\xd8"=>0,
    "\x8f\xdc\xd9"=>0,
    "\x8f\xdc\xda"=>0,
    "\x8f\xdc\xdb"=>0,
    "\x8f\xdc\xdc"=>0,
    "\x8f\xdc\xdd"=>0,
    "\x8f\xdc\xde"=>0,
    "\x8f\xdc\xdf"=>0,
    "\x8f\xdc\xe0"=>0,
    "\x8f\xdc\xe1"=>0,
    "\x8f\xdc\xe2"=>0,
    "\x8f\xdc\xe3"=>0,
    "\x8f\xdc\xe4"=>0,
    "\x8f\xdc\xe5"=>0,
    "\x8f\xdc\xe6"=>0,
    "\x8f\xdc\xe7"=>0,
    "\x8f\xdc\xe8"=>0,
    "\x8f\xdc\xe9"=>0,
    "\x8f\xdc\xea"=>0,
    "\x8f\xdc\xeb"=>0,
    "\x8f\xdc\xec"=>0,
    "\x8f\xdc\xed"=>0,
    "\x8f\xdc\xee"=>0,
    "\x8f\xdc\xef"=>0,
    "\x8f\xdc\xf0"=>0,
    "\x8f\xdc\xf1"=>0,
    "\x8f\xdc\xf2"=>0,
    "\x8f\xdc\xf3"=>0,
    "\x8f\xdc\xf4"=>0,
    "\x8f\xdc\xf5"=>0,
    "\x8f\xdc\xf6"=>0,
    "\x8f\xdc\xf7"=>0,
    "\x8f\xdc\xf8"=>0,
    "\x8f\xdc\xf9"=>0,
    "\x8f\xdc\xfa"=>0,
    "\x8f\xdc\xfb"=>0,
    "\x8f\xdc\xfc"=>0,
    "\x8f\xdc\xfd"=>0,
    "\x8f\xdc\xfe"=>0,
    "\x8f\xdd\xa1"=>0,
    "\x8f\xdd\xa2"=>0,
    "\x8f\xdd\xa3"=>0,
    "\x8f\xdd\xa4"=>0,
    "\x8f\xdd\xa5"=>0,
    "\x8f\xdd\xa6"=>0,
    "\x8f\xdd\xa7"=>0,
    "\x8f\xdd\xa8"=>0,
    "\x8f\xdd\xa9"=>0,
    "\x8f\xdd\xaa"=>0,
    "\x8f\xdd\xab"=>0,
    "\x8f\xdd\xac"=>0,
    "\x8f\xdd\xad"=>0,
    "\x8f\xdd\xae"=>0,
    "\x8f\xdd\xaf"=>0,
    "\x8f\xdd\xb0"=>0,
    "\x8f\xdd\xb1"=>0,
    "\x8f\xdd\xb2"=>0,
    "\x8f\xdd\xb3"=>0,
    "\x8f\xdd\xb4"=>0,
    "\x8f\xdd\xb5"=>0,
    "\x8f\xdd\xb6"=>0,
    "\x8f\xdd\xb7"=>0,
    "\x8f\xdd\xb8"=>0,
    "\x8f\xdd\xb9"=>0,
    "\x8f\xdd\xba"=>0,
    "\x8f\xdd\xbb"=>0,
    "\x8f\xdd\xbc"=>0,
    "\x8f\xdd\xbd"=>0,
    "\x8f\xdd\xbe"=>0,
    "\x8f\xdd\xbf"=>0,
    "\x8f\xdd\xc0"=>0,
    "\x8f\xdd\xc1"=>0,
    "\x8f\xdd\xc2"=>0,
    "\x8f\xdd\xc3"=>0,
    "\x8f\xdd\xc4"=>0,
    "\x8f\xdd\xc5"=>0,
    "\x8f\xdd\xc6"=>0,
    "\x8f\xdd\xc7"=>0,
    "\x8f\xdd\xc8"=>0,
    "\x8f\xdd\xc9"=>0,
    "\x8f\xdd\xca"=>0,
    "\x8f\xdd\xcb"=>0,
    "\x8f\xdd\xcc"=>0,
    "\x8f\xdd\xcd"=>0,
    "\x8f\xdd\xce"=>0,
    "\x8f\xdd\xcf"=>0,
    "\x8f\xdd\xd0"=>0,
    "\x8f\xdd\xd1"=>0,
    "\x8f\xdd\xd2"=>0,
    "\x8f\xdd\xd3"=>0,
    "\x8f\xdd\xd4"=>0,
    "\x8f\xdd\xd5"=>0,
    "\x8f\xdd\xd6"=>0,
    "\x8f\xdd\xd7"=>0,
    "\x8f\xdd\xd8"=>0,
    "\x8f\xdd\xd9"=>0,
    "\x8f\xdd\xda"=>0,
    "\x8f\xdd\xdb"=>0,
    "\x8f\xdd\xdc"=>0,
    "\x8f\xdd\xdd"=>0,
    "\x8f\xdd\xde"=>0,
    "\x8f\xdd\xdf"=>0,
    "\x8f\xdd\xe0"=>0,
    "\x8f\xdd\xe1"=>0,
    "\x8f\xdd\xe2"=>0,
    "\x8f\xdd\xe3"=>0,
    "\x8f\xdd\xe4"=>0,
    "\x8f\xdd\xe5"=>0,
    "\x8f\xdd\xe6"=>0,
    "\x8f\xdd\xe7"=>0,
    "\x8f\xdd\xe8"=>0,
    "\x8f\xdd\xe9"=>0,
    "\x8f\xdd\xea"=>0,
    "\x8f\xdd\xeb"=>0,
    "\x8f\xdd\xec"=>0,
    "\x8f\xdd\xed"=>0,
    "\x8f\xdd\xee"=>0,
    "\x8f\xdd\xef"=>0,
    "\x8f\xdd\xf0"=>0,
    "\x8f\xdd\xf1"=>0,
    "\x8f\xdd\xf2"=>0,
    "\x8f\xdd\xf3"=>0,
    "\x8f\xdd\xf4"=>0,
    "\x8f\xdd\xf5"=>0,
    "\x8f\xdd\xf6"=>0,
    "\x8f\xdd\xf7"=>0,
    "\x8f\xdd\xf8"=>0,
    "\x8f\xdd\xf9"=>0,
    "\x8f\xdd\xfa"=>0,
    "\x8f\xdd\xfb"=>0,
    "\x8f\xdd\xfc"=>0,
    "\x8f\xdd\xfd"=>0,
    "\x8f\xdd\xfe"=>0,
    "\x8f\xde\xa1"=>0,
    "\x8f\xde\xa2"=>0,
    "\x8f\xde\xa3"=>0,
    "\x8f\xde\xa4"=>0,
    "\x8f\xde\xa5"=>0,
    "\x8f\xde\xa6"=>0,
    "\x8f\xde\xa7"=>0,
    "\x8f\xde\xa8"=>0,
    "\x8f\xde\xa9"=>0,
    "\x8f\xde\xaa"=>0,
    "\x8f\xde\xab"=>0,
    "\x8f\xde\xac"=>0,
    "\x8f\xde\xad"=>0,
    "\x8f\xde\xae"=>0,
    "\x8f\xde\xaf"=>0,
    "\x8f\xde\xb0"=>0,
    "\x8f\xde\xb1"=>0,
    "\x8f\xde\xb2"=>0,
    "\x8f\xde\xb3"=>0,
    "\x8f\xde\xb4"=>0,
    "\x8f\xde\xb5"=>0,
    "\x8f\xde\xb6"=>0,
    "\x8f\xde\xb7"=>0,
    "\x8f\xde\xb8"=>0,
    "\x8f\xde\xb9"=>0,
    "\x8f\xde\xba"=>0,
    "\x8f\xde\xbb"=>0,
    "\x8f\xde\xbc"=>0,
    "\x8f\xde\xbd"=>0,
    "\x8f\xde\xbe"=>0,
    "\x8f\xde\xbf"=>0,
    "\x8f\xde\xc0"=>0,
    "\x8f\xde\xc1"=>0,
    "\x8f\xde\xc2"=>0,
    "\x8f\xde\xc3"=>0,
    "\x8f\xde\xc4"=>0,
    "\x8f\xde\xc5"=>0,
    "\x8f\xde\xc6"=>0,
    "\x8f\xde\xc7"=>0,
    "\x8f\xde\xc8"=>0,
    "\x8f\xde\xc9"=>0,
    "\x8f\xde\xca"=>0,
    "\x8f\xde\xcb"=>0,
    "\x8f\xde\xcc"=>0,
    "\x8f\xde\xcd"=>0,
    "\x8f\xde\xce"=>0,
    "\x8f\xde\xcf"=>0,
    "\x8f\xde\xd0"=>0,
    "\x8f\xde\xd1"=>0,
    "\x8f\xde\xd2"=>0,
    "\x8f\xde\xd3"=>0,
    "\x8f\xde\xd4"=>0,
    "\x8f\xde\xd5"=>0,
    "\x8f\xde\xd6"=>0,
    "\x8f\xde\xd7"=>0,
    "\x8f\xde\xd8"=>0,
    "\x8f\xde\xd9"=>0,
    "\x8f\xde\xda"=>0,
    "\x8f\xde\xdb"=>0,
    "\x8f\xde\xdc"=>0,
    "\x8f\xde\xdd"=>0,
    "\x8f\xde\xde"=>0,
    "\x8f\xde\xdf"=>0,
    "\x8f\xde\xe0"=>0,
    "\x8f\xde\xe1"=>0,
    "\x8f\xde\xe2"=>0,
    "\x8f\xde\xe3"=>0,
    "\x8f\xde\xe4"=>0,
    "\x8f\xde\xe5"=>0,
    "\x8f\xde\xe6"=>0,
    "\x8f\xde\xe7"=>0,
    "\x8f\xde\xe8"=>0,
    "\x8f\xde\xe9"=>0,
    "\x8f\xde\xea"=>0,
    "\x8f\xde\xeb"=>0,
    "\x8f\xde\xec"=>0,
    "\x8f\xde\xed"=>0,
    "\x8f\xde\xee"=>0,
    "\x8f\xde\xef"=>0,
    "\x8f\xde\xf0"=>0,
    "\x8f\xde\xf1"=>0,
    "\x8f\xde\xf2"=>0,
    "\x8f\xde\xf3"=>0,
    "\x8f\xde\xf4"=>0,
    "\x8f\xde\xf5"=>0,
    "\x8f\xde\xf6"=>0,
    "\x8f\xde\xf7"=>0,
    "\x8f\xde\xf8"=>0,
    "\x8f\xde\xf9"=>0,
    "\x8f\xde\xfa"=>0,
    "\x8f\xde\xfb"=>0,
    "\x8f\xde\xfc"=>0,
    "\x8f\xde\xfd"=>0,
    "\x8f\xde\xfe"=>0,
    "\x8f\xdf\xa1"=>0,
    "\x8f\xdf\xa2"=>0,
    "\x8f\xdf\xa3"=>0,
    "\x8f\xdf\xa4"=>0,
    "\x8f\xdf\xa5"=>0,
    "\x8f\xdf\xa6"=>0,
    "\x8f\xdf\xa7"=>0,
    "\x8f\xdf\xa8"=>0,
    "\x8f\xdf\xa9"=>0,
    "\x8f\xdf\xaa"=>0,
    "\x8f\xdf\xab"=>0,
    "\x8f\xdf\xac"=>0,
    "\x8f\xdf\xad"=>0,
    "\x8f\xdf\xae"=>0,
    "\x8f\xdf\xaf"=>0,
    "\x8f\xdf\xb0"=>0,
    "\x8f\xdf\xb1"=>0,
    "\x8f\xdf\xb2"=>0,
    "\x8f\xdf\xb3"=>0,
    "\x8f\xdf\xb4"=>0,
    "\x8f\xdf\xb5"=>0,
    "\x8f\xdf\xb6"=>0,
    "\x8f\xdf\xb7"=>0,
    "\x8f\xdf\xb8"=>0,
    "\x8f\xdf\xb9"=>0,
    "\x8f\xdf\xba"=>0,
    "\x8f\xdf\xbb"=>0,
    "\x8f\xdf\xbc"=>0,
    "\x8f\xdf\xbd"=>0,
    "\x8f\xdf\xbe"=>0,
    "\x8f\xdf\xbf"=>0,
    "\x8f\xdf\xc0"=>0,
    "\x8f\xdf\xc1"=>0,
    "\x8f\xdf\xc2"=>0,
    "\x8f\xdf\xc3"=>0,
    "\x8f\xdf\xc4"=>0,
    "\x8f\xdf\xc5"=>0,
    "\x8f\xdf\xc6"=>0,
    "\x8f\xdf\xc7"=>0,
    "\x8f\xdf\xc8"=>0,
    "\x8f\xdf\xc9"=>0,
    "\x8f\xdf\xca"=>0,
    "\x8f\xdf\xcb"=>0,
    "\x8f\xdf\xcc"=>0,
    "\x8f\xdf\xcd"=>0,
    "\x8f\xdf\xce"=>0,
    "\x8f\xdf\xcf"=>0,
    "\x8f\xdf\xd0"=>0,
    "\x8f\xdf\xd1"=>0,
    "\x8f\xdf\xd2"=>0,
    "\x8f\xdf\xd3"=>0,
    "\x8f\xdf\xd4"=>0,
    "\x8f\xdf\xd5"=>0,
    "\x8f\xdf\xd6"=>0,
    "\x8f\xdf\xd7"=>0,
    "\x8f\xdf\xd8"=>0,
    "\x8f\xdf\xd9"=>0,
    "\x8f\xdf\xda"=>0,
    "\x8f\xdf\xdb"=>0,
    "\x8f\xdf\xdc"=>0,
    "\x8f\xdf\xdd"=>0,
    "\x8f\xdf\xde"=>0,
    "\x8f\xdf\xdf"=>0,
    "\x8f\xdf\xe0"=>0,
    "\x8f\xdf\xe1"=>0,
    "\x8f\xdf\xe2"=>0,
    "\x8f\xdf\xe3"=>0,
    "\x8f\xdf\xe4"=>0,
    "\x8f\xdf\xe5"=>0,
    "\x8f\xdf\xe6"=>0,
    "\x8f\xdf\xe7"=>0,
    "\x8f\xdf\xe8"=>0,
    "\x8f\xdf\xe9"=>0,
    "\x8f\xdf\xea"=>0,
    "\x8f\xdf\xeb"=>0,
    "\x8f\xdf\xec"=>0,
    "\x8f\xdf\xed"=>0,
    "\x8f\xdf\xee"=>0,
    "\x8f\xdf\xef"=>0,
    "\x8f\xdf\xf0"=>0,
    "\x8f\xdf\xf1"=>0,
    "\x8f\xdf\xf2"=>0,
    "\x8f\xdf\xf3"=>0,
    "\x8f\xdf\xf4"=>0,
    "\x8f\xdf\xf5"=>0,
    "\x8f\xdf\xf6"=>0,
    "\x8f\xdf\xf7"=>0,
    "\x8f\xdf\xf8"=>0,
    "\x8f\xdf\xf9"=>0,
    "\x8f\xdf\xfa"=>0,
    "\x8f\xdf\xfb"=>0,
    "\x8f\xdf\xfc"=>0,
    "\x8f\xdf\xfd"=>0,
    "\x8f\xdf\xfe"=>0,
    "\x8f\xe0\xa1"=>0,
    "\x8f\xe0\xa2"=>0,
    "\x8f\xe0\xa3"=>0,
    "\x8f\xe0\xa4"=>0,
    "\x8f\xe0\xa5"=>0,
    "\x8f\xe0\xa6"=>0,
    "\x8f\xe0\xa7"=>0,
    "\x8f\xe0\xa8"=>0,
    "\x8f\xe0\xa9"=>0,
    "\x8f\xe0\xaa"=>0,
    "\x8f\xe0\xab"=>0,
    "\x8f\xe0\xac"=>0,
    "\x8f\xe0\xad"=>0,
    "\x8f\xe0\xae"=>0,
    "\x8f\xe0\xaf"=>0,
    "\x8f\xe0\xb0"=>0,
    "\x8f\xe0\xb1"=>0,
    "\x8f\xe0\xb2"=>0,
    "\x8f\xe0\xb3"=>0,
    "\x8f\xe0\xb4"=>0,
    "\x8f\xe0\xb5"=>0,
    "\x8f\xe0\xb6"=>0,
    "\x8f\xe0\xb7"=>0,
    "\x8f\xe0\xb8"=>0,
    "\x8f\xe0\xb9"=>0,
    "\x8f\xe0\xba"=>0,
    "\x8f\xe0\xbb"=>0,
    "\x8f\xe0\xbc"=>0,
    "\x8f\xe0\xbd"=>0,
    "\x8f\xe0\xbe"=>0,
    "\x8f\xe0\xbf"=>0,
    "\x8f\xe0\xc0"=>0,
    "\x8f\xe0\xc1"=>0,
    "\x8f\xe0\xc2"=>0,
    "\x8f\xe0\xc3"=>0,
    "\x8f\xe0\xc4"=>0,
    "\x8f\xe0\xc5"=>0,
    "\x8f\xe0\xc6"=>0,
    "\x8f\xe0\xc7"=>0,
    "\x8f\xe0\xc8"=>0,
    "\x8f\xe0\xc9"=>0,
    "\x8f\xe0\xca"=>0,
    "\x8f\xe0\xcb"=>0,
    "\x8f\xe0\xcc"=>0,
    "\x8f\xe0\xcd"=>0,
    "\x8f\xe0\xce"=>0,
    "\x8f\xe0\xcf"=>0,
    "\x8f\xe0\xd0"=>0,
    "\x8f\xe0\xd1"=>0,
    "\x8f\xe0\xd2"=>0,
    "\x8f\xe0\xd3"=>0,
    "\x8f\xe0\xd4"=>0,
    "\x8f\xe0\xd5"=>0,
    "\x8f\xe0\xd6"=>0,
    "\x8f\xe0\xd7"=>0,
    "\x8f\xe0\xd8"=>0,
    "\x8f\xe0\xd9"=>0,
    "\x8f\xe0\xda"=>0,
    "\x8f\xe0\xdb"=>0,
    "\x8f\xe0\xdc"=>0,
    "\x8f\xe0\xdd"=>0,
    "\x8f\xe0\xde"=>0,
    "\x8f\xe0\xdf"=>0,
    "\x8f\xe0\xe0"=>0,
    "\x8f\xe0\xe1"=>0,
    "\x8f\xe0\xe2"=>0,
    "\x8f\xe0\xe3"=>0,
    "\x8f\xe0\xe4"=>0,
    "\x8f\xe0\xe5"=>0,
    "\x8f\xe0\xe6"=>0,
    "\x8f\xe0\xe7"=>0,
    "\x8f\xe0\xe8"=>0,
    "\x8f\xe0\xe9"=>0,
    "\x8f\xe0\xea"=>0,
    "\x8f\xe0\xeb"=>0,
    "\x8f\xe0\xec"=>0,
    "\x8f\xe0\xed"=>0,
    "\x8f\xe0\xee"=>0,
    "\x8f\xe0\xef"=>0,
    "\x8f\xe0\xf0"=>0,
    "\x8f\xe0\xf1"=>0,
    "\x8f\xe0\xf2"=>0,
    "\x8f\xe0\xf3"=>0,
    "\x8f\xe0\xf4"=>0,
    "\x8f\xe0\xf5"=>0,
    "\x8f\xe0\xf6"=>0,
    "\x8f\xe0\xf7"=>0,
    "\x8f\xe0\xf8"=>0,
    "\x8f\xe0\xf9"=>0,
    "\x8f\xe0\xfa"=>0,
    "\x8f\xe0\xfb"=>0,
    "\x8f\xe0\xfc"=>0,
    "\x8f\xe0\xfd"=>0,
    "\x8f\xe0\xfe"=>0,
    "\x8f\xe1\xa1"=>0,
    "\x8f\xe1\xa2"=>0,
    "\x8f\xe1\xa3"=>0,
    "\x8f\xe1\xa4"=>0,
    "\x8f\xe1\xa5"=>0,
    "\x8f\xe1\xa6"=>0,
    "\x8f\xe1\xa7"=>0,
    "\x8f\xe1\xa8"=>0,
    "\x8f\xe1\xa9"=>0,
    "\x8f\xe1\xaa"=>0,
    "\x8f\xe1\xab"=>0,
    "\x8f\xe1\xac"=>0,
    "\x8f\xe1\xad"=>0,
    "\x8f\xe1\xae"=>0,
    "\x8f\xe1\xaf"=>0,
    "\x8f\xe1\xb0"=>0,
    "\x8f\xe1\xb1"=>0,
    "\x8f\xe1\xb2"=>0,
    "\x8f\xe1\xb3"=>0,
    "\x8f\xe1\xb4"=>0,
    "\x8f\xe1\xb5"=>0,
    "\x8f\xe1\xb6"=>0,
    "\x8f\xe1\xb7"=>0,
    "\x8f\xe1\xb8"=>0,
    "\x8f\xe1\xb9"=>0,
    "\x8f\xe1\xba"=>0,
    "\x8f\xe1\xbb"=>0,
    "\x8f\xe1\xbc"=>0,
    "\x8f\xe1\xbd"=>0,
    "\x8f\xe1\xbe"=>0,
    "\x8f\xe1\xbf"=>0,
    "\x8f\xe1\xc0"=>0,
    "\x8f\xe1\xc1"=>0,
    "\x8f\xe1\xc2"=>0,
    "\x8f\xe1\xc3"=>0,
    "\x8f\xe1\xc4"=>0,
    "\x8f\xe1\xc5"=>0,
    "\x8f\xe1\xc6"=>0,
    "\x8f\xe1\xc7"=>0,
    "\x8f\xe1\xc8"=>0,
    "\x8f\xe1\xc9"=>0,
    "\x8f\xe1\xca"=>0,
    "\x8f\xe1\xcb"=>0,
    "\x8f\xe1\xcc"=>0,
    "\x8f\xe1\xcd"=>0,
    "\x8f\xe1\xce"=>0,
    "\x8f\xe1\xcf"=>0,
    "\x8f\xe1\xd0"=>0,
    "\x8f\xe1\xd1"=>0,
    "\x8f\xe1\xd2"=>0,
    "\x8f\xe1\xd3"=>0,
    "\x8f\xe1\xd4"=>0,
    "\x8f\xe1\xd5"=>0,
    "\x8f\xe1\xd6"=>0,
    "\x8f\xe1\xd7"=>0,
    "\x8f\xe1\xd8"=>0,
    "\x8f\xe1\xd9"=>0,
    "\x8f\xe1\xda"=>0,
    "\x8f\xe1\xdb"=>0,
    "\x8f\xe1\xdc"=>0,
    "\x8f\xe1\xdd"=>0,
    "\x8f\xe1\xde"=>0,
    "\x8f\xe1\xdf"=>0,
    "\x8f\xe1\xe0"=>0,
    "\x8f\xe1\xe1"=>0,
    "\x8f\xe1\xe2"=>0,
    "\x8f\xe1\xe3"=>0,
    "\x8f\xe1\xe4"=>0,
    "\x8f\xe1\xe5"=>0,
    "\x8f\xe1\xe6"=>0,
    "\x8f\xe1\xe7"=>0,
    "\x8f\xe1\xe8"=>0,
    "\x8f\xe1\xe9"=>0,
    "\x8f\xe1\xea"=>0,
    "\x8f\xe1\xeb"=>0,
    "\x8f\xe1\xec"=>0,
    "\x8f\xe1\xed"=>0,
    "\x8f\xe1\xee"=>0,
    "\x8f\xe1\xef"=>0,
    "\x8f\xe1\xf0"=>0,
    "\x8f\xe1\xf1"=>0,
    "\x8f\xe1\xf2"=>0,
    "\x8f\xe1\xf3"=>0,
    "\x8f\xe1\xf4"=>0,
    "\x8f\xe1\xf5"=>0,
    "\x8f\xe1\xf6"=>0,
    "\x8f\xe1\xf7"=>0,
    "\x8f\xe1\xf8"=>0,
    "\x8f\xe1\xf9"=>0,
    "\x8f\xe1\xfa"=>0,
    "\x8f\xe1\xfb"=>0,
    "\x8f\xe1\xfc"=>0,
    "\x8f\xe1\xfd"=>0,
    "\x8f\xe1\xfe"=>0,
    "\x8f\xe2\xa1"=>0,
    "\x8f\xe2\xa2"=>0,
    "\x8f\xe2\xa3"=>0,
    "\x8f\xe2\xa4"=>0,
    "\x8f\xe2\xa5"=>0,
    "\x8f\xe2\xa6"=>0,
    "\x8f\xe2\xa7"=>0,
    "\x8f\xe2\xa8"=>0,
    "\x8f\xe2\xa9"=>0,
    "\x8f\xe2\xaa"=>0,
    "\x8f\xe2\xab"=>0,
    "\x8f\xe2\xac"=>0,
    "\x8f\xe2\xad"=>0,
    "\x8f\xe2\xae"=>0,
    "\x8f\xe2\xaf"=>0,
    "\x8f\xe2\xb0"=>0,
    "\x8f\xe2\xb1"=>0,
    "\x8f\xe2\xb2"=>0,
    "\x8f\xe2\xb3"=>0,
    "\x8f\xe2\xb4"=>0,
    "\x8f\xe2\xb5"=>0,
    "\x8f\xe2\xb6"=>0,
    "\x8f\xe2\xb7"=>0,
    "\x8f\xe2\xb8"=>0,
    "\x8f\xe2\xb9"=>0,
    "\x8f\xe2\xba"=>0,
    "\x8f\xe2\xbb"=>0,
    "\x8f\xe2\xbc"=>0,
    "\x8f\xe2\xbd"=>0,
    "\x8f\xe2\xbe"=>0,
    "\x8f\xe2\xbf"=>0,
    "\x8f\xe2\xc0"=>0,
    "\x8f\xe2\xc1"=>0,
    "\x8f\xe2\xc2"=>0,
    "\x8f\xe2\xc3"=>0,
    "\x8f\xe2\xc4"=>0,
    "\x8f\xe2\xc5"=>0,
    "\x8f\xe2\xc6"=>0,
    "\x8f\xe2\xc7"=>0,
    "\x8f\xe2\xc8"=>0,
    "\x8f\xe2\xc9"=>0,
    "\x8f\xe2\xca"=>0,
    "\x8f\xe2\xcb"=>0,
    "\x8f\xe2\xcc"=>0,
    "\x8f\xe2\xcd"=>0,
    "\x8f\xe2\xce"=>0,
    "\x8f\xe2\xcf"=>0,
    "\x8f\xe2\xd0"=>0,
    "\x8f\xe2\xd1"=>0,
    "\x8f\xe2\xd2"=>0,
    "\x8f\xe2\xd3"=>0,
    "\x8f\xe2\xd4"=>0,
    "\x8f\xe2\xd5"=>0,
    "\x8f\xe2\xd6"=>0,
    "\x8f\xe2\xd7"=>0,
    "\x8f\xe2\xd8"=>0,
    "\x8f\xe2\xd9"=>0,
    "\x8f\xe2\xda"=>0,
    "\x8f\xe2\xdb"=>0,
    "\x8f\xe2\xdc"=>0,
    "\x8f\xe2\xdd"=>0,
    "\x8f\xe2\xde"=>0,
    "\x8f\xe2\xdf"=>0,
    "\x8f\xe2\xe0"=>0,
    "\x8f\xe2\xe1"=>0,
    "\x8f\xe2\xe2"=>0,
    "\x8f\xe2\xe3"=>0,
    "\x8f\xe2\xe4"=>0,
    "\x8f\xe2\xe5"=>0,
    "\x8f\xe2\xe6"=>0,
    "\x8f\xe2\xe7"=>0,
    "\x8f\xe2\xe8"=>0,
    "\x8f\xe2\xe9"=>0,
    "\x8f\xe2\xea"=>0,
    "\x8f\xe2\xeb"=>0,
    "\x8f\xe2\xec"=>0,
    "\x8f\xe2\xed"=>0,
    "\x8f\xe2\xee"=>0,
    "\x8f\xe2\xef"=>0,
    "\x8f\xe2\xf0"=>0,
    "\x8f\xe2\xf1"=>0,
    "\x8f\xe2\xf2"=>0,
    "\x8f\xe2\xf3"=>0,
    "\x8f\xe2\xf4"=>0,
    "\x8f\xe2\xf5"=>0,
    "\x8f\xe2\xf6"=>0,
    "\x8f\xe2\xf7"=>0,
    "\x8f\xe2\xf8"=>0,
    "\x8f\xe2\xf9"=>0,
    "\x8f\xe2\xfa"=>0,
    "\x8f\xe2\xfb"=>0,
    "\x8f\xe2\xfc"=>0,
    "\x8f\xe2\xfd"=>0,
    "\x8f\xe2\xfe"=>0,
    "\x8f\xe3\xa1"=>0,
    "\x8f\xe3\xa2"=>0,
    "\x8f\xe3\xa3"=>0,
    "\x8f\xe3\xa4"=>0,
    "\x8f\xe3\xa5"=>0,
    "\x8f\xe3\xa6"=>0,
    "\x8f\xe3\xa7"=>0,
    "\x8f\xe3\xa8"=>0,
    "\x8f\xe3\xa9"=>0,
    "\x8f\xe3\xaa"=>0,
    "\x8f\xe3\xab"=>0,
    "\x8f\xe3\xac"=>0,
    "\x8f\xe3\xad"=>0,
    "\x8f\xe3\xae"=>0,
    "\x8f\xe3\xaf"=>0,
    "\x8f\xe3\xb0"=>0,
    "\x8f\xe3\xb1"=>0,
    "\x8f\xe3\xb2"=>0,
    "\x8f\xe3\xb3"=>0,
    "\x8f\xe3\xb4"=>0,
    "\x8f\xe3\xb5"=>0,
    "\x8f\xe3\xb6"=>0,
    "\x8f\xe3\xb7"=>0,
    "\x8f\xe3\xb8"=>0,
    "\x8f\xe3\xb9"=>0,
    "\x8f\xe3\xba"=>0,
    "\x8f\xe3\xbb"=>0,
    "\x8f\xe3\xbc"=>0,
    "\x8f\xe3\xbd"=>0,
    "\x8f\xe3\xbe"=>0,
    "\x8f\xe3\xbf"=>0,
    "\x8f\xe3\xc0"=>0,
    "\x8f\xe3\xc1"=>0,
    "\x8f\xe3\xc2"=>0,
    "\x8f\xe3\xc3"=>0,
    "\x8f\xe3\xc4"=>0,
    "\x8f\xe3\xc5"=>0,
    "\x8f\xe3\xc6"=>0,
    "\x8f\xe3\xc7"=>0,
    "\x8f\xe3\xc8"=>0,
    "\x8f\xe3\xc9"=>0,
    "\x8f\xe3\xca"=>0,
    "\x8f\xe3\xcb"=>0,
    "\x8f\xe3\xcc"=>0,
    "\x8f\xe3\xcd"=>0,
    "\x8f\xe3\xce"=>0,
    "\x8f\xe3\xcf"=>0,
    "\x8f\xe3\xd0"=>0,
    "\x8f\xe3\xd1"=>0,
    "\x8f\xe3\xd2"=>0,
    "\x8f\xe3\xd3"=>0,
    "\x8f\xe3\xd4"=>0,
    "\x8f\xe3\xd5"=>0,
    "\x8f\xe3\xd6"=>0,
    "\x8f\xe3\xd7"=>0,
    "\x8f\xe3\xd8"=>0,
    "\x8f\xe3\xd9"=>0,
    "\x8f\xe3\xda"=>0,
    "\x8f\xe3\xdb"=>0,
    "\x8f\xe3\xdc"=>0,
    "\x8f\xe3\xdd"=>0,
    "\x8f\xe3\xde"=>0,
    "\x8f\xe3\xdf"=>0,
    "\x8f\xe3\xe0"=>0,
    "\x8f\xe3\xe1"=>0,
    "\x8f\xe3\xe2"=>0,
    "\x8f\xe3\xe3"=>0,
    "\x8f\xe3\xe4"=>0,
    "\x8f\xe3\xe5"=>0,
    "\x8f\xe3\xe6"=>0,
    "\x8f\xe3\xe7"=>0,
    "\x8f\xe3\xe8"=>0,
    "\x8f\xe3\xe9"=>0,
    "\x8f\xe3\xea"=>0,
    "\x8f\xe3\xeb"=>0,
    "\x8f\xe3\xec"=>0,
    "\x8f\xe3\xed"=>0,
    "\x8f\xe3\xee"=>0,
    "\x8f\xe3\xef"=>0,
    "\x8f\xe3\xf0"=>0,
    "\x8f\xe3\xf1"=>0,
    "\x8f\xe3\xf2"=>0,
    "\x8f\xe3\xf3"=>0,
    "\x8f\xe3\xf4"=>0,
    "\x8f\xe3\xf5"=>0,
    "\x8f\xe3\xf6"=>0,
    "\x8f\xe3\xf7"=>0,
    "\x8f\xe3\xf8"=>0,
    "\x8f\xe3\xf9"=>0,
    "\x8f\xe3\xfa"=>0,
    "\x8f\xe3\xfb"=>0,
    "\x8f\xe3\xfc"=>0,
    "\x8f\xe3\xfd"=>0,
    "\x8f\xe3\xfe"=>0,
    "\x8f\xe4\xa1"=>0,
    "\x8f\xe4\xa2"=>0,
    "\x8f\xe4\xa3"=>0,
    "\x8f\xe4\xa4"=>0,
    "\x8f\xe4\xa5"=>0,
    "\x8f\xe4\xa6"=>0,
    "\x8f\xe4\xa7"=>0,
    "\x8f\xe4\xa8"=>0,
    "\x8f\xe4\xa9"=>0,
    "\x8f\xe4\xaa"=>0,
    "\x8f\xe4\xab"=>0,
    "\x8f\xe4\xac"=>0,
    "\x8f\xe4\xad"=>0,
    "\x8f\xe4\xae"=>0,
    "\x8f\xe4\xaf"=>0,
    "\x8f\xe4\xb0"=>0,
    "\x8f\xe4\xb1"=>0,
    "\x8f\xe4\xb2"=>0,
    "\x8f\xe4\xb3"=>0,
    "\x8f\xe4\xb4"=>0,
    "\x8f\xe4\xb5"=>0,
    "\x8f\xe4\xb6"=>0,
    "\x8f\xe4\xb7"=>0,
    "\x8f\xe4\xb8"=>0,
    "\x8f\xe4\xb9"=>0,
    "\x8f\xe4\xba"=>0,
    "\x8f\xe4\xbb"=>0,
    "\x8f\xe4\xbc"=>0,
    "\x8f\xe4\xbd"=>0,
    "\x8f\xe4\xbe"=>0,
    "\x8f\xe4\xbf"=>0,
    "\x8f\xe4\xc0"=>0,
    "\x8f\xe4\xc1"=>0,
    "\x8f\xe4\xc2"=>0,
    "\x8f\xe4\xc3"=>0,
    "\x8f\xe4\xc4"=>0,
    "\x8f\xe4\xc5"=>0,
    "\x8f\xe4\xc6"=>0,
    "\x8f\xe4\xc7"=>0,
    "\x8f\xe4\xc8"=>0,
    "\x8f\xe4\xc9"=>0,
    "\x8f\xe4\xca"=>0,
    "\x8f\xe4\xcb"=>0,
    "\x8f\xe4\xcc"=>0,
    "\x8f\xe4\xcd"=>0,
    "\x8f\xe4\xce"=>0,
    "\x8f\xe4\xcf"=>0,
    "\x8f\xe4\xd0"=>0,
    "\x8f\xe4\xd1"=>0,
    "\x8f\xe4\xd2"=>0,
    "\x8f\xe4\xd3"=>0,
    "\x8f\xe4\xd4"=>0,
    "\x8f\xe4\xd5"=>0,
    "\x8f\xe4\xd6"=>0,
    "\x8f\xe4\xd7"=>0,
    "\x8f\xe4\xd8"=>0,
    "\x8f\xe4\xd9"=>0,
    "\x8f\xe4\xda"=>0,
    "\x8f\xe4\xdb"=>0,
    "\x8f\xe4\xdc"=>0,
    "\x8f\xe4\xdd"=>0,
    "\x8f\xe4\xde"=>0,
    "\x8f\xe4\xdf"=>0,
    "\x8f\xe4\xe0"=>0,
    "\x8f\xe4\xe1"=>0,
    "\x8f\xe4\xe2"=>0,
    "\x8f\xe4\xe3"=>0,
    "\x8f\xe4\xe4"=>0,
    "\x8f\xe4\xe5"=>0,
    "\x8f\xe4\xe6"=>0,
    "\x8f\xe4\xe7"=>0,
    "\x8f\xe4\xe8"=>0,
    "\x8f\xe4\xe9"=>0,
    "\x8f\xe4\xea"=>0,
    "\x8f\xe4\xeb"=>0,
    "\x8f\xe4\xec"=>0,
    "\x8f\xe4\xed"=>0,
    "\x8f\xe4\xee"=>0,
    "\x8f\xe4\xef"=>0,
    "\x8f\xe4\xf0"=>0,
    "\x8f\xe4\xf1"=>0,
    "\x8f\xe4\xf2"=>0,
    "\x8f\xe4\xf3"=>0,
    "\x8f\xe4\xf4"=>0,
    "\x8f\xe4\xf5"=>0,
    "\x8f\xe4\xf6"=>0,
    "\x8f\xe4\xf7"=>0,
    "\x8f\xe4\xf8"=>0,
    "\x8f\xe4\xf9"=>0,
    "\x8f\xe4\xfa"=>0,
    "\x8f\xe4\xfb"=>0,
    "\x8f\xe4\xfc"=>0,
    "\x8f\xe4\xfd"=>0,
    "\x8f\xe4\xfe"=>0,
    "\x8f\xe5\xa1"=>0,
    "\x8f\xe5\xa2"=>0,
    "\x8f\xe5\xa3"=>0,
    "\x8f\xe5\xa4"=>0,
    "\x8f\xe5\xa5"=>0,
    "\x8f\xe5\xa6"=>0,
    "\x8f\xe5\xa7"=>0,
    "\x8f\xe5\xa8"=>0,
    "\x8f\xe5\xa9"=>0,
    "\x8f\xe5\xaa"=>0,
    "\x8f\xe5\xab"=>0,
    "\x8f\xe5\xac"=>0,
    "\x8f\xe5\xad"=>0,
    "\x8f\xe5\xae"=>0,
    "\x8f\xe5\xaf"=>0,
    "\x8f\xe5\xb0"=>0,
    "\x8f\xe5\xb1"=>0,
    "\x8f\xe5\xb2"=>0,
    "\x8f\xe5\xb3"=>0,
    "\x8f\xe5\xb4"=>0,
    "\x8f\xe5\xb5"=>0,
    "\x8f\xe5\xb6"=>0,
    "\x8f\xe5\xb7"=>0,
    "\x8f\xe5\xb8"=>0,
    "\x8f\xe5\xb9"=>0,
    "\x8f\xe5\xba"=>0,
    "\x8f\xe5\xbb"=>0,
    "\x8f\xe5\xbc"=>0,
    "\x8f\xe5\xbd"=>0,
    "\x8f\xe5\xbe"=>0,
    "\x8f\xe5\xbf"=>0,
    "\x8f\xe5\xc0"=>0,
    "\x8f\xe5\xc1"=>0,
    "\x8f\xe5\xc2"=>0,
    "\x8f\xe5\xc3"=>0,
    "\x8f\xe5\xc4"=>0,
    "\x8f\xe5\xc5"=>0,
    "\x8f\xe5\xc6"=>0,
    "\x8f\xe5\xc7"=>0,
    "\x8f\xe5\xc8"=>0,
    "\x8f\xe5\xc9"=>0,
    "\x8f\xe5\xca"=>0,
    "\x8f\xe5\xcb"=>0,
    "\x8f\xe5\xcc"=>0,
    "\x8f\xe5\xcd"=>0,
    "\x8f\xe5\xce"=>0,
    "\x8f\xe5\xcf"=>0,
    "\x8f\xe5\xd0"=>0,
    "\x8f\xe5\xd1"=>0,
    "\x8f\xe5\xd2"=>0,
    "\x8f\xe5\xd3"=>0,
    "\x8f\xe5\xd4"=>0,
    "\x8f\xe5\xd5"=>0,
    "\x8f\xe5\xd6"=>0,
    "\x8f\xe5\xd7"=>0,
    "\x8f\xe5\xd8"=>0,
    "\x8f\xe5\xd9"=>0,
    "\x8f\xe5\xda"=>0,
    "\x8f\xe5\xdb"=>0,
    "\x8f\xe5\xdc"=>0,
    "\x8f\xe5\xdd"=>0,
    "\x8f\xe5\xde"=>0,
    "\x8f\xe5\xdf"=>0,
    "\x8f\xe5\xe0"=>0,
    "\x8f\xe5\xe1"=>0,
    "\x8f\xe5\xe2"=>0,
    "\x8f\xe5\xe3"=>0,
    "\x8f\xe5\xe4"=>0,
    "\x8f\xe5\xe5"=>0,
    "\x8f\xe5\xe6"=>0,
    "\x8f\xe5\xe7"=>0,
    "\x8f\xe5\xe8"=>0,
    "\x8f\xe5\xe9"=>0,
    "\x8f\xe5\xea"=>0,
    "\x8f\xe5\xeb"=>0,
    "\x8f\xe5\xec"=>0,
    "\x8f\xe5\xed"=>0,
    "\x8f\xe5\xee"=>0,
    "\x8f\xe5\xef"=>0,
    "\x8f\xe5\xf0"=>0,
    "\x8f\xe5\xf1"=>0,
    "\x8f\xe5\xf2"=>0,
    "\x8f\xe5\xf3"=>0,
    "\x8f\xe5\xf4"=>0,
    "\x8f\xe5\xf5"=>0,
    "\x8f\xe5\xf6"=>0,
    "\x8f\xe5\xf7"=>0,
    "\x8f\xe5\xf8"=>0,
    "\x8f\xe5\xf9"=>0,
    "\x8f\xe5\xfa"=>0,
    "\x8f\xe5\xfb"=>0,
    "\x8f\xe5\xfc"=>0,
    "\x8f\xe5\xfd"=>0,
    "\x8f\xe5\xfe"=>0,
    "\x8f\xe6\xa1"=>0,
    "\x8f\xe6\xa2"=>0,
    "\x8f\xe6\xa3"=>0,
    "\x8f\xe6\xa4"=>0,
    "\x8f\xe6\xa5"=>0,
    "\x8f\xe6\xa6"=>0,
    "\x8f\xe6\xa7"=>0,
    "\x8f\xe6\xa8"=>0,
    "\x8f\xe6\xa9"=>0,
    "\x8f\xe6\xaa"=>0,
    "\x8f\xe6\xab"=>0,
    "\x8f\xe6\xac"=>0,
    "\x8f\xe6\xad"=>0,
    "\x8f\xe6\xae"=>0,
    "\x8f\xe6\xaf"=>0,
    "\x8f\xe6\xb0"=>0,
    "\x8f\xe6\xb1"=>0,
    "\x8f\xe6\xb2"=>0,
    "\x8f\xe6\xb3"=>0,
    "\x8f\xe6\xb4"=>0,
    "\x8f\xe6\xb5"=>0,
    "\x8f\xe6\xb6"=>0,
    "\x8f\xe6\xb7"=>0,
    "\x8f\xe6\xb8"=>0,
    "\x8f\xe6\xb9"=>0,
    "\x8f\xe6\xba"=>0,
    "\x8f\xe6\xbb"=>0,
    "\x8f\xe6\xbc"=>0,
    "\x8f\xe6\xbd"=>0,
    "\x8f\xe6\xbe"=>0,
    "\x8f\xe6\xbf"=>0,
    "\x8f\xe6\xc0"=>0,
    "\x8f\xe6\xc1"=>0,
    "\x8f\xe6\xc2"=>0,
    "\x8f\xe6\xc3"=>0,
    "\x8f\xe6\xc4"=>0,
    "\x8f\xe6\xc5"=>0,
    "\x8f\xe6\xc6"=>0,
    "\x8f\xe6\xc7"=>0,
    "\x8f\xe6\xc8"=>0,
    "\x8f\xe6\xc9"=>0,
    "\x8f\xe6\xca"=>0,
    "\x8f\xe6\xcb"=>0,
    "\x8f\xe6\xcc"=>0,
    "\x8f\xe6\xcd"=>0,
    "\x8f\xe6\xce"=>0,
    "\x8f\xe6\xcf"=>0,
    "\x8f\xe6\xd0"=>0,
    "\x8f\xe6\xd1"=>0,
    "\x8f\xe6\xd2"=>0,
    "\x8f\xe6\xd3"=>0,
    "\x8f\xe6\xd4"=>0,
    "\x8f\xe6\xd5"=>0,
    "\x8f\xe6\xd6"=>0,
    "\x8f\xe6\xd7"=>0,
    "\x8f\xe6\xd8"=>0,
    "\x8f\xe6\xd9"=>0,
    "\x8f\xe6\xda"=>0,
    "\x8f\xe6\xdb"=>0,
    "\x8f\xe6\xdc"=>0,
    "\x8f\xe6\xdd"=>0,
    "\x8f\xe6\xde"=>0,
    "\x8f\xe6\xdf"=>0,
    "\x8f\xe6\xe0"=>0,
    "\x8f\xe6\xe1"=>0,
    "\x8f\xe6\xe2"=>0,
    "\x8f\xe6\xe3"=>0,
    "\x8f\xe6\xe4"=>0,
    "\x8f\xe6\xe5"=>0,
    "\x8f\xe6\xe6"=>0,
    "\x8f\xe6\xe7"=>0,
    "\x8f\xe6\xe8"=>0,
    "\x8f\xe6\xe9"=>0,
    "\x8f\xe6\xea"=>0,
    "\x8f\xe6\xeb"=>0,
    "\x8f\xe6\xec"=>0,
    "\x8f\xe6\xed"=>0,
    "\x8f\xe6\xee"=>0,
    "\x8f\xe6\xef"=>0,
    "\x8f\xe6\xf0"=>0,
    "\x8f\xe6\xf1"=>0,
    "\x8f\xe6\xf2"=>0,
    "\x8f\xe6\xf3"=>0,
    "\x8f\xe6\xf4"=>0,
    "\x8f\xe6\xf5"=>0,
    "\x8f\xe6\xf6"=>0,
    "\x8f\xe6\xf7"=>0,
    "\x8f\xe6\xf8"=>0,
    "\x8f\xe6\xf9"=>0,
    "\x8f\xe6\xfa"=>0,
    "\x8f\xe6\xfb"=>0,
    "\x8f\xe6\xfc"=>0,
    "\x8f\xe6\xfd"=>0,
    "\x8f\xe6\xfe"=>0,
    "\x8f\xe7\xa1"=>0,
    "\x8f\xe7\xa2"=>0,
    "\x8f\xe7\xa3"=>0,
    "\x8f\xe7\xa4"=>0,
    "\x8f\xe7\xa5"=>0,
    "\x8f\xe7\xa6"=>0,
    "\x8f\xe7\xa7"=>0,
    "\x8f\xe7\xa8"=>0,
    "\x8f\xe7\xa9"=>0,
    "\x8f\xe7\xaa"=>0,
    "\x8f\xe7\xab"=>0,
    "\x8f\xe7\xac"=>0,
    "\x8f\xe7\xad"=>0,
    "\x8f\xe7\xae"=>0,
    "\x8f\xe7\xaf"=>0,
    "\x8f\xe7\xb0"=>0,
    "\x8f\xe7\xb1"=>0,
    "\x8f\xe7\xb2"=>0,
    "\x8f\xe7\xb3"=>0,
    "\x8f\xe7\xb4"=>0,
    "\x8f\xe7\xb5"=>0,
    "\x8f\xe7\xb6"=>0,
    "\x8f\xe7\xb7"=>0,
    "\x8f\xe7\xb8"=>0,
    "\x8f\xe7\xb9"=>0,
    "\x8f\xe7\xba"=>0,
    "\x8f\xe7\xbb"=>0,
    "\x8f\xe7\xbc"=>0,
    "\x8f\xe7\xbd"=>0,
    "\x8f\xe7\xbe"=>0,
    "\x8f\xe7\xbf"=>0,
    "\x8f\xe7\xc0"=>0,
    "\x8f\xe7\xc1"=>0,
    "\x8f\xe7\xc2"=>0,
    "\x8f\xe7\xc3"=>0,
    "\x8f\xe7\xc4"=>0,
    "\x8f\xe7\xc5"=>0,
    "\x8f\xe7\xc6"=>0,
    "\x8f\xe7\xc7"=>0,
    "\x8f\xe7\xc8"=>0,
    "\x8f\xe7\xc9"=>0,
    "\x8f\xe7\xca"=>0,
    "\x8f\xe7\xcb"=>0,
    "\x8f\xe7\xcc"=>0,
    "\x8f\xe7\xcd"=>0,
    "\x8f\xe7\xce"=>0,
    "\x8f\xe7\xcf"=>0,
    "\x8f\xe7\xd0"=>0,
    "\x8f\xe7\xd1"=>0,
    "\x8f\xe7\xd2"=>0,
    "\x8f\xe7\xd3"=>0,
    "\x8f\xe7\xd4"=>0,
    "\x8f\xe7\xd5"=>0,
    "\x8f\xe7\xd6"=>0,
    "\x8f\xe7\xd7"=>0,
    "\x8f\xe7\xd8"=>0,
    "\x8f\xe7\xd9"=>0,
    "\x8f\xe7\xda"=>0,
    "\x8f\xe7\xdb"=>0,
    "\x8f\xe7\xdc"=>0,
    "\x8f\xe7\xdd"=>0,
    "\x8f\xe7\xde"=>0,
    "\x8f\xe7\xdf"=>0,
    "\x8f\xe7\xe0"=>0,
    "\x8f\xe7\xe1"=>0,
    "\x8f\xe7\xe2"=>0,
    "\x8f\xe7\xe3"=>0,
    "\x8f\xe7\xe4"=>0,
    "\x8f\xe7\xe5"=>0,
    "\x8f\xe7\xe6"=>0,
    "\x8f\xe7\xe7"=>0,
    "\x8f\xe7\xe8"=>0,
    "\x8f\xe7\xe9"=>0,
    "\x8f\xe7\xea"=>0,
    "\x8f\xe7\xeb"=>0,
    "\x8f\xe7\xec"=>0,
    "\x8f\xe7\xed"=>0,
    "\x8f\xe7\xee"=>0,
    "\x8f\xe7\xef"=>0,
    "\x8f\xe7\xf0"=>0,
    "\x8f\xe7\xf1"=>0,
    "\x8f\xe7\xf2"=>0,
    "\x8f\xe7\xf3"=>0,
    "\x8f\xe7\xf4"=>0,
    "\x8f\xe7\xf5"=>0,
    "\x8f\xe7\xf6"=>0,
    "\x8f\xe7\xf7"=>0,
    "\x8f\xe7\xf8"=>0,
    "\x8f\xe7\xf9"=>0,
    "\x8f\xe7\xfa"=>0,
    "\x8f\xe7\xfb"=>0,
    "\x8f\xe7\xfc"=>0,
    "\x8f\xe7\xfd"=>0,
    "\x8f\xe7\xfe"=>0,
    "\x8f\xe8\xa1"=>0,
    "\x8f\xe8\xa2"=>0,
    "\x8f\xe8\xa3"=>0,
    "\x8f\xe8\xa4"=>0,
    "\x8f\xe8\xa5"=>0,
    "\x8f\xe8\xa6"=>0,
    "\x8f\xe8\xa7"=>0,
    "\x8f\xe8\xa8"=>0,
    "\x8f\xe8\xa9"=>0,
    "\x8f\xe8\xaa"=>0,
    "\x8f\xe8\xab"=>0,
    "\x8f\xe8\xac"=>0,
    "\x8f\xe8\xad"=>0,
    "\x8f\xe8\xae"=>0,
    "\x8f\xe8\xaf"=>0,
    "\x8f\xe8\xb0"=>0,
    "\x8f\xe8\xb1"=>0,
    "\x8f\xe8\xb2"=>0,
    "\x8f\xe8\xb3"=>0,
    "\x8f\xe8\xb4"=>0,
    "\x8f\xe8\xb5"=>0,
    "\x8f\xe8\xb6"=>0,
    "\x8f\xe8\xb7"=>0,
    "\x8f\xe8\xb8"=>0,
    "\x8f\xe8\xb9"=>0,
    "\x8f\xe8\xba"=>0,
    "\x8f\xe8\xbb"=>0,
    "\x8f\xe8\xbc"=>0,
    "\x8f\xe8\xbd"=>0,
    "\x8f\xe8\xbe"=>0,
    "\x8f\xe8\xbf"=>0,
    "\x8f\xe8\xc0"=>0,
    "\x8f\xe8\xc1"=>0,
    "\x8f\xe8\xc2"=>0,
    "\x8f\xe8\xc3"=>0,
    "\x8f\xe8\xc4"=>0,
    "\x8f\xe8\xc5"=>0,
    "\x8f\xe8\xc6"=>0,
    "\x8f\xe8\xc7"=>0,
    "\x8f\xe8\xc8"=>0,
    "\x8f\xe8\xc9"=>0,
    "\x8f\xe8\xca"=>0,
    "\x8f\xe8\xcb"=>0,
    "\x8f\xe8\xcc"=>0,
    "\x8f\xe8\xcd"=>0,
    "\x8f\xe8\xce"=>0,
    "\x8f\xe8\xcf"=>0,
    "\x8f\xe8\xd0"=>0,
    "\x8f\xe8\xd1"=>0,
    "\x8f\xe8\xd2"=>0,
    "\x8f\xe8\xd3"=>0,
    "\x8f\xe8\xd4"=>0,
    "\x8f\xe8\xd5"=>0,
    "\x8f\xe8\xd6"=>0,
    "\x8f\xe8\xd7"=>0,
    "\x8f\xe8\xd8"=>0,
    "\x8f\xe8\xd9"=>0,
    "\x8f\xe8\xda"=>0,
    "\x8f\xe8\xdb"=>0,
    "\x8f\xe8\xdc"=>0,
    "\x8f\xe8\xdd"=>0,
    "\x8f\xe8\xde"=>0,
    "\x8f\xe8\xdf"=>0,
    "\x8f\xe8\xe0"=>0,
    "\x8f\xe8\xe1"=>0,
    "\x8f\xe8\xe2"=>0,
    "\x8f\xe8\xe3"=>0,
    "\x8f\xe8\xe4"=>0,
    "\x8f\xe8\xe5"=>0,
    "\x8f\xe8\xe6"=>0,
    "\x8f\xe8\xe7"=>0,
    "\x8f\xe8\xe8"=>0,
    "\x8f\xe8\xe9"=>0,
    "\x8f\xe8\xea"=>0,
    "\x8f\xe8\xeb"=>0,
    "\x8f\xe8\xec"=>0,
    "\x8f\xe8\xed"=>0,
    "\x8f\xe8\xee"=>0,
    "\x8f\xe8\xef"=>0,
    "\x8f\xe8\xf0"=>0,
    "\x8f\xe8\xf1"=>0,
    "\x8f\xe8\xf2"=>0,
    "\x8f\xe8\xf3"=>0,
    "\x8f\xe8\xf4"=>0,
    "\x8f\xe8\xf5"=>0,
    "\x8f\xe8\xf6"=>0,
    "\x8f\xe8\xf7"=>0,
    "\x8f\xe8\xf8"=>0,
    "\x8f\xe8\xf9"=>0,
    "\x8f\xe8\xfa"=>0,
    "\x8f\xe8\xfb"=>0,
    "\x8f\xe8\xfc"=>0,
    "\x8f\xe8\xfd"=>0,
    "\x8f\xe8\xfe"=>0,
    "\x8f\xe9\xa1"=>0,
    "\x8f\xe9\xa2"=>0,
    "\x8f\xe9\xa3"=>0,
    "\x8f\xe9\xa4"=>0,
    "\x8f\xe9\xa5"=>0,
    "\x8f\xe9\xa6"=>0,
    "\x8f\xe9\xa7"=>0,
    "\x8f\xe9\xa8"=>0,
    "\x8f\xe9\xa9"=>0,
    "\x8f\xe9\xaa"=>0,
    "\x8f\xe9\xab"=>0,
    "\x8f\xe9\xac"=>0,
    "\x8f\xe9\xad"=>0,
    "\x8f\xe9\xae"=>0,
    "\x8f\xe9\xaf"=>0,
    "\x8f\xe9\xb0"=>0,
    "\x8f\xe9\xb1"=>0,
    "\x8f\xe9\xb2"=>0,
    "\x8f\xe9\xb3"=>0,
    "\x8f\xe9\xb4"=>0,
    "\x8f\xe9\xb5"=>0,
    "\x8f\xe9\xb6"=>0,
    "\x8f\xe9\xb7"=>0,
    "\x8f\xe9\xb8"=>0,
    "\x8f\xe9\xb9"=>0,
    "\x8f\xe9\xba"=>0,
    "\x8f\xe9\xbb"=>0,
    "\x8f\xe9\xbc"=>0,
    "\x8f\xe9\xbd"=>0,
    "\x8f\xe9\xbe"=>0,
    "\x8f\xe9\xbf"=>0,
    "\x8f\xe9\xc0"=>0,
    "\x8f\xe9\xc1"=>0,
    "\x8f\xe9\xc2"=>0,
    "\x8f\xe9\xc3"=>0,
    "\x8f\xe9\xc4"=>0,
    "\x8f\xe9\xc5"=>0,
    "\x8f\xe9\xc6"=>0,
    "\x8f\xe9\xc7"=>0,
    "\x8f\xe9\xc8"=>0,
    "\x8f\xe9\xc9"=>0,
    "\x8f\xe9\xca"=>0,
    "\x8f\xe9\xcb"=>0,
    "\x8f\xe9\xcc"=>0,
    "\x8f\xe9\xcd"=>0,
    "\x8f\xe9\xce"=>0,
    "\x8f\xe9\xcf"=>0,
    "\x8f\xe9\xd0"=>0,
    "\x8f\xe9\xd1"=>0,
    "\x8f\xe9\xd2"=>0,
    "\x8f\xe9\xd3"=>0,
    "\x8f\xe9\xd4"=>0,
    "\x8f\xe9\xd5"=>0,
    "\x8f\xe9\xd6"=>0,
    "\x8f\xe9\xd7"=>0,
    "\x8f\xe9\xd8"=>0,
    "\x8f\xe9\xd9"=>0,
    "\x8f\xe9\xda"=>0,
    "\x8f\xe9\xdb"=>0,
    "\x8f\xe9\xdc"=>0,
    "\x8f\xe9\xdd"=>0,
    "\x8f\xe9\xde"=>0,
    "\x8f\xe9\xdf"=>0,
    "\x8f\xe9\xe0"=>0,
    "\x8f\xe9\xe1"=>0,
    "\x8f\xe9\xe2"=>0,
    "\x8f\xe9\xe3"=>0,
    "\x8f\xe9\xe4"=>0,
    "\x8f\xe9\xe5"=>0,
    "\x8f\xe9\xe6"=>0,
    "\x8f\xe9\xe7"=>0,
    "\x8f\xe9\xe8"=>0,
    "\x8f\xe9\xe9"=>0,
    "\x8f\xe9\xea"=>0,
    "\x8f\xe9\xeb"=>0,
    "\x8f\xe9\xec"=>0,
    "\x8f\xe9\xed"=>0,
    "\x8f\xe9\xee"=>0,
    "\x8f\xe9\xef"=>0,
    "\x8f\xe9\xf0"=>0,
    "\x8f\xe9\xf1"=>0,
    "\x8f\xe9\xf2"=>0,
    "\x8f\xe9\xf3"=>0,
    "\x8f\xe9\xf4"=>0,
    "\x8f\xe9\xf5"=>0,
    "\x8f\xe9\xf6"=>0,
    "\x8f\xe9\xf7"=>0,
    "\x8f\xe9\xf8"=>0,
    "\x8f\xe9\xf9"=>0,
    "\x8f\xe9\xfa"=>0,
    "\x8f\xe9\xfb"=>0,
    "\x8f\xe9\xfc"=>0,
    "\x8f\xe9\xfd"=>0,
    "\x8f\xe9\xfe"=>0,
    "\x8f\xea\xa1"=>0,
    "\x8f\xea\xa2"=>0,
    "\x8f\xea\xa3"=>0,
    "\x8f\xea\xa4"=>0,
    "\x8f\xea\xa5"=>0,
    "\x8f\xea\xa6"=>0,
    "\x8f\xea\xa7"=>0,
    "\x8f\xea\xa8"=>0,
    "\x8f\xea\xa9"=>0,
    "\x8f\xea\xaa"=>0,
    "\x8f\xea\xab"=>0,
    "\x8f\xea\xac"=>0,
    "\x8f\xea\xad"=>0,
    "\x8f\xea\xae"=>0,
    "\x8f\xea\xaf"=>0,
    "\x8f\xea\xb0"=>0,
    "\x8f\xea\xb1"=>0,
    "\x8f\xea\xb2"=>0,
    "\x8f\xea\xb3"=>0,
    "\x8f\xea\xb4"=>0,
    "\x8f\xea\xb5"=>0,
    "\x8f\xea\xb6"=>0,
    "\x8f\xea\xb7"=>0,
    "\x8f\xea\xb8"=>0,
    "\x8f\xea\xb9"=>0,
    "\x8f\xea\xba"=>0,
    "\x8f\xea\xbb"=>0,
    "\x8f\xea\xbc"=>0,
    "\x8f\xea\xbd"=>0,
    "\x8f\xea\xbe"=>0,
    "\x8f\xea\xbf"=>0,
    "\x8f\xea\xc0"=>0,
    "\x8f\xea\xc1"=>0,
    "\x8f\xea\xc2"=>0,
    "\x8f\xea\xc3"=>0,
    "\x8f\xea\xc4"=>0,
    "\x8f\xea\xc5"=>0,
    "\x8f\xea\xc6"=>0,
    "\x8f\xea\xc7"=>0,
    "\x8f\xea\xc8"=>0,
    "\x8f\xea\xc9"=>0,
    "\x8f\xea\xca"=>0,
    "\x8f\xea\xcb"=>0,
    "\x8f\xea\xcc"=>0,
    "\x8f\xea\xcd"=>0,
    "\x8f\xea\xce"=>0,
    "\x8f\xea\xcf"=>0,
    "\x8f\xea\xd0"=>0,
    "\x8f\xea\xd1"=>0,
    "\x8f\xea\xd2"=>0,
    "\x8f\xea\xd3"=>0,
    "\x8f\xea\xd4"=>0,
    "\x8f\xea\xd5"=>0,
    "\x8f\xea\xd6"=>0,
    "\x8f\xea\xd7"=>0,
    "\x8f\xea\xd8"=>0,
    "\x8f\xea\xd9"=>0,
    "\x8f\xea\xda"=>0,
    "\x8f\xea\xdb"=>0,
    "\x8f\xea\xdc"=>0,
    "\x8f\xea\xdd"=>0,
    "\x8f\xea\xde"=>0,
    "\x8f\xea\xdf"=>0,
    "\x8f\xea\xe0"=>0,
    "\x8f\xea\xe1"=>0,
    "\x8f\xea\xe2"=>0,
    "\x8f\xea\xe3"=>0,
    "\x8f\xea\xe4"=>0,
    "\x8f\xea\xe5"=>0,
    "\x8f\xea\xe6"=>0,
    "\x8f\xea\xe7"=>0,
    "\x8f\xea\xe8"=>0,
    "\x8f\xea\xe9"=>0,
    "\x8f\xea\xea"=>0,
    "\x8f\xea\xeb"=>0,
    "\x8f\xea\xec"=>0,
    "\x8f\xea\xed"=>0,
    "\x8f\xea\xee"=>0,
    "\x8f\xea\xef"=>0,
    "\x8f\xea\xf0"=>0,
    "\x8f\xea\xf1"=>0,
    "\x8f\xea\xf2"=>0,
    "\x8f\xea\xf3"=>0,
    "\x8f\xea\xf4"=>0,
    "\x8f\xea\xf5"=>0,
    "\x8f\xea\xf6"=>0,
    "\x8f\xea\xf7"=>0,
    "\x8f\xea\xf8"=>0,
    "\x8f\xea\xf9"=>0,
    "\x8f\xea\xfa"=>0,
    "\x8f\xea\xfb"=>0,
    "\x8f\xea\xfc"=>0,
    "\x8f\xea\xfd"=>0,
    "\x8f\xea\xfe"=>0,
    "\x8f\xeb\xa1"=>0,
    "\x8f\xeb\xa2"=>0,
    "\x8f\xeb\xa3"=>0,
    "\x8f\xeb\xa4"=>0,
    "\x8f\xeb\xa5"=>0,
    "\x8f\xeb\xa6"=>0,
    "\x8f\xeb\xa7"=>0,
    "\x8f\xeb\xa8"=>0,
    "\x8f\xeb\xa9"=>0,
    "\x8f\xeb\xaa"=>0,
    "\x8f\xeb\xab"=>0,
    "\x8f\xeb\xac"=>0,
    "\x8f\xeb\xad"=>0,
    "\x8f\xeb\xae"=>0,
    "\x8f\xeb\xaf"=>0,
    "\x8f\xeb\xb0"=>0,
    "\x8f\xeb\xb1"=>0,
    "\x8f\xeb\xb2"=>0,
    "\x8f\xeb\xb3"=>0,
    "\x8f\xeb\xb4"=>0,
    "\x8f\xeb\xb5"=>0,
    "\x8f\xeb\xb6"=>0,
    "\x8f\xeb\xb7"=>0,
    "\x8f\xeb\xb8"=>0,
    "\x8f\xeb\xb9"=>0,
    "\x8f\xeb\xba"=>0,
    "\x8f\xeb\xbb"=>0,
    "\x8f\xeb\xbc"=>0,
    "\x8f\xeb\xbd"=>0,
    "\x8f\xeb\xbe"=>0,
    "\x8f\xeb\xbf"=>0,
    "\x8f\xeb\xc0"=>0,
    "\x8f\xeb\xc1"=>0,
    "\x8f\xeb\xc2"=>0,
    "\x8f\xeb\xc3"=>0,
    "\x8f\xeb\xc4"=>0,
    "\x8f\xeb\xc5"=>0,
    "\x8f\xeb\xc6"=>0,
    "\x8f\xeb\xc7"=>0,
    "\x8f\xeb\xc8"=>0,
    "\x8f\xeb\xc9"=>0,
    "\x8f\xeb\xca"=>0,
    "\x8f\xeb\xcb"=>0,
    "\x8f\xeb\xcc"=>0,
    "\x8f\xeb\xcd"=>0,
    "\x8f\xeb\xce"=>0,
    "\x8f\xeb\xcf"=>0,
    "\x8f\xeb\xd0"=>0,
    "\x8f\xeb\xd1"=>0,
    "\x8f\xeb\xd2"=>0,
    "\x8f\xeb\xd3"=>0,
    "\x8f\xeb\xd4"=>0,
    "\x8f\xeb\xd5"=>0,
    "\x8f\xeb\xd6"=>0,
    "\x8f\xeb\xd7"=>0,
    "\x8f\xeb\xd8"=>0,
    "\x8f\xeb\xd9"=>0,
    "\x8f\xeb\xda"=>0,
    "\x8f\xeb\xdb"=>0,
    "\x8f\xeb\xdc"=>0,
    "\x8f\xeb\xdd"=>0,
    "\x8f\xeb\xde"=>0,
    "\x8f\xeb\xdf"=>0,
    "\x8f\xeb\xe0"=>0,
    "\x8f\xeb\xe1"=>0,
    "\x8f\xeb\xe2"=>0,
    "\x8f\xeb\xe3"=>0,
    "\x8f\xeb\xe4"=>0,
    "\x8f\xeb\xe5"=>0,
    "\x8f\xeb\xe6"=>0,
    "\x8f\xeb\xe7"=>0,
    "\x8f\xeb\xe8"=>0,
    "\x8f\xeb\xe9"=>0,
    "\x8f\xeb\xea"=>0,
    "\x8f\xeb\xeb"=>0,
    "\x8f\xeb\xec"=>0,
    "\x8f\xeb\xed"=>0,
    "\x8f\xeb\xee"=>0,
    "\x8f\xeb\xef"=>0,
    "\x8f\xeb\xf0"=>0,
    "\x8f\xeb\xf1"=>0,
    "\x8f\xeb\xf2"=>0,
    "\x8f\xeb\xf3"=>0,
    "\x8f\xeb\xf4"=>0,
    "\x8f\xeb\xf5"=>0,
    "\x8f\xeb\xf6"=>0,
    "\x8f\xeb\xf7"=>0,
    "\x8f\xeb\xf8"=>0,
    "\x8f\xeb\xf9"=>0,
    "\x8f\xeb\xfa"=>0,
    "\x8f\xeb\xfb"=>0,
    "\x8f\xeb\xfc"=>0,
    "\x8f\xeb\xfd"=>0,
    "\x8f\xeb\xfe"=>0,
    "\x8f\xec\xa1"=>0,
    "\x8f\xec\xa2"=>0,
    "\x8f\xec\xa3"=>0,
    "\x8f\xec\xa4"=>0,
    "\x8f\xec\xa5"=>0,
    "\x8f\xec\xa6"=>0,
    "\x8f\xec\xa7"=>0,
    "\x8f\xec\xa8"=>0,
    "\x8f\xec\xa9"=>0,
    "\x8f\xec\xaa"=>0,
    "\x8f\xec\xab"=>0,
    "\x8f\xec\xac"=>0,
    "\x8f\xec\xad"=>0,
    "\x8f\xec\xae"=>0,
    "\x8f\xec\xaf"=>0,
    "\x8f\xec\xb0"=>0,
    "\x8f\xec\xb1"=>0,
    "\x8f\xec\xb2"=>0,
    "\x8f\xec\xb3"=>0,
    "\x8f\xec\xb4"=>0,
    "\x8f\xec\xb5"=>0,
    "\x8f\xec\xb6"=>0,
    "\x8f\xec\xb7"=>0,
    "\x8f\xec\xb8"=>0,
    "\x8f\xec\xb9"=>0,
    "\x8f\xec\xba"=>0,
    "\x8f\xec\xbb"=>0,
    "\x8f\xec\xbc"=>0,
    "\x8f\xec\xbd"=>0,
    "\x8f\xec\xbe"=>0,
    "\x8f\xec\xbf"=>0,
    "\x8f\xec\xc0"=>0,
    "\x8f\xec\xc1"=>0,
    "\x8f\xec\xc2"=>0,
    "\x8f\xec\xc3"=>0,
    "\x8f\xec\xc4"=>0,
    "\x8f\xec\xc5"=>0,
    "\x8f\xec\xc6"=>0,
    "\x8f\xec\xc7"=>0,
    "\x8f\xec\xc8"=>0,
    "\x8f\xec\xc9"=>0,
    "\x8f\xec\xca"=>0,
    "\x8f\xec\xcb"=>0,
    "\x8f\xec\xcc"=>0,
    "\x8f\xec\xcd"=>0,
    "\x8f\xec\xce"=>0,
    "\x8f\xec\xcf"=>0,
    "\x8f\xec\xd0"=>0,
    "\x8f\xec\xd1"=>0,
    "\x8f\xec\xd2"=>0,
    "\x8f\xec\xd3"=>0,
    "\x8f\xec\xd4"=>0,
    "\x8f\xec\xd5"=>0,
    "\x8f\xec\xd6"=>0,
    "\x8f\xec\xd7"=>0,
    "\x8f\xec\xd8"=>0,
    "\x8f\xec\xd9"=>0,
    "\x8f\xec\xda"=>0,
    "\x8f\xec\xdb"=>0,
    "\x8f\xec\xdc"=>0,
    "\x8f\xec\xdd"=>0,
    "\x8f\xec\xde"=>0,
    "\x8f\xec\xdf"=>0,
    "\x8f\xec\xe0"=>0,
    "\x8f\xec\xe1"=>0,
    "\x8f\xec\xe2"=>0,
    "\x8f\xec\xe3"=>0,
    "\x8f\xec\xe4"=>0,
    "\x8f\xec\xe5"=>0,
    "\x8f\xec\xe6"=>0,
    "\x8f\xec\xe7"=>0,
    "\x8f\xec\xe8"=>0,
    "\x8f\xec\xe9"=>0,
    "\x8f\xec\xea"=>0,
    "\x8f\xec\xeb"=>0,
    "\x8f\xec\xec"=>0,
    "\x8f\xec\xed"=>0,
    "\x8f\xec\xee"=>0,
    "\x8f\xec\xef"=>0,
    "\x8f\xec\xf0"=>0,
    "\x8f\xec\xf1"=>0,
    "\x8f\xec\xf2"=>0,
    "\x8f\xec\xf3"=>0,
    "\x8f\xec\xf4"=>0,
    "\x8f\xec\xf5"=>0,
    "\x8f\xec\xf6"=>0,
    "\x8f\xec\xf7"=>0,
    "\x8f\xec\xf8"=>0,
    "\x8f\xec\xf9"=>0,
    "\x8f\xec\xfa"=>0,
    "\x8f\xec\xfb"=>0,
    "\x8f\xec\xfc"=>0,
    "\x8f\xec\xfd"=>0,
    "\x8f\xec\xfe"=>0,
    "\x8f\xed\xa1"=>0,
    "\x8f\xed\xa2"=>0,
    "\x8f\xed\xa3"=>0,
    "\x8f\xed\xa4"=>0,
    "\x8f\xed\xa5"=>0,
    "\x8f\xed\xa6"=>0,
    "\x8f\xed\xa7"=>0,
    "\x8f\xed\xa8"=>0,
    "\x8f\xed\xa9"=>0,
    "\x8f\xed\xaa"=>0,
    "\x8f\xed\xab"=>0,
    "\x8f\xed\xac"=>0,
    "\x8f\xed\xad"=>0,
    "\x8f\xed\xae"=>0,
    "\x8f\xed\xaf"=>0,
    "\x8f\xed\xb0"=>0,
    "\x8f\xed\xb1"=>0,
    "\x8f\xed\xb2"=>0,
    "\x8f\xed\xb3"=>0,
    "\x8f\xed\xb4"=>0,
    "\x8f\xed\xb5"=>0,
    "\x8f\xed\xb6"=>0,
    "\x8f\xed\xb7"=>0,
    "\x8f\xed\xb8"=>0,
    "\x8f\xed\xb9"=>0,
    "\x8f\xed\xba"=>0,
    "\x8f\xed\xbb"=>0,
    "\x8f\xed\xbc"=>0,
    "\x8f\xed\xbd"=>0,
    "\x8f\xed\xbe"=>0,
    "\x8f\xed\xbf"=>0,
    "\x8f\xed\xc0"=>0,
    "\x8f\xed\xc1"=>0,
    "\x8f\xed\xc2"=>0,
    "\x8f\xed\xc3"=>0,
    "\x8f\xed\xc4"=>0,
    "\x8f\xed\xc5"=>0,
    "\x8f\xed\xc6"=>0,
    "\x8f\xed\xc7"=>0,
    "\x8f\xed\xc8"=>0,
    "\x8f\xed\xc9"=>0,
    "\x8f\xed\xca"=>0,
    "\x8f\xed\xcb"=>0,
    "\x8f\xed\xcc"=>0,
    "\x8f\xed\xcd"=>0,
    "\x8f\xed\xce"=>0,
    "\x8f\xed\xcf"=>0,
    "\x8f\xed\xd0"=>0,
    "\x8f\xed\xd1"=>0,
    "\x8f\xed\xd2"=>0,
    "\x8f\xed\xd3"=>0,
    "\x8f\xed\xd4"=>0,
    "\x8f\xed\xd5"=>0,
    "\x8f\xed\xd6"=>0,
    "\x8f\xed\xd7"=>0,
    "\x8f\xed\xd8"=>0,
    "\x8f\xed\xd9"=>0,
    "\x8f\xed\xda"=>0,
    "\x8f\xed\xdb"=>0,
    "\x8f\xed\xdc"=>0,
    "\x8f\xed\xdd"=>0,
    "\x8f\xed\xde"=>0,
    "\x8f\xed\xdf"=>0,
    "\x8f\xed\xe0"=>0,
    "\x8f\xed\xe1"=>0,
    "\x8f\xed\xe2"=>0,
    "\x8f\xed\xe3"=>0,
  }

  UCS_CP51932_MAP = {
    0x0100=>"",
    0x0101=>"",
    0x0102=>"",
    0x0103=>"",
    0x0104=>"",
    0x0105=>"",
    0x0106=>"",
    0x0107=>"",
    0x0108=>"",
    0x0109=>"",
    0x010a=>"",
    0x010b=>"",
    0x010c=>"",
    0x010d=>"",
    0x010e=>"",
    0x010f=>"",
    0x0110=>"",
    0x0111=>"",
    0x0112=>"",
    0x0113=>"",
    0x0116=>"",
    0x0117=>"",
    0x0118=>"",
    0x0119=>"",
    0x011a=>"",
    0x011b=>"",
    0x011c=>"",
    0x011d=>"",
    0x011e=>"",
    0x011f=>"",
    0x0120=>"",
    0x0121=>"",
    0x0122=>"",
    0x0124=>"",
    0x0125=>"",
    0x0126=>"",
    0x0127=>"",
    0x0128=>"",
    0x0129=>"",
    0x012a=>"",
    0x012b=>"",
    0x012e=>"",
    0x012f=>"",
    0x0130=>"",
    0x0131=>"",
    0x0132=>"",
    0x0133=>"",
    0x0134=>"",
    0x0135=>"",
    0x0136=>"",
    0x0137=>"",
    0x0138=>"",
    0x0139=>"",
    0x013a=>"",
    0x013b=>"",
    0x013c=>"",
    0x013d=>"",
    0x013e=>"",
    0x013f=>"",
    0x0140=>"",
    0x0141=>"",
    0x0142=>"",
    0x0143=>"",
    0x0144=>"",
    0x0145=>"",
    0x0146=>"",
    0x0147=>"",
    0x0148=>"",
    0x0149=>"",
    0x014a=>"",
    0x014b=>"",
    0x014c=>"",
    0x014d=>"",
    0x0150=>"",
    0x0151=>"",
    0x0152=>"",
    0x0153=>"",
    0x0154=>"",
    0x0155=>"",
    0x0156=>"",
    0x0157=>"",
    0x0158=>"",
    0x0159=>"",
    0x015a=>"",
    0x015b=>"",
    0x015c=>"",
    0x015d=>"",
    0x015e=>"",
    0x015f=>"",
    0x0160=>"",
    0x0161=>"",
    0x0162=>"",
    0x0163=>"",
    0x0164=>"",
    0x0165=>"",
    0x0166=>"",
    0x0167=>"",
    0x0168=>"",
    0x0169=>"",
    0x016a=>"",
    0x016b=>"",
    0x016c=>"",
    0x016d=>"",
    0x016e=>"",
    0x016f=>"",
    0x0170=>"",
    0x0171=>"",
    0x0172=>"",
    0x0173=>"",
    0x0174=>"",
    0x0175=>"",
    0x0176=>"",
    0x0177=>"",
    0x0178=>"",
    0x0179=>"",
    0x017a=>"",
    0x017b=>"",
    0x017c=>"",
    0x017d=>"",
    0x017e=>"",
    0x01cd=>"",
    0x01ce=>"",
    0x01cf=>"",
    0x01d0=>"",
    0x01d1=>"",
    0x01d2=>"",
    0x01d3=>"",
    0x01d4=>"",
    0x01d5=>"",
    0x01d6=>"",
    0x01d7=>"",
    0x01d8=>"",
    0x01d9=>"",
    0x01da=>"",
    0x01db=>"",
    0x01dc=>"",
    0x01f5=>"",
    0x02c7=>"",
    0x02d8=>"",
    0x02d9=>"",
    0x02da=>"",
    0x02db=>"",
    0x02dd=>"",
    0x0384=>"",
    0x0385=>"",
    0x0386=>"",
    0x0388=>"",
    0x0389=>"",
    0x038a=>"",
    0x038c=>"",
    0x038e=>"",
    0x038f=>"",
    0x0390=>"",
    0x03aa=>"",
    0x03ab=>"",
    0x03ac=>"",
    0x03ad=>"",
    0x03ae=>"",
    0x03af=>"",
    0x03b0=>"",
    0x03c2=>"",
    0x03ca=>"",
    0x03cb=>"",
    0x03cc=>"",
    0x03cd=>"",
    0x03ce=>"",
    0x0402=>"",
    0x0403=>"",
    0x0404=>"",
    0x0405=>"",
    0x0406=>"",
    0x0407=>"",
    0x0408=>"",
    0x0409=>"",
    0x040a=>"",
    0x040b=>"",
    0x040c=>"",
    0x040e=>"",
    0x040f=>"",
    0x0452=>"",
    0x0453=>"",
    0x0454=>"",
    0x0455=>"",
    0x0456=>"",
    0x0457=>"",
    0x0458=>"",
    0x0459=>"",
    0x045a=>"",
    0x045b=>"",
    0x045c=>"",
    0x045e=>"",
    0x045f=>"",
    0x2016=>"",
    0x2116=>"\xad\xe2",
    0x2121=>"\xad\xe4",
    0x2122=>"",
    0x2160=>"\xad\xb5",
    0x2161=>"\xad\xb6",
    0x2162=>"\xad\xb7",
    0x2163=>"\xad\xb8",
    0x2164=>"\xad\xb9",
    0x2165=>"\xad\xba",
    0x2166=>"\xad\xbb",
    0x2167=>"\xad\xbc",
    0x2168=>"\xad\xbd",
    0x2169=>"\xad\xbe",
    0x2170=>"\xfc\xf1",
    0x2171=>"\xfc\xf2",
    0x2172=>"\xfc\xf3",
    0x2173=>"\xfc\xf4",
    0x2174=>"\xfc\xf5",
    0x2175=>"\xfc\xf6",
    0x2176=>"\xfc\xf7",
    0x2177=>"\xfc\xf8",
    0x2178=>"\xfc\xf9",
    0x2179=>"\xfc\xfa",
    0x2211=>"\xad\xf4",
    0x2212=>"",
    0x221f=>"\xad\xf8",
    0x2225=>"\xa1\xc2",
    0x222e=>"\xad\xf3",
    0x22bf=>"\xad\xf9",
    0x2460=>"\xad\xa1",
    0x2461=>"\xad\xa2",
    0x2462=>"\xad\xa3",
    0x2463=>"\xad\xa4",
    0x2464=>"\xad\xa5",
    0x2465=>"\xad\xa6",
    0x2466=>"\xad\xa7",
    0x2467=>"\xad\xa8",
    0x2468=>"\xad\xa9",
    0x2469=>"\xad\xaa",
    0x246a=>"\xad\xab",
    0x246b=>"\xad\xac",
    0x246c=>"\xad\xad",
    0x246d=>"\xad\xae",
    0x246e=>"\xad\xaf",
    0x246f=>"\xad\xb0",
    0x2470=>"\xad\xb1",
    0x2471=>"\xad\xb2",
    0x2472=>"\xad\xb3",
    0x2473=>"\xad\xb4",
    0x301c=>"",
    0x301d=>"\xad\xe0",
    0x301f=>"\xad\xe1",
    0x3094=>"\xa5\xf4",
    0x3231=>"\xad\xea",
    0x3232=>"\xad\xeb",
    0x3239=>"\xad\xec",
    0x32a4=>"\xad\xe5",
    0x32a5=>"\xad\xe6",
    0x32a6=>"\xad\xe7",
    0x32a7=>"\xad\xe8",
    0x32a8=>"\xad\xe9",
    0x3303=>"\xad\xc6",
    0x330d=>"\xad\xca",
    0x3314=>"\xad\xc1",
    0x3318=>"\xad\xc4",
    0x3322=>"\xad\xc2",
    0x3323=>"\xad\xcc",
    0x3326=>"\xad\xcb",
    0x3327=>"\xad\xc5",
    0x332b=>"\xad\xcd",
    0x3336=>"\xad\xc7",
    0x333b=>"\xad\xcf",
    0x3349=>"\xad\xc0",
    0x334a=>"\xad\xce",
    0x334d=>"\xad\xc3",
    0x3351=>"\xad\xc8",
    0x3357=>"\xad\xc9",
    0x337b=>"\xad\xdf",
    0x337c=>"\xad\xef",
    0x337d=>"\xad\xee",
    0x337e=>"\xad\xed",
    0x338e=>"\xad\xd3",
    0x338f=>"\xad\xd4",
    0x339c=>"\xad\xd0",
    0x339d=>"\xad\xd1",
    0x339e=>"\xad\xd2",
    0x33a1=>"\xad\xd6",
    0x33c4=>"\xad\xd5",
    0x33cd=>"\xad\xe3",
    0x4e02=>"",
    0x4e04=>"",
    0x4e05=>"",
    0x4e0c=>"",
    0x4e12=>"",
    0x4e1f=>"",
    0x4e23=>"",
    0x4e24=>"",
    0x4e28=>"\xf9\xad",
    0x4e2b=>"",
    0x4e2e=>"",
    0x4e2f=>"",
    0x4e30=>"",
    0x4e35=>"",
    0x4e40=>"",
    0x4e41=>"",
    0x4e44=>"",
    0x4e47=>"",
    0x4e51=>"",
    0x4e5a=>"",
    0x4e5c=>"",
    0x4e63=>"",
    0x4e68=>"",
    0x4e69=>"",
    0x4e74=>"",
    0x4e75=>"",
    0x4e79=>"",
    0x4e7f=>"",
    0x4e8d=>"",
    0x4e96=>"",
    0x4e97=>"",
    0x4e9d=>"",
    0x4eaf=>"",
    0x4eb9=>"",
    0x4ec3=>"",
    0x4ed0=>"",
    0x4eda=>"",
    0x4edb=>"",
    0x4ee0=>"",
    0x4ee1=>"\xf9\xae",
    0x4ee2=>"",
    0x4ee8=>"",
    0x4eef=>"",
    0x4ef1=>"",
    0x4ef3=>"",
    0x4ef5=>"",
    0x4efc=>"\xf9\xaf",
    0x4efd=>"",
    0x4efe=>"",
    0x4eff=>"",
    0x4f00=>"\xf9\xb0",
    0x4f02=>"",
    0x4f03=>"\xf9\xb1",
    0x4f08=>"",
    0x4f0b=>"",
    0x4f0c=>"",
    0x4f12=>"",
    0x4f15=>"",
    0x4f16=>"",
    0x4f17=>"",
    0x4f19=>"",
    0x4f2e=>"",
    0x4f31=>"",
    0x4f33=>"",
    0x4f35=>"",
    0x4f37=>"",
    0x4f39=>"\xf9\xb2",
    0x4f3b=>"",
    0x4f3e=>"",
    0x4f40=>"",
    0x4f42=>"",
    0x4f48=>"",
    0x4f49=>"",
    0x4f4b=>"",
    0x4f4c=>"",
    0x4f52=>"",
    0x4f54=>"",
    0x4f56=>"\xf9\xb3",
    0x4f58=>"",
    0x4f5f=>"",
    0x4f60=>"",
    0x4f63=>"",
    0x4f6a=>"",
    0x4f6c=>"",
    0x4f6e=>"",
    0x4f71=>"",
    0x4f77=>"",
    0x4f78=>"",
    0x4f79=>"",
    0x4f7a=>"",
    0x4f7d=>"",
    0x4f7e=>"",
    0x4f81=>"",
    0x4f82=>"",
    0x4f84=>"",
    0x4f85=>"",
    0x4f89=>"",
    0x4f8a=>"\xf9\xb5",
    0x4f8c=>"",
    0x4f8e=>"",
    0x4f90=>"",
    0x4f92=>"\xf9\xb4",
    0x4f93=>"",
    0x4f94=>"\xf9\xb7",
    0x4f97=>"",
    0x4f99=>"",
    0x4f9a=>"\xf9\xb6",
    0x4f9e=>"",
    0x4f9f=>"",
    0x4fb2=>"",
    0x4fb7=>"",
    0x4fb9=>"",
    0x4fbb=>"",
    0x4fbc=>"",
    0x4fbd=>"",
    0x4fbe=>"",
    0x4fc0=>"",
    0x4fc1=>"",
    0x4fc5=>"",
    0x4fc6=>"",
    0x4fc8=>"",
    0x4fc9=>"\xf9\xa6",
    0x4fcb=>"",
    0x4fcc=>"",
    0x4fcd=>"\xf9\xb8",
    0x4fcf=>"",
    0x4fd2=>"",
    0x4fdc=>"",
    0x4fe0=>"",
    0x4fe2=>"",
    0x4ff0=>"",
    0x4ff2=>"",
    0x4ffc=>"",
    0x4ffd=>"",
    0x4fff=>"\xf9\xbb",
    0x5000=>"",
    0x5001=>"",
    0x5004=>"",
    0x5007=>"",
    0x500a=>"",
    0x500c=>"",
    0x500e=>"",
    0x5010=>"",
    0x5013=>"",
    0x5017=>"",
    0x5018=>"",
    0x501b=>"",
    0x501c=>"",
    0x501d=>"",
    0x501e=>"\xf9\xbc",
    0x5022=>"\xf9\xba",
    0x5027=>"",
    0x502e=>"",
    0x5030=>"",
    0x5032=>"",
    0x5033=>"",
    0x5035=>"",
    0x503b=>"",
    0x5040=>"\xf9\xb9",
    0x5041=>"",
    0x5042=>"\xf9\xbf",
    0x5045=>"",
    0x5046=>"\xf9\xbd",
    0x504a=>"",
    0x504c=>"",
    0x504e=>"",
    0x5051=>"",
    0x5052=>"",
    0x5053=>"",
    0x5057=>"",
    0x5059=>"",
    0x505f=>"",
    0x5060=>"",
    0x5062=>"",
    0x5063=>"",
    0x5066=>"",
    0x5067=>"",
    0x506a=>"",
    0x506d=>"",
    0x5070=>"\xf9\xbe",
    0x5071=>"",
    0x5081=>"",
    0x5083=>"",
    0x5084=>"",
    0x5086=>"",
    0x508a=>"",
    0x508e=>"",
    0x508f=>"",
    0x5090=>"",
    0x5092=>"",
    0x5093=>"",
    0x5094=>"\xf9\xc0",
    0x5096=>"",
    0x509b=>"",
    0x509c=>"",
    0x509e=>"",
    0x509f=>"",
    0x50a0=>"",
    0x50a1=>"",
    0x50a2=>"",
    0x50aa=>"",
    0x50af=>"",
    0x50b0=>"",
    0x50b9=>"",
    0x50ba=>"",
    0x50bd=>"",
    0x50c0=>"",
    0x50c3=>"",
    0x50c4=>"",
    0x50c7=>"",
    0x50cc=>"",
    0x50ce=>"",
    0x50d0=>"",
    0x50d3=>"",
    0x50d4=>"",
    0x50d8=>"\xf9\xc2",
    0x50dc=>"",
    0x50dd=>"",
    0x50df=>"",
    0x50e2=>"",
    0x50e4=>"",
    0x50e6=>"",
    0x50e8=>"",
    0x50e9=>"",
    0x50ef=>"",
    0x50f1=>"",
    0x50f2=>"",
    0x50f4=>"\xf9\xc1",
    0x50f6=>"",
    0x50fa=>"",
    0x50fe=>"",
    0x5103=>"",
    0x5106=>"",
    0x5107=>"",
    0x5108=>"",
    0x510b=>"",
    0x510c=>"",
    0x510d=>"",
    0x510e=>"",
    0x5110=>"",
    0x5117=>"",
    0x5119=>"",
    0x511b=>"",
    0x511c=>"",
    0x511d=>"",
    0x511e=>"",
    0x5123=>"",
    0x5127=>"",
    0x5128=>"",
    0x512c=>"",
    0x512d=>"",
    0x512f=>"",
    0x5131=>"",
    0x5133=>"",
    0x5134=>"",
    0x5135=>"",
    0x5138=>"",
    0x5139=>"",
    0x5142=>"",
    0x514a=>"\xf9\xc3",
    0x514f=>"",
    0x5153=>"",
    0x5155=>"",
    0x5157=>"",
    0x5158=>"",
    0x515f=>"",
    0x5164=>"\xf9\xc4",
    0x5166=>"",
    0x517e=>"",
    0x5183=>"",
    0x5184=>"",
    0x518b=>"",
    0x518e=>"",
    0x5198=>"",
    0x519d=>"\xf9\xc5",
    0x51a1=>"",
    0x51a3=>"",
    0x51ad=>"",
    0x51b8=>"",
    0x51ba=>"",
    0x51bc=>"",
    0x51be=>"\xf9\xc6",
    0x51bf=>"",
    0x51c2=>"",
    0x51c8=>"",
    0x51cf=>"",
    0x51d1=>"",
    0x51d2=>"",
    0x51d3=>"",
    0x51d5=>"",
    0x51d8=>"",
    0x51de=>"",
    0x51e2=>"",
    0x51e5=>"",
    0x51ec=>"\xf9\xc7",
    0x51ee=>"",
    0x51f2=>"",
    0x51f3=>"",
    0x51f4=>"",
    0x51f7=>"",
    0x5201=>"",
    0x5202=>"",
    0x5205=>"",
    0x5212=>"",
    0x5213=>"",
    0x5215=>"\xf9\xc8",
    0x5216=>"",
    0x5218=>"",
    0x5222=>"",
    0x5228=>"",
    0x5231=>"",
    0x5232=>"",
    0x5235=>"",
    0x523c=>"",
    0x5245=>"",
    0x5249=>"",
    0x5255=>"",
    0x5257=>"",
    0x5258=>"",
    0x525a=>"",
    0x525c=>"",
    0x525f=>"",
    0x5260=>"",
    0x5261=>"",
    0x5266=>"",
    0x526e=>"",
    0x5277=>"",
    0x5278=>"",
    0x5279=>"",
    0x5280=>"",
    0x5282=>"",
    0x5285=>"",
    0x528a=>"",
    0x528c=>"",
    0x5293=>"",
    0x5295=>"",
    0x5296=>"",
    0x5297=>"",
    0x5298=>"",
    0x529a=>"",
    0x529c=>"\xf9\xc9",
    0x52a4=>"",
    0x52a5=>"",
    0x52a6=>"\xf9\xca",
    0x52a7=>"",
    0x52af=>"\xfb\xbc",
    0x52b0=>"",
    0x52b6=>"",
    0x52b7=>"",
    0x52b8=>"",
    0x52ba=>"",
    0x52bb=>"",
    0x52bd=>"",
    0x52c0=>"\xf9\xcb",
    0x52c4=>"",
    0x52c6=>"",
    0x52c8=>"",
    0x52cc=>"",
    0x52cf=>"",
    0x52d1=>"",
    0x52d4=>"",
    0x52d6=>"",
    0x52db=>"\xf9\xcc",
    0x52dc=>"",
    0x52e1=>"",
    0x52e5=>"",
    0x52e8=>"",
    0x52e9=>"",
    0x52ea=>"",
    0x52ec=>"",
    0x52f0=>"",
    0x52f1=>"",
    0x52f4=>"",
    0x52f6=>"",
    0x52f7=>"",
    0x5300=>"\xf9\xcd",
    0x5303=>"",
    0x5307=>"\xf9\xce",
    0x530a=>"",
    0x530b=>"",
    0x530c=>"",
    0x5311=>"",
    0x5313=>"",
    0x5318=>"",
    0x531b=>"",
    0x531c=>"",
    0x531e=>"",
    0x531f=>"",
    0x5324=>"\xf9\xcf",
    0x5325=>"",
    0x5327=>"",
    0x5328=>"",
    0x5329=>"",
    0x532b=>"",
    0x532c=>"",
    0x532d=>"",
    0x5330=>"",
    0x5332=>"",
    0x5335=>"",
    0x533c=>"",
    0x533d=>"",
    0x533e=>"",
    0x5342=>"",
    0x534b=>"",
    0x534c=>"",
    0x5359=>"",
    0x535b=>"",
    0x5361=>"",
    0x5363=>"",
    0x5365=>"",
    0x536c=>"",
    0x536d=>"",
    0x5372=>"\xf9\xd0",
    0x5379=>"",
    0x537e=>"",
    0x5383=>"",
    0x5387=>"",
    0x5388=>"",
    0x538e=>"",
    0x5393=>"\xf9\xd1",
    0x5394=>"",
    0x5399=>"",
    0x539d=>"",
    0x53a1=>"",
    0x53a4=>"",
    0x53aa=>"",
    0x53ab=>"",
    0x53af=>"",
    0x53b2=>"\xf9\xd2",
    0x53b4=>"",
    0x53b5=>"",
    0x53b7=>"",
    0x53b8=>"",
    0x53ba=>"",
    0x53bd=>"",
    0x53c0=>"",
    0x53c5=>"",
    0x53cf=>"",
    0x53d2=>"",
    0x53d3=>"",
    0x53d5=>"",
    0x53da=>"",
    0x53dd=>"\xf9\xd3",
    0x53de=>"",
    0x53e0=>"",
    0x53e6=>"",
    0x53e7=>"",
    0x53f5=>"",
    0x5402=>"",
    0x5413=>"",
    0x541a=>"",
    0x5421=>"",
    0x5427=>"",
    0x5428=>"",
    0x542a=>"",
    0x542f=>"",
    0x5431=>"",
    0x5434=>"",
    0x5435=>"",
    0x5443=>"",
    0x5444=>"",
    0x5447=>"",
    0x544d=>"",
    0x544f=>"",
    0x545e=>"",
    0x5462=>"",
    0x5464=>"",
    0x5466=>"",
    0x5467=>"",
    0x5469=>"",
    0x546b=>"",
    0x546d=>"",
    0x546e=>"",
    0x5474=>"",
    0x547f=>"",
    0x5481=>"",
    0x5483=>"",
    0x5485=>"",
    0x5488=>"",
    0x5489=>"",
    0x548a=>"\xf9\xd6",
    0x548d=>"",
    0x5491=>"",
    0x5495=>"",
    0x5496=>"",
    0x549c=>"\xf9\xd5",
    0x549f=>"",
    0x54a1=>"",
    0x54a6=>"",
    0x54a7=>"",
    0x54a9=>"\xf9\xd7",
    0x54aa=>"",
    0x54ad=>"",
    0x54ae=>"",
    0x54b1=>"",
    0x54b7=>"",
    0x54b9=>"",
    0x54ba=>"",
    0x54bb=>"",
    0x54bf=>"",
    0x54c6=>"",
    0x54ca=>"",
    0x54cd=>"",
    0x54ce=>"",
    0x54e0=>"",
    0x54ea=>"",
    0x54ec=>"",
    0x54ef=>"",
    0x54f6=>"",
    0x54fc=>"",
    0x54fe=>"",
    0x54ff=>"\xf9\xd8",
    0x5500=>"",
    0x5501=>"",
    0x5505=>"",
    0x5508=>"",
    0x5509=>"",
    0x550c=>"",
    0x550d=>"",
    0x550e=>"",
    0x5515=>"",
    0x552a=>"",
    0x552b=>"",
    0x5532=>"",
    0x5535=>"",
    0x5536=>"",
    0x553b=>"",
    0x553c=>"",
    0x553d=>"",
    0x5541=>"",
    0x5547=>"",
    0x5549=>"",
    0x554a=>"",
    0x554d=>"",
    0x5550=>"",
    0x5551=>"",
    0x5558=>"",
    0x555a=>"",
    0x555b=>"",
    0x555e=>"",
    0x5560=>"",
    0x5561=>"",
    0x5564=>"",
    0x5566=>"",
    0x557f=>"",
    0x5581=>"",
    0x5582=>"",
    0x5586=>"\xf9\xd9",
    0x5588=>"",
    0x558e=>"",
    0x558f=>"",
    0x5591=>"",
    0x5592=>"",
    0x5593=>"",
    0x5594=>"",
    0x5597=>"",
    0x55a3=>"",
    0x55a4=>"",
    0x55ad=>"",
    0x55b2=>"",
    0x55bf=>"",
    0x55c1=>"",
    0x55c3=>"",
    0x55c6=>"",
    0x55c9=>"",
    0x55cb=>"",
    0x55cc=>"",
    0x55ce=>"",
    0x55d1=>"",
    0x55d2=>"",
    0x55d3=>"",
    0x55d7=>"",
    0x55d8=>"",
    0x55db=>"",
    0x55de=>"",
    0x55e2=>"",
    0x55e9=>"",
    0x55f6=>"",
    0x55ff=>"",
    0x5605=>"",
    0x5608=>"",
    0x560a=>"",
    0x560d=>"",
    0x560e=>"",
    0x560f=>"",
    0x5610=>"",
    0x5611=>"",
    0x5612=>"",
    0x5619=>"",
    0x562c=>"",
    0x5630=>"",
    0x5633=>"",
    0x5635=>"",
    0x5637=>"",
    0x5639=>"",
    0x563b=>"",
    0x563c=>"",
    0x563d=>"",
    0x563f=>"",
    0x5640=>"",
    0x5641=>"",
    0x5643=>"",
    0x5644=>"",
    0x5646=>"",
    0x5649=>"",
    0x564b=>"",
    0x564d=>"",
    0x564f=>"",
    0x5654=>"",
    0x565e=>"",
    0x5660=>"",
    0x5661=>"",
    0x5662=>"",
    0x5663=>"",
    0x5666=>"",
    0x5669=>"",
    0x566d=>"",
    0x566f=>"",
    0x5671=>"",
    0x5672=>"",
    0x5675=>"",
    0x5684=>"",
    0x5685=>"",
    0x5688=>"",
    0x568b=>"",
    0x568c=>"",
    0x5695=>"",
    0x5699=>"",
    0x569a=>"",
    0x569d=>"",
    0x569e=>"",
    0x569f=>"",
    0x56a6=>"",
    0x56a7=>"",
    0x56a8=>"",
    0x56a9=>"",
    0x56ab=>"",
    0x56ac=>"",
    0x56ad=>"",
    0x56b1=>"",
    0x56b3=>"",
    0x56b7=>"",
    0x56be=>"",
    0x56c5=>"",
    0x56c9=>"",
    0x56ca=>"",
    0x56cb=>"",
    0x56cc=>"",
    0x56cd=>"",
    0x56cf=>"",
    0x56d0=>"",
    0x56d9=>"",
    0x56dc=>"",
    0x56dd=>"",
    0x56df=>"",
    0x56e1=>"",
    0x56e4=>"",
    0x56e5=>"",
    0x56e6=>"",
    0x56e7=>"",
    0x56e8=>"",
    0x56eb=>"",
    0x56ed=>"",
    0x56f1=>"",
    0x56f6=>"",
    0x56f7=>"",
    0x5701=>"",
    0x5702=>"",
    0x5707=>"",
    0x570a=>"",
    0x570c=>"",
    0x5711=>"",
    0x5715=>"",
    0x571a=>"",
    0x571b=>"",
    0x571d=>"",
    0x5720=>"",
    0x5722=>"",
    0x5723=>"",
    0x5724=>"",
    0x5725=>"",
    0x5729=>"",
    0x572a=>"",
    0x572c=>"",
    0x572e=>"",
    0x572f=>"",
    0x5733=>"",
    0x5734=>"",
    0x573d=>"",
    0x573e=>"",
    0x573f=>"",
    0x5745=>"",
    0x5746=>"",
    0x574c=>"",
    0x574d=>"",
    0x5752=>"",
    0x5759=>"\xf9\xda",
    0x5762=>"",
    0x5765=>"\xf9\xdb",
    0x5767=>"",
    0x5768=>"",
    0x576b=>"",
    0x576d=>"",
    0x576e=>"",
    0x576f=>"",
    0x5770=>"",
    0x5771=>"",
    0x5773=>"",
    0x5774=>"",
    0x5775=>"",
    0x5777=>"",
    0x5779=>"",
    0x577a=>"",
    0x577b=>"",
    0x577c=>"",
    0x577e=>"",
    0x5781=>"",
    0x5783=>"",
    0x578c=>"",
    0x5794=>"",
    0x5795=>"",
    0x5797=>"",
    0x5799=>"",
    0x579a=>"",
    0x579c=>"",
    0x579d=>"",
    0x579e=>"",
    0x579f=>"",
    0x57a1=>"",
    0x57a7=>"",
    0x57a8=>"",
    0x57a9=>"",
    0x57ac=>"\xf9\xdc",
    0x57b8=>"",
    0x57bd=>"",
    0x57c7=>"\xf9\xde",
    0x57c8=>"\xf9\xdd",
    0x57cc=>"",
    0x57cf=>"",
    0x57d5=>"",
    0x57dd=>"",
    0x57de=>"",
    0x57e1=>"",
    0x57e4=>"",
    0x57e6=>"",
    0x57e7=>"",
    0x57e9=>"",
    0x57ed=>"",
    0x57f0=>"",
    0x57f5=>"",
    0x57f6=>"",
    0x57f8=>"",
    0x57fd=>"",
    0x57fe=>"",
    0x57ff=>"",
    0x5803=>"",
    0x5804=>"",
    0x5808=>"",
    0x5809=>"",
    0x580c=>"",
    0x580d=>"",
    0x581b=>"",
    0x581e=>"",
    0x581f=>"",
    0x5820=>"",
    0x5826=>"",
    0x5827=>"",
    0x582d=>"",
    0x5832=>"",
    0x5839=>"",
    0x583f=>"",
    0x5849=>"",
    0x584c=>"",
    0x584d=>"",
    0x584f=>"",
    0x5850=>"",
    0x5855=>"",
    0x585f=>"",
    0x5861=>"",
    0x5864=>"",
    0x5867=>"",
    0x5868=>"",
    0x5878=>"",
    0x587c=>"",
    0x587f=>"",
    0x5880=>"",
    0x5881=>"",
    0x5887=>"",
    0x5888=>"",
    0x5889=>"",
    0x588a=>"",
    0x588c=>"",
    0x588d=>"",
    0x588f=>"",
    0x5890=>"",
    0x5894=>"",
    0x5896=>"",
    0x589d=>"",
    0x589e=>"\xf9\xe1",
    0x58a0=>"",
    0x58a1=>"",
    0x58a2=>"",
    0x58a6=>"",
    0x58a9=>"",
    0x58b1=>"",
    0x58b2=>"\xf9\xe2",
    0x58bc=>"",
    0x58c2=>"",
    0x58c4=>"",
    0x58c8=>"",
    0x58cd=>"",
    0x58ce=>"",
    0x58d0=>"",
    0x58d2=>"",
    0x58d4=>"",
    0x58d6=>"",
    0x58da=>"",
    0x58dd=>"",
    0x58e1=>"",
    0x58e2=>"",
    0x58e9=>"",
    0x58f3=>"",
    0x5905=>"",
    0x5906=>"",
    0x590b=>"\xf9\xe3",
    0x590c=>"",
    0x5912=>"",
    0x5913=>"",
    0x5914=>"",
    0x591d=>"",
    0x5921=>"",
    0x5923=>"",
    0x5924=>"",
    0x5928=>"",
    0x592f=>"",
    0x5930=>"",
    0x5933=>"",
    0x5935=>"",
    0x5936=>"",
    0x593f=>"",
    0x5943=>"",
    0x5946=>"",
    0x5952=>"",
    0x5953=>"\xf9\xe4",
    0x5959=>"",
    0x595b=>"\xf9\xe5",
    0x595d=>"\xf9\xe6",
    0x595e=>"",
    0x595f=>"",
    0x5961=>"",
    0x5963=>"\xf9\xe7",
    0x596b=>"",
    0x596d=>"",
    0x596f=>"",
    0x5972=>"",
    0x5975=>"",
    0x5976=>"",
    0x5979=>"",
    0x597b=>"",
    0x597c=>"",
    0x598b=>"",
    0x598c=>"",
    0x598e=>"",
    0x5992=>"",
    0x5995=>"",
    0x5997=>"",
    0x599f=>"",
    0x59a4=>"\xf9\xe8",
    0x59a7=>"",
    0x59ad=>"",
    0x59ae=>"",
    0x59af=>"",
    0x59b0=>"",
    0x59b3=>"",
    0x59b7=>"",
    0x59ba=>"\xf9\xe9",
    0x59bc=>"",
    0x59c1=>"",
    0x59c3=>"",
    0x59c4=>"",
    0x59c8=>"",
    0x59ca=>"",
    0x59cd=>"",
    0x59d2=>"",
    0x59dd=>"",
    0x59de=>"",
    0x59df=>"",
    0x59e3=>"",
    0x59e4=>"",
    0x59e7=>"",
    0x59ee=>"",
    0x59ef=>"",
    0x59f1=>"",
    0x59f2=>"",
    0x59f4=>"",
    0x59f7=>"",
    0x5a00=>"",
    0x5a04=>"",
    0x5a0c=>"",
    0x5a0d=>"",
    0x5a0e=>"",
    0x5a12=>"",
    0x5a13=>"",
    0x5a1e=>"",
    0x5a23=>"",
    0x5a24=>"",
    0x5a27=>"",
    0x5a28=>"",
    0x5a2a=>"",
    0x5a2d=>"",
    0x5a30=>"",
    0x5a44=>"",
    0x5a45=>"",
    0x5a47=>"",
    0x5a48=>"",
    0x5a4c=>"",
    0x5a50=>"",
    0x5a55=>"",
    0x5a5e=>"",
    0x5a63=>"",
    0x5a65=>"",
    0x5a67=>"",
    0x5a6d=>"",
    0x5a77=>"",
    0x5a7a=>"",
    0x5a7b=>"",
    0x5a7e=>"",
    0x5a8b=>"",
    0x5a90=>"",
    0x5a93=>"",
    0x5a96=>"",
    0x5a99=>"",
    0x5a9c=>"",
    0x5a9e=>"",
    0x5a9f=>"",
    0x5aa0=>"",
    0x5aa2=>"",
    0x5aa7=>"",
    0x5aac=>"",
    0x5ab1=>"",
    0x5ab2=>"",
    0x5ab3=>"",
    0x5ab5=>"",
    0x5ab8=>"",
    0x5aba=>"",
    0x5abb=>"",
    0x5abf=>"",
    0x5ac4=>"",
    0x5ac6=>"",
    0x5ac8=>"",
    0x5acf=>"",
    0x5ada=>"",
    0x5adc=>"",
    0x5ae0=>"",
    0x5ae5=>"",
    0x5aea=>"",
    0x5aee=>"",
    0x5af5=>"",
    0x5af6=>"",
    0x5afd=>"",
    0x5b00=>"",
    0x5b01=>"",
    0x5b08=>"",
    0x5b17=>"",
    0x5b19=>"",
    0x5b1b=>"",
    0x5b1d=>"",
    0x5b21=>"",
    0x5b25=>"",
    0x5b2d=>"",
    0x5b34=>"",
    0x5b38=>"",
    0x5b41=>"",
    0x5b4b=>"",
    0x5b4c=>"",
    0x5b52=>"",
    0x5b56=>"\xf9\xea",
    0x5b5e=>"",
    0x5b68=>"",
    0x5b6e=>"",
    0x5b6f=>"",
    0x5b7c=>"",
    0x5b7d=>"",
    0x5b7e=>"",
    0x5b7f=>"",
    0x5b81=>"",
    0x5b84=>"",
    0x5b86=>"",
    0x5b8a=>"",
    0x5b8e=>"",
    0x5b90=>"",
    0x5b91=>"",
    0x5b93=>"",
    0x5b94=>"",
    0x5b96=>"",
    0x5ba8=>"",
    0x5ba9=>"",
    0x5bac=>"",
    0x5bad=>"",
    0x5baf=>"",
    0x5bb1=>"",
    0x5bb2=>"",
    0x5bb7=>"",
    0x5bba=>"",
    0x5bbc=>"",
    0x5bc0=>"\xf9\xeb",
    0x5bc1=>"",
    0x5bcd=>"",
    0x5bcf=>"",
    0x5bd6=>"",
    0x5bd7=>"",
    0x5bd8=>"\xf9\xed",
    0x5bd9=>"",
    0x5bda=>"",
    0x5be0=>"",
    0x5bec=>"\xf9\xee",
    0x5bef=>"",
    0x5bf1=>"",
    0x5bf4=>"",
    0x5bfd=>"",
    0x5c0c=>"",
    0x5c17=>"",
    0x5c1e=>"\xf9\xef",
    0x5c1f=>"",
    0x5c23=>"",
    0x5c26=>"",
    0x5c29=>"",
    0x5c2b=>"",
    0x5c2c=>"",
    0x5c2e=>"",
    0x5c30=>"",
    0x5c32=>"",
    0x5c35=>"",
    0x5c36=>"",
    0x5c59=>"",
    0x5c5a=>"",
    0x5c5c=>"",
    0x5c62=>"",
    0x5c63=>"",
    0x5c67=>"",
    0x5c68=>"",
    0x5c69=>"",
    0x5c6d=>"",
    0x5c70=>"",
    0x5c74=>"",
    0x5c75=>"",
    0x5c7a=>"",
    0x5c7b=>"",
    0x5c7c=>"",
    0x5c7d=>"",
    0x5c87=>"",
    0x5c88=>"",
    0x5c8a=>"",
    0x5c8f=>"",
    0x5c92=>"",
    0x5c9d=>"",
    0x5c9f=>"",
    0x5ca0=>"",
    0x5ca2=>"",
    0x5ca3=>"",
    0x5ca6=>"\xf9\xf0",
    0x5caa=>"",
    0x5cb2=>"",
    0x5cb4=>"",
    0x5cb5=>"",
    0x5cba=>"\xf9\xf1",
    0x5cc9=>"",
    0x5ccb=>"",
    0x5cd2=>"",
    0x5cd7=>"",
    0x5cdd=>"",
    0x5cee=>"",
    0x5cf1=>"",
    0x5cf2=>"",
    0x5cf4=>"",
    0x5cf5=>"\xf9\xf2",
    0x5d01=>"",
    0x5d06=>"",
    0x5d0d=>"",
    0x5d12=>"",
    0x5d23=>"",
    0x5d24=>"",
    0x5d26=>"",
    0x5d27=>"\xf9\xf3",
    0x5d2b=>"",
    0x5d31=>"",
    0x5d34=>"",
    0x5d39=>"",
    0x5d3d=>"",
    0x5d3f=>"",
    0x5d42=>"\xf9\xf6",
    0x5d43=>"",
    0x5d46=>"",
    0x5d48=>"",
    0x5d4a=>"",
    0x5d51=>"",
    0x5d53=>"\xf9\xf4",
    0x5d55=>"",
    0x5d59=>"",
    0x5d5f=>"",
    0x5d60=>"",
    0x5d61=>"",
    0x5d62=>"",
    0x5d64=>"",
    0x5d6a=>"",
    0x5d6d=>"\xf9\xf7",
    0x5d70=>"",
    0x5d79=>"",
    0x5d7a=>"",
    0x5d7e=>"",
    0x5d7f=>"",
    0x5d81=>"",
    0x5d83=>"",
    0x5d88=>"",
    0x5d8a=>"",
    0x5d92=>"",
    0x5d93=>"",
    0x5d94=>"",
    0x5d95=>"",
    0x5d99=>"",
    0x5d9b=>"",
    0x5d9f=>"",
    0x5da0=>"",
    0x5da7=>"",
    0x5dab=>"",
    0x5db0=>"",
    0x5db2=>"",
    0x5db4=>"",
    0x5db8=>"\xf9\xf8",
    0x5db9=>"\xf9\xf9",
    0x5dc3=>"",
    0x5dc7=>"",
    0x5dcb=>"",
    0x5dce=>"",
    0x5dd0=>"\xf9\xfa",
    0x5dd8=>"",
    0x5dd9=>"",
    0x5de0=>"",
    0x5de4=>"",
    0x5de9=>"",
    0x5df8=>"",
    0x5df9=>"",
    0x5e00=>"",
    0x5e07=>"",
    0x5e0d=>"",
    0x5e12=>"",
    0x5e14=>"",
    0x5e15=>"",
    0x5e18=>"",
    0x5e1f=>"",
    0x5e20=>"",
    0x5e28=>"",
    0x5e2e=>"",
    0x5e32=>"",
    0x5e35=>"",
    0x5e3e=>"",
    0x5e49=>"",
    0x5e4b=>"",
    0x5e50=>"",
    0x5e51=>"",
    0x5e56=>"",
    0x5e58=>"",
    0x5e5b=>"",
    0x5e5c=>"",
    0x5e5e=>"",
    0x5e68=>"",
    0x5e6a=>"",
    0x5e6b=>"",
    0x5e6c=>"",
    0x5e6d=>"",
    0x5e6e=>"",
    0x5e70=>"",
    0x5e80=>"",
    0x5e8b=>"",
    0x5e8e=>"",
    0x5ea2=>"",
    0x5ea4=>"",
    0x5ea5=>"",
    0x5ea8=>"",
    0x5eaa=>"",
    0x5eac=>"",
    0x5eb1=>"",
    0x5eb3=>"",
    0x5ebd=>"",
    0x5ebe=>"",
    0x5ebf=>"",
    0x5ec6=>"",
    0x5ecb=>"",
    0x5ecc=>"",
    0x5ece=>"",
    0x5ed1=>"",
    0x5ed2=>"",
    0x5ed4=>"",
    0x5ed5=>"",
    0x5edc=>"",
    0x5ede=>"",
    0x5ee5=>"",
    0x5eeb=>"",
    0x5f02=>"",
    0x5f06=>"",
    0x5f07=>"",
    0x5f08=>"",
    0x5f0e=>"",
    0x5f19=>"",
    0x5f1c=>"",
    0x5f1d=>"",
    0x5f21=>"\xf9\xfb",
    0x5f22=>"",
    0x5f23=>"",
    0x5f24=>"",
    0x5f28=>"",
    0x5f2b=>"",
    0x5f2c=>"",
    0x5f2e=>"",
    0x5f30=>"",
    0x5f34=>"\xf9\xfc",
    0x5f36=>"",
    0x5f3b=>"",
    0x5f3d=>"",
    0x5f3f=>"",
    0x5f40=>"",
    0x5f44=>"",
    0x5f45=>"\xf9\xac",
    0x5f47=>"",
    0x5f4d=>"",
    0x5f50=>"",
    0x5f54=>"",
    0x5f58=>"",
    0x5f5b=>"",
    0x5f60=>"",
    0x5f63=>"",
    0x5f64=>"",
    0x5f67=>"\xf9\xfd",
    0x5f6f=>"",
    0x5f72=>"",
    0x5f74=>"",
    0x5f75=>"",
    0x5f78=>"",
    0x5f7a=>"",
    0x5f7d=>"",
    0x5f7e=>"",
    0x5f89=>"",
    0x5f8d=>"",
    0x5f8f=>"",
    0x5f96=>"",
    0x5f9c=>"",
    0x5f9d=>"",
    0x5fa2=>"",
    0x5fa4=>"",
    0x5fa7=>"",
    0x5fab=>"",
    0x5fac=>"",
    0x5faf=>"",
    0x5fb0=>"",
    0x5fb1=>"",
    0x5fb7=>"\xf9\xfe",
    0x5fb8=>"",
    0x5fc4=>"",
    0x5fc7=>"",
    0x5fc8=>"",
    0x5fc9=>"",
    0x5fcb=>"",
    0x5fd0=>"",
    0x5fd1=>"",
    0x5fd2=>"",
    0x5fd3=>"",
    0x5fd4=>"",
    0x5fde=>"\xfa\xa1",
    0x5fe1=>"",
    0x5fe2=>"",
    0x5fe8=>"",
    0x5fe9=>"",
    0x5fea=>"",
    0x5fec=>"",
    0x5fed=>"",
    0x5fee=>"",
    0x5fef=>"",
    0x5ff2=>"",
    0x5ff3=>"",
    0x5ff6=>"",
    0x5ffa=>"",
    0x5ffc=>"",
    0x6007=>"",
    0x600a=>"",
    0x600d=>"",
    0x6013=>"",
    0x6014=>"",
    0x6017=>"",
    0x6018=>"",
    0x601a=>"",
    0x601f=>"",
    0x6024=>"",
    0x602d=>"",
    0x6033=>"",
    0x6035=>"",
    0x6040=>"",
    0x6047=>"",
    0x6048=>"",
    0x6049=>"",
    0x604c=>"",
    0x6051=>"",
    0x6054=>"",
    0x6056=>"",
    0x6057=>"",
    0x605d=>"\xfa\xa2",
    0x6061=>"",
    0x6067=>"",
    0x6071=>"",
    0x607e=>"",
    0x607f=>"",
    0x6082=>"",
    0x6085=>"\xfa\xa3",
    0x6086=>"",
    0x6088=>"",
    0x608a=>"\xfa\xa4",
    0x608e=>"",
    0x6091=>"",
    0x6093=>"",
    0x6095=>"",
    0x6098=>"",
    0x609d=>"",
    0x609e=>"",
    0x60a2=>"",
    0x60a4=>"",
    0x60a5=>"",
    0x60a8=>"",
    0x60b0=>"",
    0x60b1=>"",
    0x60b7=>"",
    0x60bb=>"",
    0x60be=>"",
    0x60c2=>"",
    0x60c4=>"",
    0x60c8=>"",
    0x60c9=>"",
    0x60ca=>"",
    0x60cb=>"",
    0x60ce=>"",
    0x60cf=>"",
    0x60d4=>"",
    0x60d5=>"\xfa\xa6",
    0x60d9=>"",
    0x60db=>"",
    0x60dd=>"",
    0x60de=>"\xfa\xa5",
    0x60e2=>"",
    0x60e5=>"",
    0x60f2=>"\xfa\xa8",
    0x60f5=>"",
    0x60f8=>"",
    0x60fc=>"",
    0x60fd=>"",
    0x6102=>"",
    0x6107=>"",
    0x610a=>"",
    0x610c=>"",
    0x6110=>"",
    0x6111=>"\xfa\xa9",
    0x6112=>"",
    0x6113=>"",
    0x6114=>"",
    0x6116=>"",
    0x6117=>"",
    0x6119=>"",
    0x611c=>"",
    0x611e=>"",
    0x6120=>"\xfa\xa7",
    0x6122=>"",
    0x612a=>"",
    0x612b=>"",
    0x6130=>"\xfa\xab",
    0x6131=>"",
    0x6135=>"",
    0x6136=>"",
    0x6137=>"\xfa\xaa",
    0x6139=>"",
    0x6141=>"",
    0x6145=>"",
    0x6146=>"",
    0x6149=>"",
    0x615e=>"",
    0x6160=>"",
    0x616c=>"",
    0x6172=>"",
    0x6178=>"",
    0x617b=>"",
    0x617c=>"",
    0x617f=>"",
    0x6180=>"",
    0x6181=>"",
    0x6183=>"",
    0x6184=>"",
    0x618b=>"",
    0x618d=>"",
    0x6192=>"",
    0x6193=>"",
    0x6197=>"",
    0x6198=>"\xfa\xac",
    0x619c=>"",
    0x619d=>"",
    0x619f=>"",
    0x61a0=>"",
    0x61a5=>"",
    0x61a8=>"",
    0x61aa=>"",
    0x61ad=>"",
    0x61b8=>"",
    0x61b9=>"",
    0x61bc=>"",
    0x61c0=>"",
    0x61c1=>"",
    0x61c2=>"",
    0x61ce=>"",
    0x61cf=>"",
    0x61d5=>"",
    0x61dc=>"",
    0x61dd=>"",
    0x61de=>"",
    0x61df=>"",
    0x61e1=>"",
    0x61e2=>"",
    0x61e5=>"",
    0x61e7=>"",
    0x61e9=>"",
    0x61ec=>"",
    0x61ed=>"",
    0x61ef=>"",
    0x6201=>"",
    0x6203=>"",
    0x6204=>"",
    0x6207=>"",
    0x6213=>"\xfa\xad",
    0x6215=>"",
    0x621c=>"",
    0x6220=>"",
    0x6222=>"",
    0x6223=>"",
    0x6227=>"",
    0x6229=>"",
    0x622b=>"",
    0x6239=>"",
    0x623d=>"",
    0x6242=>"",
    0x6243=>"",
    0x6244=>"",
    0x6246=>"",
    0x624c=>"",
    0x6250=>"",
    0x6251=>"",
    0x6252=>"",
    0x6254=>"",
    0x6256=>"",
    0x625a=>"",
    0x625c=>"",
    0x6264=>"",
    0x626d=>"",
    0x626f=>"",
    0x6273=>"",
    0x627a=>"",
    0x627d=>"",
    0x628d=>"",
    0x628e=>"",
    0x628f=>"",
    0x6290=>"",
    0x62a6=>"\xfa\xae",
    0x62a8=>"",
    0x62b3=>"",
    0x62b6=>"",
    0x62b7=>"",
    0x62ba=>"",
    0x62be=>"",
    0x62bf=>"",
    0x62c4=>"",
    0x62ce=>"",
    0x62d5=>"",
    0x62d6=>"",
    0x62da=>"",
    0x62ea=>"",
    0x62f2=>"",
    0x62f4=>"",
    0x62fc=>"",
    0x62fd=>"",
    0x6303=>"",
    0x6304=>"",
    0x630a=>"",
    0x630b=>"",
    0x630d=>"",
    0x6310=>"",
    0x6313=>"",
    0x6316=>"",
    0x6318=>"",
    0x6329=>"",
    0x632a=>"",
    0x632d=>"",
    0x6335=>"",
    0x6336=>"",
    0x6339=>"",
    0x633c=>"",
    0x6341=>"",
    0x6342=>"",
    0x6343=>"",
    0x6344=>"",
    0x6346=>"",
    0x634a=>"",
    0x634b=>"",
    0x634e=>"",
    0x6352=>"",
    0x6353=>"",
    0x6354=>"",
    0x6358=>"",
    0x635b=>"",
    0x6365=>"",
    0x6366=>"",
    0x636c=>"",
    0x636d=>"",
    0x6371=>"",
    0x6374=>"",
    0x6375=>"",
    0x6378=>"",
    0x637c=>"",
    0x637d=>"",
    0x637f=>"",
    0x6382=>"",
    0x6384=>"",
    0x6387=>"",
    0x638a=>"",
    0x6390=>"",
    0x6394=>"",
    0x6395=>"",
    0x6399=>"",
    0x639a=>"",
    0x639e=>"",
    0x63a4=>"",
    0x63a6=>"",
    0x63ad=>"",
    0x63ae=>"",
    0x63af=>"",
    0x63bd=>"",
    0x63c1=>"",
    0x63c5=>"",
    0x63c8=>"",
    0x63ce=>"",
    0x63d1=>"",
    0x63d3=>"",
    0x63d4=>"",
    0x63d5=>"",
    0x63dc=>"",
    0x63e0=>"",
    0x63e5=>"",
    0x63ea=>"",
    0x63ec=>"",
    0x63f2=>"",
    0x63f3=>"",
    0x63f5=>"\xfa\xaf",
    0x63f8=>"",
    0x63f9=>"",
    0x6409=>"",
    0x640a=>"",
    0x6410=>"",
    0x6412=>"",
    0x6414=>"",
    0x6418=>"",
    0x641e=>"",
    0x6420=>"",
    0x6422=>"",
    0x6424=>"",
    0x6425=>"",
    0x6429=>"",
    0x642a=>"",
    0x642f=>"",
    0x6430=>"",
    0x6435=>"",
    0x643d=>"",
    0x643f=>"",
    0x644b=>"",
    0x644f=>"",
    0x6451=>"",
    0x6452=>"",
    0x6453=>"",
    0x6454=>"",
    0x645a=>"",
    0x645b=>"",
    0x645c=>"",
    0x645d=>"",
    0x645f=>"",
    0x6460=>"\xfa\xb0",
    0x6461=>"",
    0x6463=>"",
    0x646d=>"",
    0x6473=>"",
    0x6474=>"",
    0x647b=>"",
    0x647d=>"",
    0x6485=>"",
    0x6487=>"",
    0x648f=>"",
    0x6490=>"",
    0x6491=>"",
    0x6498=>"",
    0x6499=>"",
    0x649b=>"",
    0x649d=>"\xfa\xb1",
    0x649f=>"",
    0x64a1=>"",
    0x64a3=>"",
    0x64a6=>"",
    0x64a8=>"",
    0x64ac=>"",
    0x64b3=>"",
    0x64bd=>"",
    0x64be=>"",
    0x64bf=>"",
    0x64c4=>"",
    0x64c9=>"",
    0x64ca=>"",
    0x64cb=>"",
    0x64cc=>"",
    0x64ce=>"\xfa\xb2",
    0x64d0=>"",
    0x64d1=>"",
    0x64d5=>"",
    0x64d7=>"",
    0x64e4=>"",
    0x64e5=>"",
    0x64e9=>"",
    0x64ea=>"",
    0x64ed=>"",
    0x64f0=>"",
    0x64f5=>"",
    0x64f7=>"",
    0x64fb=>"",
    0x64ff=>"",
    0x6501=>"",
    0x6504=>"",
    0x6508=>"",
    0x6509=>"",
    0x650a=>"",
    0x650f=>"",
    0x6513=>"",
    0x6514=>"",
    0x6516=>"",
    0x6519=>"",
    0x651b=>"",
    0x651e=>"",
    0x651f=>"",
    0x6522=>"",
    0x6526=>"",
    0x6529=>"",
    0x652e=>"",
    0x6531=>"",
    0x653a=>"",
    0x653c=>"",
    0x653d=>"",
    0x6543=>"",
    0x6547=>"",
    0x6549=>"",
    0x654e=>"\xfa\xb3",
    0x6550=>"",
    0x6552=>"",
    0x6554=>"",
    0x655f=>"",
    0x6560=>"",
    0x6567=>"",
    0x656b=>"",
    0x657a=>"",
    0x657d=>"",
    0x6581=>"",
    0x6585=>"",
    0x658a=>"",
    0x6592=>"",
    0x6595=>"",
    0x6598=>"",
    0x659d=>"",
    0x65a0=>"",
    0x65a3=>"",
    0x65a6=>"",
    0x65ae=>"",
    0x65b2=>"",
    0x65b3=>"",
    0x65b4=>"",
    0x65bf=>"",
    0x65c2=>"",
    0x65c8=>"",
    0x65c9=>"",
    0x65ce=>"",
    0x65d0=>"",
    0x65d4=>"",
    0x65d6=>"",
    0x65d8=>"",
    0x65df=>"",
    0x65f0=>"",
    0x65f2=>"",
    0x65f4=>"",
    0x65f5=>"",
    0x65f9=>"",
    0x65fe=>"",
    0x65ff=>"",
    0x6600=>"\xfa\xb4",
    0x6604=>"",
    0x6608=>"",
    0x6609=>"\xfa\xb7",
    0x660d=>"",
    0x6611=>"",
    0x6612=>"",
    0x6615=>"\xfa\xb5",
    0x6616=>"",
    0x661d=>"",
    0x661e=>"\xfa\xb9",
    0x6621=>"",
    0x6622=>"",
    0x6623=>"",
    0x6624=>"\xfa\xba",
    0x6626=>"",
    0x6629=>"",
    0x662a=>"",
    0x662b=>"",
    0x662c=>"",
    0x662e=>"\xfa\xb8",
    0x6630=>"",
    0x6631=>"\xf9\xa8",
    0x6633=>"",
    0x6637=>"",
    0x6639=>"",
    0x663b=>"\xfa\xb6",
    0x6640=>"",
    0x6645=>"",
    0x6646=>"",
    0x664a=>"",
    0x664c=>"",
    0x664e=>"",
    0x6651=>"",
    0x6657=>"\xfa\xbc",
    0x6658=>"",
    0x6659=>"\xfa\xbd",
    0x665b=>"",
    0x665c=>"",
    0x6660=>"",
    0x6661=>"",
    0x6665=>"\xfa\xbb",
    0x666a=>"",
    0x666b=>"",
    0x666c=>"",
    0x6673=>"\xfa\xbf",
    0x6675=>"",
    0x6677=>"",
    0x6678=>"",
    0x6679=>"",
    0x667b=>"",
    0x667c=>"",
    0x667e=>"",
    0x667f=>"",
    0x6680=>"",
    0x668b=>"",
    0x668c=>"",
    0x668d=>"",
    0x6690=>"",
    0x6692=>"",
    0x6699=>"\xfa\xc0",
    0x669a=>"",
    0x669b=>"",
    0x669c=>"",
    0x669f=>"",
    0x66a0=>"\xfa\xc1",
    0x66a4=>"",
    0x66ad=>"",
    0x66b1=>"",
    0x66b2=>"\xfa\xc2",
    0x66b5=>"",
    0x66bb=>"",
    0x66bf=>"\xfa\xc3",
    0x66c0=>"",
    0x66c2=>"",
    0x66c3=>"",
    0x66c8=>"",
    0x66cc=>"",
    0x66ce=>"",
    0x66cf=>"",
    0x66d4=>"",
    0x66db=>"",
    0x66df=>"",
    0x66e8=>"",
    0x66eb=>"",
    0x66ec=>"",
    0x66ee=>"",
    0x66fa=>"\xfa\xc4",
    0x66fb=>"\xf9\xab",
    0x6705=>"",
    0x6707=>"",
    0x670e=>"\xfa\xc5",
    0x6713=>"",
    0x6719=>"",
    0x671c=>"",
    0x6720=>"",
    0x6722=>"",
    0x6733=>"",
    0x673e=>"",
    0x6745=>"",
    0x6747=>"",
    0x6748=>"",
    0x674c=>"",
    0x6754=>"",
    0x6755=>"",
    0x675d=>"",
    0x6766=>"\xfa\xc7",
    0x676c=>"",
    0x676e=>"",
    0x6774=>"",
    0x6776=>"",
    0x677b=>"",
    0x6781=>"",
    0x6784=>"",
    0x678e=>"",
    0x678f=>"",
    0x6791=>"",
    0x6793=>"",
    0x6796=>"",
    0x6798=>"",
    0x6799=>"",
    0x679b=>"",
    0x67b0=>"",
    0x67b1=>"",
    0x67b2=>"",
    0x67b5=>"",
    0x67bb=>"\xfa\xc8",
    0x67bc=>"",
    0x67bd=>"",
    0x67c0=>"\xfa\xca",
    0x67c2=>"",
    0x67c3=>"",
    0x67c5=>"",
    0x67c8=>"",
    0x67c9=>"",
    0x67d2=>"",
    0x67d7=>"",
    0x67d9=>"",
    0x67dc=>"",
    0x67e1=>"",
    0x67e6=>"",
    0x67f0=>"",
    0x67f2=>"",
    0x67f6=>"",
    0x67f7=>"",
    0x67f9=>"",
    0x6801=>"\xfa\xcb",
    0x6814=>"",
    0x6819=>"",
    0x681d=>"",
    0x681f=>"",
    0x6827=>"",
    0x6828=>"",
    0x682c=>"",
    0x682d=>"",
    0x682f=>"",
    0x6830=>"",
    0x6831=>"",
    0x6833=>"",
    0x683b=>"",
    0x683f=>"",
    0x6844=>"\xfa\xcc",
    0x6845=>"",
    0x684a=>"",
    0x684c=>"",
    0x6852=>"\xfa\xc9",
    0x6855=>"",
    0x6857=>"",
    0x6858=>"",
    0x685b=>"",
    0x686b=>"",
    0x686e=>"",
    0x686f=>"",
    0x6870=>"",
    0x6871=>"",
    0x6872=>"",
    0x6875=>"",
    0x6879=>"",
    0x687a=>"",
    0x687b=>"",
    0x687c=>"",
    0x6882=>"",
    0x6884=>"",
    0x6886=>"",
    0x6888=>"",
    0x6896=>"",
    0x6898=>"",
    0x689a=>"",
    0x689c=>"",
    0x68a1=>"",
    0x68a3=>"",
    0x68a5=>"",
    0x68a9=>"",
    0x68aa=>"",
    0x68ae=>"",
    0x68b2=>"",
    0x68bb=>"",
    0x68c5=>"",
    0x68c8=>"\xf9\xa9",
    0x68cc=>"",
    0x68cf=>"\xfa\xcd",
    0x68d0=>"",
    0x68d1=>"",
    0x68d3=>"",
    0x68d6=>"",
    0x68d9=>"",
    0x68dc=>"",
    0x68dd=>"",
    0x68e5=>"",
    0x68e8=>"",
    0x68ea=>"",
    0x68eb=>"",
    0x68ec=>"",
    0x68ed=>"",
    0x68f0=>"",
    0x68f1=>"",
    0x68f5=>"",
    0x68f6=>"",
    0x68fb=>"",
    0x68fc=>"",
    0x68fd=>"",
    0x6906=>"",
    0x6909=>"",
    0x690a=>"",
    0x6910=>"",
    0x6911=>"",
    0x6913=>"",
    0x6916=>"",
    0x6917=>"",
    0x6931=>"",
    0x6933=>"",
    0x6935=>"",
    0x6938=>"",
    0x693b=>"",
    0x6942=>"",
    0x6945=>"",
    0x6949=>"",
    0x694e=>"",
    0x6957=>"",
    0x695b=>"",
    0x6963=>"",
    0x6964=>"",
    0x6965=>"",
    0x6966=>"",
    0x6968=>"\xfa\xcf",
    0x6969=>"",
    0x696c=>"",
    0x6970=>"",
    0x6971=>"",
    0x6972=>"",
    0x697a=>"",
    0x697b=>"",
    0x697f=>"",
    0x6980=>"",
    0x698d=>"",
    0x6992=>"",
    0x6996=>"",
    0x6998=>"\xfa\xd1",
    0x69a1=>"",
    0x69a5=>"",
    0x69a6=>"",
    0x69a8=>"",
    0x69ab=>"",
    0x69ad=>"",
    0x69af=>"",
    0x69b7=>"",
    0x69b8=>"",
    0x69ba=>"",
    0x69bc=>"",
    0x69c5=>"",
    0x69c8=>"",
    0x69d1=>"",
    0x69d6=>"",
    0x69d7=>"",
    0x69e2=>"\xfa\xd2",
    0x69e5=>"",
    0x69ee=>"",
    0x69ef=>"",
    0x69f1=>"",
    0x69f3=>"",
    0x69f5=>"",
    0x69fe=>"",
    0x6a00=>"",
    0x6a01=>"",
    0x6a03=>"",
    0x6a0f=>"",
    0x6a11=>"",
    0x6a15=>"",
    0x6a1a=>"",
    0x6a1d=>"",
    0x6a20=>"",
    0x6a24=>"",
    0x6a28=>"",
    0x6a30=>"\xfa\xd3",
    0x6a32=>"",
    0x6a34=>"",
    0x6a37=>"",
    0x6a3b=>"",
    0x6a3e=>"",
    0x6a3f=>"",
    0x6a45=>"",
    0x6a46=>"\xfa\xd5",
    0x6a49=>"",
    0x6a4a=>"",
    0x6a4e=>"",
    0x6a50=>"",
    0x6a51=>"",
    0x6a52=>"",
    0x6a55=>"",
    0x6a56=>"",
    0x6a5b=>"",
    0x6a64=>"",
    0x6a67=>"",
    0x6a6a=>"",
    0x6a6b=>"\xfa\xd4",
    0x6a71=>"",
    0x6a73=>"\xfa\xd6",
    0x6a7e=>"\xfa\xd7",
    0x6a81=>"",
    0x6a83=>"",
    0x6a86=>"",
    0x6a87=>"",
    0x6a89=>"",
    0x6a8b=>"",
    0x6a91=>"",
    0x6a9b=>"",
    0x6a9d=>"",
    0x6a9e=>"",
    0x6a9f=>"",
    0x6aa5=>"",
    0x6aab=>"",
    0x6aaf=>"",
    0x6ab0=>"",
    0x6ab1=>"",
    0x6ab4=>"",
    0x6abd=>"",
    0x6abe=>"",
    0x6abf=>"",
    0x6ac6=>"",
    0x6ac8=>"",
    0x6ac9=>"",
    0x6acc=>"",
    0x6ad0=>"",
    0x6ad4=>"",
    0x6ad5=>"",
    0x6ad6=>"",
    0x6adc=>"",
    0x6add=>"",
    0x6ae2=>"\xfa\xd8",
    0x6ae4=>"\xfa\xd9",
    0x6ae7=>"",
    0x6aec=>"",
    0x6af0=>"",
    0x6af1=>"",
    0x6af2=>"",
    0x6afc=>"",
    0x6afd=>"",
    0x6b02=>"",
    0x6b03=>"",
    0x6b06=>"",
    0x6b07=>"",
    0x6b09=>"",
    0x6b0f=>"",
    0x6b10=>"",
    0x6b11=>"",
    0x6b17=>"",
    0x6b1b=>"",
    0x6b1e=>"",
    0x6b24=>"",
    0x6b28=>"",
    0x6b2b=>"",
    0x6b2c=>"",
    0x6b2f=>"",
    0x6b35=>"",
    0x6b36=>"",
    0x6b3b=>"",
    0x6b3f=>"",
    0x6b46=>"",
    0x6b4a=>"",
    0x6b4d=>"",
    0x6b52=>"",
    0x6b56=>"",
    0x6b58=>"",
    0x6b5d=>"",
    0x6b60=>"",
    0x6b67=>"",
    0x6b6b=>"",
    0x6b6e=>"",
    0x6b70=>"",
    0x6b75=>"",
    0x6b7d=>"",
    0x6b7e=>"",
    0x6b82=>"",
    0x6b85=>"",
    0x6b97=>"",
    0x6b9b=>"",
    0x6b9f=>"",
    0x6ba0=>"",
    0x6ba2=>"",
    0x6ba3=>"",
    0x6ba8=>"",
    0x6ba9=>"",
    0x6bac=>"",
    0x6bad=>"",
    0x6bae=>"",
    0x6bb0=>"",
    0x6bb8=>"",
    0x6bb9=>"",
    0x6bbd=>"",
    0x6bbe=>"",
    0x6bc3=>"",
    0x6bc4=>"",
    0x6bc9=>"",
    0x6bcc=>"",
    0x6bd6=>"\xfa\xda",
    0x6bda=>"",
    0x6be1=>"",
    0x6be3=>"",
    0x6be6=>"",
    0x6be7=>"",
    0x6bee=>"",
    0x6bf1=>"",
    0x6bf7=>"",
    0x6bf9=>"",
    0x6bff=>"",
    0x6c02=>"",
    0x6c04=>"",
    0x6c05=>"",
    0x6c09=>"",
    0x6c0d=>"",
    0x6c0e=>"",
    0x6c10=>"",
    0x6c12=>"",
    0x6c19=>"",
    0x6c1f=>"",
    0x6c26=>"",
    0x6c27=>"",
    0x6c28=>"",
    0x6c2c=>"",
    0x6c2e=>"",
    0x6c33=>"",
    0x6c35=>"",
    0x6c36=>"",
    0x6c3a=>"",
    0x6c3b=>"",
    0x6c3f=>"\xfa\xdb",
    0x6c4a=>"",
    0x6c4b=>"",
    0x6c4d=>"",
    0x6c4f=>"",
    0x6c52=>"",
    0x6c54=>"",
    0x6c59=>"",
    0x6c5b=>"",
    0x6c5c=>"\xfa\xdc",
    0x6c67=>"",
    0x6c6b=>"",
    0x6c6d=>"",
    0x6c6f=>"\xfa\xde",
    0x6c74=>"",
    0x6c76=>"",
    0x6c78=>"",
    0x6c79=>"",
    0x6c7b=>"",
    0x6c85=>"",
    0x6c86=>"\xfa\xdd",
    0x6c87=>"",
    0x6c89=>"",
    0x6c94=>"",
    0x6c95=>"",
    0x6c97=>"",
    0x6c98=>"",
    0x6c9c=>"",
    0x6c9f=>"",
    0x6cb0=>"",
    0x6cb2=>"",
    0x6cb4=>"",
    0x6cc2=>"",
    0x6cc6=>"",
    0x6ccd=>"",
    0x6ccf=>"",
    0x6cd0=>"",
    0x6cd1=>"",
    0x6cd2=>"",
    0x6cd4=>"",
    0x6cd6=>"",
    0x6cda=>"\xfa\xdf",
    0x6cdc=>"",
    0x6ce0=>"",
    0x6ce7=>"",
    0x6ce9=>"",
    0x6ceb=>"",
    0x6cec=>"",
    0x6cee=>"",
    0x6cf2=>"",
    0x6cf4=>"",
    0x6d04=>"\xfa\xe0",
    0x6d07=>"",
    0x6d0a=>"",
    0x6d0e=>"",
    0x6d0f=>"",
    0x6d11=>"",
    0x6d13=>"",
    0x6d1a=>"",
    0x6d26=>"",
    0x6d27=>"",
    0x6d28=>"",
    0x6d2e=>"",
    0x6d2f=>"",
    0x6d31=>"",
    0x6d39=>"",
    0x6d3c=>"",
    0x6d3f=>"",
    0x6d57=>"",
    0x6d5e=>"",
    0x6d5f=>"",
    0x6d61=>"",
    0x6d65=>"",
    0x6d67=>"",
    0x6d6f=>"\xfa\xe2",
    0x6d70=>"",
    0x6d7c=>"",
    0x6d82=>"",
    0x6d87=>"\xfa\xe1",
    0x6d91=>"",
    0x6d92=>"",
    0x6d94=>"",
    0x6d96=>"\xfa\xe3",
    0x6d97=>"",
    0x6d98=>"",
    0x6daa=>"",
    0x6dac=>"\xfa\xe4",
    0x6db4=>"",
    0x6db7=>"",
    0x6db9=>"",
    0x6dbd=>"",
    0x6dbf=>"",
    0x6dc4=>"",
    0x6dc8=>"",
    0x6dca=>"",
    0x6dce=>"",
    0x6dcf=>"\xfa\xe5",
    0x6dd6=>"",
    0x6ddb=>"",
    0x6ddd=>"",
    0x6ddf=>"",
    0x6de0=>"",
    0x6de2=>"",
    0x6de5=>"",
    0x6de9=>"",
    0x6def=>"",
    0x6df0=>"",
    0x6df2=>"\xfa\xe7",
    0x6df4=>"",
    0x6df6=>"",
    0x6df8=>"\xfa\xe6",
    0x6dfc=>"\xfa\xe8",
    0x6e00=>"",
    0x6e04=>"",
    0x6e1e=>"",
    0x6e22=>"",
    0x6e27=>"\xfa\xeb",
    0x6e32=>"",
    0x6e36=>"",
    0x6e39=>"\xfa\xe9",
    0x6e3b=>"",
    0x6e3c=>"\xfa\xec",
    0x6e44=>"",
    0x6e45=>"",
    0x6e48=>"",
    0x6e49=>"",
    0x6e4b=>"",
    0x6e4f=>"",
    0x6e51=>"",
    0x6e52=>"",
    0x6e53=>"",
    0x6e54=>"",
    0x6e57=>"",
    0x6e5c=>"\xfa\xea",
    0x6e5d=>"",
    0x6e5e=>"",
    0x6e62=>"",
    0x6e63=>"",
    0x6e68=>"",
    0x6e73=>"",
    0x6e7b=>"",
    0x6e7d=>"",
    0x6e8d=>"",
    0x6e93=>"",
    0x6e99=>"",
    0x6ea0=>"",
    0x6ea7=>"",
    0x6ead=>"",
    0x6eae=>"",
    0x6eb1=>"",
    0x6eb3=>"",
    0x6ebb=>"",
    0x6ebf=>"\xfa\xed",
    0x6ec0=>"",
    0x6ec1=>"",
    0x6ec3=>"",
    0x6ec7=>"",
    0x6ec8=>"",
    0x6eca=>"",
    0x6ecd=>"",
    0x6ece=>"",
    0x6ecf=>"",
    0x6eeb=>"",
    0x6eed=>"",
    0x6eee=>"",
    0x6ef9=>"",
    0x6efb=>"",
    0x6efd=>"",
    0x6f04=>"",
    0x6f08=>"",
    0x6f0a=>"",
    0x6f0c=>"",
    0x6f0d=>"",
    0x6f16=>"",
    0x6f18=>"",
    0x6f1a=>"",
    0x6f1b=>"",
    0x6f26=>"",
    0x6f29=>"",
    0x6f2a=>"",
    0x6f2d=>"",
    0x6f2f=>"",
    0x6f30=>"",
    0x6f33=>"",
    0x6f36=>"",
    0x6f3b=>"",
    0x6f3c=>"",
    0x6f4f=>"",
    0x6f51=>"",
    0x6f52=>"",
    0x6f53=>"",
    0x6f57=>"",
    0x6f59=>"",
    0x6f5a=>"",
    0x6f5d=>"",
    0x6f5e=>"",
    0x6f61=>"",
    0x6f62=>"",
    0x6f68=>"",
    0x6f6c=>"",
    0x6f7d=>"",
    0x6f7e=>"",
    0x6f83=>"",
    0x6f87=>"",
    0x6f88=>"\xfa\xee",
    0x6f8b=>"",
    0x6f8c=>"",
    0x6f8d=>"",
    0x6f90=>"",
    0x6f92=>"",
    0x6f93=>"",
    0x6f94=>"",
    0x6f96=>"",
    0x6f9a=>"",
    0x6f9f=>"",
    0x6fa0=>"",
    0x6fa5=>"",
    0x6fa6=>"",
    0x6fa7=>"",
    0x6fa8=>"",
    0x6fae=>"",
    0x6faf=>"",
    0x6fb0=>"",
    0x6fb5=>"\xfa\xef",
    0x6fb6=>"",
    0x6fbc=>"",
    0x6fc5=>"",
    0x6fc7=>"",
    0x6fc8=>"",
    0x6fca=>"",
    0x6fda=>"",
    0x6fde=>"",
    0x6fe8=>"",
    0x6fe9=>"",
    0x6ff0=>"",
    0x6ff5=>"\xfa\xf0",
    0x6ff9=>"",
    0x6ffc=>"",
    0x6ffd=>"",
    0x7000=>"",
    0x7005=>"\xfa\xf1",
    0x7006=>"",
    0x7007=>"\xfa\xf2",
    0x700d=>"",
    0x7017=>"",
    0x7020=>"",
    0x7023=>"",
    0x7028=>"\xfa\xf3",
    0x702f=>"",
    0x7034=>"",
    0x7037=>"",
    0x7039=>"",
    0x703c=>"",
    0x7043=>"",
    0x7044=>"",
    0x7048=>"",
    0x7049=>"",
    0x704a=>"",
    0x704b=>"",
    0x704e=>"",
    0x7054=>"",
    0x7055=>"",
    0x705d=>"",
    0x705e=>"",
    0x7064=>"",
    0x7065=>"",
    0x706c=>"",
    0x706e=>"",
    0x7075=>"",
    0x7076=>"",
    0x707e=>"",
    0x7081=>"",
    0x7085=>"\xfa\xf4",
    0x7086=>"",
    0x7094=>"",
    0x7095=>"",
    0x7096=>"",
    0x7097=>"",
    0x7098=>"",
    0x709b=>"",
    0x70a4=>"",
    0x70ab=>"\xfa\xf5",
    0x70b0=>"",
    0x70b1=>"",
    0x70b4=>"",
    0x70b7=>"",
    0x70bb=>"\xf9\xa7",
    0x70ca=>"",
    0x70d1=>"",
    0x70d3=>"",
    0x70d4=>"",
    0x70d5=>"",
    0x70d6=>"",
    0x70d8=>"",
    0x70dc=>"",
    0x70e4=>"",
    0x70fa=>"",
    0x7103=>"",
    0x7104=>"\xfa\xf7",
    0x7105=>"",
    0x7106=>"",
    0x7107=>"",
    0x710b=>"",
    0x710c=>"",
    0x710f=>"\xfa\xf6",
    0x711e=>"",
    0x7120=>"",
    0x712b=>"",
    0x712d=>"",
    0x712f=>"",
    0x7130=>"",
    0x7131=>"",
    0x7138=>"",
    0x7141=>"",
    0x7145=>"",
    0x7146=>"\xfa\xf9",
    0x7147=>"\xfa\xfa",
    0x714a=>"",
    0x714b=>"",
    0x7150=>"",
    0x7152=>"",
    0x7157=>"",
    0x715a=>"",
    0x715c=>"\xfa\xf8",
    0x715e=>"",
    0x7160=>"",
    0x7168=>"",
    0x7179=>"",
    0x7180=>"",
    0x7185=>"",
    0x7187=>"",
    0x718c=>"",
    0x7192=>"",
    0x719a=>"",
    0x719b=>"",
    0x71a0=>"",
    0x71a2=>"",
    0x71af=>"",
    0x71b0=>"",
    0x71b2=>"",
    0x71b3=>"",
    0x71ba=>"",
    0x71bf=>"",
    0x71c0=>"",
    0x71c1=>"\xfa\xfc",
    0x71c4=>"",
    0x71cb=>"",
    0x71cc=>"",
    0x71d3=>"",
    0x71d6=>"",
    0x71d9=>"",
    0x71da=>"",
    0x71dc=>"",
    0x71f8=>"",
    0x71fe=>"\xfa\xfd",
    0x7200=>"",
    0x7207=>"",
    0x7208=>"",
    0x7209=>"",
    0x7213=>"",
    0x7217=>"",
    0x721a=>"",
    0x721d=>"",
    0x721f=>"",
    0x7224=>"",
    0x722b=>"",
    0x722f=>"",
    0x7234=>"",
    0x7238=>"",
    0x7239=>"",
    0x7241=>"",
    0x7242=>"",
    0x7243=>"",
    0x7245=>"",
    0x724e=>"",
    0x724f=>"",
    0x7250=>"",
    0x7253=>"",
    0x7255=>"",
    0x7256=>"",
    0x725a=>"",
    0x725c=>"",
    0x725e=>"",
    0x7260=>"",
    0x7263=>"",
    0x7268=>"",
    0x726b=>"",
    0x726e=>"",
    0x726f=>"",
    0x7271=>"",
    0x7277=>"",
    0x7278=>"",
    0x727b=>"",
    0x727c=>"",
    0x727f=>"",
    0x7284=>"",
    0x7289=>"",
    0x728d=>"",
    0x728e=>"",
    0x7293=>"",
    0x729b=>"",
    0x72a8=>"",
    0x72ad=>"",
    0x72ae=>"",
    0x72b1=>"\xfa\xfe",
    0x72b4=>"",
    0x72be=>"\xfb\xa1",
    0x72c1=>"",
    0x72c7=>"",
    0x72c9=>"",
    0x72cc=>"",
    0x72d5=>"",
    0x72d6=>"",
    0x72d8=>"",
    0x72df=>"",
    0x72e5=>"",
    0x72f3=>"",
    0x72f4=>"",
    0x72fa=>"",
    0x72fb=>"",
    0x72fe=>"",
    0x7302=>"",
    0x7304=>"",
    0x7305=>"",
    0x7307=>"",
    0x730b=>"",
    0x730d=>"",
    0x7312=>"",
    0x7313=>"",
    0x7318=>"",
    0x7319=>"",
    0x731e=>"",
    0x7322=>"",
    0x7324=>"\xfb\xa2",
    0x7327=>"",
    0x7328=>"",
    0x732c=>"",
    0x7331=>"",
    0x7332=>"",
    0x7335=>"",
    0x733a=>"",
    0x733b=>"",
    0x733d=>"",
    0x7343=>"",
    0x734d=>"",
    0x7350=>"",
    0x7352=>"",
    0x7356=>"",
    0x7358=>"",
    0x735d=>"",
    0x735e=>"",
    0x735f=>"",
    0x7360=>"",
    0x7366=>"",
    0x7367=>"",
    0x7369=>"",
    0x736b=>"",
    0x736c=>"",
    0x736e=>"",
    0x736f=>"",
    0x7371=>"",
    0x7377=>"\xfb\xa4",
    0x7379=>"",
    0x737c=>"",
    0x7380=>"",
    0x7381=>"",
    0x7383=>"",
    0x7385=>"",
    0x7386=>"",
    0x738e=>"",
    0x7390=>"",
    0x7393=>"",
    0x7395=>"",
    0x7397=>"",
    0x7398=>"",
    0x739c=>"",
    0x739e=>"",
    0x739f=>"",
    0x73a0=>"",
    0x73a2=>"",
    0x73a5=>"",
    0x73a6=>"",
    0x73aa=>"",
    0x73ab=>"",
    0x73ad=>"",
    0x73b5=>"",
    0x73b7=>"",
    0x73b9=>"",
    0x73bc=>"",
    0x73bd=>"\xfb\xa5",
    0x73bf=>"",
    0x73c5=>"",
    0x73c6=>"",
    0x73c9=>"\xfb\xa6",
    0x73cb=>"",
    0x73cc=>"",
    0x73cf=>"",
    0x73d2=>"\xfb\xa9",
    0x73d3=>"",
    0x73d6=>"\xfb\xa7",
    0x73d9=>"",
    0x73dd=>"",
    0x73e1=>"",
    0x73e3=>"\xfb\xa8",
    0x73e6=>"",
    0x73e7=>"",
    0x73e9=>"",
    0x73f4=>"",
    0x73f5=>"\xfb\xab",
    0x73f7=>"",
    0x73f9=>"",
    0x73fa=>"",
    0x73fb=>"",
    0x73fd=>"",
    0x73ff=>"",
    0x7400=>"",
    0x7401=>"",
    0x7404=>"",
    0x7407=>"\xfb\xaa",
    0x740a=>"",
    0x7411=>"",
    0x741a=>"",
    0x741b=>"",
    0x7424=>"",
    0x7426=>"\xfb\xac",
    0x7428=>"",
    0x7429=>"\xfb\xae",
    0x742a=>"\xfb\xad",
    0x742b=>"",
    0x742c=>"",
    0x742d=>"",
    0x742e=>"\xfb\xaf",
    0x742f=>"",
    0x7430=>"",
    0x7431=>"",
    0x7439=>"",
    0x7440=>"",
    0x7443=>"",
    0x7444=>"",
    0x7446=>"",
    0x7447=>"",
    0x744b=>"",
    0x744d=>"",
    0x7451=>"",
    0x7452=>"",
    0x7457=>"",
    0x745d=>"",
    0x7462=>"\xfb\xb0",
    0x7466=>"",
    0x7467=>"",
    0x7468=>"",
    0x746b=>"",
    0x746d=>"",
    0x746e=>"",
    0x7471=>"",
    0x7472=>"",
    0x7480=>"",
    0x7481=>"",
    0x7485=>"",
    0x7486=>"",
    0x7487=>"",
    0x7489=>"\xfb\xb1",
    0x748f=>"",
    0x7490=>"",
    0x7491=>"",
    0x7492=>"",
    0x7498=>"",
    0x7499=>"",
    0x749a=>"",
    0x749c=>"",
    0x749f=>"\xfb\xb2",
    0x74a0=>"",
    0x74a1=>"",
    0x74a3=>"",
    0x74a6=>"",
    0x74a8=>"",
    0x74a9=>"",
    0x74aa=>"",
    0x74ab=>"",
    0x74ae=>"",
    0x74af=>"",
    0x74b1=>"",
    0x74b2=>"",
    0x74b5=>"",
    0x74b9=>"",
    0x74bb=>"",
    0x74bf=>"",
    0x74c8=>"",
    0x74c9=>"",
    0x74cc=>"",
    0x74d0=>"",
    0x74d3=>"",
    0x74d8=>"",
    0x74da=>"",
    0x74db=>"",
    0x74de=>"",
    0x74df=>"",
    0x74e4=>"",
    0x74e8=>"",
    0x74ea=>"",
    0x74eb=>"",
    0x74ef=>"",
    0x74f4=>"",
    0x74fa=>"",
    0x74fb=>"",
    0x74fc=>"",
    0x74ff=>"",
    0x7501=>"\xfb\xb3",
    0x7506=>"",
    0x7512=>"",
    0x7516=>"",
    0x7517=>"",
    0x7520=>"",
    0x7521=>"",
    0x7524=>"",
    0x7527=>"",
    0x7529=>"",
    0x752a=>"",
    0x752f=>"\xf9\xec",
    0x7536=>"",
    0x7539=>"",
    0x753d=>"",
    0x753e=>"",
    0x753f=>"",
    0x7540=>"",
    0x7543=>"",
    0x7547=>"",
    0x7548=>"",
    0x754e=>"",
    0x7550=>"",
    0x7552=>"",
    0x7557=>"",
    0x755e=>"",
    0x755f=>"",
    0x7561=>"",
    0x756f=>"\xfb\xb4",
    0x7571=>"",
    0x7579=>"",
    0x757a=>"",
    0x757b=>"",
    0x757c=>"",
    0x757d=>"",
    0x757e=>"",
    0x7581=>"",
    0x7585=>"",
    0x7590=>"",
    0x7592=>"",
    0x7593=>"",
    0x7595=>"",
    0x7599=>"",
    0x759c=>"",
    0x75a2=>"",
    0x75a4=>"",
    0x75b4=>"",
    0x75ba=>"",
    0x75bf=>"",
    0x75c0=>"",
    0x75c1=>"",
    0x75c4=>"",
    0x75c6=>"",
    0x75cc=>"",
    0x75ce=>"",
    0x75cf=>"",
    0x75d7=>"",
    0x75dc=>"",
    0x75df=>"",
    0x75e0=>"",
    0x75e1=>"",
    0x75e4=>"",
    0x75e7=>"",
    0x75ec=>"",
    0x75ee=>"",
    0x75ef=>"",
    0x75f1=>"",
    0x75f9=>"",
    0x7600=>"",
    0x7602=>"",
    0x7603=>"",
    0x7604=>"",
    0x7607=>"",
    0x7608=>"",
    0x760a=>"",
    0x760c=>"",
    0x760f=>"",
    0x7612=>"",
    0x7613=>"",
    0x7615=>"",
    0x7616=>"",
    0x7619=>"",
    0x761b=>"",
    0x761c=>"",
    0x761d=>"",
    0x761e=>"",
    0x7623=>"",
    0x7625=>"",
    0x7626=>"",
    0x7629=>"",
    0x762d=>"",
    0x7632=>"",
    0x7633=>"",
    0x7635=>"",
    0x7638=>"",
    0x7639=>"",
    0x763a=>"",
    0x763c=>"",
    0x7640=>"",
    0x7641=>"",
    0x7643=>"",
    0x7644=>"",
    0x7645=>"",
    0x7649=>"",
    0x764a=>"",
    0x764b=>"",
    0x7655=>"",
    0x7659=>"",
    0x765f=>"",
    0x7664=>"",
    0x7665=>"",
    0x766d=>"",
    0x766e=>"",
    0x766f=>"",
    0x7671=>"",
    0x7674=>"",
    0x7681=>"",
    0x7682=>"\xfb\xb5",
    0x7685=>"",
    0x768c=>"",
    0x768d=>"",
    0x7695=>"",
    0x769b=>"\xfb\xb8",
    0x769c=>"\xfb\xb6",
    0x769d=>"",
    0x769e=>"\xfb\xb7",
    0x769f=>"",
    0x76a0=>"",
    0x76a2=>"",
    0x76a3=>"",
    0x76a4=>"",
    0x76a5=>"",
    0x76a6=>"\xfb\xb9",
    0x76a7=>"",
    0x76a8=>"",
    0x76aa=>"",
    0x76ad=>"",
    0x76bd=>"",
    0x76c1=>"",
    0x76c5=>"",
    0x76c9=>"",
    0x76cb=>"",
    0x76cc=>"",
    0x76ce=>"",
    0x76d4=>"",
    0x76d9=>"",
    0x76e0=>"",
    0x76e6=>"",
    0x76e8=>"",
    0x76ec=>"",
    0x76f0=>"",
    0x76f1=>"",
    0x76f6=>"",
    0x76f9=>"",
    0x76fc=>"",
    0x7700=>"",
    0x7706=>"",
    0x770a=>"",
    0x770e=>"",
    0x7712=>"",
    0x7714=>"",
    0x7715=>"",
    0x7717=>"",
    0x7719=>"",
    0x771a=>"",
    0x771c=>"",
    0x7722=>"",
    0x7728=>"",
    0x772d=>"",
    0x772e=>"",
    0x772f=>"",
    0x7734=>"",
    0x7735=>"",
    0x7736=>"",
    0x7739=>"",
    0x773d=>"",
    0x773e=>"",
    0x7742=>"",
    0x7745=>"",
    0x7746=>"\xfb\xbb",
    0x774a=>"",
    0x774d=>"",
    0x774e=>"",
    0x774f=>"",
    0x7752=>"",
    0x7756=>"",
    0x7757=>"",
    0x775c=>"",
    0x775e=>"",
    0x775f=>"",
    0x7760=>"",
    0x7762=>"",
    0x7764=>"",
    0x7767=>"",
    0x776a=>"",
    0x776c=>"",
    0x7770=>"",
    0x7772=>"",
    0x7773=>"",
    0x7774=>"",
    0x777a=>"",
    0x777d=>"",
    0x7780=>"",
    0x7784=>"",
    0x778c=>"",
    0x778d=>"",
    0x7794=>"",
    0x7795=>"",
    0x7796=>"",
    0x779a=>"",
    0x779f=>"",
    0x77a2=>"",
    0x77a7=>"",
    0x77aa=>"",
    0x77ae=>"",
    0x77af=>"",
    0x77b1=>"",
    0x77b5=>"",
    0x77be=>"",
    0x77c3=>"",
    0x77c9=>"",
    0x77d1=>"",
    0x77d2=>"",
    0x77d5=>"",
    0x77d9=>"",
    0x77de=>"",
    0x77df=>"",
    0x77e0=>"",
    0x77e4=>"",
    0x77e6=>"",
    0x77ea=>"",
    0x77ec=>"",
    0x77f0=>"",
    0x77f1=>"",
    0x77f4=>"",
    0x77f8=>"",
    0x77fb=>"",
    0x7805=>"",
    0x7806=>"",
    0x7809=>"",
    0x780d=>"",
    0x780e=>"",
    0x7811=>"",
    0x781d=>"",
    0x7821=>"\xfb\xbd",
    0x7822=>"",
    0x7823=>"",
    0x782d=>"",
    0x782e=>"",
    0x7830=>"",
    0x7835=>"",
    0x7837=>"",
    0x7843=>"",
    0x7844=>"",
    0x7847=>"",
    0x7848=>"",
    0x784c=>"",
    0x784e=>"\xfb\xbe",
    0x7852=>"",
    0x785c=>"",
    0x785e=>"",
    0x7860=>"",
    0x7861=>"",
    0x7863=>"",
    0x7864=>"\xfb\xbf",
    0x7868=>"",
    0x786a=>"",
    0x786e=>"",
    0x787a=>"\xfb\xc0",
    0x787e=>"",
    0x788a=>"",
    0x788f=>"",
    0x7894=>"",
    0x7898=>"",
    0x789d=>"",
    0x789e=>"",
    0x789f=>"",
    0x78a1=>"",
    0x78a4=>"",
    0x78a8=>"",
    0x78ac=>"",
    0x78ad=>"",
    0x78b0=>"",
    0x78b1=>"",
    0x78b2=>"",
    0x78b3=>"",
    0x78bb=>"",
    0x78bd=>"",
    0x78bf=>"",
    0x78c7=>"",
    0x78c8=>"",
    0x78c9=>"",
    0x78cc=>"",
    0x78ce=>"",
    0x78d2=>"",
    0x78d3=>"",
    0x78d5=>"",
    0x78d6=>"",
    0x78db=>"",
    0x78df=>"",
    0x78e0=>"",
    0x78e1=>"",
    0x78e4=>"",
    0x78e6=>"",
    0x78ea=>"",
    0x78f2=>"",
    0x78f3=>"",
    0x78f6=>"",
    0x78f7=>"",
    0x78fa=>"",
    0x78fb=>"",
    0x78ff=>"",
    0x7900=>"",
    0x7906=>"",
    0x790c=>"",
    0x7910=>"",
    0x791a=>"",
    0x791c=>"",
    0x791e=>"",
    0x791f=>"",
    0x7920=>"",
    0x7925=>"",
    0x7927=>"",
    0x7929=>"",
    0x792d=>"",
    0x7930=>"\xfb\xc1",
    0x7931=>"",
    0x7934=>"",
    0x7935=>"",
    0x793b=>"",
    0x793d=>"",
    0x793f=>"",
    0x7944=>"",
    0x7945=>"",
    0x7946=>"",
    0x794a=>"",
    0x794b=>"",
    0x794f=>"",
    0x7951=>"",
    0x7954=>"",
    0x7958=>"",
    0x795b=>"",
    0x795c=>"",
    0x7967=>"",
    0x7969=>"",
    0x796b=>"",
    0x7972=>"",
    0x7979=>"",
    0x797b=>"",
    0x797c=>"",
    0x797e=>"",
    0x798b=>"",
    0x798c=>"",
    0x7991=>"",
    0x7993=>"",
    0x7994=>"\xfb\xc5",
    0x7995=>"",
    0x7996=>"",
    0x7998=>"",
    0x799b=>"\xfb\xc7",
    0x799c=>"",
    0x79a1=>"",
    0x79a8=>"",
    0x79a9=>"",
    0x79ab=>"",
    0x79af=>"",
    0x79b1=>"",
    0x79b4=>"",
    0x79b8=>"",
    0x79bb=>"",
    0x79c2=>"",
    0x79c4=>"",
    0x79c7=>"",
    0x79c8=>"",
    0x79ca=>"",
    0x79cf=>"",
    0x79d4=>"",
    0x79d6=>"",
    0x79da=>"",
    0x79dd=>"",
    0x79de=>"",
    0x79e0=>"",
    0x79e2=>"",
    0x79e5=>"",
    0x79ea=>"",
    0x79eb=>"",
    0x79ed=>"",
    0x79f1=>"",
    0x79f8=>"",
    0x79fc=>"",
    0x7a02=>"",
    0x7a03=>"",
    0x7a07=>"",
    0x7a09=>"",
    0x7a0a=>"",
    0x7a0c=>"",
    0x7a11=>"",
    0x7a15=>"",
    0x7a1b=>"",
    0x7a1e=>"",
    0x7a21=>"",
    0x7a27=>"",
    0x7a2b=>"",
    0x7a2d=>"",
    0x7a2f=>"",
    0x7a30=>"",
    0x7a34=>"",
    0x7a35=>"",
    0x7a38=>"",
    0x7a39=>"",
    0x7a3a=>"",
    0x7a44=>"",
    0x7a45=>"",
    0x7a47=>"",
    0x7a48=>"",
    0x7a4c=>"",
    0x7a55=>"",
    0x7a56=>"",
    0x7a59=>"",
    0x7a5c=>"",
    0x7a5d=>"",
    0x7a5f=>"",
    0x7a60=>"",
    0x7a65=>"",
    0x7a67=>"",
    0x7a6a=>"",
    0x7a6d=>"",
    0x7a75=>"",
    0x7a78=>"",
    0x7a7e=>"",
    0x7a80=>"",
    0x7a82=>"",
    0x7a85=>"",
    0x7a86=>"",
    0x7a8a=>"",
    0x7a8b=>"",
    0x7a90=>"",
    0x7a91=>"",
    0x7a94=>"",
    0x7a9e=>"",
    0x7aa0=>"",
    0x7aa3=>"",
    0x7aac=>"",
    0x7ab3=>"",
    0x7ab5=>"",
    0x7ab9=>"",
    0x7abb=>"",
    0x7abc=>"",
    0x7ac6=>"",
    0x7ac9=>"",
    0x7acc=>"",
    0x7ace=>"",
    0x7ad1=>"\xfb\xc8",
    0x7adb=>"",
    0x7ae7=>"\xfb\xc9",
    0x7ae8=>"",
    0x7ae9=>"",
    0x7aeb=>"\xfb\xcb",
    0x7aec=>"",
    0x7af1=>"",
    0x7af4=>"",
    0x7afb=>"",
    0x7afd=>"",
    0x7afe=>"",
    0x7b07=>"",
    0x7b14=>"",
    0x7b1f=>"",
    0x7b23=>"",
    0x7b27=>"",
    0x7b29=>"",
    0x7b2a=>"",
    0x7b2b=>"",
    0x7b2d=>"",
    0x7b2e=>"",
    0x7b2f=>"",
    0x7b30=>"",
    0x7b31=>"",
    0x7b34=>"",
    0x7b3d=>"",
    0x7b3f=>"",
    0x7b40=>"",
    0x7b41=>"",
    0x7b47=>"",
    0x7b4e=>"",
    0x7b55=>"",
    0x7b60=>"",
    0x7b64=>"",
    0x7b66=>"",
    0x7b69=>"",
    0x7b6a=>"",
    0x7b6d=>"",
    0x7b6f=>"",
    0x7b72=>"",
    0x7b73=>"",
    0x7b77=>"",
    0x7b84=>"",
    0x7b89=>"",
    0x7b8e=>"",
    0x7b90=>"",
    0x7b91=>"",
    0x7b96=>"",
    0x7b9b=>"",
    0x7b9e=>"\xfb\xcc",
    0x7ba0=>"",
    0x7ba5=>"",
    0x7bac=>"",
    0x7baf=>"",
    0x7bb0=>"",
    0x7bb2=>"",
    0x7bb5=>"",
    0x7bb6=>"",
    0x7bba=>"",
    0x7bbb=>"",
    0x7bbc=>"",
    0x7bbd=>"",
    0x7bc2=>"",
    0x7bc5=>"",
    0x7bc8=>"",
    0x7bca=>"",
    0x7bd4=>"",
    0x7bd6=>"",
    0x7bd7=>"",
    0x7bd9=>"",
    0x7bda=>"",
    0x7bdb=>"",
    0x7be8=>"",
    0x7bea=>"",
    0x7bf2=>"",
    0x7bf4=>"",
    0x7bf5=>"",
    0x7bf8=>"",
    0x7bf9=>"",
    0x7bfa=>"",
    0x7bfc=>"",
    0x7bfe=>"",
    0x7c01=>"",
    0x7c02=>"",
    0x7c03=>"",
    0x7c04=>"",
    0x7c06=>"",
    0x7c09=>"",
    0x7c0b=>"",
    0x7c0c=>"",
    0x7c0e=>"",
    0x7c0f=>"",
    0x7c19=>"",
    0x7c1b=>"",
    0x7c20=>"",
    0x7c25=>"",
    0x7c26=>"",
    0x7c28=>"",
    0x7c2c=>"",
    0x7c31=>"",
    0x7c33=>"",
    0x7c34=>"",
    0x7c36=>"",
    0x7c39=>"",
    0x7c3a=>"",
    0x7c46=>"",
    0x7c4a=>"",
    0x7c51=>"",
    0x7c52=>"",
    0x7c53=>"",
    0x7c55=>"",
    0x7c59=>"",
    0x7c5a=>"",
    0x7c5b=>"",
    0x7c5c=>"",
    0x7c5d=>"",
    0x7c5e=>"",
    0x7c61=>"",
    0x7c63=>"",
    0x7c67=>"",
    0x7c69=>"",
    0x7c6d=>"",
    0x7c6e=>"",
    0x7c70=>"",
    0x7c72=>"",
    0x7c79=>"",
    0x7c7c=>"",
    0x7c7d=>"",
    0x7c86=>"",
    0x7c87=>"",
    0x7c8f=>"",
    0x7c94=>"",
    0x7c9e=>"",
    0x7ca0=>"",
    0x7ca6=>"",
    0x7cb0=>"",
    0x7cb6=>"",
    0x7cb7=>"",
    0x7cba=>"",
    0x7cbb=>"",
    0x7cbc=>"",
    0x7cbf=>"",
    0x7cc4=>"",
    0x7cc7=>"",
    0x7cc8=>"",
    0x7cc9=>"",
    0x7ccd=>"",
    0x7ccf=>"",
    0x7cd3=>"",
    0x7cd4=>"",
    0x7cd5=>"",
    0x7cd7=>"",
    0x7cd9=>"",
    0x7cda=>"",
    0x7cdd=>"",
    0x7ce6=>"",
    0x7ce9=>"",
    0x7ceb=>"",
    0x7cf5=>"",
    0x7d03=>"",
    0x7d07=>"",
    0x7d08=>"",
    0x7d09=>"",
    0x7d0f=>"",
    0x7d11=>"",
    0x7d12=>"",
    0x7d13=>"",
    0x7d16=>"",
    0x7d1d=>"",
    0x7d1e=>"",
    0x7d23=>"",
    0x7d26=>"",
    0x7d2a=>"",
    0x7d2d=>"",
    0x7d31=>"",
    0x7d3c=>"",
    0x7d3d=>"",
    0x7d3e=>"",
    0x7d40=>"",
    0x7d41=>"",
    0x7d47=>"",
    0x7d48=>"\xfb\xce",
    0x7d4d=>"",
    0x7d51=>"",
    0x7d53=>"",
    0x7d57=>"",
    0x7d59=>"",
    0x7d5a=>"",
    0x7d5c=>"\xfb\xcf",
    0x7d5d=>"",
    0x7d65=>"",
    0x7d67=>"",
    0x7d6a=>"",
    0x7d70=>"",
    0x7d78=>"",
    0x7d7a=>"",
    0x7d7b=>"",
    0x7d7f=>"",
    0x7d81=>"",
    0x7d82=>"",
    0x7d83=>"",
    0x7d85=>"",
    0x7d86=>"",
    0x7d88=>"",
    0x7d8b=>"",
    0x7d8c=>"",
    0x7d8d=>"",
    0x7d91=>"",
    0x7d96=>"",
    0x7d97=>"",
    0x7d9d=>"",
    0x7d9e=>"",
    0x7da0=>"\xfb\xd1",
    0x7da6=>"",
    0x7da7=>"",
    0x7daa=>"",
    0x7db3=>"",
    0x7db6=>"",
    0x7db7=>"\xfb\xd0",
    0x7db9=>"",
    0x7dc2=>"",
    0x7dc3=>"",
    0x7dc4=>"",
    0x7dc5=>"",
    0x7dc6=>"",
    0x7dcc=>"",
    0x7dcd=>"",
    0x7dce=>"",
    0x7dd6=>"\xfb\xd2",
    0x7dd7=>"",
    0x7dd9=>"",
    0x7de2=>"",
    0x7de5=>"",
    0x7de6=>"",
    0x7dea=>"",
    0x7deb=>"",
    0x7ded=>"",
    0x7df1=>"",
    0x7df5=>"",
    0x7df6=>"",
    0x7df9=>"",
    0x7dfa=>"",
    0x7e00=>"",
    0x7e08=>"",
    0x7e10=>"",
    0x7e11=>"",
    0x7e15=>"",
    0x7e17=>"",
    0x7e1c=>"",
    0x7e1d=>"",
    0x7e20=>"",
    0x7e27=>"",
    0x7e28=>"",
    0x7e2c=>"",
    0x7e2d=>"",
    0x7e2f=>"",
    0x7e33=>"",
    0x7e36=>"",
    0x7e3f=>"",
    0x7e44=>"",
    0x7e45=>"",
    0x7e47=>"",
    0x7e4e=>"",
    0x7e50=>"",
    0x7e52=>"\xfb\xd3",
    0x7e58=>"",
    0x7e5f=>"",
    0x7e61=>"",
    0x7e62=>"",
    0x7e65=>"",
    0x7e6b=>"",
    0x7e6e=>"",
    0x7e6f=>"",
    0x7e73=>"",
    0x7e78=>"",
    0x7e7e=>"",
    0x7e81=>"",
    0x7e86=>"",
    0x7e87=>"",
    0x7e8a=>"\xf9\xa1",
    0x7e8d=>"",
    0x7e91=>"",
    0x7e95=>"",
    0x7e98=>"",
    0x7e9a=>"",
    0x7e9d=>"",
    0x7e9e=>"",
    0x7f3b=>"",
    0x7f3c=>"",
    0x7f3d=>"",
    0x7f3e=>"",
    0x7f3f=>"",
    0x7f43=>"",
    0x7f44=>"",
    0x7f47=>"\xfb\xd4",
    0x7f4f=>"",
    0x7f52=>"",
    0x7f53=>"",
    0x7f5b=>"",
    0x7f5c=>"",
    0x7f5d=>"",
    0x7f61=>"",
    0x7f63=>"",
    0x7f64=>"",
    0x7f65=>"",
    0x7f66=>"",
    0x7f6d=>"",
    0x7f71=>"",
    0x7f7d=>"",
    0x7f7e=>"",
    0x7f7f=>"",
    0x7f80=>"",
    0x7f8b=>"",
    0x7f8d=>"",
    0x7f8f=>"",
    0x7f90=>"",
    0x7f91=>"",
    0x7f96=>"",
    0x7f97=>"",
    0x7f9c=>"",
    0x7fa1=>"\xfb\xd5",
    0x7fa2=>"",
    0x7fa6=>"",
    0x7faa=>"",
    0x7fad=>"",
    0x7fb4=>"",
    0x7fbc=>"",
    0x7fbf=>"",
    0x7fc0=>"",
    0x7fc3=>"",
    0x7fc8=>"",
    0x7fce=>"",
    0x7fcf=>"",
    0x7fdb=>"",
    0x7fdf=>"",
    0x7fe3=>"",
    0x7fe5=>"",
    0x7fe8=>"",
    0x7fec=>"",
    0x7fee=>"",
    0x7fef=>"",
    0x7ff2=>"",
    0x7ffa=>"",
    0x7ffd=>"",
    0x7ffe=>"",
    0x7fff=>"",
    0x8007=>"",
    0x8008=>"",
    0x800a=>"",
    0x800d=>"",
    0x800e=>"",
    0x800f=>"",
    0x8011=>"",
    0x8013=>"",
    0x8014=>"",
    0x8016=>"",
    0x801d=>"",
    0x801e=>"",
    0x801f=>"",
    0x8020=>"",
    0x8024=>"",
    0x8026=>"",
    0x802c=>"",
    0x802e=>"",
    0x8030=>"",
    0x8034=>"",
    0x8035=>"",
    0x8037=>"",
    0x8039=>"",
    0x803a=>"",
    0x803c=>"",
    0x803e=>"",
    0x8040=>"",
    0x8044=>"",
    0x8060=>"",
    0x8064=>"",
    0x8066=>"",
    0x806d=>"",
    0x8071=>"",
    0x8075=>"",
    0x8081=>"",
    0x8088=>"",
    0x808e=>"",
    0x809c=>"",
    0x809e=>"",
    0x80a6=>"",
    0x80a7=>"",
    0x80ab=>"",
    0x80b8=>"",
    0x80b9=>"",
    0x80c8=>"",
    0x80cd=>"",
    0x80cf=>"",
    0x80d2=>"",
    0x80d4=>"",
    0x80d5=>"",
    0x80d7=>"",
    0x80d8=>"",
    0x80e0=>"",
    0x80ed=>"",
    0x80ee=>"",
    0x80f0=>"",
    0x80f2=>"",
    0x80f3=>"",
    0x80f6=>"",
    0x80f9=>"",
    0x80fa=>"",
    0x80fe=>"",
    0x8103=>"",
    0x810b=>"",
    0x8116=>"",
    0x8117=>"",
    0x8118=>"",
    0x811c=>"",
    0x811e=>"",
    0x8120=>"",
    0x8124=>"",
    0x8127=>"",
    0x812c=>"",
    0x8130=>"",
    0x8135=>"",
    0x813a=>"",
    0x813c=>"",
    0x8145=>"",
    0x8147=>"",
    0x814a=>"",
    0x814c=>"",
    0x8152=>"",
    0x8157=>"",
    0x8160=>"",
    0x8161=>"",
    0x8167=>"",
    0x8168=>"",
    0x8169=>"",
    0x816d=>"",
    0x816f=>"",
    0x8177=>"",
    0x8181=>"",
    0x8184=>"",
    0x8185=>"",
    0x8186=>"",
    0x818b=>"",
    0x818e=>"",
    0x8190=>"",
    0x8196=>"",
    0x8198=>"",
    0x819b=>"",
    0x819e=>"",
    0x81a2=>"",
    0x81ae=>"",
    0x81b2=>"",
    0x81b4=>"",
    0x81bb=>"",
    0x81c3=>"",
    0x81c5=>"",
    0x81ca=>"",
    0x81cb=>"",
    0x81ce=>"",
    0x81cf=>"",
    0x81d5=>"",
    0x81d7=>"",
    0x81db=>"",
    0x81dd=>"",
    0x81de=>"",
    0x81e1=>"",
    0x81e4=>"",
    0x81eb=>"",
    0x81ec=>"",
    0x81f0=>"",
    0x81f1=>"",
    0x81f2=>"",
    0x81f5=>"",
    0x81f6=>"",
    0x81f8=>"",
    0x81f9=>"",
    0x81fd=>"",
    0x81ff=>"",
    0x8200=>"",
    0x8203=>"",
    0x820f=>"",
    0x8213=>"",
    0x8214=>"",
    0x8219=>"",
    0x821a=>"",
    0x821d=>"",
    0x8221=>"",
    0x8222=>"",
    0x8228=>"",
    0x8232=>"",
    0x8234=>"",
    0x823a=>"",
    0x8243=>"",
    0x8244=>"",
    0x8245=>"",
    0x8246=>"",
    0x824b=>"",
    0x824e=>"",
    0x824f=>"",
    0x8251=>"",
    0x8256=>"",
    0x825c=>"",
    0x8260=>"",
    0x8263=>"",
    0x8267=>"",
    0x826d=>"",
    0x8274=>"",
    0x827b=>"",
    0x827d=>"",
    0x827f=>"",
    0x8280=>"",
    0x8281=>"",
    0x8283=>"",
    0x8284=>"",
    0x8287=>"",
    0x8289=>"",
    0x828a=>"",
    0x828e=>"",
    0x8291=>"",
    0x8294=>"",
    0x8296=>"",
    0x8298=>"",
    0x829a=>"",
    0x829b=>"",
    0x82a0=>"",
    0x82a1=>"",
    0x82a3=>"",
    0x82a4=>"",
    0x82a7=>"",
    0x82a8=>"",
    0x82a9=>"",
    0x82aa=>"",
    0x82ae=>"",
    0x82b0=>"",
    0x82b2=>"",
    0x82b4=>"",
    0x82b7=>"",
    0x82ba=>"",
    0x82bc=>"",
    0x82be=>"",
    0x82bf=>"",
    0x82c6=>"",
    0x82d0=>"",
    0x82d5=>"",
    0x82da=>"",
    0x82e0=>"",
    0x82e2=>"",
    0x82e4=>"",
    0x82e8=>"",
    0x82ea=>"",
    0x82ed=>"",
    0x82ef=>"",
    0x82f6=>"",
    0x82f7=>"",
    0x82fd=>"",
    0x82fe=>"",
    0x8300=>"",
    0x8301=>"\xfb\xd7",
    0x8307=>"",
    0x8308=>"",
    0x830a=>"",
    0x830b=>"",
    0x831b=>"",
    0x831d=>"",
    0x831e=>"",
    0x831f=>"",
    0x8321=>"",
    0x8322=>"",
    0x832c=>"",
    0x832d=>"",
    0x832e=>"",
    0x8330=>"",
    0x8333=>"",
    0x8337=>"",
    0x833a=>"",
    0x833c=>"",
    0x833d=>"",
    0x8342=>"",
    0x8343=>"",
    0x8344=>"",
    0x8347=>"",
    0x834d=>"",
    0x834e=>"",
    0x8351=>"",
    0x8353=>"",
    0x8354=>"",
    0x8355=>"",
    0x8356=>"",
    0x8357=>"",
    0x8362=>"\xfb\xd8",
    0x8370=>"",
    0x8378=>"",
    0x837d=>"",
    0x837f=>"\xfb\xd9",
    0x8380=>"",
    0x8382=>"",
    0x8384=>"",
    0x8386=>"",
    0x838d=>"",
    0x8392=>"",
    0x8394=>"",
    0x8395=>"",
    0x8398=>"",
    0x8399=>"",
    0x839b=>"",
    0x839c=>"",
    0x839d=>"",
    0x83a6=>"",
    0x83a7=>"",
    0x83a9=>"",
    0x83ac=>"",
    0x83ad=>"",
    0x83be=>"",
    0x83bf=>"",
    0x83c0=>"",
    0x83c7=>"\xfb\xda",
    0x83c9=>"",
    0x83cf=>"",
    0x83d0=>"",
    0x83d1=>"",
    0x83d4=>"",
    0x83dd=>"",
    0x83e8=>"",
    0x83ea=>"",
    0x83f6=>"\xfb\xdb",
    0x83f8=>"",
    0x83f9=>"",
    0x83fc=>"",
    0x8401=>"",
    0x8406=>"",
    0x840a=>"",
    0x840f=>"",
    0x8411=>"",
    0x8415=>"",
    0x8419=>"",
    0x842f=>"",
    0x8439=>"",
    0x8445=>"",
    0x8447=>"",
    0x8448=>"\xfb\xdc",
    0x844a=>"",
    0x844d=>"",
    0x844f=>"",
    0x8451=>"",
    0x8452=>"",
    0x8456=>"",
    0x8458=>"",
    0x8459=>"",
    0x845a=>"",
    0x845c=>"",
    0x8460=>"",
    0x8464=>"",
    0x8465=>"",
    0x8467=>"",
    0x846a=>"",
    0x8470=>"",
    0x8473=>"",
    0x8474=>"",
    0x8476=>"",
    0x8478=>"",
    0x847c=>"",
    0x847d=>"",
    0x8481=>"",
    0x8485=>"",
    0x8492=>"",
    0x8493=>"",
    0x8495=>"",
    0x849e=>"",
    0x84a6=>"",
    0x84a8=>"",
    0x84a9=>"",
    0x84aa=>"",
    0x84af=>"",
    0x84b1=>"",
    0x84b4=>"\xfb\xdd",
    0x84ba=>"",
    0x84bd=>"",
    0x84be=>"",
    0x84c0=>"",
    0x84c2=>"",
    0x84c7=>"",
    0x84c8=>"",
    0x84cc=>"",
    0x84cf=>"",
    0x84d3=>"",
    0x84dc=>"\xf9\xa5",
    0x84e7=>"",
    0x84ea=>"",
    0x84ef=>"",
    0x84f0=>"",
    0x84f1=>"",
    0x84f2=>"",
    0x84f7=>"",
    0x84fa=>"",
    0x84fb=>"",
    0x84fd=>"",
    0x8502=>"",
    0x8503=>"",
    0x8507=>"",
    0x850c=>"",
    0x850e=>"",
    0x8510=>"",
    0x851c=>"",
    0x851e=>"",
    0x8522=>"",
    0x8523=>"",
    0x8524=>"",
    0x8525=>"",
    0x8527=>"",
    0x852a=>"",
    0x852b=>"",
    0x852f=>"",
    0x8532=>"",
    0x8533=>"",
    0x8534=>"",
    0x8536=>"",
    0x853f=>"",
    0x8546=>"",
    0x854f=>"",
    0x8550=>"",
    0x8551=>"",
    0x8552=>"",
    0x8553=>"\xfb\xde",
    0x8556=>"",
    0x8559=>"\xfb\xdf",
    0x855c=>"",
    0x855d=>"",
    0x855e=>"",
    0x855f=>"",
    0x8560=>"",
    0x8561=>"",
    0x8562=>"",
    0x8564=>"",
    0x856b=>"\xfb\xe0",
    0x856f=>"",
    0x8579=>"",
    0x857a=>"",
    0x857b=>"",
    0x857d=>"",
    0x857f=>"",
    0x8581=>"",
    0x8585=>"",
    0x8586=>"",
    0x8589=>"",
    0x858b=>"",
    0x858c=>"",
    0x858f=>"",
    0x8593=>"",
    0x8598=>"",
    0x859d=>"",
    0x859f=>"",
    0x85a0=>"",
    0x85a2=>"",
    0x85a5=>"",
    0x85a7=>"",
    0x85ad=>"",
    0x85b0=>"\xfb\xe2",
    0x85b4=>"",
    0x85b6=>"",
    0x85b7=>"",
    0x85b8=>"",
    0x85bc=>"",
    0x85bd=>"",
    0x85be=>"",
    0x85bf=>"",
    0x85c2=>"",
    0x85c7=>"",
    0x85ca=>"",
    0x85cb=>"",
    0x85ce=>"",
    0x85d8=>"",
    0x85da=>"",
    0x85df=>"",
    0x85e0=>"",
    0x85e6=>"",
    0x85e8=>"",
    0x85ed=>"",
    0x85f3=>"",
    0x85f6=>"",
    0x85fc=>"",
    0x85ff=>"",
    0x8600=>"",
    0x8604=>"",
    0x8605=>"",
    0x860d=>"",
    0x860e=>"",
    0x8610=>"",
    0x8611=>"",
    0x8612=>"",
    0x8618=>"",
    0x8619=>"",
    0x861b=>"",
    0x861e=>"",
    0x8621=>"",
    0x8627=>"",
    0x8629=>"",
    0x8636=>"",
    0x8638=>"",
    0x863a=>"",
    0x863c=>"",
    0x863d=>"",
    0x8640=>"",
    0x8641=>"",
    0x8642=>"",
    0x8646=>"",
    0x8652=>"",
    0x8653=>"",
    0x8656=>"",
    0x8657=>"",
    0x8658=>"",
    0x8659=>"",
    0x865d=>"",
    0x8660=>"",
    0x8661=>"",
    0x8662=>"",
    0x8663=>"",
    0x8664=>"",
    0x8669=>"",
    0x866c=>"",
    0x866f=>"",
    0x8675=>"",
    0x8676=>"",
    0x8677=>"",
    0x867a=>"",
    0x8688=>"",
    0x868d=>"",
    0x8691=>"",
    0x8696=>"",
    0x8698=>"",
    0x869a=>"",
    0x869c=>"",
    0x86a1=>"",
    0x86a6=>"",
    0x86a7=>"",
    0x86a8=>"",
    0x86ad=>"",
    0x86b1=>"",
    0x86b3=>"",
    0x86b4=>"",
    0x86b5=>"",
    0x86b7=>"",
    0x86b8=>"",
    0x86b9=>"",
    0x86bf=>"",
    0x86c0=>"",
    0x86c1=>"",
    0x86c3=>"",
    0x86c5=>"",
    0x86d1=>"",
    0x86d2=>"",
    0x86d5=>"",
    0x86d7=>"",
    0x86da=>"",
    0x86dc=>"",
    0x86e0=>"",
    0x86e3=>"",
    0x86e5=>"",
    0x86e7=>"",
    0x86fa=>"",
    0x86fc=>"",
    0x86fd=>"",
    0x8704=>"",
    0x8705=>"",
    0x8707=>"",
    0x870b=>"",
    0x870e=>"",
    0x870f=>"",
    0x8710=>"",
    0x8713=>"",
    0x8714=>"",
    0x8719=>"",
    0x871e=>"",
    0x871f=>"",
    0x8721=>"",
    0x8723=>"",
    0x8728=>"",
    0x872e=>"",
    0x872f=>"",
    0x8731=>"",
    0x8732=>"",
    0x8739=>"",
    0x873a=>"",
    0x873c=>"",
    0x873d=>"",
    0x873e=>"",
    0x8740=>"",
    0x8743=>"",
    0x8745=>"",
    0x874d=>"",
    0x8758=>"",
    0x875d=>"",
    0x8761=>"",
    0x8764=>"",
    0x8765=>"",
    0x876f=>"",
    0x8771=>"",
    0x8772=>"",
    0x877b=>"",
    0x8783=>"",
    0x8784=>"",
    0x8785=>"",
    0x8786=>"",
    0x8787=>"",
    0x8788=>"",
    0x8789=>"",
    0x878b=>"",
    0x878c=>"",
    0x8790=>"",
    0x8793=>"",
    0x8795=>"",
    0x8797=>"",
    0x8798=>"",
    0x8799=>"",
    0x879e=>"",
    0x87a0=>"",
    0x87a3=>"",
    0x87a7=>"",
    0x87ac=>"",
    0x87ad=>"",
    0x87ae=>"",
    0x87b1=>"",
    0x87b5=>"",
    0x87be=>"",
    0x87bf=>"",
    0x87c1=>"",
    0x87c8=>"",
    0x87c9=>"",
    0x87ca=>"",
    0x87ce=>"",
    0x87d5=>"",
    0x87d6=>"",
    0x87d9=>"",
    0x87da=>"",
    0x87dc=>"",
    0x87df=>"",
    0x87e2=>"",
    0x87e3=>"",
    0x87e4=>"",
    0x87ea=>"",
    0x87eb=>"",
    0x87ed=>"",
    0x87f1=>"",
    0x87f3=>"",
    0x87f8=>"",
    0x87fa=>"",
    0x87ff=>"",
    0x8801=>"",
    0x8803=>"",
    0x8806=>"",
    0x8807=>"\xfb\xe5",
    0x8809=>"",
    0x880a=>"",
    0x880b=>"",
    0x8810=>"",
    0x8812=>"",
    0x8813=>"",
    0x8814=>"",
    0x8818=>"",
    0x8819=>"",
    0x881a=>"",
    0x881b=>"",
    0x881c=>"",
    0x881e=>"",
    0x881f=>"",
    0x8828=>"",
    0x882d=>"",
    0x882e=>"",
    0x8830=>"",
    0x8832=>"",
    0x8835=>"",
    0x883a=>"",
    0x883c=>"",
    0x8841=>"",
    0x8843=>"",
    0x8845=>"",
    0x8848=>"",
    0x8849=>"",
    0x884a=>"",
    0x884b=>"",
    0x884e=>"",
    0x8851=>"",
    0x8855=>"",
    0x8856=>"",
    0x8858=>"",
    0x885a=>"",
    0x885c=>"",
    0x885f=>"",
    0x8860=>"",
    0x8864=>"",
    0x8869=>"",
    0x8871=>"",
    0x8879=>"",
    0x887b=>"",
    0x8880=>"",
    0x8898=>"",
    0x889a=>"",
    0x889b=>"",
    0x889c=>"",
    0x889f=>"",
    0x88a0=>"",
    0x88a8=>"",
    0x88aa=>"",
    0x88ba=>"",
    0x88bd=>"",
    0x88be=>"",
    0x88c0=>"",
    0x88ca=>"",
    0x88cb=>"",
    0x88cc=>"",
    0x88cd=>"",
    0x88ce=>"",
    0x88d1=>"",
    0x88d2=>"",
    0x88d3=>"",
    0x88db=>"",
    0x88de=>"",
    0x88e7=>"",
    0x88ef=>"",
    0x88f0=>"",
    0x88f1=>"",
    0x88f5=>"\xfb\xe6",
    0x88f7=>"",
    0x8901=>"",
    0x8906=>"",
    0x890d=>"",
    0x890e=>"",
    0x890f=>"",
    0x8915=>"",
    0x8916=>"",
    0x8918=>"",
    0x8919=>"",
    0x891a=>"",
    0x891c=>"\xf9\xa2",
    0x8920=>"",
    0x8926=>"",
    0x8927=>"",
    0x8928=>"",
    0x8930=>"",
    0x8931=>"",
    0x8932=>"",
    0x8935=>"",
    0x8939=>"",
    0x893a=>"",
    0x893e=>"",
    0x8940=>"",
    0x8942=>"",
    0x8945=>"",
    0x8946=>"",
    0x8949=>"",
    0x894f=>"",
    0x8952=>"",
    0x8957=>"",
    0x895a=>"",
    0x895b=>"",
    0x895c=>"",
    0x8961=>"",
    0x8962=>"",
    0x8963=>"",
    0x896b=>"",
    0x896e=>"",
    0x8970=>"",
    0x8973=>"",
    0x8975=>"",
    0x897a=>"",
    0x897b=>"",
    0x897c=>"",
    0x897d=>"",
    0x8989=>"",
    0x898d=>"",
    0x8990=>"",
    0x8994=>"",
    0x8995=>"",
    0x899b=>"",
    0x899c=>"",
    0x899f=>"",
    0x89a0=>"",
    0x89a5=>"",
    0x89b0=>"",
    0x89b4=>"",
    0x89b5=>"",
    0x89b6=>"",
    0x89b7=>"",
    0x89bc=>"",
    0x89d4=>"",
    0x89d5=>"",
    0x89d6=>"",
    0x89d7=>"",
    0x89d8=>"",
    0x89e5=>"",
    0x89e9=>"",
    0x89eb=>"",
    0x89ed=>"",
    0x89f1=>"",
    0x89f3=>"",
    0x89f6=>"",
    0x89f9=>"",
    0x89fd=>"",
    0x89ff=>"",
    0x8a04=>"",
    0x8a05=>"",
    0x8a07=>"",
    0x8a0f=>"",
    0x8a11=>"",
    0x8a12=>"\xfb\xe7",
    0x8a14=>"",
    0x8a15=>"",
    0x8a1e=>"",
    0x8a20=>"",
    0x8a22=>"",
    0x8a24=>"",
    0x8a26=>"",
    0x8a2b=>"",
    0x8a2c=>"",
    0x8a2f=>"",
    0x8a35=>"",
    0x8a37=>"\xfb\xe8",
    0x8a3d=>"",
    0x8a3e=>"",
    0x8a40=>"",
    0x8a43=>"",
    0x8a45=>"",
    0x8a47=>"",
    0x8a49=>"",
    0x8a4d=>"",
    0x8a4e=>"",
    0x8a53=>"",
    0x8a56=>"",
    0x8a57=>"",
    0x8a58=>"",
    0x8a5c=>"",
    0x8a5d=>"",
    0x8a61=>"",
    0x8a65=>"",
    0x8a67=>"",
    0x8a75=>"",
    0x8a76=>"",
    0x8a77=>"",
    0x8a79=>"\xfb\xe9",
    0x8a7a=>"",
    0x8a7b=>"",
    0x8a7e=>"",
    0x8a7f=>"",
    0x8a80=>"",
    0x8a83=>"",
    0x8a86=>"",
    0x8a8b=>"",
    0x8a8f=>"",
    0x8a90=>"",
    0x8a92=>"",
    0x8a96=>"",
    0x8a97=>"",
    0x8a99=>"",
    0x8a9f=>"",
    0x8aa7=>"\xfb\xea",
    0x8aa9=>"",
    0x8aae=>"",
    0x8aaf=>"",
    0x8ab3=>"",
    0x8ab6=>"",
    0x8ab7=>"",
    0x8abb=>"",
    0x8abe=>"\xfb\xeb",
    0x8ac3=>"",
    0x8ac6=>"",
    0x8ac8=>"",
    0x8ac9=>"",
    0x8aca=>"",
    0x8ad1=>"",
    0x8ad3=>"",
    0x8ad4=>"",
    0x8ad5=>"",
    0x8ad7=>"",
    0x8add=>"",
    0x8adf=>"\xfb\xec",
    0x8aec=>"",
    0x8af0=>"",
    0x8af4=>"",
    0x8af5=>"",
    0x8af6=>"\xfb\xee",
    0x8afc=>"",
    0x8aff=>"",
    0x8b05=>"",
    0x8b06=>"",
    0x8b0a=>"",
    0x8b0b=>"",
    0x8b11=>"",
    0x8b1c=>"",
    0x8b1e=>"",
    0x8b1f=>"",
    0x8b2d=>"",
    0x8b30=>"",
    0x8b37=>"",
    0x8b3c=>"",
    0x8b42=>"",
    0x8b43=>"",
    0x8b44=>"",
    0x8b45=>"",
    0x8b46=>"",
    0x8b48=>"",
    0x8b4d=>"",
    0x8b52=>"",
    0x8b53=>"\xfb\xef",
    0x8b54=>"",
    0x8b59=>"",
    0x8b5e=>"",
    0x8b63=>"",
    0x8b6d=>"",
    0x8b76=>"",
    0x8b78=>"",
    0x8b79=>"",
    0x8b7c=>"",
    0x8b7e=>"",
    0x8b7f=>"\xfb\xf0",
    0x8b81=>"",
    0x8b84=>"",
    0x8b85=>"",
    0x8b8b=>"",
    0x8b8d=>"",
    0x8b8f=>"",
    0x8b94=>"",
    0x8b95=>"",
    0x8b9c=>"",
    0x8b9e=>"",
    0x8b9f=>"",
    0x8c38=>"",
    0x8c39=>"",
    0x8c3d=>"",
    0x8c3e=>"",
    0x8c45=>"",
    0x8c47=>"",
    0x8c49=>"",
    0x8c4b=>"",
    0x8c4f=>"",
    0x8c51=>"",
    0x8c53=>"",
    0x8c54=>"",
    0x8c57=>"",
    0x8c58=>"",
    0x8c59=>"",
    0x8c5b=>"",
    0x8c5d=>"",
    0x8c63=>"",
    0x8c64=>"",
    0x8c66=>"",
    0x8c68=>"",
    0x8c69=>"",
    0x8c6d=>"",
    0x8c73=>"",
    0x8c75=>"",
    0x8c76=>"",
    0x8c7b=>"",
    0x8c7e=>"",
    0x8c86=>"",
    0x8c87=>"",
    0x8c8b=>"",
    0x8c90=>"",
    0x8c92=>"",
    0x8c93=>"",
    0x8c99=>"",
    0x8c9b=>"",
    0x8c9c=>"",
    0x8ca4=>"",
    0x8cb9=>"",
    0x8cba=>"",
    0x8cc5=>"",
    0x8cc6=>"",
    0x8cc9=>"",
    0x8ccb=>"",
    0x8ccf=>"",
    0x8cd5=>"",
    0x8cd6=>"",
    0x8cd9=>"",
    0x8cdd=>"",
    0x8ce1=>"",
    0x8ce8=>"",
    0x8cec=>"",
    0x8cef=>"",
    0x8cf0=>"\xfb\xf1",
    0x8cf2=>"",
    0x8cf4=>"\xfb\xf2",
    0x8cf5=>"",
    0x8cf7=>"",
    0x8cf8=>"",
    0x8cfe=>"",
    0x8cff=>"",
    0x8d01=>"",
    0x8d03=>"",
    0x8d09=>"",
    0x8d12=>"\xfb\xf3",
    0x8d17=>"",
    0x8d1b=>"",
    0x8d65=>"",
    0x8d69=>"",
    0x8d6c=>"",
    0x8d6e=>"",
    0x8d76=>"\xfb\xf4",
    0x8d7f=>"",
    0x8d82=>"",
    0x8d84=>"",
    0x8d88=>"",
    0x8d8d=>"",
    0x8d90=>"",
    0x8d91=>"",
    0x8d95=>"",
    0x8d9e=>"",
    0x8d9f=>"",
    0x8da0=>"",
    0x8da6=>"",
    0x8dab=>"",
    0x8dac=>"",
    0x8daf=>"",
    0x8db2=>"",
    0x8db5=>"",
    0x8db7=>"",
    0x8db9=>"",
    0x8dbb=>"",
    0x8dbc=>"",
    0x8dc0=>"",
    0x8dc5=>"",
    0x8dc6=>"",
    0x8dc7=>"",
    0x8dc8=>"",
    0x8dca=>"",
    0x8dce=>"",
    0x8dd1=>"",
    0x8dd4=>"",
    0x8dd5=>"",
    0x8dd7=>"",
    0x8dd9=>"",
    0x8de4=>"",
    0x8de5=>"",
    0x8de7=>"",
    0x8dec=>"",
    0x8df0=>"",
    0x8df1=>"",
    0x8df2=>"",
    0x8df4=>"",
    0x8dfd=>"",
    0x8e01=>"",
    0x8e04=>"",
    0x8e05=>"",
    0x8e06=>"",
    0x8e0b=>"",
    0x8e11=>"",
    0x8e14=>"",
    0x8e16=>"",
    0x8e20=>"",
    0x8e21=>"",
    0x8e22=>"",
    0x8e23=>"",
    0x8e26=>"",
    0x8e27=>"",
    0x8e31=>"",
    0x8e33=>"",
    0x8e36=>"",
    0x8e37=>"",
    0x8e38=>"",
    0x8e39=>"",
    0x8e3d=>"",
    0x8e40=>"",
    0x8e41=>"",
    0x8e4b=>"",
    0x8e4d=>"",
    0x8e4e=>"",
    0x8e4f=>"",
    0x8e54=>"",
    0x8e5b=>"",
    0x8e5c=>"",
    0x8e5d=>"",
    0x8e5e=>"",
    0x8e61=>"",
    0x8e62=>"",
    0x8e69=>"",
    0x8e6c=>"",
    0x8e6d=>"",
    0x8e6f=>"",
    0x8e70=>"",
    0x8e71=>"",
    0x8e79=>"",
    0x8e7a=>"",
    0x8e7b=>"",
    0x8e82=>"",
    0x8e83=>"",
    0x8e89=>"",
    0x8e90=>"",
    0x8e92=>"",
    0x8e95=>"",
    0x8e9a=>"",
    0x8e9b=>"",
    0x8e9d=>"",
    0x8e9e=>"",
    0x8ea2=>"",
    0x8ea7=>"",
    0x8ea9=>"",
    0x8ead=>"",
    0x8eae=>"",
    0x8eb3=>"",
    0x8eb5=>"",
    0x8eba=>"",
    0x8ebb=>"",
    0x8ec0=>"",
    0x8ec1=>"",
    0x8ec3=>"",
    0x8ec4=>"",
    0x8ec7=>"",
    0x8ecf=>"\xfb\xf6",
    0x8ed1=>"",
    0x8ed4=>"",
    0x8edc=>"",
    0x8ee8=>"",
    0x8eed=>"",
    0x8eee=>"",
    0x8ef0=>"",
    0x8ef1=>"",
    0x8ef7=>"",
    0x8ef9=>"",
    0x8efa=>"",
    0x8f00=>"",
    0x8f02=>"",
    0x8f07=>"",
    0x8f08=>"",
    0x8f0f=>"",
    0x8f10=>"",
    0x8f16=>"",
    0x8f17=>"",
    0x8f18=>"",
    0x8f1e=>"",
    0x8f20=>"",
    0x8f21=>"",
    0x8f23=>"",
    0x8f25=>"",
    0x8f27=>"",
    0x8f28=>"",
    0x8f2c=>"",
    0x8f2d=>"",
    0x8f2e=>"",
    0x8f34=>"",
    0x8f35=>"",
    0x8f36=>"",
    0x8f37=>"",
    0x8f3a=>"",
    0x8f40=>"",
    0x8f41=>"",
    0x8f43=>"",
    0x8f47=>"",
    0x8f4f=>"",
    0x8f51=>"",
    0x8f52=>"",
    0x8f53=>"",
    0x8f54=>"",
    0x8f55=>"",
    0x8f58=>"",
    0x8f5d=>"",
    0x8f5e=>"",
    0x8f65=>"",
    0x8f9d=>"",
    0x8fa0=>"",
    0x8fa1=>"",
    0x8fa4=>"",
    0x8fa5=>"",
    0x8fa6=>"",
    0x8fb5=>"",
    0x8fb6=>"",
    0x8fb8=>"",
    0x8fbe=>"",
    0x8fc0=>"",
    0x8fc1=>"",
    0x8fc6=>"",
    0x8fca=>"",
    0x8fcb=>"",
    0x8fcd=>"",
    0x8fd0=>"",
    0x8fd2=>"",
    0x8fd3=>"",
    0x8fd5=>"",
    0x8fe0=>"",
    0x8fe3=>"",
    0x8fe4=>"",
    0x8fe8=>"",
    0x8fee=>"",
    0x8ff1=>"",
    0x8ff5=>"",
    0x8ff6=>"",
    0x8ffb=>"",
    0x8ffe=>"",
    0x9002=>"",
    0x9004=>"",
    0x9008=>"",
    0x900c=>"",
    0x9018=>"",
    0x901b=>"",
    0x9028=>"",
    0x9029=>"",
    0x902a=>"",
    0x902c=>"",
    0x902d=>"",
    0x902f=>"",
    0x9033=>"",
    0x9034=>"",
    0x9037=>"",
    0x903f=>"",
    0x9043=>"",
    0x9044=>"",
    0x904c=>"",
    0x905b=>"",
    0x905d=>"",
    0x9062=>"",
    0x9066=>"",
    0x9067=>"\xfb\xf9",
    0x906c=>"",
    0x9070=>"",
    0x9074=>"",
    0x9079=>"",
    0x9085=>"",
    0x9088=>"",
    0x908b=>"",
    0x908c=>"",
    0x908e=>"",
    0x9090=>"",
    0x9095=>"",
    0x9097=>"",
    0x9098=>"",
    0x9099=>"",
    0x909b=>"",
    0x90a0=>"",
    0x90a1=>"",
    0x90a2=>"",
    0x90a5=>"",
    0x90b0=>"",
    0x90b2=>"",
    0x90b3=>"",
    0x90b4=>"",
    0x90b6=>"",
    0x90bd=>"",
    0x90be=>"",
    0x90c3=>"",
    0x90c4=>"",
    0x90c5=>"",
    0x90c7=>"",
    0x90c8=>"",
    0x90cc=>"",
    0x90d2=>"",
    0x90d5=>"",
    0x90d7=>"",
    0x90d8=>"",
    0x90d9=>"",
    0x90dc=>"",
    0x90dd=>"",
    0x90de=>"\xfb\xfa",
    0x90df=>"",
    0x90e5=>"",
    0x90eb=>"",
    0x90ef=>"",
    0x90f0=>"",
    0x90f4=>"",
    0x90f6=>"",
    0x90fe=>"",
    0x90ff=>"",
    0x9100=>"",
    0x9104=>"",
    0x9105=>"",
    0x9106=>"",
    0x9108=>"",
    0x910d=>"",
    0x9110=>"",
    0x9114=>"",
    0x9115=>"\xfb\xfc",
    0x9116=>"",
    0x9117=>"",
    0x9118=>"",
    0x911a=>"",
    0x911c=>"",
    0x911e=>"",
    0x9120=>"",
    0x9122=>"",
    0x9123=>"",
    0x9125=>"",
    0x9127=>"\xfb\xfd",
    0x9129=>"",
    0x912e=>"",
    0x912f=>"",
    0x9131=>"",
    0x9134=>"",
    0x9136=>"",
    0x9137=>"",
    0x9139=>"",
    0x913a=>"",
    0x913c=>"",
    0x913d=>"",
    0x9143=>"",
    0x9147=>"",
    0x9148=>"",
    0x914f=>"",
    0x9153=>"",
    0x9157=>"",
    0x9159=>"",
    0x915a=>"",
    0x915b=>"",
    0x9161=>"",
    0x9164=>"",
    0x9167=>"",
    0x916d=>"",
    0x9174=>"",
    0x9179=>"",
    0x917a=>"",
    0x917b=>"",
    0x9181=>"",
    0x9183=>"",
    0x9185=>"",
    0x9186=>"",
    0x918a=>"",
    0x918e=>"",
    0x9191=>"",
    0x9193=>"",
    0x9194=>"",
    0x9195=>"",
    0x9198=>"",
    0x919e=>"",
    0x91a1=>"",
    0x91a6=>"",
    0x91a8=>"",
    0x91ac=>"",
    0x91ad=>"",
    0x91ae=>"",
    0x91b0=>"",
    0x91b1=>"",
    0x91b2=>"",
    0x91b3=>"",
    0x91b6=>"",
    0x91bb=>"",
    0x91bc=>"",
    0x91bd=>"",
    0x91bf=>"",
    0x91c2=>"",
    0x91c3=>"",
    0x91c5=>"",
    0x91d3=>"",
    0x91d4=>"",
    0x91d7=>"\xfc\xa1",
    0x91d9=>"",
    0x91da=>"\xfb\xfe",
    0x91de=>"\xfc\xa2",
    0x91e4=>"\xfc\xa5",
    0x91e5=>"\xfc\xa6",
    0x91e9=>"",
    0x91ea=>"",
    0x91ec=>"",
    0x91ed=>"\xfc\xa3",
    0x91ee=>"\xfc\xa4",
    0x91ef=>"",
    0x91f0=>"",
    0x91f1=>"",
    0x91f7=>"",
    0x91f9=>"",
    0x91fb=>"",
    0x91fd=>"",
    0x9200=>"",
    0x9201=>"",
    0x9204=>"",
    0x9205=>"",
    0x9206=>"\xfc\xa7",
    0x9207=>"",
    0x9209=>"",
    0x920a=>"\xfc\xa9",
    0x920c=>"",
    0x9210=>"\xfc\xa8",
    0x9212=>"",
    0x9213=>"",
    0x9216=>"",
    0x9218=>"",
    0x921c=>"",
    0x921d=>"",
    0x9223=>"",
    0x9224=>"",
    0x9225=>"",
    0x9226=>"",
    0x9228=>"",
    0x922e=>"",
    0x922f=>"",
    0x9230=>"",
    0x9233=>"",
    0x9235=>"",
    0x9236=>"",
    0x9238=>"",
    0x9239=>"\xfc\xb0",
    0x923a=>"\xfc\xaa",
    0x923c=>"\xfc\xac",
    0x923e=>"",
    0x9240=>"\xfc\xab",
    0x9242=>"",
    0x9243=>"",
    0x9246=>"",
    0x9247=>"",
    0x924a=>"",
    0x924d=>"",
    0x924e=>"\xfc\xad",
    0x924f=>"",
    0x9251=>"\xfc\xaf",
    0x9258=>"",
    0x9259=>"\xfc\xae",
    0x925c=>"",
    0x925d=>"",
    0x9260=>"",
    0x9261=>"",
    0x9265=>"",
    0x9267=>"\xfc\xb1",
    0x9268=>"",
    0x9269=>"",
    0x926e=>"",
    0x926f=>"",
    0x9270=>"",
    0x9275=>"",
    0x9276=>"",
    0x9277=>"\xfc\xb3",
    0x9278=>"\xfc\xb4",
    0x9279=>"",
    0x927b=>"",
    0x927c=>"",
    0x927d=>"",
    0x927f=>"",
    0x9288=>"\xf9\xa4",
    0x9289=>"",
    0x928a=>"",
    0x928d=>"",
    0x928e=>"",
    0x9292=>"",
    0x9297=>"",
    0x9299=>"",
    0x929f=>"",
    0x92a0=>"",
    0x92a4=>"",
    0x92a5=>"",
    0x92a7=>"\xfc\xb2",
    0x92a8=>"",
    0x92ab=>"",
    0x92af=>"",
    0x92b2=>"",
    0x92b6=>"",
    0x92b8=>"",
    0x92ba=>"",
    0x92bb=>"",
    0x92bc=>"",
    0x92bd=>"",
    0x92bf=>"",
    0x92c0=>"",
    0x92c1=>"",
    0x92c2=>"",
    0x92c3=>"",
    0x92c5=>"",
    0x92c6=>"",
    0x92c7=>"",
    0x92c8=>"",
    0x92cb=>"",
    0x92cc=>"",
    0x92cd=>"",
    0x92ce=>"",
    0x92d0=>"\xfc\xb8",
    0x92d3=>"\xfc\xbc",
    0x92d5=>"\xfc\xba",
    0x92d7=>"\xfc\xb6",
    0x92d8=>"",
    0x92d9=>"\xfc\xb7",
    0x92dc=>"",
    0x92dd=>"",
    0x92df=>"",
    0x92e0=>"\xfc\xbb",
    0x92e1=>"",
    0x92e3=>"",
    0x92e5=>"",
    0x92e7=>"\xfc\xb5",
    0x92e8=>"",
    0x92ec=>"",
    0x92ee=>"",
    0x92f0=>"",
    0x92f9=>"\xf9\xaa",
    0x92fb=>"\xfc\xbf",
    0x92ff=>"\xfc\xc2",
    0x9300=>"",
    0x9302=>"\xfc\xc4",
    0x9308=>"",
    0x930d=>"",
    0x9311=>"",
    0x9314=>"",
    0x9315=>"",
    0x931c=>"",
    0x931d=>"\xfc\xc3",
    0x931e=>"\xfc\xc1",
    0x931f=>"",
    0x9321=>"\xfc\xbe",
    0x9324=>"",
    0x9325=>"\xfc\xbd",
    0x9327=>"",
    0x9329=>"",
    0x932a=>"",
    0x9333=>"",
    0x9334=>"",
    0x9336=>"",
    0x9337=>"",
    0x9347=>"",
    0x9348=>"\xf9\xa3",
    0x9349=>"",
    0x9350=>"",
    0x9351=>"",
    0x9352=>"",
    0x9355=>"",
    0x9357=>"\xfc\xc6",
    0x9358=>"",
    0x935a=>"",
    0x935e=>"",
    0x9364=>"",
    0x9365=>"",
    0x9367=>"",
    0x9369=>"",
    0x936a=>"",
    0x936d=>"",
    0x936f=>"",
    0x9370=>"\xfc\xc5",
    0x9371=>"",
    0x9373=>"",
    0x9374=>"",
    0x9376=>"",
    0x937a=>"",
    0x937d=>"",
    0x937f=>"",
    0x9380=>"",
    0x9381=>"",
    0x9382=>"",
    0x9388=>"",
    0x938a=>"",
    0x938b=>"",
    0x938d=>"",
    0x938f=>"",
    0x9392=>"",
    0x9395=>"",
    0x9398=>"",
    0x939b=>"",
    0x939e=>"",
    0x93a1=>"",
    0x93a3=>"",
    0x93a4=>"\xfc\xc7",
    0x93a6=>"",
    0x93a8=>"",
    0x93a9=>"",
    0x93ab=>"",
    0x93b4=>"",
    0x93b5=>"",
    0x93b6=>"",
    0x93ba=>"",
    0x93c1=>"",
    0x93c4=>"",
    0x93c5=>"",
    0x93c6=>"\xfc\xc8",
    0x93c7=>"",
    0x93c9=>"",
    0x93ca=>"",
    0x93cb=>"",
    0x93cc=>"",
    0x93cd=>"",
    0x93d3=>"",
    0x93d9=>"",
    0x93dc=>"",
    0x93de=>"\xfc\xc9",
    0x93df=>"",
    0x93e2=>"",
    0x93e6=>"",
    0x93e7=>"",
    0x93f7=>"",
    0x93f8=>"\xfc\xca",
    0x93f9=>"",
    0x93fa=>"",
    0x93fb=>"",
    0x93fd=>"",
    0x9401=>"",
    0x9402=>"",
    0x9404=>"",
    0x9408=>"",
    0x9409=>"",
    0x940d=>"",
    0x940e=>"",
    0x940f=>"",
    0x9415=>"",
    0x9416=>"",
    0x9417=>"",
    0x941f=>"",
    0x942e=>"",
    0x942f=>"",
    0x9431=>"\xfc\xcb",
    0x9432=>"",
    0x9433=>"",
    0x9434=>"",
    0x943b=>"",
    0x943d=>"",
    0x943f=>"",
    0x9443=>"",
    0x9445=>"\xfc\xcc",
    0x9448=>"\xfc\xcd",
    0x944a=>"",
    0x944c=>"",
    0x9455=>"",
    0x9459=>"",
    0x945c=>"",
    0x945f=>"",
    0x9461=>"",
    0x9463=>"",
    0x9468=>"",
    0x946b=>"",
    0x946d=>"",
    0x946e=>"",
    0x946f=>"",
    0x9471=>"",
    0x9472=>"",
    0x9483=>"",
    0x9484=>"",
    0x9578=>"",
    0x9579=>"",
    0x957e=>"",
    0x9584=>"",
    0x9588=>"",
    0x958c=>"",
    0x958d=>"",
    0x958e=>"",
    0x9592=>"\xfc\xce",
    0x959d=>"",
    0x959e=>"",
    0x959f=>"",
    0x95a1=>"",
    0x95a6=>"",
    0x95a9=>"",
    0x95ab=>"",
    0x95ac=>"",
    0x95b4=>"",
    0x95b6=>"",
    0x95ba=>"",
    0x95bd=>"",
    0x95bf=>"",
    0x95c6=>"",
    0x95c8=>"",
    0x95c9=>"",
    0x95cb=>"",
    0x95d0=>"",
    0x95d1=>"",
    0x95d2=>"",
    0x95d3=>"",
    0x95d9=>"",
    0x95da=>"",
    0x95dd=>"",
    0x95de=>"",
    0x95df=>"",
    0x95e0=>"",
    0x95e4=>"",
    0x95e6=>"",
    0x961d=>"",
    0x961e=>"",
    0x9622=>"",
    0x9624=>"",
    0x9625=>"",
    0x9626=>"",
    0x962c=>"",
    0x9631=>"",
    0x9633=>"",
    0x9637=>"",
    0x9638=>"",
    0x9639=>"",
    0x963a=>"",
    0x963c=>"",
    0x963d=>"",
    0x9641=>"",
    0x9652=>"",
    0x9654=>"",
    0x9656=>"",
    0x9657=>"",
    0x9658=>"",
    0x9661=>"",
    0x966e=>"",
    0x9674=>"",
    0x967b=>"",
    0x967c=>"",
    0x967e=>"",
    0x967f=>"",
    0x9681=>"",
    0x9682=>"",
    0x9683=>"",
    0x9684=>"",
    0x9689=>"",
    0x9691=>"",
    0x9696=>"",
    0x969a=>"",
    0x969d=>"\xfc\xd1",
    0x969f=>"",
    0x96a4=>"",
    0x96a5=>"",
    0x96a6=>"",
    0x96a9=>"",
    0x96ae=>"",
    0x96af=>"\xfc\xd2",
    0x96b3=>"",
    0x96ba=>"",
    0x96ca=>"",
    0x96d2=>"",
    0x96d8=>"",
    0x96da=>"",
    0x96dd=>"",
    0x96de=>"",
    0x96df=>"",
    0x96e9=>"",
    0x96ef=>"",
    0x96f1=>"",
    0x96fa=>"",
    0x9702=>"",
    0x9703=>"",
    0x9705=>"",
    0x9709=>"",
    0x971a=>"",
    0x971b=>"",
    0x971d=>"",
    0x9721=>"",
    0x9722=>"",
    0x9723=>"",
    0x9728=>"",
    0x9731=>"",
    0x9733=>"\xfc\xd3",
    0x973b=>"\xfc\xd4",
    0x9741=>"",
    0x9743=>"\xfc\xd5",
    0x974a=>"",
    0x974d=>"\xfc\xd6",
    0x974e=>"",
    0x974f=>"\xfc\xd7",
    0x9751=>"\xfc\xd8",
    0x9755=>"\xfc\xd9",
    0x9757=>"",
    0x9758=>"",
    0x975a=>"",
    0x975b=>"",
    0x9763=>"",
    0x9767=>"",
    0x976a=>"",
    0x976e=>"",
    0x9773=>"",
    0x9776=>"",
    0x9777=>"",
    0x9778=>"",
    0x977b=>"",
    0x977d=>"",
    0x977f=>"",
    0x9780=>"",
    0x9789=>"",
    0x9795=>"",
    0x9796=>"",
    0x9797=>"",
    0x9799=>"",
    0x979a=>"",
    0x979e=>"",
    0x979f=>"",
    0x97a2=>"",
    0x97ac=>"",
    0x97ae=>"",
    0x97b1=>"",
    0x97b2=>"",
    0x97b5=>"",
    0x97b6=>"",
    0x97b8=>"",
    0x97b9=>"",
    0x97ba=>"",
    0x97bc=>"",
    0x97be=>"",
    0x97bf=>"",
    0x97c1=>"",
    0x97c4=>"",
    0x97c5=>"",
    0x97c7=>"",
    0x97c9=>"",
    0x97ca=>"",
    0x97cc=>"",
    0x97cd=>"",
    0x97ce=>"",
    0x97d0=>"",
    0x97d1=>"",
    0x97d4=>"",
    0x97d7=>"",
    0x97d8=>"",
    0x97d9=>"",
    0x97db=>"",
    0x97dd=>"",
    0x97de=>"",
    0x97e0=>"",
    0x97e1=>"",
    0x97e4=>"",
    0x97ef=>"",
    0x97f1=>"",
    0x97f4=>"",
    0x97f7=>"",
    0x97f8=>"",
    0x97fa=>"",
    0x9807=>"",
    0x980a=>"",
    0x980d=>"",
    0x980e=>"",
    0x9814=>"",
    0x9816=>"",
    0x9819=>"",
    0x981c=>"",
    0x981e=>"",
    0x9820=>"",
    0x9823=>"",
    0x9825=>"",
    0x9826=>"",
    0x982b=>"",
    0x982e=>"",
    0x982f=>"",
    0x9830=>"",
    0x9832=>"",
    0x9833=>"",
    0x9835=>"",
    0x983e=>"",
    0x9844=>"",
    0x9847=>"",
    0x984a=>"",
    0x9851=>"",
    0x9852=>"",
    0x9853=>"",
    0x9856=>"",
    0x9857=>"\xfc\xda",
    0x9859=>"",
    0x985a=>"",
    0x9862=>"",
    0x9863=>"",
    0x9865=>"\xfc\xdb",
    0x9866=>"",
    0x986a=>"",
    0x986c=>"",
    0x98ab=>"",
    0x98ad=>"",
    0x98ae=>"",
    0x98b0=>"",
    0x98b4=>"",
    0x98b7=>"",
    0x98b8=>"",
    0x98ba=>"",
    0x98bb=>"",
    0x98bf=>"",
    0x98c2=>"",
    0x98c5=>"",
    0x98c8=>"",
    0x98cc=>"",
    0x98e1=>"",
    0x98e3=>"",
    0x98e5=>"",
    0x98e6=>"",
    0x98e7=>"",
    0x98ea=>"",
    0x98f3=>"",
    0x98f6=>"",
    0x9902=>"",
    0x9907=>"",
    0x9908=>"",
    0x9911=>"",
    0x9915=>"",
    0x9916=>"",
    0x9917=>"",
    0x991a=>"",
    0x991b=>"",
    0x991c=>"",
    0x991f=>"",
    0x9922=>"",
    0x9926=>"",
    0x9927=>"\xfc\xde",
    0x992b=>"",
    0x9931=>"",
    0x9932=>"",
    0x9933=>"",
    0x9934=>"",
    0x9935=>"",
    0x9939=>"",
    0x993a=>"",
    0x993b=>"",
    0x993c=>"",
    0x9940=>"",
    0x9941=>"",
    0x9946=>"",
    0x9947=>"",
    0x9948=>"",
    0x994d=>"",
    0x994e=>"",
    0x9954=>"",
    0x9958=>"",
    0x9959=>"",
    0x995b=>"",
    0x995c=>"",
    0x995e=>"",
    0x995f=>"",
    0x9960=>"",
    0x999b=>"",
    0x999d=>"",
    0x999e=>"\xfc\xe0",
    0x999f=>"",
    0x99a6=>"",
    0x99b0=>"",
    0x99b1=>"",
    0x99b2=>"",
    0x99b5=>"",
    0x99b9=>"",
    0x99ba=>"",
    0x99bd=>"",
    0x99bf=>"",
    0x99c3=>"",
    0x99c9=>"",
    0x99d3=>"",
    0x99d4=>"",
    0x99d9=>"",
    0x99da=>"",
    0x99dc=>"",
    0x99de=>"",
    0x99e7=>"",
    0x99ea=>"",
    0x99eb=>"",
    0x99ec=>"",
    0x99f0=>"",
    0x99f4=>"",
    0x99f5=>"",
    0x99f9=>"",
    0x99fd=>"",
    0x99fe=>"",
    0x9a02=>"",
    0x9a03=>"",
    0x9a04=>"",
    0x9a0b=>"",
    0x9a0c=>"",
    0x9a10=>"",
    0x9a11=>"",
    0x9a16=>"",
    0x9a1e=>"",
    0x9a20=>"",
    0x9a22=>"",
    0x9a23=>"",
    0x9a24=>"",
    0x9a27=>"",
    0x9a2d=>"",
    0x9a2e=>"",
    0x9a33=>"",
    0x9a35=>"",
    0x9a36=>"",
    0x9a38=>"",
    0x9a41=>"",
    0x9a44=>"",
    0x9a47=>"",
    0x9a4a=>"",
    0x9a4b=>"",
    0x9a4c=>"",
    0x9a4e=>"\xfc\xe1",
    0x9a51=>"",
    0x9a54=>"",
    0x9a56=>"",
    0x9a5d=>"",
    0x9aaa=>"",
    0x9aac=>"",
    0x9aae=>"",
    0x9aaf=>"",
    0x9ab2=>"",
    0x9ab4=>"",
    0x9ab5=>"",
    0x9ab6=>"",
    0x9ab9=>"",
    0x9abb=>"",
    0x9abe=>"",
    0x9abf=>"",
    0x9ac1=>"",
    0x9ac3=>"",
    0x9ac6=>"",
    0x9ac8=>"",
    0x9ace=>"",
    0x9ad0=>"",
    0x9ad2=>"",
    0x9ad5=>"",
    0x9ad6=>"",
    0x9ad7=>"",
    0x9ad9=>"\xfc\xe2",
    0x9adb=>"",
    0x9adc=>"\xfc\xe3",
    0x9ae0=>"",
    0x9ae4=>"",
    0x9ae5=>"",
    0x9ae7=>"",
    0x9ae9=>"",
    0x9aec=>"",
    0x9af2=>"",
    0x9af3=>"",
    0x9af5=>"",
    0x9af9=>"",
    0x9afa=>"",
    0x9afd=>"",
    0x9aff=>"",
    0x9b00=>"",
    0x9b01=>"",
    0x9b02=>"",
    0x9b03=>"",
    0x9b04=>"",
    0x9b05=>"",
    0x9b08=>"",
    0x9b09=>"",
    0x9b0b=>"",
    0x9b0c=>"",
    0x9b0d=>"",
    0x9b0e=>"",
    0x9b10=>"",
    0x9b12=>"",
    0x9b16=>"",
    0x9b19=>"",
    0x9b1b=>"",
    0x9b1c=>"",
    0x9b20=>"",
    0x9b26=>"",
    0x9b2b=>"",
    0x9b2d=>"",
    0x9b33=>"",
    0x9b34=>"",
    0x9b35=>"",
    0x9b37=>"",
    0x9b39=>"",
    0x9b3a=>"",
    0x9b3d=>"",
    0x9b48=>"",
    0x9b4b=>"",
    0x9b4c=>"",
    0x9b55=>"",
    0x9b56=>"",
    0x9b57=>"",
    0x9b5b=>"",
    0x9b5e=>"",
    0x9b61=>"",
    0x9b63=>"",
    0x9b65=>"",
    0x9b66=>"",
    0x9b68=>"",
    0x9b6a=>"",
    0x9b6b=>"",
    0x9b6c=>"",
    0x9b6d=>"",
    0x9b6e=>"",
    0x9b72=>"\xfc\xe5",
    0x9b73=>"",
    0x9b75=>"\xfc\xe4",
    0x9b77=>"",
    0x9b78=>"",
    0x9b79=>"",
    0x9b7f=>"",
    0x9b80=>"",
    0x9b84=>"",
    0x9b85=>"",
    0x9b86=>"",
    0x9b87=>"",
    0x9b89=>"",
    0x9b8a=>"",
    0x9b8b=>"",
    0x9b8d=>"",
    0x9b8f=>"\xfc\xe6",
    0x9b90=>"",
    0x9b94=>"",
    0x9b9a=>"",
    0x9b9d=>"",
    0x9b9e=>"",
    0x9ba6=>"",
    0x9ba7=>"",
    0x9ba9=>"",
    0x9bac=>"",
    0x9bb0=>"",
    0x9bb1=>"\xfc\xe7",
    0x9bb2=>"",
    0x9bb7=>"",
    0x9bb8=>"",
    0x9bbb=>"\xfc\xe8",
    0x9bbc=>"",
    0x9bbe=>"",
    0x9bbf=>"",
    0x9bc1=>"",
    0x9bc7=>"",
    0x9bc8=>"",
    0x9bce=>"",
    0x9bd0=>"",
    0x9bd7=>"",
    0x9bd8=>"",
    0x9bdd=>"",
    0x9bdf=>"",
    0x9be5=>"",
    0x9be7=>"",
    0x9bea=>"",
    0x9beb=>"",
    0x9bef=>"",
    0x9bf3=>"",
    0x9bf7=>"",
    0x9bf8=>"",
    0x9bf9=>"",
    0x9bfa=>"",
    0x9bfd=>"",
    0x9bff=>"",
    0x9c00=>"\xfc\xe9",
    0x9c02=>"",
    0x9c0b=>"",
    0x9c0f=>"",
    0x9c11=>"",
    0x9c16=>"",
    0x9c18=>"",
    0x9c19=>"",
    0x9c1a=>"",
    0x9c1c=>"",
    0x9c1e=>"",
    0x9c22=>"",
    0x9c23=>"",
    0x9c26=>"",
    0x9c27=>"",
    0x9c28=>"",
    0x9c29=>"",
    0x9c2a=>"",
    0x9c31=>"",
    0x9c35=>"",
    0x9c36=>"",
    0x9c37=>"",
    0x9c3d=>"",
    0x9c41=>"",
    0x9c43=>"",
    0x9c44=>"",
    0x9c45=>"",
    0x9c49=>"",
    0x9c4a=>"",
    0x9c4e=>"",
    0x9c4f=>"",
    0x9c50=>"",
    0x9c53=>"",
    0x9c54=>"",
    0x9c56=>"",
    0x9c58=>"",
    0x9c5b=>"",
    0x9c5c=>"",
    0x9c5d=>"",
    0x9c5e=>"",
    0x9c5f=>"",
    0x9c63=>"",
    0x9c68=>"",
    0x9c69=>"",
    0x9c6a=>"",
    0x9c6b=>"",
    0x9c6e=>"",
    0x9c70=>"",
    0x9c72=>"",
    0x9c75=>"",
    0x9c77=>"",
    0x9c7b=>"",
    0x9ce6=>"",
    0x9cf2=>"",
    0x9cf7=>"",
    0x9cf9=>"",
    0x9d02=>"",
    0x9d0b=>"",
    0x9d11=>"",
    0x9d17=>"",
    0x9d18=>"",
    0x9d1c=>"",
    0x9d1d=>"",
    0x9d1e=>"",
    0x9d2f=>"",
    0x9d30=>"",
    0x9d32=>"",
    0x9d33=>"",
    0x9d34=>"",
    0x9d3a=>"",
    0x9d3c=>"",
    0x9d3d=>"",
    0x9d42=>"",
    0x9d43=>"",
    0x9d45=>"",
    0x9d47=>"",
    0x9d4a=>"",
    0x9d53=>"",
    0x9d54=>"",
    0x9d5f=>"",
    0x9d62=>"",
    0x9d63=>"",
    0x9d65=>"",
    0x9d69=>"",
    0x9d6a=>"",
    0x9d6b=>"\xfc\xeb",
    0x9d70=>"\xfc\xea",
    0x9d76=>"",
    0x9d77=>"",
    0x9d7b=>"",
    0x9d7c=>"",
    0x9d7e=>"",
    0x9d83=>"",
    0x9d84=>"",
    0x9d86=>"",
    0x9d8a=>"",
    0x9d8d=>"",
    0x9d8e=>"",
    0x9d92=>"",
    0x9d93=>"",
    0x9d95=>"",
    0x9d96=>"",
    0x9d97=>"",
    0x9d98=>"",
    0x9da1=>"",
    0x9daa=>"",
    0x9dac=>"",
    0x9dae=>"",
    0x9db1=>"",
    0x9db5=>"",
    0x9db9=>"",
    0x9dbc=>"",
    0x9dbf=>"",
    0x9dc3=>"",
    0x9dc7=>"",
    0x9dc9=>"",
    0x9dca=>"",
    0x9dd4=>"",
    0x9dd5=>"",
    0x9dd6=>"",
    0x9dd7=>"",
    0x9dda=>"",
    0x9dde=>"",
    0x9ddf=>"",
    0x9de0=>"",
    0x9de5=>"",
    0x9de7=>"",
    0x9de9=>"",
    0x9deb=>"",
    0x9dee=>"",
    0x9df0=>"",
    0x9df3=>"",
    0x9df4=>"",
    0x9dfe=>"",
    0x9e02=>"",
    0x9e07=>"",
    0x9e0a=>"",
    0x9e0e=>"",
    0x9e10=>"",
    0x9e11=>"",
    0x9e12=>"",
    0x9e15=>"",
    0x9e16=>"",
    0x9e19=>"\xfc\xed",
    0x9e1c=>"",
    0x9e1d=>"",
    0x9e7a=>"",
    0x9e7b=>"",
    0x9e7c=>"",
    0x9e80=>"",
    0x9e82=>"",
    0x9e83=>"",
    0x9e84=>"",
    0x9e85=>"",
    0x9e87=>"",
    0x9e8e=>"",
    0x9e8f=>"",
    0x9e96=>"",
    0x9e98=>"",
    0x9e9b=>"",
    0x9e9e=>"",
    0x9ea4=>"",
    0x9ea8=>"",
    0x9eac=>"",
    0x9eae=>"",
    0x9eaf=>"",
    0x9eb0=>"",
    0x9eb3=>"",
    0x9eb4=>"",
    0x9eb5=>"",
    0x9ec6=>"",
    0x9ec8=>"",
    0x9ecb=>"",
    0x9ed1=>"\xfc\xee",
    0x9ed5=>"",
    0x9edf=>"",
    0x9ee4=>"",
    0x9ee7=>"",
    0x9eec=>"",
    0x9eed=>"",
    0x9eee=>"",
    0x9ef0=>"",
    0x9ef1=>"",
    0x9ef2=>"",
    0x9ef5=>"",
    0x9ef8=>"",
    0x9eff=>"",
    0x9f02=>"",
    0x9f03=>"",
    0x9f09=>"",
    0x9f0f=>"",
    0x9f10=>"",
    0x9f11=>"",
    0x9f12=>"",
    0x9f14=>"",
    0x9f16=>"",
    0x9f17=>"",
    0x9f19=>"",
    0x9f1a=>"",
    0x9f1b=>"",
    0x9f1f=>"",
    0x9f22=>"",
    0x9f26=>"",
    0x9f2a=>"",
    0x9f2b=>"",
    0x9f2f=>"",
    0x9f31=>"",
    0x9f32=>"",
    0x9f34=>"",
    0x9f37=>"",
    0x9f39=>"",
    0x9f3a=>"",
    0x9f3c=>"",
    0x9f3d=>"",
    0x9f3f=>"",
    0x9f41=>"",
    0x9f43=>"",
    0x9f44=>"",
    0x9f45=>"",
    0x9f46=>"",
    0x9f47=>"",
    0x9f53=>"",
    0x9f55=>"",
    0x9f56=>"",
    0x9f57=>"",
    0x9f58=>"",
    0x9f5a=>"",
    0x9f5d=>"",
    0x9f5e=>"",
    0x9f68=>"",
    0x9f69=>"",
    0x9f6d=>"",
    0x9f6e=>"",
    0x9f6f=>"",
    0x9f70=>"",
    0x9f71=>"",
    0x9f73=>"",
    0x9f75=>"",
    0x9f7a=>"",
    0x9f7d=>"",
    0x9f8f=>"",
    0x9f90=>"",
    0x9f91=>"",
    0x9f92=>"",
    0x9f94=>"",
    0x9f96=>"",
    0x9f97=>"",
    0x9f9e=>"",
    0x9fa1=>"",
    0x9fa2=>"",
    0x9fa3=>"",
    0x9fa5=>"",
    0xf929=>"\xfa\xc6",
    0xf9dc=>"\xfc\xcf",
    0xfa0e=>"\xf9\xd4",
    0xfa0f=>"\xf9\xdf",
    0xfa10=>"\xf9\xe0",
    0xfa11=>"\xf9\xf5",
    0xfa12=>"\xfa\xbe",
    0xfa13=>"\xfa\xce",
    0xfa14=>"\xfa\xd0",
    0xfa15=>"\xfa\xfb",
    0xfa16=>"\xfb\xa3",
    0xfa17=>"\xfb\xba",
    0xfa18=>"\xfb\xc2",
    0xfa19=>"\xfb\xc3",
    0xfa1a=>"\xfb\xc4",
    0xfa1b=>"\xfb\xc6",
    0xfa1c=>"\xfb\xca",
    0xfa1d=>"\xfb\xcd",
    0xfa1e=>"\xfb\xd6",
    0xfa1f=>"\xfb\xe1",
    0xfa20=>"\xfb\xe3",
    0xfa21=>"\xfb\xe4",
    0xfa22=>"\xfb\xed",
    0xfa23=>"\xfb\xf5",
    0xfa24=>"\xfb\xf7",
    0xfa25=>"\xfb\xf8",
    0xfa26=>"\xfb\xfb",
    0xfa27=>"\xfc\xb9",
    0xfa28=>"\xfc\xc0",
    0xfa29=>"\xfc\xd0",
    0xfa2a=>"\xfc\xdc",
    0xfa2b=>"\xfc\xdd",
    0xfa2c=>"\xfc\xdf",
    0xfa2d=>"\xfc\xec",
    0xff02=>"\xfc\xfe",
    0xff07=>"\xfc\xfd",
    0xff0d=>"\xa1\xdd",
    0xff3c=>"\xa1\xc0",
    0xff5e=>"\xa1\xc1",
    0xffe0=>"\xa1\xf1",
    0xffe1=>"\xa1\xf2",
    0xffe2=>"\xa2\xcc",
    0xffe4=>"\xfc\xfc",
  }


   def self.cp51932()
    self.euc_hook = proc do |e|
      CP51932_UCS_MAP[e]
    end

    self.unicode_euc_hook = proc do |u|
      UCS_CP51932_MAP[u]
    end
  end
end

Uconv.cp51932
