/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WrappedPlainView
extends BoxView
implements TabExpander {
    Color selectedColor;
    Color unselectedColor;
    Color disabledColor;
    protected FontMetrics metrics;
    boolean wordWrap;
    ViewFactory viewFactory;
    private transient Segment lineBuffer;

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    public float nextTabStop(float x, int tabStop) {
        JTextComponent host = (JTextComponent)this.getContainer();
        float tabSizePixels = this.getTabSize() * host.getFontMetrics(host.getFont()).charWidth('m');
        return (float)(Math.floor(x / tabSizePixels) + 1.0) * tabSizePixels;
    }

    protected int getTabSize() {
        Object tabSize = this.getDocument().getProperty("tabSize");
        if (tabSize == null) {
            return 8;
        }
        return (Integer)tabSize;
    }

    protected void drawLine(int p0, int p1, Graphics g, int x, int y) {
        try {
            this.drawUnselectedText(g, x, y, p0, p1);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.selectedColor);
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, 0);
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        JTextComponent textComponent = (JTextComponent)this.getContainer();
        if (textComponent.isEnabled()) {
            g.setColor(this.unselectedColor);
        } else {
            g.setColor(this.disabledColor);
        }
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, segment.offset);
    }

    protected void loadChildren(ViewFactory f) {
        Element root = this.getElement();
        int numChildren = root.getElementCount();
        if (numChildren == 0) {
            return;
        }
        View[] children = new View[numChildren];
        int i = 0;
        while (i < numChildren) {
            children[i] = new WrappedLine(root.getElement(i));
            ++i;
        }
        this.replace(0, 0, children);
    }

    protected int calculateBreakPosition(int p0, int p1) {
        Container c = this.getContainer();
        Rectangle alloc = c.isValid() ? c.getBounds() : new Rectangle(c.getPreferredSize());
        this.updateMetrics();
        try {
            this.getDocument().getText(p0, p1 - p0, this.getLineBuffer());
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        if (this.wordWrap) {
            return p0 + Utilities.getBreakLocation(this.lineBuffer, this.metrics, alloc.x, alloc.x + alloc.width, this, 0);
        }
        return p0 + Utilities.getTabbedTextOffset(this.lineBuffer, this.metrics, alloc.x, alloc.x + alloc.width, this, 0);
    }

    void updateMetrics() {
        Container component = this.getContainer();
        this.metrics = component.getFontMetrics(component.getFont());
    }

    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        return super.getPreferredSpan(axis);
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, this.viewFactory);
        this.getContainer().repaint();
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, this.viewFactory);
        this.getContainer().repaint();
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, this.viewFactory);
        this.getContainer().repaint();
    }

    public void paint(Graphics g, Shape a) {
        this.updateMetrics();
        super.paint(g, a);
    }

    public void setSize(float width, float height) {
        this.updateMetrics();
        super.setSize(width, height);
    }

    private final /* synthetic */ void this() {
        this.viewFactory = new WrappedLineCreator();
    }

    public WrappedPlainView(Element elem) {
        this(elem, false);
    }

    public WrappedPlainView(Element elem, boolean wordWrap) {
        super(elem, 1);
        this.this();
        this.wordWrap = wordWrap;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WrappedLine
    extends View {
        int numLines;

        public void paint(Graphics g, Shape s) {
            WrappedPlainView.this.updateMetrics();
            JTextComponent textComponent = (JTextComponent)this.getContainer();
            g.setFont(textComponent.getFont());
            WrappedPlainView.this.selectedColor = textComponent.getSelectedTextColor();
            WrappedPlainView.this.unselectedColor = textComponent.getForeground();
            WrappedPlainView.this.disabledColor = textComponent.getDisabledTextColor();
            Rectangle rect = s.getBounds();
            int lineHeight = WrappedPlainView.this.metrics.getHeight();
            int end = this.getEndOffset();
            int currStart = this.getStartOffset();
            while (currStart < end) {
                int currEnd = WrappedPlainView.this.calculateBreakPosition(currStart, end);
                WrappedPlainView.this.drawLine(currStart, currEnd, g, rect.x, rect.y);
                rect.y += lineHeight;
                if (currEnd == currStart) {
                    ++currStart;
                    continue;
                }
                currStart = currEnd;
            }
        }

        int determineNumLines() {
            int end = this.getEndOffset();
            if (end == 0) {
                return 0;
            }
            this.numLines = 0;
            int i = this.getStartOffset();
            while (i < end) {
                ++this.numLines;
                int breakPoint = WrappedPlainView.this.calculateBreakPosition(i, end);
                if (breakPoint == i) {
                    ++i;
                    continue;
                }
                i = breakPoint;
            }
            return this.numLines;
        }

        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                return WrappedPlainView.this.getWidth();
            }
            if (axis == 1) {
                return this.numLines * WrappedPlainView.this.metrics.getHeight();
            }
            throw new IllegalArgumentException("Invalid axis for getPreferredSpan: " + axis);
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Segment s = WrappedPlainView.this.getLineBuffer();
            int lineHeight = WrappedPlainView.this.metrics.getHeight();
            Rectangle rect = a.getBounds();
            rect.height = lineHeight;
            rect.width = 1;
            int currLineStart = this.getStartOffset();
            int end = this.getEndOffset();
            if (pos < currLineStart || pos >= end) {
                throw new BadLocationException("invalid offset", pos);
            }
            while (true) {
                int currLineEnd = WrappedPlainView.this.calculateBreakPosition(currLineStart, end);
                if (pos >= currLineStart && pos < currLineEnd || pos == end - 1) {
                    try {
                        this.getDocument().getText(currLineStart, pos - currLineStart, s);
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                    rect.x += Utilities.getTabbedTextWidth(s, WrappedPlainView.this.metrics, rect.x, WrappedPlainView.this, currLineStart);
                    return rect;
                }
                rect.y += lineHeight;
                if (currLineEnd == currLineStart) {
                    currLineStart = end;
                    continue;
                }
                currLineStart = currLineEnd;
            }
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
            Segment s = WrappedPlainView.this.getLineBuffer();
            Rectangle rect = a.getBounds();
            int currLineStart = this.getStartOffset();
            int end = this.getEndOffset();
            int lineHeight = WrappedPlainView.this.metrics.getHeight();
            if (y < (float)rect.y) {
                return currLineStart;
            }
            if (y > (float)(rect.y + rect.height)) {
                return end - 1;
            }
            while (true) {
                int currLineEnd = WrappedPlainView.this.calculateBreakPosition(currLineStart, end);
                if (y >= (float)rect.y && y < (float)(rect.y + lineHeight)) {
                    if (x < (float)rect.x) {
                        return currLineStart;
                    }
                    if (x > (float)(rect.x + rect.width)) {
                        return currLineEnd - 1;
                    }
                    try {
                        this.getDocument().getText(currLineStart, end - currLineStart, s);
                    }
                    catch (BadLocationException mark) {
                        // empty catch block
                    }
                    int mark = Utilities.getTabbedTextOffset(s, WrappedPlainView.this.metrics, rect.x, (int)x, WrappedPlainView.this, currLineStart);
                    return currLineStart + mark;
                }
                rect.y += lineHeight;
                if (currLineEnd == currLineStart) {
                    currLineStart = end;
                    continue;
                }
                currLineStart = currLineEnd;
            }
        }

        public WrappedLine(Element elem) {
            super(elem);
            this.determineNumLines();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WrappedLineCreator
    implements ViewFactory {
        public View create(Element elem) {
            return new WrappedLine(elem);
        }

        WrappedLineCreator() {
        }
    }
}

