/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;

public class MParse
extends Task {
    private Path classpath = null;
    private Path sourcepath = null;
    private File metahome = null;
    private File target = null;
    private boolean verbose = false;
    private boolean debugparser = false;
    private boolean debugscanner = false;
    private boolean cleanup = false;
    private CommandlineJava cmdl = new CommandlineJava();
    private File optionsFile = null;

    public void setMetamatahome(File metamatahome) {
        this.metahome = metamatahome;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath;
    }

    public Path createSourcepath() {
        if (this.sourcepath == null) {
            this.sourcepath = new Path(((ProjectComponent)this).project);
        }
        return this.sourcepath;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void setDebugscanner(boolean flag) {
        this.debugscanner = flag;
    }

    public void setDebugparser(boolean flag) {
        this.debugparser = flag;
    }

    public void setCleanup(boolean value) {
        this.cleanup = value;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmdl.createVmArgument();
    }

    public void setMaxmemory(String max) {
        this.cmdl.setMaxmemory(max);
    }

    public MParse() {
        this.cmdl.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.cmdl.setClassname("com.metamata.jj.MParse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            this.setUp();
            ExecuteStreamHandler handler = this.createStreamHandler();
            this._execute(handler);
        }
        finally {
            this.cleanUp();
        }
    }

    protected ExecuteStreamHandler createStreamHandler() {
        return new LogStreamHandler((Task)this, 2, 2);
    }

    protected void setUp() throws BuildException {
        this.checkOptions();
        File[] jars = this.getMetamataLibs();
        Path classPath = this.cmdl.createClasspath(((ProjectComponent)this).project);
        for (int i = 0; i < jars.length; ++i) {
            classPath.createPathElement().setLocation(jars[i]);
        }
        Commandline.Argument vmArgs = this.cmdl.createVmArgument();
        vmArgs.setValue("-Dmetamata.home=" + this.metahome.getAbsolutePath());
        String[] options = this.getOptions();
        this.optionsFile = MParse.createTmpFile();
        this.generateOptionsFile(this.optionsFile, options);
        Commandline.Argument args = this.cmdl.createArgument();
        args.setLine("-arguments " + this.optionsFile.getAbsolutePath());
    }

    protected void _execute(ExecuteStreamHandler handler) throws BuildException {
        String pathname = this.target.getAbsolutePath();
        int pos = pathname.length() - ".jj".length();
        File javaFile = new File(pathname = pathname.substring(0, pos) + ".java");
        if (javaFile.exists() && this.target.lastModified() < javaFile.lastModified()) {
            ((ProjectComponent)this).project.log("Target is already build - skipping (" + this.target + ")");
            return;
        }
        Execute process = new Execute(handler);
        this.log(this.cmdl.describeCommand(), 3);
        process.setCommandline(this.cmdl.getCommandline());
        try {
            if (process.execute() != 0) {
                throw new BuildException("Metamata task failed.");
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to launch Metamata task: " + e);
        }
    }

    protected void cleanUp() {
        if (this.optionsFile != null) {
            this.optionsFile.delete();
            this.optionsFile = null;
        }
        if (this.cleanup) {
            String name = this.target.getName();
            int pos = name.length() - ".jj".length();
            name = "__jj" + name.substring(0, pos) + ".sunjj";
            File sunjj = new File(this.target.getParent(), name);
            if (sunjj.exists()) {
                ((ProjectComponent)this).project.log("Removing stale file: " + sunjj.getName());
                sunjj.delete();
            }
        }
    }

    protected File[] getMetamataLibs() {
        Vector<File> files = new Vector<File>();
        files.addElement(new File(this.metahome, "lib/metamata.jar"));
        files.addElement(new File(this.metahome, "bin/lib/JavaCC.zip"));
        Object[] array = new File[files.size()];
        files.copyInto(array);
        return array;
    }

    protected void checkOptions() throws BuildException {
        if (this.metahome == null || !this.metahome.exists()) {
            throw new BuildException("'metamatahome' must point to Metamata home directory.");
        }
        this.metahome = ((ProjectComponent)this).project.resolveFile(this.metahome.getPath());
        File[] jars = this.getMetamataLibs();
        for (int i = 0; i < jars.length; ++i) {
            if (jars[i].exists()) continue;
            throw new BuildException(jars[i] + " does not exist. Check your metamata installation.");
        }
        if (this.target == null || !this.target.isFile() || !this.target.getName().endsWith(".jj")) {
            throw new BuildException("Invalid target: " + this.target);
        }
        this.target = ((ProjectComponent)this).project.resolveFile(this.target.getPath());
    }

    protected String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.verbose) {
            options.addElement("-verbose");
        }
        if (this.debugscanner) {
            options.addElement("-ds");
        }
        if (this.debugparser) {
            options.addElement("-dp");
        }
        if (this.classpath != null) {
            options.addElement("-classpath");
            options.addElement(this.classpath.toString());
        }
        if (this.sourcepath != null) {
            options.addElement("-sourcepath");
            options.addElement(this.sourcepath.toString());
        }
        options.addElement(this.target.getAbsolutePath());
        Object[] array = new String[options.size()];
        options.copyInto(array);
        return array;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateOptionsFile(File tofile, String[] options) throws BuildException {
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(tofile);
                PrintWriter pw = new PrintWriter(fw);
                for (int i = 0; i < options.length; ++i) {
                    pw.println(options[i]);
                }
                pw.flush();
            }
            catch (IOException e) {
                throw new BuildException("Error while writing options file " + tofile, (Throwable)e);
            }
            Object var7_7 = null;
            if (fw == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fw == null) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        fw.close();
        return;
    }

    protected static final File createTmpFile() {
        long rand = new Random(System.currentTimeMillis()).nextLong();
        File file = new File("metamata" + rand + ".tmp");
        return file;
    }
}

