/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.props;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import javax.swing.Icon;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.util.TypedHashtable;
import org.flexdock.util.Utilities;

public class BasicDockablePropertySet
extends TypedHashtable
implements DockablePropertySet,
DockingConstants {
    private String dockingId;
    private PropertyChangeSupport changeSupport;

    public static String getRegionInsetKey(String region) {
        if ("NORTH".equals(region)) {
            return "Dockable.REGION_SIZE_NORTH";
        }
        if ("SOUTH".equals(region)) {
            return "Dockable.REGION_SIZE_SOUTH";
        }
        if ("EAST".equals(region)) {
            return "Dockable.REGION_SIZE_EAST";
        }
        if ("WEST".equals(region)) {
            return "Dockable.REGION_SIZE_WEST";
        }
        return null;
    }

    public static String getSiblingSizeKey(String region) {
        if ("NORTH".equals(region)) {
            return "Dockable.SIBLING_SIZE_NORTH";
        }
        if ("SOUTH".equals(region)) {
            return "Dockable.SIBLING_SIZE_SOUTH";
        }
        if ("EAST".equals(region)) {
            return "Dockable.SIBLING_SIZE_EAST";
        }
        if ("WEST".equals(region)) {
            return "Dockable.SIBLING_SIZE_WEST";
        }
        return null;
    }

    public static String getTerritoryBlockedKey(String region) {
        if ("NORTH".equals(region)) {
            return "Dockable.TERRITORY_BLOCKED_NORTH";
        }
        if ("SOUTH".equals(region)) {
            return "Dockable.TERRITORY_BLOCKED_SOUTH";
        }
        if ("EAST".equals(region)) {
            return "Dockable.TERRITORY_BLOCKED_EAST";
        }
        if ("WEST".equals(region)) {
            return "Dockable.TERRITORY_BLOCKED_WEST";
        }
        if ("CENTER".equals(region)) {
            return "Dockable.TERRITORY_BLOCKED_CENTER";
        }
        return null;
    }

    public BasicDockablePropertySet(Dockable dockable) {
        this.init(dockable);
    }

    public BasicDockablePropertySet(int initialCapacity, Dockable dockable) {
        super(initialCapacity);
        this.init(dockable);
    }

    public BasicDockablePropertySet(int initialCapacity, float loadFactor, Dockable dockable) {
        super(initialCapacity, loadFactor);
        this.init(dockable);
    }

    public BasicDockablePropertySet(Map t, Dockable dockable) {
        super(t);
        this.init(dockable);
    }

    private void init(Dockable dockable) {
        this.dockingId = dockable == null ? null : dockable.getPersistentId();
        Object changeSrc = dockable == null ? this : dockable;
        this.changeSupport = new PropertyChangeSupport(changeSrc);
    }

    public Icon getDockbarIcon() {
        return (Icon)this.get("Dockable.DOCKBAR_ICON");
    }

    public Icon getTabIcon() {
        return (Icon)this.get("Dockable.TAB_ICON");
    }

    public String getDockableDesc() {
        return (String)this.get("Dockable.DESCRIPTION");
    }

    public Boolean isDockingEnabled() {
        return this.getBoolean("Dockable.DOCKING_ENABLED");
    }

    public Boolean isActive() {
        return this.getBoolean("Dockable.ACTIVE");
    }

    public Boolean isMouseMotionListenersBlockedWhileDragging() {
        return this.getBoolean("Dockable.MOUSE_MOTION_DRAG_BLOCK");
    }

    public Float getRegionInset(String region) {
        String key = BasicDockablePropertySet.getRegionInsetKey(region);
        return key == null ? null : (Float)this.get(key);
    }

    public Float getSiblingSize(String region) {
        String key = BasicDockablePropertySet.getSiblingSizeKey(region);
        return key == null ? null : (Float)this.get(key);
    }

    public Boolean isTerritoryBlocked(String region) {
        String key = BasicDockablePropertySet.getTerritoryBlockedKey(region);
        return key == null ? null : (Boolean)this.get(key);
    }

    public Float getDragThreshold() {
        return this.getFloat("Dockable.DRAG_THRESHOLD");
    }

    public Float getPreviewSize() {
        return this.getFloat("Dockable.PREVIEW_SIZE");
    }

    public void setDockbarIcon(Icon icon) {
        Icon oldValue = this.getDockbarIcon();
        this.put((Object)"Dockable.DOCKBAR_ICON", icon);
        this.firePropertyChange("Dockable.DOCKBAR_ICON", oldValue, icon);
    }

    public void setTabIcon(Icon icon) {
        Icon oldValue = this.getTabIcon();
        this.put((Object)"Dockable.TAB_ICON", icon);
        this.firePropertyChange("Dockable.TAB_ICON", oldValue, icon);
    }

    public void setDockableDesc(String dockableDesc) {
        String oldValue = this.getDockableDesc();
        this.put((Object)"Dockable.DESCRIPTION", dockableDesc);
        this.firePropertyChange("Dockable.DESCRIPTION", oldValue, dockableDesc);
    }

    public void setDockingEnabled(boolean enabled) {
        this.put((Object)"Dockable.DOCKING_ENABLED", enabled);
    }

    public void setActive(boolean active) {
        Boolean oldValue = this.isActive();
        if (oldValue == null) {
            oldValue = Boolean.FALSE;
        }
        this.put((Object)"Dockable.ACTIVE", active);
        this.firePropertyChange("Dockable.ACTIVE", oldValue, active);
    }

    public void setMouseMotionListenersBlockedWhileDragging(boolean blocked) {
        this.put((Object)"Dockable.MOUSE_MOTION_DRAG_BLOCK", blocked);
    }

    public void setRegionInset(String region, float inset) {
        String key = BasicDockablePropertySet.getRegionInsetKey(region);
        if (key != null) {
            Float f = new Float(inset);
            this.put((Object)key, f);
        }
    }

    public void setSiblingSize(String region, float size) {
        String key = BasicDockablePropertySet.getSiblingSizeKey(region);
        if (key != null) {
            Float f = new Float(size);
            this.put((Object)key, f);
        }
    }

    public void setTerritoryBlocked(String region, boolean blocked) {
        String key = BasicDockablePropertySet.getTerritoryBlockedKey(region);
        if (key != null) {
            Boolean bool = blocked ? Boolean.TRUE : Boolean.FALSE;
            this.put((Object)key, bool);
        }
    }

    public void setDragTheshold(float threshold) {
        threshold = Math.max(threshold, 0.0f);
        this.put((Object)"Dockable.DRAG_THRESHOLD", threshold);
    }

    public void setPreviewSize(float previewSize) {
        previewSize = Math.max(previewSize, 0.0f);
        previewSize = Math.min(previewSize, 1.0f);
        this.put((Object)"Dockable.PREVIEW_SIZE", previewSize);
    }

    public String getDockingId() {
        return this.dockingId;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (Utilities.isChanged(oldValue, newValue)) {
            this.changeSupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String property, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.changeSupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String property, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.changeSupport.firePropertyChange(property, oldValue, newValue);
        }
    }
}

