/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

public final class ReportIndianPanel
extends ReportPanel {
    private static final String[] headlines = new String[]{"settlement", "mission", "report.indian.tension", "skillTaught", "report.indian.mostHated", "report.indian.tradeInterests"};

    public ReportIndianPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportIndianAction");
        Player player = this.getMyPlayer();
        this.reportPanel.setLayout(new MigLayout("wrap 6, fillx, insets 0", "[]20px[center]", "[top]"));
        boolean needsSeperator = false;
        for (Player opponent : this.getGame().getLiveNativePlayers(null)) {
            if (!player.hasContacted(opponent)) continue;
            if (needsSeperator) {
                this.reportPanel.add((Component)new JSeparator(0), "newline 20, span, growx, wrap 20");
            }
            this.buildIndianAdvisorPanel(player, opponent);
            needsSeperator = true;
        }
        this.scrollPane.getViewport().setOpaque(false);
        this.reportPanel.setOpaque(true);
        this.reportPanel.doLayout();
    }

    private void buildIndianAdvisorPanel(Player player, Player opponent) {
        NationSummary ns = this.igc().getNationSummary(opponent);
        List<IndianSettlement> nativeSettlements = opponent.getIndianSettlements();
        String numSettlements = String.valueOf(nativeSettlements.size()) + " / " + String.valueOf(ns.getNumberOfSettlements());
        ImageLibrary lib = this.getImageLibrary();
        JLabel villageLabel = new JLabel();
        villageLabel.setIcon(new ImageIcon(ImageLibrary.getSettlementImage(opponent.getNationType().getCapitalType(), lib.getScaleFactor())));
        this.reportPanel.add((Component)villageLabel, "span, split 2");
        JLabel headline = Utility.localizedLabel(opponent.getNationLabel());
        headline.setFont(FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.SMALL, 1, lib.getScaleFactor()));
        this.reportPanel.add((Component)headline, "wrap 20, aligny center");
        JLabel label = Utility.localizedLabel("report.indian.chieftain");
        Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, 1, lib.getScaleFactor());
        label.setFont(font);
        this.reportPanel.add(label);
        this.reportPanel.add((Component)Utility.localizedLabel(opponent.getName()), "left, wrap");
        label = Utility.localizedLabel("report.indian.typeOfSettlements");
        label.setFont(font);
        this.reportPanel.add(label);
        this.reportPanel.add((Component)Utility.localizedLabel(Messages.nameKey(opponent.getNationType().getCapitalType().getId())), "left, wrap");
        label = Utility.localizedLabel("report.indian.numberOfSettlements");
        this.reportPanel.add(label);
        label.setFont(font);
        this.reportPanel.add((Component)new JLabel(numSettlements), "left, wrap");
        label = Utility.localizedLabel("report.indian.tribeTension");
        this.reportPanel.add(label);
        label.setFont(font);
        this.reportPanel.add((Component)Utility.localizedLabel(StringTemplate.template("report.indian.tensionStance").addNamed("%tension%", opponent.getTension(player)).addNamed("%stance%", opponent.getStance(player))), "left, wrap 20");
        if (nativeSettlements.isEmpty()) {
            this.reportPanel.add(Utility.localizedLabel("report.indian.noKnownSettlements"));
        } else {
            for (String key : headlines) {
                JLabel head = Utility.localizedLabel(key);
                head.setFont(font);
                this.reportPanel.add(head);
            }
            ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>(nativeSettlements.size());
            for (IndianSettlement settlement : nativeSettlements) {
                if (settlement.isCapital()) {
                    settlements.add(0, settlement);
                    continue;
                }
                settlements.add(settlement);
            }
            for (IndianSettlement settlement : settlements) {
                JLabel skillLabel;
                Tile tile = settlement.getTile();
                boolean known = tile.isExplored();
                boolean contacted = settlement.hasContacted(player);
                boolean visited = settlement.hasVisited(player);
                String locationName = Messages.message(settlement.getLocationLabelFor(player));
                if (known && settlement.isCapital()) {
                    locationName = locationName + ResourceManager.getString("indianSettlementChip.capital");
                }
                if (settlement.worthScouting(player)) {
                    locationName = locationName + ResourceManager.getString("unscoutedIndianSettlement");
                }
                JButton settlementButton = Utility.getLinkButton(locationName, null, settlement.getTile().getId());
                Utility.localizeToolTip((JComponent)settlementButton, settlement.getTile().getDetailedLocationLabelFor(player));
                settlementButton.addActionListener(this);
                this.reportPanel.add((Component)settlementButton, "newline 15");
                Unit missionary = settlement.getMissionary();
                JLabel missionLabel = new JLabel("");
                if (missionary != null) {
                    BufferedImage dummy = new BufferedImage(1, 1, 2);
                    Graphics2D g = dummy.createGraphics();
                    missionLabel.setIcon(new ImageIcon(lib.getMissionChip(g, missionary.getOwner(), missionary.hasAbility("model.ability.expertMissionary"))));
                    g.dispose();
                    Utility.localizeToolTip((JComponent)missionLabel, Messages.message(missionary.getLabel(Unit.UnitLabelType.NATIONAL)));
                }
                this.reportPanel.add(missionLabel);
                this.reportPanel.add(Utility.localizedLabel(settlement.getAlarmLevelKey(player)));
                UnitType skillType = settlement.getLearnableSkill();
                if (visited && skillType != null) {
                    skillLabel = new JLabel("");
                    skillLabel.setIcon(new ImageIcon(lib.getSmallUnitImage(skillType)));
                    Utility.localizeToolTip((JComponent)skillLabel, Messages.message(settlement.getLearnableSkillLabel(visited)));
                } else {
                    skillLabel = Utility.localizedLabel(settlement.getLearnableSkillLabel(visited));
                }
                this.reportPanel.add(skillLabel);
                this.reportPanel.add(Utility.localizedLabel(settlement.getMostHatedLabel(contacted)));
                GoodsType[] wantedGoods = settlement.getWantedGoods();
                int n = visited ? settlement.getWantedGoodsAmount() : 1;
                String x = n > 1 ? "split " + Integer.toString(n) : null;
                for (int i = 0; i < n; ++i) {
                    JLabel goodsLabel;
                    if (visited && wantedGoods[i] != null) {
                        goodsLabel = new JLabel("");
                        goodsLabel.setIcon(new ImageIcon(lib.getSmallIconImage(wantedGoods[i])));
                        Utility.localizeToolTip((JComponent)goodsLabel, Messages.message(settlement.getWantedGoodsLabel(i, player)));
                    } else {
                        goodsLabel = Utility.localizedLabel(settlement.getWantedGoodsLabel(i, player));
                    }
                    this.reportPanel.add((Component)goodsLabel, x);
                    x = null;
                }
            }
        }
    }
}

