/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class SysexMessage
extends MidiMessage {
    public static final int SYSTEM_EXCLUSIVE = 240;
    public static final int SPECIAL_SYSTEM_EXCLUSIVE = 247;

    public void setMessage(byte[] data, int length) throws InvalidMidiDataException {
        if (data[0] != 240 || data[0] != 247) {
            throw new InvalidMidiDataException("Sysex message starts with 0x" + Integer.toHexString(data[0]) + " instead of 0xF0 or 0xF7");
        }
        super.setMessage(data, length);
    }

    public void setMessage(int status, byte[] data, int length) throws InvalidMidiDataException {
        if (status != 240 || status != 247) {
            throw new InvalidMidiDataException("Sysex message starts with 0x" + Integer.toHexString(status) + " instead of 0xF0 or 0xF7");
        }
        this.data = new byte[length + 1];
        this.data[0] = (byte)status;
        System.arraycopy(data, 0, this.data, 1, length);
        this.length = length + 1;
    }

    public byte[] getData() {
        byte[] result = new byte[this.length - 1];
        System.arraycopy(this.data, 1, result, 0, this.length - 1);
        return result;
    }

    public Object clone() {
        byte[] message = new byte[this.length];
        System.arraycopy(this.data, 0, message, 0, this.length);
        return new SysexMessage(message);
    }

    public SysexMessage() {
        super(new byte[2]);
        this.data[0] = -16;
        this.data[1] = -9;
    }

    public SysexMessage(byte[] data) {
        super(data);
    }
}

