/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.leveldbjni.internal;

import java.io.File;
import java.io.IOException;
import org.fusesource.hawtjni.runtime.ClassFlag;
import org.fusesource.hawtjni.runtime.JniArg;
import org.fusesource.hawtjni.runtime.JniClass;
import org.fusesource.hawtjni.runtime.JniMethod;
import org.fusesource.hawtjni.runtime.MethodFlag;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.fusesource.leveldbjni.internal.NativeSlice;

public class Util {
    public static void link(File source, File target) throws IOException {
        if (UtilJNI.link(source.getCanonicalPath(), target.getCanonicalPath()) != 0) {
            throw new IOException("link failed: " + Util.strerror());
        }
    }

    static int errno() {
        return UtilJNI.errno();
    }

    static String strerror() {
        return Util.string(UtilJNI.strerror(Util.errno()));
    }

    static String string(long ptr) {
        if (ptr == 0L) {
            return null;
        }
        return new String(new NativeSlice(ptr, UtilJNI.strlen(ptr)).toByteArray());
    }

    @JniClass(flags={ClassFlag.CPP})
    static class UtilJNI {
        UtilJNI() {
        }

        @JniMethod
        static final native int link(@JniArg(cast="const char*") String var0, @JniArg(cast="const char*") String var1);

        @JniMethod(flags={MethodFlag.CONSTANT_GETTER})
        public static final native int errno();

        @JniMethod(cast="char *")
        public static final native long strerror(int var0);

        public static final native int strlen(@JniArg(cast="const char *") long var0);

        static {
            NativeDB.LIBRARY.load();
        }
    }
}

