/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import free.util.AWTUtilities;
import free.util.Localization;
import free.util.swing.LocalizationService;
import free.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSelectorPanel
extends JPanel {
    private static Localization l10n;
    public static final String BOLD_OPTION_ID = "bold";
    public static final String ITALIC_OPTION_ID = "italic";
    private static final int[] DEFAULT_FONT_SIZES;
    private final JList fontNamesList;
    private final JList fontSizesList;
    private Hashtable fontOptions = new Hashtable();
    private Hashtable fontOptionCheckBoxes = new Hashtable();
    private JComponent previewPanel;
    private final JPanel previewPanelHolder;
    private final ChangeEvent changeEvent = new ChangeEvent(this);

    public FontSelectorPanel() {
        this(new BooleanFontOption[]{FontSelectorPanel.createBoldFontOption(), FontSelectorPanel.createItalicFontOption()});
    }

    public FontSelectorPanel(BooleanFontOption[] booleanFontOptionArray) {
        this(AWTUtilities.getAvailableFontNames(), booleanFontOptionArray);
    }

    public FontSelectorPanel(int[] nArray) {
        this(nArray, new BooleanFontOption[]{FontSelectorPanel.createBoldFontOption(), FontSelectorPanel.createItalicFontOption()});
    }

    public FontSelectorPanel(int[] nArray, BooleanFontOption[] booleanFontOptionArray) {
        this(AWTUtilities.getAvailableFontNames(), nArray, booleanFontOptionArray);
    }

    public FontSelectorPanel(String[] stringArray) {
        this(stringArray, DEFAULT_FONT_SIZES);
    }

    public FontSelectorPanel(String[] stringArray, int[] nArray) {
        this(stringArray, nArray, new BooleanFontOption[]{FontSelectorPanel.createBoldFontOption(), FontSelectorPanel.createItalicFontOption()});
    }

    public FontSelectorPanel(String[] stringArray, BooleanFontOption[] booleanFontOptionArray) {
        this(stringArray, DEFAULT_FONT_SIZES, booleanFontOptionArray);
    }

    public FontSelectorPanel(String[] stringArray, int[] nArray, BooleanFontOption[] booleanFontOptionArray) {
        Object object;
        int n;
        this.fontNamesList = new JList<String>(stringArray);
        this.fontNamesList.setSelectionMode(0);
        Integer[] integerArray = new Integer[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            integerArray[n] = new Integer(nArray[n]);
        }
        this.fontSizesList = new JList<Integer>(integerArray);
        this.fontSizesList.setSelectionMode(0);
        for (n = 0; n < booleanFontOptionArray.length; ++n) {
            object = booleanFontOptionArray[n];
            this.fontOptions.put(((BooleanFontOption)object).getOptionId(), object);
            ((BooleanFontOption)object).setFontSelectorPanel(this);
        }
        this.previewPanelHolder = new JPanel(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(1), FontSelectorPanel.getL10n().getString("preview"));
        object = new EmptyBorder(10, 10, 10, 10);
        this.previewPanelHolder.setBorder(new CompoundBorder(titledBorder, (Border)object));
        this.setPreviewPanel(new DefaultPreviewPanel(this));
        this.createUI(booleanFontOptionArray);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontSelectorPanel.this.fireStateChanged();
            }
        };
        this.fontNamesList.addListSelectionListener(listSelectionListener);
        this.fontSizesList.addListSelectionListener(listSelectionListener);
    }

    private static synchronized Localization getL10n() {
        if (l10n == null) {
            l10n = LocalizationService.getForClass(FontSelectorPanel.class);
        }
        return l10n;
    }

    public BooleanFontOption getFontOption(String string) {
        return (BooleanFontOption)this.fontOptions.get(string);
    }

    public boolean getFontOptionValue(String string) {
        BooleanFontOption booleanFontOption = this.getFontOption(string);
        if (booleanFontOption == null) {
            throw new IllegalArgumentException();
        }
        return booleanFontOption.getValue();
    }

    public static BooleanFontOption createBoldFontOption() {
        return new BooleanFontOption(BOLD_OPTION_ID, FontSelectorPanel.getL10n().getString(BOLD_OPTION_ID), 0, false);
    }

    public static BooleanFontOption createItalicFontOption() {
        return new BooleanFontOption(ITALIC_OPTION_ID, FontSelectorPanel.getL10n().getString(ITALIC_OPTION_ID), 0, false);
    }

    private void createUI(BooleanFontOption[] booleanFontOptionArray) {
        this.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
        JScrollPane jScrollPane = new JScrollPane(this.fontNamesList);
        JLabel jLabel = new JLabel();
        SwingUtils.applyLabelSpec(jLabel, FontSelectorPanel.getL10n().getString("fontNameLabel.text"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setLabelFor(this.fontNamesList);
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(2, 2));
        JScrollPane jScrollPane2 = new JScrollPane(this.fontSizesList);
        JLabel jLabel2 = new JLabel();
        SwingUtils.applyLabelSpec(jLabel2, FontSelectorPanel.getL10n().getString("fontSizeLabel.text"));
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setLabelFor(this.fontSizesList);
        jPanel3.add((Component)jLabel2, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
                String string = abstractButton.getActionCommand();
                BooleanFontOption booleanFontOption = FontSelectorPanel.this.getFontOption(string);
                booleanFontOption.setValue(abstractButton.isSelected());
            }
        };
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        for (int i = 0; i < booleanFontOptionArray.length; ++i) {
            BooleanFontOption booleanFontOption = booleanFontOptionArray[i];
            JCheckBox jCheckBox = new JCheckBox(booleanFontOption.getOptionName(), booleanFontOption.getValue());
            jCheckBox.setActionCommand(booleanFontOption.getOptionId());
            jCheckBox.setDisplayedMnemonicIndex(booleanFontOption.getDisplayedMnemonicIndex());
            jCheckBox.addChangeListener(changeListener);
            box.add(jCheckBox);
            this.fontOptionCheckBoxes.put(booleanFontOption, jCheckBox);
        }
        box.add(Box.createVerticalGlue());
        jPanel4.add((Component)box, "West");
        jPanel4.add((Component)this.previewPanelHolder, "Center");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel4, "South");
    }

    public Font getSelectedFont() {
        String string = (String)this.fontNamesList.getSelectedValue();
        Integer n = (Integer)this.fontSizesList.getSelectedValue();
        if (string == null || n == null) {
            return null;
        }
        int n2 = 0;
        BooleanFontOption booleanFontOption = this.getFontOption(BOLD_OPTION_ID);
        BooleanFontOption booleanFontOption2 = this.getFontOption(ITALIC_OPTION_ID);
        if (booleanFontOption != null && booleanFontOption.getValue()) {
            n2 |= 1;
        }
        if (booleanFontOption2 != null && booleanFontOption2.getValue()) {
            n2 |= 2;
        }
        return new Font(string, n2, n);
    }

    public void setSelectedFont(Font font) {
        BooleanFontOption booleanFontOption = this.getFontOption(BOLD_OPTION_ID);
        BooleanFontOption booleanFontOption2 = this.getFontOption(ITALIC_OPTION_ID);
        if (booleanFontOption != null) {
            booleanFontOption.setValue(font.isBold());
        }
        if (booleanFontOption2 != null) {
            booleanFontOption2.setValue(font.isItalic());
        }
        this.fontNamesList.setSelectedValue(font.getFamily(), true);
        this.fontSizesList.setSelectedValue(new Integer(font.getSize()), true);
        this.fireStateChanged();
    }

    protected void booleanOptionChanged(BooleanFontOption booleanFontOption) {
        AbstractButton abstractButton = (AbstractButton)this.fontOptionCheckBoxes.get(booleanFontOption);
        abstractButton.setSelected(booleanFontOption.getValue());
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? FontSelectorPanel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(this.changeEvent);
        }
    }

    public void setPreviewPanel(JComponent jComponent) {
        if (this.previewPanel != null) {
            this.previewPanelHolder.remove(this.previewPanel);
        }
        this.previewPanel = jComponent;
        if (this.previewPanel != null) {
            this.previewPanelHolder.add((Component)this.previewPanel, "Center");
        }
    }

    public JComponent getPreviewPanel() {
        return this.previewPanel;
    }

    static {
        DEFAULT_FONT_SIZES = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
    }

    public static class BooleanFontOption {
        private final String id;
        private final String name;
        private final int displayedMnemonicIndex;
        private boolean value;
        private FontSelectorPanel fontSelectorPanel;

        public BooleanFontOption(String string, String string2, int n, boolean bl) {
            this.id = string;
            this.name = string2;
            this.displayedMnemonicIndex = n;
            this.value = bl;
        }

        private void setFontSelectorPanel(FontSelectorPanel fontSelectorPanel) {
            this.fontSelectorPanel = fontSelectorPanel;
        }

        public String getOptionId() {
            return this.id;
        }

        public String getOptionName() {
            return this.name;
        }

        public int getDisplayedMnemonicIndex() {
            return this.displayedMnemonicIndex;
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean bl) {
            if (this.value != bl) {
                this.value = bl;
                this.fontSelectorPanel.booleanOptionChanged(this);
            }
        }
    }

    public static class DefaultPreviewPanel
    extends JLabel
    implements ChangeListener {
        protected final FontSelectorPanel fontSelectorPanel;

        public DefaultPreviewPanel(FontSelectorPanel fontSelectorPanel) {
            super(FontSelectorPanel.getL10n().getString("previewText"), 0);
            this.fontSelectorPanel = fontSelectorPanel;
            fontSelectorPanel.addChangeListener(this);
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.setFont(this.fontSelectorPanel.getSelectedFont());
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height += 20;
            return dimension;
        }
    }
}

