require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_PARAM_H)) {
    eval 'sub _POWERPC_PARAM_H () {1;}' unless defined(&_POWERPC_PARAM_H);
    if(defined(&_KERNEL)) {
	if(defined(&_KERNEL_OPT)) {
	    require './powerpc/opt_ppcarch.ph';
	}
    }
    unless(defined(&_KERNEL)) {
	undef(&MACHINE) if defined(&MACHINE);
    }
    if(defined(&_LP64)) {
	unless(defined(&MACHINE)) {
	    eval 'sub MACHINE () {"powerpc64";}' unless defined(&MACHINE);
	}
	eval 'sub MACHINE_ARCH () {"powerpc64";}' unless defined(&MACHINE_ARCH);
	eval 'sub MID_MACHINE () { &MID_POWERPC64;}' unless defined(&MID_MACHINE);
    } else {
	unless(defined(&MACHINE)) {
	    eval 'sub MACHINE () {"powerpc";}' unless defined(&MACHINE);
	}
	eval 'sub MACHINE_ARCH () {"powerpc";}' unless defined(&MACHINE_ARCH);
	eval 'sub MID_MACHINE () { &MID_POWERPC;}' unless defined(&MID_MACHINE);
    }
    eval 'sub STACK_ALIGNBYTES () {(16- 1);}' unless defined(&STACK_ALIGNBYTES);
    if(defined(&PPC_IBM4XX)) {
	eval 'sub PGSHIFT () {14;}' unless defined(&PGSHIFT);
	eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    } else {
	eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
	eval 'sub UPAGES () {4;}' unless defined(&UPAGES);
    }
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG - 1);}' unless defined(&PGOFSET);
    eval 'sub BLKDEV_IOSIZE () { &NBPG;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub USPACE () {( &UPAGES *  &NBPG);}' unless defined(&USPACE);
    unless(defined(&MSGBUFSIZE)) {
	eval 'sub MSGBUFSIZE () {(2* &NBPG);}' unless defined(&MSGBUFSIZE);
    }
    unless(defined(&KERNBASE)) {
	eval 'sub KERNBASE () {0x100000;}' unless defined(&KERNBASE);
    }
    unless(defined(&MSIZE)) {
	if(defined(&_LP64)) {
	    eval 'sub MSIZE () {512;}' unless defined(&MSIZE);
	} else {
	    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
	}
    }
    unless(defined(&MCLSHIFT)) {
	eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    }
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    unless(defined(&NKMEMPAGES_MIN_DEFAULT)) {
	eval 'sub NKMEMPAGES_MIN_DEFAULT () {((16* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    }
    unless(defined(&NKMEMPAGES_MAX_DEFAULT)) {
	eval 'sub NKMEMPAGES_MAX_DEFAULT () {((256* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    }
    if(defined(&_KERNEL)  && !defined(&_LOCORE)) {
	require 'machine/cpu.ph';
    }
}
1;
