/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.util.Enumeration;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DomParser
implements XMLReader {
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String HANDLERS = "http://xml.org/sax/properties/";
    private DefaultHandler2 defaultHandler;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private DeclHandler declHandler;
    private LexicalHandler lexicalHandler;
    private ErrorHandler errHandler;
    private EntityResolver resolver;
    private Locale locale;
    private Node start;
    private Node current;
    private boolean isL2;
    private boolean showNamespaces;
    private boolean showXML1_0;
    private NamespaceSupport prefixStack;
    private boolean isDocument;

    public final EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public final void setEntityResolver(EntityResolver resolver) {
        if (resolver == null) {
            resolver = this.defaultHandler;
        }
        this.resolver = resolver;
    }

    public final void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public final ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public final void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            handler = this.defaultHandler;
        }
        this.errHandler = handler;
    }

    public final ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public final void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            handler = this.defaultHandler;
        }
        this.contentHandler = handler;
    }

    public final DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public final void setDTDHandler(DTDHandler handler) {
        if (handler == null) {
            handler = this.defaultHandler;
        }
        this.dtdHandler = handler;
    }

    public final void parse(String uri) throws SAXException {
        this.parse();
    }

    public final void parse(InputSource input) throws SAXException {
        this.parse();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void parse() throws SAXException {
        block4: {
            try {
                this.walk();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.isDocument) {
                    this.contentHandler.endDocument();
                }
                this.current = null;
                this.prefixStack.reset();
                throw throwable;
            }
            {
                Object var2_3 = null;
                if (!this.isDocument) break block4;
            }
            this.contentHandler.endDocument();
        }
        this.current = null;
        this.prefixStack.reset();
    }

    private final boolean getIsL2(Node node2) {
        Document doc = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
        if (doc == null) {
            throw new RuntimeException("? unowned node - L2 DTD ?");
        }
        DOMImplementation impl = doc.getImplementation();
        return impl.hasFeature("XML", "2.0");
    }

    public final boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(name) || "http://xml.org/sax/features/external-general-entities".equals(name) || "http://xml.org/sax/features/external-parameter-entities".equals(name) || "http://xml.org/sax/features/string-interning".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.showNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.showXML1_0;
        }
        throw new SAXNotRecognizedException(name);
    }

    public final Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            return this.declHandler == this.defaultHandler ? null : this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.lexicalHandler == this.defaultHandler ? null : this.lexicalHandler;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(name)) {
            return this.current;
        }
        throw new SAXNotRecognizedException(name);
    }

    public final void setFeature(String name, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.current != null) {
            throw new IllegalStateException("feature change midparse");
        }
        boolean value = this.getFeature(name);
        if (value == state) {
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            if (!this.showXML1_0 && !state) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showNamespaces = state;
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            if (!this.showNamespaces && !state) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showXML1_0 = state;
            return;
        }
        throw new SAXNotSupportedException(name);
    }

    public final void setProperty(String name, Object state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            if (!(state instanceof DeclHandler) && state != null) {
                throw new SAXNotSupportedException(name);
            }
            this.declHandler = (DeclHandler)state;
            return;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            if (!(state instanceof LexicalHandler) && state != null) {
                throw new SAXNotSupportedException(name);
            }
            this.lexicalHandler = (LexicalHandler)state;
            return;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(name)) {
            if (state == null || state instanceof Node) {
                if (this.current != null) {
                    throw new SAXNotSupportedException("property is readonly during parse:  " + name);
                }
                this.setStart((Node)state);
                return;
            }
            throw new SAXNotSupportedException("not a DOM Node");
        }
        throw new SAXNotRecognizedException(name);
    }

    private final void setStart(Node property) {
        this.start = property;
        if (this.start != null) {
            this.isL2 = this.getIsL2(this.start);
            this.isDocument = this.start instanceof Document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void walk() throws SAXException {
        attrs = new AttributesImpl();
        var8_2 = this;
        synchronized (var8_2) {
            if (this.current != null) {
                throw new IllegalStateException("already walking tree");
            }
            this.current = this.start;
        }
        block17: while (true) {
            block42: {
                type = this.current.getNodeType();
                switch (type) {
                    case 9: {
                        this.contentHandler.startDocument();
                        break block42;
                    }
                    case 1: {
                        nodes = this.current.getAttributes();
                        length = nodes.getLength();
                        this.prefixStack.pushContext();
                        i = 0;
                        while (true) {
                            if (i < length) ** GOTO lbl33
                            if (!this.showNamespaces) break;
                            if (!this.isL2) {
                                throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                            }
                            ns = this.current.getNamespaceURI();
                            if (ns == null) {
                                ns = "";
                            }
                            if ((local = this.current.getLocalName()) == null) {
                                local = this.current.getNodeName();
                            }
                            ** GOTO lbl58
lbl33:
                            // 1 sources

                            attr = (Attr)nodes.item(i);
                            name = attr.getNodeName();
                            if (!this.showNamespaces || !name.startsWith("xmlns")) ** GOTO lbl42
                            prefix = "xmlns".equals(name) != false ? "" : name.substring(6);
                            uri = attr.getNodeValue();
                            this.prefixStack.declarePrefix(prefix, uri);
                            this.contentHandler.startPrefixMapping(prefix, uri);
                            if (!this.showXML1_0) ** GOTO lbl54
lbl42:
                            // 2 sources

                            if (this.showNamespaces) {
                                if (!this.isL2) {
                                    throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                                }
                                ns = attr.getNamespaceURI();
                                if (ns == null) {
                                    ns = "";
                                }
                                if ((local = attr.getLocalName()) == null) {
                                    local = name;
                                }
                            } else {
                                local = "";
                                ns = "";
                            }
                            attrs.addAttribute(ns, local, name, "CDATA", attr.getNodeValue());
lbl54:
                            // 2 sources

                            ++i;
                        }
                        local = "";
                        ns = "";
lbl58:
                        // 2 sources

                        this.contentHandler.startElement(ns, local, this.current.getNodeName(), attrs);
                        if (length != 0) {
                            attrs.clear();
                        }
                        break block42;
                    }
                    case 4: {
                        this.lexicalHandler.startCDATA();
                        chars = this.current.getNodeValue().toCharArray();
                        this.contentHandler.characters(chars, 0, chars.length);
                        this.lexicalHandler.endCDATA();
                        break block42;
                    }
                    case 8: {
                        chars = this.current.getNodeValue().toCharArray();
                        this.lexicalHandler.comment(chars, 0, chars.length);
                        break block42;
                    }
                    case 10: {
                        doctype = (DocumentType)this.current;
                        if (this.isL2) {
                            this.lexicalHandler.startDTD(doctype.getName(), doctype.getPublicId(), doctype.getSystemId());
                        } else {
                            this.lexicalHandler.startDTD(doctype.getName(), null, null);
                        }
                        message = this.isL2 != false && doctype.getInternalSubset() != null ? " Full DTD known; can't be shown using SAX2. " : " This DTD was was recreated using incomplete DOM L2 records. ";
                        buf = message.toCharArray();
                        this.lexicalHandler.comment(buf, 0, buf.length);
                        nodes = doctype.getNotations();
                        length = nodes.getLength();
                        i = 0;
                        while (true) {
                            if (i < length) ** GOTO lbl90
                            nodes = doctype.getEntities();
                            length = nodes.getLength();
                            i = 0;
                            if (true) ** GOTO lbl113
lbl90:
                            // 1 sources

                            notation = (Notation)nodes.item(i);
                            this.dtdHandler.notationDecl(notation.getNodeName(), notation.getPublicId(), notation.getSystemId());
                            ++i;
                        }
                    }
                    case 5: {
                        this.lexicalHandler.startEntity(this.current.getNodeName());
                        break block42;
                    }
                    case 7: {
                        this.contentHandler.processingInstruction(this.current.getNodeName(), this.current.getNodeValue());
                        break block42;
                    }
                    case 3: {
                        chars = this.current.getNodeValue().toCharArray();
                        this.contentHandler.characters(chars, 0, chars.length);
                        break block42;
                    }
                    default: {
                        throw new SAXException("Illegal DOM Node type in Document:  " + this.current.getNodeType());
                    }
                }
                do {
                    if ((notation = (entity = (Entity)nodes.item(i)).getNotationName()) != null) {
                        this.dtdHandler.unparsedEntityDecl(entity.getNodeName(), entity.getPublicId(), entity.getSystemId(), notation);
                    } else if (entity.getSystemId() != null) {
                        this.declHandler.externalEntityDecl(entity.getNodeName(), entity.getPublicId(), entity.getSystemId());
                    }
                    ++i;
lbl113:
                    // 2 sources

                } while (i < length);
                this.lexicalHandler.endDTD();
            }
            switch (type) {
                case 1: 
                case 5: 
                case 9: {
                    next = this.current.getFirstChild();
                    if (next != null) {
                        this.current = next;
                        continue block17;
                    }
                    this.callEnd(this.current);
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    throw new SAXException("Illegal DOM Node type found:  " + this.current.getNodeType());
                }
            }
            while (true) {
                if ((next = this.current.getNextSibling()) != null) {
                    this.current = next;
                    continue block17;
                }
                this.current = this.current.getParentNode();
                if (this.current == null || this.current == this.start) {
                    return;
                }
                this.callEnd(this.current);
            }
            break;
        }
    }

    private final void callEnd(Node node2) throws SAXException {
        switch (node2.getNodeType()) {
            case 9: {
                return;
            }
            case 1: {
                if (this.showNamespaces) {
                    if (!this.isL2) {
                        throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                    }
                    this.contentHandler.endElement(node2.getNamespaceURI(), node2.getLocalName(), node2.getNodeName());
                    Enumeration e = this.prefixStack.getDeclaredPrefixes();
                    while (e.hasMoreElements()) {
                        this.contentHandler.endPrefixMapping((String)e.nextElement());
                    }
                } else {
                    this.contentHandler.endElement("", "", node2.getNodeName());
                }
                this.prefixStack.popContext();
                return;
            }
            case 5: {
                this.lexicalHandler.endEntity(node2.getNodeName());
                return;
            }
            case 2: 
            case 11: {
                return;
            }
        }
        throw new SAXException("Illegal DOM container type found:  " + this.current.getNodeType());
    }

    private final /* synthetic */ void this() {
        this.defaultHandler = new DefaultHandler2();
        this.contentHandler = this.defaultHandler;
        this.dtdHandler = this.defaultHandler;
        this.declHandler = this.defaultHandler;
        this.lexicalHandler = this.defaultHandler;
        this.errHandler = this.defaultHandler;
        this.resolver = this.defaultHandler;
        this.locale = Locale.getDefault();
        this.showNamespaces = true;
        this.showXML1_0 = false;
        this.prefixStack = new NamespaceSupport();
    }

    public DomParser() {
        this.this();
    }

    public DomParser(Node node2) {
        this.this();
        this.setStart(node2);
    }
}

