/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.nio.channels.FileChannel;

public abstract class FileLock {
    private final FileChannel channel;
    private final long position;
    private final long size;
    private final boolean shared;

    public abstract boolean isValid();

    public abstract void release() throws IOException;

    public final FileChannel channel() {
        return this.channel;
    }

    public final boolean isShared() {
        return this.shared;
    }

    public final boolean overlaps(long position, long size) {
        if (position > this.position + this.size) {
            return false;
        }
        return position + size >= this.position;
    }

    public final long position() {
        return this.position;
    }

    public final long size() {
        return this.size;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append("[");
        buf.append(this.position);
        buf.append(":");
        buf.append(this.size);
        if (this.shared) {
            buf.append(" shared");
        } else {
            buf.append(" exclusive");
        }
        if (this.isValid()) {
            buf.append(" valid]");
        } else {
            buf.append(" invalid]");
        }
        return buf.toString();
    }

    protected FileLock(FileChannel channel, long position, long size, boolean shared) {
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException();
        }
        this.channel = channel;
        this.position = position;
        this.size = size;
        this.shared = shared;
    }
}

