
package TDS::Cache::Recent;
# $Id: Recent.pm,v 1.14.2.1 2001/02/13 00:48:11 tom Exp $
################################################################

use strict;
use vars qw(@ISA $AUTOLOAD);

use TDS;
use TDS::Cache::Display;
use TDS::DirInfo;

@ISA = qw(TDS::Cache::Display);

attributes qw();

################################################################
# auto loading

use AutoLoader;

sub AUTOLOAD {
    $AutoLoader::AUTOLOAD = $AUTOLOAD;
    goto &AutoLoader::AUTOLOAD;
}

package TDS::Cache::Recent;
1;

__END__
################################################################
sub IsFresh($)
{

    my $self = shift;

##    warn " Recent IsFresh start";
    # super class
    return 0 unless $self->SUPER::IsFresh;
    # mode check
    return 0 unless $TDS::Status->mode eq 'RECENT';

    # today's check
    my $cache_lm = $self->GetCacheLastModified;
    my $dt = new DateTime::Date;
    $dt->SetTime($cache_lm, $TDS::System::TZ);
    return 0 unless $dt == $TDS::Status->start_time;	    
    
    return 1;
}
sub NewerThanDatafile($)
{
    my $self = shift;

    my $data_dir = GetDataDir();

    # PIM: todo, schedule
    my $year = $TDS::Status->start_time->year;
    return 0 if $self->newer_than_cache("$data_dir/schedule.dat");
    return 0 if $self->newer_than_cache(GetDiaryDir() . "/$year/schedule.dat");
    $year++;
    return 0 if $self->newer_than_cache(GetDiaryDir() . "/$year/schedule.dat");

    return 0 if $self->newer_than_cache("$data_dir/todo.dat");

    return $self->SUPER::NewerThanDatafile;
}

sub GetCacheFilename($)
{
    my $self = shift;

    return $self->create_cache_filename("recent");
}

1;
