/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

public class Kernel
implements Cloneable {
    private final int width;
    private final int height;
    private final float[] data;

    public final int getXOrigin() {
        return (this.width - 1) / 2;
    }

    public final int getYOrigin() {
        return (this.height - 1) / 2;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final float[] getKernelData(float[] data) throws IllegalArgumentException {
        if (data == null) {
            return (float[])this.data.clone();
        }
        if (data.length < this.data.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.data, 0, data, 0, this.data.length);
        return data;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public Kernel(int width, int height, float[] data) throws IllegalArgumentException {
        this.width = width;
        this.height = height;
        if (data.length < width * height || width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.data = new float[width * height];
        System.arraycopy(data, 0, this.data, 0, width * height);
    }
}

