package org.cdavies.itunes;

import java.io.*;
import org.cdavies.itunes.hash.*;
import org.cdavies.itunes.request.*;

public interface Track {
	
	public int getTrackId();
	public void setTrackId(int trackId);
	
	public String getTrackName();
	public void setTrackName(String name);
	
	public String getAlbumName();
	public void setAlbumName(String name);
	
	public String getArtistName();
	public void setArtistName(String name);
	
	public int getTrackNumber();
	public void setTrackNumber(int num);
	
	public String getGenre();
	public void setGenre(String genre);
	
	public int getRating();
	public void setRating(int rating);
	
	public String getFormat();
	public void setFormat(String format);
	
	public int getLength();
	public void setLength(int len);
	
	public void setItunesConnection(ItunesConnection conn);
	public void setItunesHash(ItunesHash hash);
	
	public void setDatabaseId(int dbId);
	public int getDatabaseId();
	
	public InputStream getInputStream() throws NoServerPermissionException;
	
	public boolean equals(Track t);
	public String toString();
	
}
