/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import jmapps.ui.JMPanel;
import jmapps.ui.TreeNode;

public class TreeControl
extends JMPanel
implements ComponentListener,
MouseListener,
KeyListener,
FocusListener,
ActionListener,
AdjustmentListener {
    private TreeNode nodeRoot = null;
    private TreeNode nodeTop = null;
    private TreeNode nodeCurrent = null;
    private Vector vectorTreeElList = new Vector();
    private boolean boolLayoutDone = false;
    private boolean boolRootVisible = true;
    private Scrollbar scrollBarVert = null;
    private Scrollbar scrollBarHorz = null;
    private int nScrollVertVisible;
    private int nScrollHorzMax;
    private int nScrollHorzVisible;
    private int nScrollHorzLeft = 0;
    private int nScrollHorzCell = 6;
    private Image imageDraw = null;

    public TreeControl() {
        this((String)null);
    }

    public TreeControl(String stringRootName) {
        super(null);
        this.setLoweredBorder();
        this.setBackground(TreeNode.colorBg);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        if (stringRootName != null) {
            this.createRootElement(stringRootName);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public TreeNode createRootElement(String stringRootName) {
        this.nodeRoot = new TreeNode(stringRootName, this);
        this.nodeRoot.addActionListener(this);
        this.vectorTreeElList = new Vector();
        this.nodeRoot.addToTreeElList(this.vectorTreeElList);
        this.nodeTop = this.nodeRoot;
        this.nodeRoot.setCurrent(true);
        return this.nodeRoot;
    }

    public TreeNode createSubElement(TreeNode nodeParent, String stringNodeName) {
        TreeNode nodeChild = nodeParent.addSubElement(stringNodeName);
        nodeChild.addActionListener(this);
        if (this.isShowing()) {
            this.recomputeLayout();
            this.recomputeScrollbars();
            this.repaint();
        }
        return nodeChild;
    }

    public void destroySubElement(TreeNode nodeParent, TreeNode node) {
        TreeNode nodeCurrent = this.getCurrentElement();
        if (nodeCurrent != null && node.isRecursiveSubElement(nodeCurrent)) {
            nodeParent.setCurrent(true);
        }
        nodeParent.destroySubElement(node);
        if (this.isShowing()) {
            this.recomputeLayout();
            this.recomputeScrollbars();
            this.repaint();
        }
    }

    public boolean isRootVisible() {
        return this.boolRootVisible;
    }

    public void setRootVisible(boolean boolVisible) {
        if (this.boolRootVisible == boolVisible) {
            return;
        }
        this.boolRootVisible = boolVisible;
        this.nodeRoot.setVisible(this.boolRootVisible);
        this.recomputeLayout();
        this.recomputeScrollbars();
        this.repaint();
    }

    public TreeNode getRootElement() {
        return this.nodeRoot;
    }

    public TreeNode findElement(String stringFullPath) {
        TreeNode node = this.nodeRoot.findElement(stringFullPath);
        return node;
    }

    public TreeNode getCurrentElement() {
        return this.nodeRoot.getCurrent();
    }

    public void setCurrentElement(TreeNode node) {
        if (node == null) {
            return;
        }
        if (!this.nodeRoot.isRecursiveSubElement(node)) {
            return;
        }
        node.setCurrent(true);
    }

    public boolean SetElementImage(TreeNode node, Image image) {
        boolean boolResult = this.nodeRoot.isRecursiveSubElement(node);
        if (!boolResult) {
            return false;
        }
        node.setImage(image);
        if (!this.vectorTreeElList.contains(node)) {
            return true;
        }
        this.recomputeLayout();
        this.recomputeScrollbars();
        this.repaint();
        return true;
    }

    public boolean setElementImageCur(TreeNode node, Image image) {
        boolean boolResult = this.nodeRoot.isRecursiveSubElement(node);
        if (!boolResult) {
            return false;
        }
        node.setImageCur(image);
        if (!this.vectorTreeElList.contains(node)) {
            return true;
        }
        this.recomputeLayout();
        this.recomputeScrollbars();
        this.repaint();
        return true;
    }

    public Dimension getPreferredSize() {
        Rectangle rect = this.nodeRoot.getNodeBoundsFull();
        Insets insets = this.getInsets();
        Dimension dim = new Dimension(rect.width + insets.left + insets.right, rect.height + insets.top + insets.bottom);
        return dim;
    }

    public Rectangle getClientArea() {
        Rectangle rectScrollbar;
        Rectangle rect = new Rectangle(this.getSize());
        Insets insets = this.getInsets();
        rect.x = insets.left;
        rect.y = insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        if (this.scrollBarVert != null && this.scrollBarVert.isVisible()) {
            rectScrollbar = this.scrollBarVert.getBounds();
            rect.width -= rectScrollbar.width;
        }
        if (this.scrollBarHorz != null && this.scrollBarHorz.isVisible()) {
            rectScrollbar = this.scrollBarHorz.getBounds();
            rect.height -= rectScrollbar.height;
        }
        if (rect.width < 0) {
            rect.width = 0;
        }
        if (rect.height < 0) {
            rect.height = 0;
        }
        return rect;
    }

    public void update(Graphics graphics) {
        if (this.isShowing()) {
            this.paint(graphics);
        }
    }

    public void paint(Graphics graphics) {
        Rectangle rect;
        Dimension dim = this.getSize();
        if (this.imageDraw == null || this.imageDraw.getWidth(this) < dim.width || this.imageDraw.getHeight(this) < dim.height) {
            this.imageDraw = this.createImage(dim.width, dim.height);
        }
        Graphics graphicsImage = this.imageDraw.getGraphics();
        graphicsImage.setColor(this.getBackground());
        graphicsImage.fillRect(0, 0, dim.width, dim.height);
        if (!this.boolLayoutDone) {
            this.recomputeLayout(graphicsImage);
            this.recomputeScrollbars();
        }
        Rectangle rectClientArea = this.getClientArea();
        graphicsImage.setFont(this.getFont());
        int nSize = this.vectorTreeElList.size();
        int nIndexTop = this.vectorTreeElList.indexOf(this.nodeTop);
        Rectangle rectTop = this.nodeTop.getNodeBounds();
        if (!this.boolRootVisible) {
            rect = this.nodeRoot.getNodeBounds();
            Rectangle rectFirst = this.nodeRoot.getSubElement(0).getNodeBounds();
            Rectangle rectLast = this.nodeRoot.getSubElement(this.nodeRoot.size() - 1).getNodeBounds();
            int nX = rectFirst.x - this.nScrollHorzLeft * this.nScrollHorzCell + 6 + 4;
            int nY = rectFirst.y + rectFirst.height / 2 - rectTop.y;
            int nY2 = rectLast.y + rectLast.height / 2 - rectTop.y;
            this.nodeRoot.drawDottedLine(graphicsImage, nX, nY, nX, nY2);
        }
        int i2 = 0;
        while (i2 < nSize) {
            TreeNode node = (TreeNode)this.vectorTreeElList.elementAt(i2);
            node.drawElement(graphicsImage, this.nScrollHorzLeft * this.nScrollHorzCell, rectTop.y);
            rect = node.getNodeBounds();
            if (rect.y + rect.height >= rectTop.y + rectClientArea.height) break;
            ++i2;
        }
        super.paint(graphicsImage);
        graphics.drawImage(this.imageDraw, 0, 0, this);
    }

    public void addNotify() {
        super.addNotify();
        this.addScrollbarVert();
        this.addScrollbarHorz();
    }

    public void componentResized(ComponentEvent event) {
        this.recomputeLayout();
        this.recomputeScrollbars();
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        this.requestFocus();
        if (event.getClickCount() % 2 == 1) {
            return;
        }
        Rectangle rect = this.nodeTop.getNodeBounds();
        Point point = new Point(event.getPoint());
        point.y += rect.y;
        point.x += this.nScrollHorzLeft * this.nScrollHorzCell;
        this.nodeRoot.onMouseDoubleclick(point);
    }

    public void mousePressed(MouseEvent event) {
        Rectangle rect = this.nodeTop.getNodeBounds();
        Point point = new Point(event.getPoint());
        point.y += rect.y;
        point.x += this.nScrollHorzLeft * this.nScrollHorzCell;
        int nModifiers = event.getModifiers();
        if ((nModifiers & 0x10) == 16) {
            this.nodeRoot.onMousePressedLeft(point, event.isShiftDown(), event.isControlDown(), event.isAltDown());
        } else if ((nModifiers & 4) == 4) {
            this.nodeRoot.onMousePressedRight(point, event.isShiftDown(), event.isControlDown(), event.isAltDown());
        }
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        int nIndexCurrent;
        char cKeyChar = event.getKeyChar();
        int nKeyCode = event.getKeyCode();
        int nModifiers = event.getModifiers();
        if (nKeyCode == 107) {
            this.nodeCurrent.setExpanded(true);
            return;
        }
        if (nKeyCode == 109) {
            this.nodeCurrent.setExpanded(false);
            return;
        }
        int nIndexCurrentNew = nIndexCurrent = this.vectorTreeElList.indexOf(this.nodeCurrent);
        if (nKeyCode == 40) {
            ++nIndexCurrentNew;
        } else if (nKeyCode == 34) {
            nIndexCurrentNew += this.nScrollVertVisible;
        } else if (nKeyCode == 38) {
            --nIndexCurrentNew;
        } else if (nKeyCode == 33) {
            nIndexCurrentNew -= this.nScrollVertVisible;
        } else if (nKeyCode == 35) {
            nIndexCurrentNew = this.vectorTreeElList.size() - 1;
        } else if (nKeyCode == 36) {
            nIndexCurrentNew = 0;
        }
        if (nIndexCurrentNew > this.vectorTreeElList.size() - 1) {
            nIndexCurrentNew = this.vectorTreeElList.size() - 1;
        }
        if (nIndexCurrentNew < 0) {
            nIndexCurrentNew = 0;
        }
        if (nIndexCurrentNew != nIndexCurrent) {
            this.nodeCurrent = (TreeNode)this.vectorTreeElList.elementAt(nIndexCurrentNew);
            this.nodeCurrent.setCurrent(true);
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void focusGained(FocusEvent event) {
        this.repaint();
    }

    public void focusLost(FocusEvent event) {
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        Adjustable adjustable = event.getAdjustable();
        if (adjustable == null || !(adjustable instanceof Scrollbar)) {
            return;
        }
        int nType = event.getAdjustmentType();
        int nValue = event.getValue();
        if (nValue != adjustable.getValue()) {
            adjustable.setValue(nValue);
        }
        if (((Scrollbar)adjustable).getOrientation() == 1) {
            int nIndexTop = this.vectorTreeElList.indexOf(this.nodeTop);
            if (nIndexTop != nValue) {
                nIndexTop = nValue;
                this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(nIndexTop);
                this.recomputeScrollbars();
                this.repaint();
            }
        } else if (this.nScrollHorzLeft != nValue) {
            this.nScrollHorzLeft = nValue;
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object objSource = event.getSource();
        if (objSource == null || !(objSource instanceof TreeNode)) {
            return;
        }
        String strAction = event.getActionCommand();
        if (strAction.equals("Node Added")) {
            this.recomputeTreeElList();
            if (this.vectorTreeElList.contains(objSource)) {
                this.recomputeLayout();
                this.recomputeScrollbars();
            }
            this.repaint();
        } else if (strAction.equals("Node Removed")) {
            if (this.vectorTreeElList.contains(objSource)) {
                this.recomputeTreeElList();
                this.recomputeLayout();
                this.recomputeScrollbars();
            }
            this.repaint();
        } else if (strAction.equals("Node Expanded")) {
            this.recomputeTreeElList();
            this.recomputeLayout();
            this.recomputeScrollbars();
            this.repaint();
        } else if (strAction.equals("Node Collapsed")) {
            this.recomputeTreeElList();
            this.recomputeLayout();
            this.recomputeScrollbars();
            this.repaint();
        } else if (strAction.equals("Node Set Current")) {
            this.nodeCurrent = (TreeNode)objSource;
            this.scrollCurrentIntoView();
            this.repaint();
        } else if (strAction.equals("Node Reset Current")) {
            // empty if block
        }
    }

    private void recomputeTreeElList() {
        boolean boolResult;
        if (this.nodeRoot == null) {
            return;
        }
        this.vectorTreeElList.removeAllElements();
        this.nodeRoot.addToTreeElList(this.vectorTreeElList);
        while (this.nodeTop != null) {
            boolResult = this.vectorTreeElList.contains(this.nodeTop);
            if (boolResult) break;
            this.nodeTop = this.nodeTop.getOwner();
        }
        if (this.nodeTop == null && this.vectorTreeElList.size() > 0) {
            this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(0);
        }
        if (this.nodeTop == null) {
            this.nodeTop = this.nodeRoot;
        }
        TreeNode nodeCurrentOld = this.nodeCurrent;
        while (this.nodeCurrent != null) {
            boolResult = this.vectorTreeElList.contains(this.nodeCurrent);
            if (boolResult) break;
            this.nodeCurrent = this.nodeCurrent.getOwner();
        }
        if (this.nodeCurrent == null && this.vectorTreeElList.size() > 0) {
            this.nodeCurrent = (TreeNode)this.vectorTreeElList.elementAt(0);
        }
        if (this.nodeCurrent == null) {
            this.nodeCurrent = this.nodeRoot;
        }
        if (nodeCurrentOld != this.nodeCurrent) {
            if (nodeCurrentOld != null) {
                nodeCurrentOld.setCurrent(false);
            }
            if (this.nodeCurrent != null) {
                this.nodeCurrent.setCurrent(true);
            }
        }
    }

    private void recomputeLayout() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.recomputeLayout(graphics);
        }
    }

    private void recomputeLayout(Graphics graphics) {
        Font font = this.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        rect = this.nodeRoot.recomputeLayout(rect, fontMetrics);
        Rectangle rectClientArea = this.getClientArea();
        int nIndexTop = this.vectorTreeElList.indexOf(this.nodeTop);
        Rectangle rectTop = this.nodeTop.getNodeBounds();
        while (nIndexTop > 0 && rectClientArea.height > rect.height - (rectTop.y - rect.y)) {
            this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(--nIndexTop);
            rectTop = this.nodeTop.getNodeBounds();
        }
        this.boolLayoutDone = true;
    }

    public void addScrollbarVert() {
        this.scrollBarVert = new Scrollbar(1);
        this.scrollBarVert.addAdjustmentListener(this);
        this.scrollBarVert.setUnitIncrement(1);
        this.add(this.scrollBarVert);
    }

    public void addScrollbarHorz() {
        this.scrollBarHorz = new Scrollbar(0);
        this.scrollBarHorz.addAdjustmentListener(this);
        this.scrollBarHorz.setUnitIncrement(1);
        this.add(this.scrollBarHorz);
    }

    public void removeScrollbarVert() {
        this.scrollBarVert.removeAdjustmentListener(this);
        this.remove(this.scrollBarVert);
        this.scrollBarVert = null;
    }

    public void removeScrollbarHorz() {
        this.scrollBarHorz.removeAdjustmentListener(this);
        this.remove(this.scrollBarHorz);
        this.scrollBarHorz = null;
    }

    private void recomputeScrollbars() {
        Rectangle rect;
        if (!this.boolLayoutDone) {
            return;
        }
        int nSize = this.vectorTreeElList.size();
        int nIndexTop = this.vectorTreeElList.indexOf(this.nodeTop);
        Rectangle rectTop = this.nodeTop.getNodeBounds();
        Rectangle rectClientArea = this.getClientArea();
        int i2 = nIndexTop;
        while (i2 < nSize) {
            TreeNode node = (TreeNode)this.vectorTreeElList.elementAt(i2);
            rect = node.getNodeBounds();
            if (rect.y + rect.height - rectTop.y > rectClientArea.height) break;
            ++i2;
        }
        this.nScrollVertVisible = i2 - nIndexTop;
        this.setScrollbarVertValues(nIndexTop, this.nScrollVertVisible, 0, nSize);
        rect = this.nodeRoot.getNodeBoundsFull();
        this.nScrollHorzMax = (rect.width + this.nScrollHorzCell - 1) / this.nScrollHorzCell;
        this.nScrollHorzVisible = rectClientArea.width / this.nScrollHorzCell;
        this.setScrollbarHorzValues(this.nScrollHorzLeft, this.nScrollHorzVisible, 0, this.nScrollHorzMax);
        rect = this.getClientArea();
        if (!rectClientArea.equals(rect)) {
            this.recomputeScrollbars();
        }
    }

    private void scrollCurrentIntoView() {
        if (!this.boolLayoutDone) {
            return;
        }
        int nSize = this.vectorTreeElList.size();
        int nIndexCurrent = this.vectorTreeElList.indexOf(this.nodeCurrent);
        if (nIndexCurrent < 0) {
            return;
        }
        int nIndexTop = this.vectorTreeElList.indexOf(this.nodeTop);
        int nIndexTopNew = nIndexTop;
        if (nIndexCurrent >= nIndexTopNew + this.nScrollVertVisible) {
            Rectangle rectClientArea = this.getClientArea();
            Rectangle rectCurrent = this.nodeCurrent.getNodeBounds();
            if (nIndexTopNew < nSize - 1) {
                this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(++nIndexTopNew);
                Rectangle rectTop = this.nodeTop.getNodeBounds();
                if (rectCurrent.y + rectCurrent.height - rectTop.y > rectClientArea.height) {
                    // empty if block
                }
            }
        }
        if (nIndexCurrent < nIndexTopNew) {
            nIndexTopNew = nIndexCurrent;
            this.nodeTop = (TreeNode)this.vectorTreeElList.elementAt(nIndexTopNew);
        }
        if (nIndexTopNew != nIndexTop) {
            this.recomputeScrollbars();
        }
    }

    public boolean setScrollbarVertValues(int nValue, int nVisibleCount, int nMinValue, int nMaxValue) {
        if (this.scrollBarVert == null) {
            return false;
        }
        boolean boolResult = this.scrollBarVert.isVisible();
        this.scrollBarVert.setValues(nValue, nVisibleCount, nMinValue, nMaxValue);
        if (nVisibleCount - 1 < 1) {
            this.scrollBarVert.setBlockIncrement(1);
        } else {
            this.scrollBarVert.setBlockIncrement(nVisibleCount - 1);
        }
        boolean boolVisible = nMaxValue - nMinValue > nVisibleCount;
        this.scrollBarVert.setVisible(boolVisible);
        this.positionScrollbars();
        this.scrollBarVert.setValues(nValue, nVisibleCount, nMinValue, nMaxValue);
        if (nVisibleCount - 1 < 1) {
            this.scrollBarVert.setBlockIncrement(1);
        } else {
            this.scrollBarVert.setBlockIncrement(nVisibleCount - 1);
        }
        return boolResult != boolVisible;
    }

    public boolean setScrollbarHorzValues(int nValue, int nVisibleCount, int nMinValue, int nMaxValue) {
        if (this.scrollBarHorz == null) {
            return false;
        }
        boolean boolResult = this.scrollBarHorz.isVisible();
        this.scrollBarHorz.setValues(nValue, nVisibleCount, nMinValue, nMaxValue);
        if (nVisibleCount - 1 < 1) {
            this.scrollBarHorz.setBlockIncrement(1);
        } else {
            this.scrollBarHorz.setBlockIncrement(nVisibleCount - 1);
        }
        boolean boolVisible = nMaxValue - nMinValue > nVisibleCount;
        this.scrollBarHorz.setVisible(boolVisible);
        this.positionScrollbars();
        this.scrollBarHorz.setValues(nValue, nVisibleCount, nMinValue, nMaxValue);
        if (nVisibleCount - 1 < 1) {
            this.scrollBarHorz.setBlockIncrement(1);
        } else {
            this.scrollBarHorz.setBlockIncrement(nVisibleCount - 1);
        }
        return boolResult != boolVisible;
    }

    private void positionScrollbars() {
        Dimension dimHorz;
        Dimension dimVert;
        Rectangle rect = this.getBounds();
        Insets insets = this.getInsets();
        rect.x = insets.left;
        rect.y = insets.top;
        rect.width = rect.width - insets.left - insets.right;
        rect.height = rect.height - insets.top - insets.bottom;
        if (this.scrollBarVert != null && this.scrollBarVert.isVisible()) {
            dimVert = this.scrollBarVert.getPreferredSize();
            dimVert.width += 2;
        } else {
            dimVert = new Dimension(0, 0);
        }
        if (this.scrollBarHorz != null && this.scrollBarHorz.isVisible()) {
            dimHorz = this.scrollBarHorz.getPreferredSize();
            dimHorz.height += 2;
        } else {
            dimHorz = new Dimension(0, 0);
        }
        if (this.scrollBarVert != null) {
            this.scrollBarVert.setBounds(rect.x + rect.width - dimVert.width, rect.y, dimVert.width, rect.height - dimHorz.height);
        }
        if (this.scrollBarHorz != null) {
            this.scrollBarHorz.setBounds(rect.x, rect.y + rect.height - dimHorz.height, rect.width - dimVert.width, dimHorz.height);
        }
    }
}

