;;;
;;; irchat-pj-specific-xmas.el
;;; last modify : Thu, 28 Oct 1999 00:04:46 +0900
;;;               by simm@irc.fan.gr.jp / irchat-PJ Project
;;; (date format modification by simm@irc.fan.gr.jp, Sun, 27 Jun 1999)
;;; see file irchat-copyright.el for change log and copyright info
;;;

;;; for irchat-pj-coding-system.el

;; support tab or not

(defun irchat-pj-tab-supported-xemacs-p ()
  (or (< 21 emacs-major-version)
      (and (= 21 emacs-major-version)
	   (or (< 2  emacs-minor-version)
	       (and (= 2  emacs-minor-version)
		    (let (beta)
		      (string-match "[0-9]+" xemacs-betaname)
		      (setq beta (string-to-number
				  (substring xemacs-betaname(match-beginning 0) (match-end 0))))
		      (<= 20 beta)))))))

;; define service / set process

(defsubst irchat-pj-define-service-coding-system (service)
  (modify-coding-system-alist 'network service (cons 'no-conversion 'no-conversion)))

(defsubst irchat-pj-set-process-coding-system (proc)
  (set-process-coding-system proc 'no-conversion 'no-conversion))

;; output functions

(defsubst irchat-pj-string-out-iso-2022-7bit-ss2 (str)
  (encode-coding-string str 'iso-2022-7bit-ss2))

(defsubst irchat-pj-string-out-iso-2022-jp (str)
  (encode-coding-string str 'iso-2022-jp))

(defsubst irchat-pj-string-out-euc-jp (str)
  (encode-coding-string str 'euc-jp))

(defsubst irchat-pj-string-out-sjis (str)
  (encode-coding-string str 'shift_jis))

;; input functions

(defsubst irchat-pj-string-in-iso-2022-7bit-ss2 (str)
  (decode-coding-string str 'iso-2022-7bit-ss2))

(defsubst irchat-pj-string-in-iso-2022-jp (str)
  (decode-coding-string str 'iso-2022-jp))

(defsubst irchat-pj-string-in-euc-jp-internal (str)
  (decode-coding-string str 'euc-jp))

(defsubst irchat-pj-string-in-sjis-internal (str)
  (decode-coding-string str 'shift_jis))

;;; for irchat-pj-version-string.el

(defun irchat-pj-set-emacs-version-string ()
  "Set Emacs version string for CTCP VERSION"
  (concat (cond ((featurep 'utf-2000)
		 (concat "UTF-2000-MULE/"
			 (if (boundp 'rail-ja-utf-2000-version)
			     rail-ja-utf-2000-version
			   (let ((stop (string-match " " utf-2000-version)))
			     (if stop
				 (substring utf-2000-version 0 stop)
			       utf-2000-version)))))
		((featurep 'mule)
		 "MULE")
		(t
		 ""))
	  " XEmacs "
	  (if (string-match " " emacs-version)
	      (substring emacs-version 0 (match-beginning 0))
	    "")
	  (cond ((stringp xemacs-betaname)
		 (concat "-" (substring xemacs-betaname 1 (1- (length xemacs-betaname)))))
		((numberp emacs-patch-level)
		 (concat "-patch" (number-to-string emacs-patch-level)))
		(t
		 ""))
	  " \""
	  (if (boundp 'rail-ja-xemacs-codename)
	      rail-ja-xemacs-codename
	    xemacs-codename)
	  "\" (" system-configuration ")"))

(provide 'irchat-pj-specific-xmas)

;;;
;;; end
;;;
