#!/bin/sh

#
# $Id: pks-queue-run.sh,v 1.4 1996/12/11 19:17:27 marc Exp $
#
# Copyright (c) 1996, Marc Horowitz.  All rights reserved.
# See the LICENSE file in the release for redistribution information.

conf="$1"

case "X$conf" in
	X)
		echo "usage: $0 conf_file" 1>&2
		exit 1
		;;
esac

[ ! -r $conf ] && {
	echo "conf_file $conf is not readable" 1>&2
	exit 1
}
		
dir=`awk '/mail_dir/ { print $2 }' < $conf`
socket=`awk '/socket_name/ { print $2 }' < $conf`
bindir=`awk '/pks_bin_dir/ { print $2 }' < $conf`

for file in $dir/pks-mail.*; do
	if [ -r "$file" ]; then
		$bindir/pksdctl $socket "mail $file"
	fi
done
