# finger.pl --- A script for orabidoo's sirc
# 18 April 1995 by GG <choude@eece.maine.edu>
# modified and debugged by orabidoo <roger.espel.llima@ens.fr>

# Adds the capability to finger a user@host from either the nick or the
# actual user@host.  Uses the unix finger command to accomplish this

# 3 Nov 95: fixed a bug reported by Haaino Zuithoff (missing \)

$add_ons .= "+finger.pl";

sub GGfinger {
  if (fork) {
    foreach (`finger $_[0]`) {
      &tell($_);
      }
    exit 0;
    }
  }

sub cmd_finger {
  &tell("*\c_Finger Error\c_* usage /finger <nick> or /finger <user>\@<host>"), return unless $args;
  if ($args =~ /\@/) {
    &GGfinger($args);
    }
  else {
    &userhost($args, "&tell(\"*\c_Finger Reply\c_* \$who!\$user\\\@\$host\");
    		      \$user =~ s/^~//;
		      &GGfinger(\$user.'\@'.\$host);");
    }
  }

&addcmd("finger");

