###############################################################################
# quiet.pl filters join/leave/kick/signoff and changenick. A join can
# be seen only when the person says something in public. A leave can
# be seen only if the join was seen. A kick can be seen only if the
# join was seen, etc. Use the /quiet #channel command to add a channel
# in the list of filtered channels.

$add_ons.="+quiet.pl" if $add_ons !~ /quiet/;

sub cmd_quiet {
    &getarg;
    if($newarg) {
	local($c) = $newarg; $c =~ tr/[A-Z]/[a-z]/;
	unless ($c =~ /^[\#\&\+]/) { $c='#'.$c; }
	if($quiet_channel{$c}) {
	    delete $quiet_channel{$c};
	    &tell("*\cbq\cb* Removing $c from the list of filtered channels\n");
	} else {
	    $quiet_channel{$c} = 1;
	    &tell("*\cbq\cb* Adding $c to the list of filtered channels\n");
	}
    } else {
	local($s) = "*\cbq\cb* Quiet channels :";
	foreach $c ( keys %quiet_channel ) {
	    $s .= " ";
	    $s .= $c;
	}
	&tell($s);
    }
}

&addcmd("quiet");

sub hook_q_join {
    local($c) = $_[0]; $c =~ tr/[A-Z]/[a-z]/;
    if($quiet_channel{$c}) {
	$have_joined{$c}{$who} = "$user\@$host";
	$silent = 1;
    }
}

sub hook_q_leave {
    local($c) = $_[0]; $c =~ tr/[A-Z]/[a-z]/;
    if($have_joined{$c}{$who}) {
	delete $have_joined{$c}{$who};
	$silent = 1;
    }
}

sub hook_q_kick {
    local($c) = $_[1]; $c =~ tr/[A-Z]/[a-z]/;
    if($have_joined{$c}{$_[0]}) {
	delete $have_joined{$c}{$_[0]};
	$silent = 1;
    }
}

sub hook_q_nick {
    foreach $c ( keys %quiet_channel ) {
	if($have_joined{$c}{$who}) {
	    &tell("*\cbq\cb* $who ($have_joined{$c}{$who}) is in channel $c");
	    delete $have_joined{$c}{$who};
	}
    }
}

sub hook_q_public {
    local($c) = $_[0]; $c =~ tr/[A-Z]/[a-z]/;
    if($have_joined{$c}{$who}) {
	&tell("*\cbq\cb* $who ($have_joined{$c}{$who}) is in channel $c");
	delete $have_joined{$c}{$who};
    }
}

sub hook_q_signoff {
    foreach $c ( keys %quiet_channel ) {
	delete $have_joined{$c}{$who};
    }
}

sub hook_q_mode {
    local($c) = $_[0]; $c =~ tr/[A-Z]/[a-z]/;
    if($quiet_channel{$c}) {
	if($args =~ /^[\+\-][lsnmk]/) {
	    $silent = 1; 
	}
    }
}

&addhook("join", "q_join");
&addhook("leave", "q_leave");
&addhook("kick", "q_kick");
&addhook("nick", "q_nick");
&addhook("public", "q_public");
&addhook("signoff", "q_signoff");
&addhook("mode", q_mode);

&addhelp("quiet", "Usage: \cbQUIET\cb [<channel>]
Without argument, shows the list of quiet channels, with an argument adds the channel or removes it.");

&print("*\cbq\cb* \cbTHX-1138\cb's quiet.pl loaded");
