/*
 * Decompiled with CFR 0.152.
 */
package net.pflaeging.PortableSigner;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.xml.xmp.XmpWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import net.pflaeging.PortableSigner.GetPKCS12;
import net.pflaeging.PortableSigner.PDFSignerException;
import net.pflaeging.PortableSigner.Version;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PDFSigner {
    private static PrivateKey privateKey;
    private static Certificate[] certificateChain;
    private static GetPKCS12 pkcs12;
    public float ptToCm = 0.035277776f;

    public void doSignPDF(String pdfInputFileName, String pdfOutputFileName, String pkcs12FileName, String password, Boolean signText, String signLanguage, String sigLogo, Boolean finalize, String sigComment, String signReason, String signLocation, Boolean noExtraPage, float verticalPos, float leftMargin, float rightMargin, Boolean signLastPage, byte[] ownerPassword) throws PDFSignerException {
        try {
            System.err.println("Position V:" + verticalPos + " L:" + leftMargin + " R:" + rightMargin);
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
            pkcs12 = new GetPKCS12(pkcs12FileName, password);
            PdfReader reader = null;
            try {
                reader = ownerPassword == null ? new PdfReader(pdfInputFileName) : new PdfReader(pdfInputFileName, ownerPassword);
            }
            catch (IOException e) {
                throw new PDFSignerException(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CouldNotBeOpened"), true, e.getLocalizedMessage());
            }
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(pdfOutputFileName);
            }
            catch (FileNotFoundException e) {
                throw new PDFSignerException(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CouldNotBeWritten"), true, e.getLocalizedMessage());
            }
            PdfStamper stp = null;
            try {
                Date datum = new Date(System.currentTimeMillis());
                int pages = reader.getNumberOfPages();
                Rectangle size = reader.getPageSize(pages);
                stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)fout, (char)'\u0000', null, (boolean)true);
                HashMap pdfInfo = reader.getInfo();
                String pdfInfoProducer = "";
                if (pdfInfo.get("Producer") != null) {
                    pdfInfoProducer = pdfInfo.get("Producer").toString();
                    pdfInfoProducer = pdfInfoProducer + " (signed with PortableSigner " + Version.release + ")";
                } else {
                    pdfInfoProducer = "Unknown Producer (signed with PortableSigner " + Version.release + ")";
                }
                pdfInfo.put("Producer", pdfInfoProducer);
                stp.setMoreInfo((Map)pdfInfo);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XmpWriter xmp = new XmpWriter((OutputStream)baos, (Map)pdfInfo);
                xmp.close();
                stp.setXmpMetadata(baos.toByteArray());
                if (signText.booleanValue()) {
                    float[] cellsize;
                    float verticalPositionPT;
                    int leftMarginPT;
                    int rightMarginPT;
                    int sigpage;
                    int specialcount = 0;
                    ResourceBundle block = ResourceBundle.getBundle("net/pflaeging/PortableSigner/Signatureblock_" + signLanguage);
                    String greet = block.getString("greeting");
                    String signator = block.getString("signator");
                    String datestr = block.getString("date");
                    String ca = block.getString("issuer");
                    String serial = block.getString("serial");
                    String special = block.getString("special");
                    String note = block.getString("note");
                    String urn = block.getString("urn");
                    String urnvalue = block.getString("urnvalue");
                    float topy = size.getTop();
                    System.err.println("Top: " + topy * this.ptToCm);
                    float rightx = size.getRight();
                    System.err.println("Right: " + rightx * this.ptToCm);
                    if (!noExtraPage.booleanValue()) {
                        sigpage = pages + 1;
                        stp.insertPage(sigpage, size);
                        rightMarginPT = 30;
                        leftMarginPT = 30;
                        verticalPositionPT = topy - 20.0f;
                    } else {
                        sigpage = signLastPage != false ? pages : 1;
                        System.err.println("Page: " + sigpage);
                        rightMarginPT = Math.round(rightMargin / this.ptToCm);
                        leftMarginPT = Math.round(leftMargin / this.ptToCm);
                        verticalPositionPT = topy - (float)Math.round(verticalPos / this.ptToCm);
                    }
                    if (!GetPKCS12.atEgovOID.equals("")) {
                        specialcount = 1;
                    }
                    PdfContentByte content = stp.getOverContent(sigpage);
                    cellsize = new float[]{100.0f, rightx - (float)rightMarginPT - (float)leftMarginPT - cellsize[0] - cellsize[1] - 70.0f};
                    PdfPTable signatureBlockCompleteTable = new PdfPTable(2);
                    PdfPTable signatureTextTable = new PdfPTable(2);
                    PdfPCell signatureBlockHeadingCell = new PdfPCell((Phrase)new Paragraph(new Chunk(greet, new Font(Font.FontFamily.HELVETICA, 12.0f))));
                    signatureBlockHeadingCell.setPaddingBottom(5.0f);
                    signatureBlockHeadingCell.setColspan(2);
                    signatureBlockHeadingCell.setBorderWidth(0.0f);
                    signatureBlockCompleteTable.addCell(signatureBlockHeadingCell);
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(signator, new Font(Font.FontFamily.HELVETICA, 10.0f, 1))));
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(GetPKCS12.subject, new Font(Font.FontFamily.COURIER, 10.0f))));
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(datestr, new Font(Font.FontFamily.HELVETICA, 10.0f, 1))));
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(datum.toString(), new Font(Font.FontFamily.COURIER, 10.0f))));
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(ca, new Font(Font.FontFamily.HELVETICA, 10.0f, 1))));
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(GetPKCS12.issuer, new Font(Font.FontFamily.COURIER, 10.0f))));
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(serial, new Font(Font.FontFamily.HELVETICA, 10.0f, 1))));
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(GetPKCS12.serial.toString(), new Font(Font.FontFamily.COURIER, 10.0f))));
                    if (specialcount == 1) {
                        signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(special, new Font(Font.FontFamily.HELVETICA, 10.0f, 1))));
                        signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(GetPKCS12.atEgovOID, new Font(Font.FontFamily.COURIER, 10.0f))));
                    }
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(urn, new Font(Font.FontFamily.HELVETICA, 10.0f, 1))));
                    signatureTextTable.addCell((Phrase)new Paragraph(new Chunk(urnvalue, new Font(Font.FontFamily.COURIER, 10.0f))));
                    signatureTextTable.setTotalWidth(cellsize);
                    System.err.println("signatureTextTable Width: " + cellsize[0] * this.ptToCm + " " + cellsize[1] * this.ptToCm);
                    signatureBlockCompleteTable.setHorizontalAlignment(1);
                    Image logo = sigLogo.equals("") || sigLogo == null ? Image.getInstance((URL)this.getClass().getResource("/net/pflaeging/PortableSigner/SignatureLogo.png")) : Image.getInstance((String)sigLogo);
                    PdfPCell logocell = new PdfPCell();
                    logocell.setVerticalAlignment(5);
                    logocell.setHorizontalAlignment(1);
                    logocell.setImage(logo);
                    signatureBlockCompleteTable.addCell(logocell);
                    PdfPCell incell = new PdfPCell(signatureTextTable);
                    incell.setBorderWidth(0.0f);
                    signatureBlockCompleteTable.addCell(incell);
                    PdfPCell commentcell = new PdfPCell((Phrase)new Paragraph(new Chunk(sigComment, new Font(Font.FontFamily.HELVETICA, 10.0f))));
                    PdfPCell notecell = new PdfPCell((Phrase)new Paragraph(new Chunk(note, new Font(Font.FontFamily.HELVETICA, 10.0f, 1))));
                    if (!sigComment.equals("")) {
                        signatureBlockCompleteTable.addCell(notecell);
                        signatureBlockCompleteTable.addCell(commentcell);
                    }
                    float[] cells = new float[]{70.0f, cellsize[0] + cellsize[1]};
                    signatureBlockCompleteTable.setTotalWidth(cells);
                    System.err.println("signatureBlockCompleteTable Width: " + cells[0] * this.ptToCm + " " + cells[1] * this.ptToCm);
                    signatureBlockCompleteTable.writeSelectedRows(0, 4 + specialcount, (float)leftMarginPT, verticalPositionPT, content);
                    System.err.println("signatureBlockCompleteTable Position " + 30.0f * this.ptToCm + " " + (topy - 20.0f) * this.ptToCm);
                    Rectangle signatureBlock = new Rectangle(30.0f + signatureBlockCompleteTable.getTotalWidth() - 20.0f, topy - 20.0f - 20.0f, 30.0f + signatureBlockCompleteTable.getTotalWidth(), topy - 20.0f);
                } else {
                    Rectangle signatureBlock = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
                }
                PdfSignatureAppearance sap = stp.getSignatureAppearance();
                sap.setCrypto(GetPKCS12.privateKey, GetPKCS12.certificateChain, null, PdfSignatureAppearance.WINCER_SIGNED);
                sap.setReason(signReason);
                sap.setLocation(signLocation);
                if (finalize.booleanValue()) {
                    sap.setCertificationLevel(1);
                } else {
                    sap.setCertificationLevel(0);
                }
                stp.close();
            }
            catch (Exception e) {
                throw new PDFSignerException(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("ErrorWhileSigningFile"), true, e.getLocalizedMessage());
            }
        }
        catch (KeyStoreException kse) {
            throw new PDFSignerException(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("ErrorCreatingKeystore"), true, kse.getLocalizedMessage());
        }
    }
}

