/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.i18n;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.DefaultNumberRule;
import net.sf.freecol.common.i18n.DualNumberRule;
import net.sf.freecol.common.i18n.Number;
import net.sf.freecol.common.i18n.OtherNumberRule;
import net.sf.freecol.common.i18n.PluralNumberRule;
import net.sf.freecol.common.i18n.Rule;
import net.sf.freecol.common.i18n.ZeroOneNumberRule;
import net.sf.freecol.common.io.FreeColXMLReader;

public class NumberRules {
    private static final Logger logger = Logger.getLogger(NumberRules.class.getName());
    public static final Number OTHER_NUMBER_RULE = new OtherNumberRule();
    public static final Number DUAL_NUMBER_RULE = new DualNumberRule();
    public static final Number PLURAL_NUMBER_RULE = new PluralNumberRule();
    public static final Number ZERO_ONE_NUMBER_RULE = new ZeroOneNumberRule();
    private static final Map<String, Number> numberMap = new HashMap<String, Number>();
    private static final String COUNT_TAG = "count";
    private static final String GENERATION_TAG = "generation";
    private static final String LOCALES_TAG = "locales";
    private static final String PLURALS_TAG = "plurals";
    private static final String PLURAL_RULE_TAG = "pluralRule";
    private static final String PLURAL_RULES_TAG = "pluralRules";
    private static final String VERSION_TAG = "version";

    public NumberRules(InputStream in) {
        NumberRules.load(in);
    }

    public static Number getNumberForLanguage(String lang) {
        Number number = numberMap.get(lang);
        return number == null ? OTHER_NUMBER_RULE : number;
    }

    public static boolean isInitialized() {
        return !numberMap.isEmpty();
    }

    public static void load(InputStream in) {
        try (FreeColXMLReader xr = new FreeColXMLReader(in);){
            NumberRules.readFromXML(xr);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Load parse", e);
            throw new RuntimeException("Error parsing number rules.", e);
        }
    }

    private static void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        while (xr.nextTag() != 2) {
            String tag = xr.getLocalName();
            if (null == tag) continue;
            switch (tag) {
                case "version": {
                    xr.nextTag();
                    break;
                }
                case "generation": {
                    xr.nextTag();
                    break;
                }
                case "plurals": {
                    while (xr.nextTag() != 2) {
                        tag = xr.getLocalName();
                        if (!PLURAL_RULES_TAG.equals(tag)) continue;
                        NumberRules.readChild(xr);
                    }
                    break;
                }
            }
        }
    }

    private static void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String[] locales;
        String loc = xr.getAttribute(LOCALES_TAG, null);
        String[] stringArray = locales = loc == null ? null : loc.split(" ");
        if (locales != null) {
            DefaultNumberRule numberRule = new DefaultNumberRule();
            while (xr.nextTag() != 2) {
                if (!PLURAL_RULE_TAG.equals(xr.getLocalName())) continue;
                String plu = xr.getAttribute(COUNT_TAG, null);
                Number.Category category = Number.Category.valueOf(plu);
                Object rule = new Rule(xr.getElementText());
                numberRule.addRule(category, (Rule)rule);
            }
            Number number = null;
            switch (numberRule.countRules()) {
                case 0: {
                    number = OTHER_NUMBER_RULE;
                    break;
                }
                case 1: {
                    Rule rule = numberRule.getRule(Number.Category.one);
                    if (rule == null || null == rule.toString()) break;
                    switch (rule.toString()) {
                        case "n is 1": {
                            number = PLURAL_NUMBER_RULE;
                            break;
                        }
                        case "n in 0..1": {
                            number = ZERO_ONE_NUMBER_RULE;
                        }
                    }
                    break;
                }
                case 2: {
                    Rule oneRule = numberRule.getRule(Number.Category.one);
                    Rule twoRule = numberRule.getRule(Number.Category.two);
                    if (oneRule == null || !"n is 1".equals(oneRule.toString()) || twoRule == null || !"n is 2".equals(twoRule.toString())) break;
                    number = DUAL_NUMBER_RULE;
                    break;
                }
                default: {
                    number = numberRule;
                }
            }
            for (String locale : locales) {
                numberMap.put(locale, number);
            }
        }
    }
}

