/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.Jin;
import free.jin.Preferences;
import free.jin.Session;
import free.jin.SessionEvent;
import free.jin.SessionListener;
import free.jin.User;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginUIContainer;
import free.jin.ui.AbstractPluginUIContainer;
import free.jin.ui.PluginContainersMenu;
import free.jin.ui.UIProvider;
import free.util.AWTUtilities;
import free.util.Pair;
import free.util.RectDouble;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;

public abstract class AbstractUiProvider
implements UIProvider,
SessionListener {
    private final Hashtable pluginContainers = new Hashtable();
    private final Vector creationNotifiedMenus = new Vector();

    public void start() {
        Jin.getInstance().getConnManager().addSessionListener(this);
    }

    public void sessionEstablished(SessionEvent sessionEvent) {
        this.loadSelectedFrame(sessionEvent.getSession());
        Enumeration enumeration = this.getExistingPluginUIContainers();
        while (enumeration.hasMoreElements()) {
            AbstractPluginUIContainer abstractPluginUIContainer = (AbstractPluginUIContainer)enumeration.nextElement();
            if (abstractPluginUIContainer.getMode() != 1) continue;
            abstractPluginUIContainer.setVisible(abstractPluginUIContainer.getPlugin().getPrefs().getBool(abstractPluginUIContainer.getPrefsPrefix() + "visible", true));
        }
    }

    public void sessionClosed(SessionEvent sessionEvent) {
        this.saveSelectedFrame(sessionEvent.getSession());
        Enumeration enumeration = this.getExistingPluginUIContainers();
        while (enumeration.hasMoreElements()) {
            AbstractPluginUIContainer abstractPluginUIContainer = (AbstractPluginUIContainer)enumeration.nextElement();
            if (abstractPluginUIContainer.getMode() != 1) continue;
            abstractPluginUIContainer.getPlugin().getPrefs().setBool(abstractPluginUIContainer.getPrefsPrefix() + "visible", abstractPluginUIContainer.isVisible());
        }
        this.removePluginContainers();
    }

    private void loadSelectedFrame(Session session) {
        User user = session.getUser();
        String string = user.getPrefs().getString("selected.plugin", null);
        String string2 = user.getPrefs().getString("selected.container", null);
        Enumeration enumeration = this.pluginContainers.elements();
        while (enumeration.hasMoreElements()) {
            PluginUIContainer pluginUIContainer = (PluginUIContainer)enumeration.nextElement();
            if (!pluginUIContainer.getPlugin().getId().equals(string) || !pluginUIContainer.getId().equals(string2)) continue;
            if (!pluginUIContainer.isVisible()) break;
            pluginUIContainer.setActive(true);
            break;
        }
    }

    private void saveSelectedFrame(Session session) {
        User user = session.getUser();
        Enumeration enumeration = this.pluginContainers.elements();
        while (enumeration.hasMoreElements()) {
            PluginUIContainer pluginUIContainer = (PluginUIContainer)enumeration.nextElement();
            if (!pluginUIContainer.isActive()) continue;
            String string = pluginUIContainer.getId();
            String string2 = pluginUIContainer.getPlugin().getId();
            if (string == null) break;
            user.getPrefs().setString("selected.plugin", string2);
            user.getPrefs().setString("selected.container", string);
            break;
        }
    }

    protected final void addPluginContainer(Plugin plugin, String string, AbstractPluginUIContainer abstractPluginUIContainer) {
        Pair pair;
        Object object;
        if (string != null && (object = this.pluginContainers.put(pair = new Pair(plugin, string), abstractPluginUIContainer)) != null) {
            this.pluginContainers.put(pair, object);
            throw new IllegalArgumentException("Cannot allocate a container with the same id twice");
        }
        for (int i = 0; i < this.creationNotifiedMenus.size(); ++i) {
            object = (PluginContainersMenu)this.creationNotifiedMenus.elementAt(i);
            ((PluginContainersMenu)object).pluginContainerAdded(abstractPluginUIContainer);
        }
    }

    public Enumeration getExistingPluginUIContainers() {
        return this.pluginContainers.elements();
    }

    public void addPluginUIContainerCreationListener(PluginContainersMenu pluginContainersMenu) {
        this.creationNotifiedMenus.addElement(pluginContainersMenu);
    }

    public void removePluginUIContainerCreationListener(PluginContainersMenu pluginContainersMenu) {
        this.creationNotifiedMenus.removeElement(pluginContainersMenu);
    }

    protected void removePluginContainers() {
        Enumeration enumeration = this.pluginContainers.elements();
        while (enumeration.hasMoreElements()) {
            ((PluginUIContainer)enumeration.nextElement()).dispose();
        }
        this.pluginContainers.clear();
    }

    protected void restoreFrameGeometry(Preferences preferences, JFrame jFrame, String string, RectDouble rectDouble) {
        Dimension dimension = AWTUtilities.getUsableScreenBounds().getSize();
        Rectangle rectangle = rectDouble.scale(dimension.width, dimension.height).toRect();
        Rectangle rectangle2 = preferences.getRect(string + "bounds", rectangle);
        rectangle2 = this.frameBoundsOk(dimension, rectangle2) ? rectangle2 : rectangle;
        jFrame.setBounds(rectangle2);
        boolean bl = preferences.getBool(string + "maximized.vert", false);
        boolean bl2 = preferences.getBool(string + "maximized.horiz", false);
        if (jFrame.getPeer() == null) {
            jFrame.addNotify();
        }
        int n = (bl ? 4 : 0) | (bl2 ? 2 : 0);
        AWTUtilities.setExtendedFrameState(jFrame, n);
    }

    protected void saveFrameGeometry(Preferences preferences, JFrame jFrame, String string) {
        Point point = jFrame.isVisible() ? jFrame.getLocationOnScreen() : jFrame.getLocation();
        Dimension dimension = jFrame.getSize();
        preferences.setRect(string + "bounds", new Rectangle(point, dimension));
        int n = AWTUtilities.getExtendedFrameState(jFrame);
        preferences.setBool(string + "maximized.vert", (n & 4) != 0);
        preferences.setBool(string + "maximized.horiz", (n & 2) != 0);
    }

    protected boolean frameBoundsOk(Dimension dimension, Rectangle rectangle) {
        if (rectangle.x + rectangle.width < 50) {
            return false;
        }
        if (rectangle.y < -10) {
            return false;
        }
        if (rectangle.width < 30) {
            return false;
        }
        if (rectangle.height < 40) {
            return false;
        }
        if (rectangle.x > dimension.width - 10) {
            return false;
        }
        return rectangle.y <= dimension.height - 20;
    }
}

