/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.Handshake;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.net.ssl.SSLProtocolException;

final class Certificate
implements Handshake.Body {
    private final X509Certificate[] certs;

    static final Certificate read(InputStream inputStream, CertificateType certificateType) throws IOException {
        if (certificateType == CertificateType.X509) {
            int n = (inputStream.read() & 0xFF) << 16 | (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = inputStream.read(byArray, n2, n - n2);
                if (n3 == -1) {
                    throw new EOFException("unexpected end of stream");
                }
                n2 += n3;
            }
            try {
                LinkedList linkedList = new LinkedList();
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                n2 = 0;
                while (n2 < n) {
                    int n4 = (byteArrayInputStream.read() & 0xFF) << 16 | (byteArrayInputStream.read() & 0xFF) << 8 | byteArrayInputStream.read() & 0xFF;
                    linkedList.add(certificateFactory.generateCertificate(byteArrayInputStream));
                    n2 += n4 + 3;
                }
                return new Certificate((X509Certificate[])linkedList.toArray(new X509Certificate[linkedList.size()]));
            }
            catch (CertificateException certificateException) {
                SSLProtocolException sSLProtocolException = new SSLProtocolException(certificateException.getMessage());
                sSLProtocolException.initCause(certificateException);
                throw sSLProtocolException;
            }
        }
        if (certificateType == CertificateType.OPEN_PGP) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        throw new Error("unsupported certificate type " + certificateType);
    }

    public final void write(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = 0;
            while (n < this.certs.length) {
                byte[] byArray = this.certs[n].getEncoded();
                byteArrayOutputStream.write(byArray.length >>> 16 & 0xFF);
                byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
                byteArrayOutputStream.write(byArray.length & 0xFF);
                byteArrayOutputStream.write(byArray);
                ++n;
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new Error("cannot encode certificates");
        }
        catch (IOException iOException) {}
        outputStream.write(byteArrayOutputStream.size() >>> 16 & 0xFF);
        outputStream.write(byteArrayOutputStream.size() >>> 8 & 0xFF);
        outputStream.write(byteArrayOutputStream.size() & 0xFF);
        byteArrayOutputStream.writeTo(outputStream);
    }

    final X509Certificate[] getCertificates() {
        return this.certs;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.println("  certificateList =");
        int n = 0;
        while (n < this.certs.length) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(this.certs[n].toString()));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.print("    ");
                    printWriter.println(string);
                }
            }
            catch (IOException iOException) {}
            ++n;
        }
        printWriter.println("} Certificate;");
        return stringWriter.toString();
    }

    Certificate(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null) {
            throw new NullPointerException();
        }
        this.certs = x509CertificateArray;
    }
}

