/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MemoryHandler
extends Handler {
    private final LogRecord[] buffer;
    private int position;
    private int numPublished;
    private Level pushLevel;
    private final Handler target;
    static /* synthetic */ Class class$java$util$logging$Handler;
    static /* synthetic */ Class class$java$util$logging$Filter;

    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        this.buffer[this.position] = logRecord;
        this.position = (this.position + 1) % this.buffer.length;
        ++this.numPublished;
        if (logRecord.getLevel().intValue() >= this.pushLevel.intValue()) {
            this.push();
        }
    }

    public void push() {
        if (this.numPublished < this.buffer.length) {
            int n = 0;
            while (n < this.position) {
                this.target.publish(this.buffer[n]);
                ++n;
            }
        } else {
            int n = this.position;
            while (n < this.buffer.length) {
                this.target.publish(this.buffer[n]);
                ++n;
            }
            n = 0;
            while (n < this.position) {
                this.target.publish(this.buffer[n]);
                ++n;
            }
        }
        this.numPublished = 0;
        this.position = 0;
    }

    public void flush() {
        this.target.flush();
    }

    public void close() throws SecurityException {
        this.push();
        this.target.close();
    }

    public Level getPushLevel() {
        return this.pushLevel;
    }

    public void setPushLevel(Level level) {
        LogManager.getLogManager().checkAccess();
        level.getClass();
        this.pushLevel = level;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public MemoryHandler() {
        Class clazz = class$java$util$logging$Handler;
        if (clazz == null) {
            clazz = class$java$util$logging$Handler = MemoryHandler.class("[Ljava.util.logging.Handler;", false);
        }
        this((Handler)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.target", clazz, null), LogManager.getIntPropertyClamped("java.util.logging.MemoryHandler.size", 1000, 1, Integer.MAX_VALUE), LogManager.getLevelProperty("java.util.logging.MemoryHandler.push", Level.SEVERE));
    }

    public MemoryHandler(Handler handler, int n, Level level) {
        if (handler == null || n <= 0 || level == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = new LogRecord[n];
        this.pushLevel = level;
        this.target = handler;
        this.setLevel(LogManager.getLevelProperty("java.util.logging.MemoryHandler.level", Level.ALL));
        Class clazz = class$java$util$logging$Filter;
        if (clazz == null) {
            clazz = class$java$util$logging$Filter = MemoryHandler.class("[Ljava.util.logging.Filter;", false);
        }
        this.setFilter((Filter)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.filter", clazz, null));
    }
}

