/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;

public abstract class View
implements SwingConstants {
    public static final int BadBreakWeight = 0;
    public static final int ExcellentBreakWeight = 2000;
    public static final int ForcedBreakWeight = 3000;
    public static final int GoodBreakWeight = 1000;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private float width;
    private float height;
    private Element elt;
    private View parent;

    public abstract void paint(Graphics var1, Shape var2);

    public void setParent(View view) {
        if (view == null) {
            int n = this.getViewCount();
            int n2 = 0;
            while (n2 < n) {
                this.getView(n2).setParent(null);
                ++n2;
            }
        }
        this.parent = view;
    }

    public View getParent() {
        return this.parent;
    }

    public Container getContainer() {
        View view = this.getParent();
        if (view == null) {
            return null;
        }
        return view.getContainer();
    }

    public Document getDocument() {
        return this.getElement().getDocument();
    }

    public Element getElement() {
        return this.elt;
    }

    public abstract float getPreferredSpan(int var1);

    public int getResizeWeight(int n) {
        return 0;
    }

    public float getMaximumSpan(int n) {
        float f = 2.1474836E9f;
        if (this.getResizeWeight(n) <= 0) {
            f = this.getPreferredSpan(n);
        }
        return f;
    }

    public float getMinimumSpan(int n) {
        float f = 0.0f;
        if (this.getResizeWeight(n) <= 0) {
            f = this.getPreferredSpan(n);
        }
        return f;
    }

    public void setSize(float f, float f2) {
    }

    public float getAlignment(int n) {
        return 0.5f;
    }

    public AttributeSet getAttributes() {
        return this.getElement().getAttributes();
    }

    public boolean isVisible() {
        return true;
    }

    public int getViewCount() {
        return 0;
    }

    public View getView(int n) {
        return null;
    }

    public ViewFactory getViewFactory() {
        View view = this.getParent();
        return view != null ? view.getViewFactory() : null;
    }

    public void replace(int n, int n2, View[] viewArray) {
    }

    public void insert(int n, View view) {
        View[] viewArray = new View[]{view};
        this.replace(n, 1, viewArray);
    }

    public void append(View view) {
        View[] viewArray = new View[]{view};
        int n = this.getViewCount();
        this.replace(n, 0, viewArray);
    }

    public void removeAll() {
        this.replace(0, this.getViewCount(), new View[0]);
    }

    public void remove(int n) {
        this.replace(n, 1, null);
    }

    public View createFragment(int n, int n2) {
        return this;
    }

    public int getStartOffset() {
        return this.getElement().getStartOffset();
    }

    public int getEndOffset() {
        return this.getElement().getEndOffset();
    }

    public Shape getChildAllocation(int n, Shape shape) {
        return null;
    }

    public int getViewIndex(float f, float f2, Shape shape) {
        return -1;
    }

    public String getToolTipText(float f, float f2, Shape shape) {
        int n = this.getViewIndex(f, f2, shape);
        if (n < -1) {
            return null;
        }
        Shape shape2 = this.getChildAllocation(n, shape);
        if (shape2.getBounds().contains(f, f2)) {
            return this.getView(n).getToolTipText(f, f2, shape2);
        }
        return null;
    }

    public Graphics getGraphics() {
        return this.getContainer().getGraphics();
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (this.parent != null) {
            this.parent.preferenceChanged(this, bl, bl2);
        }
    }

    public int getBreakWeight(int n, float f, float f2) {
        return 0;
    }

    public View breakView(int n, int n2, float f, float f2) {
        return this;
    }

    public int getViewIndex(int n, Position.Bias bias) {
        return -1;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateChildren(elementChange, documentEvent, viewFactory);
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateChildren(elementChange, documentEvent, viewFactory);
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateChildren(elementChange, documentEvent, viewFactory);
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        Element[] elementArray = elementChange.getChildrenAdded();
        Element[] elementArray2 = elementChange.getChildrenRemoved();
        int n = elementChange.getIndex();
        View[] viewArray = new View[elementArray.length];
        int n2 = 0;
        while (n2 < elementArray.length) {
            viewArray[n2] = viewFactory.create(elementArray[n2]);
            ++n2;
        }
        this.replace(n, elementArray2.length, viewArray);
        return true;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        int n = this.getViewCount();
        if (n > 0) {
            int n2 = documentEvent.getOffset();
            int n3 = n2 + documentEvent.getLength();
            int n4 = this.getViewIndex(n2, Position.Bias.Backward);
            int n5 = this.getViewIndex(n3, Position.Bias.Forward);
            int n6 = -1;
            int n7 = -1;
            if (elementChange != null) {
                n6 = elementChange.getIndex();
                n7 = elementChange.getChildrenAdded().length;
            }
            if (n4 >= 0 && n5 >= 0) {
                int n8 = n4;
                while (n8 <= n5) {
                    if (n6 < 0 || n8 < n6 || n8 >= n6 + n7) {
                        View view = this.getView(n8);
                        this.forwardUpdateToView(view, documentEvent, shape, viewFactory);
                    }
                    ++n8;
                }
            }
        }
    }

    protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        DocumentEvent.EventType eventType = documentEvent.getType();
        if (eventType == DocumentEvent.EventType.INSERT) {
            view.insertUpdate(documentEvent, shape, viewFactory);
        } else if (eventType == DocumentEvent.EventType.REMOVE) {
            view.removeUpdate(documentEvent, shape, viewFactory);
        } else if (eventType == DocumentEvent.EventType.CHANGE) {
            view.changedUpdate(documentEvent, shape, viewFactory);
        }
    }

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        Container container;
        if (elementChange != null && shape != null) {
            this.preferenceChanged(null, true, true);
        }
        if ((container = this.getContainer()) != null) {
            container.repaint();
        }
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        if (bias != Position.Bias.Forward && bias != Position.Bias.Backward) {
            throw new IllegalArgumentException("b1 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        if (bias2 != Position.Bias.Forward && bias2 != Position.Bias.Backward) {
            throw new IllegalArgumentException("b2 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        Rectangle rectangle = (Rectangle)this.modelToView(n, shape, bias);
        Rectangle rectangle2 = (Rectangle)this.modelToView(n2, shape, bias2);
        return SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        return this.modelToView(n, shape, Position.Bias.Forward);
    }

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);

    public int viewToModel(float f, float f2, Shape shape) {
        return this.viewToModel(f, f2, shape, new Position.Bias[0]);
    }

    protected void dump() {
        View view = this.getParent();
        if (view != null) {
            view.dump();
        } else {
            this.dump(0);
        }
    }

    void dump(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print('.');
            ++n2;
        }
        System.out.println(this + '(' + this.getStartOffset() + ',' + this.getEndOffset() + ": " + this.getElement());
        n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            this.getView(n3).dump(n + 1);
            ++n3;
        }
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = n;
        switch (n2) {
            case 7: {
                n3 = n - 1;
                break;
            }
            case 3: {
                n3 = n + 1;
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for d");
            }
        }
        return n3;
    }

    public View(Element element) {
        this.elt = element;
    }
}

