/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.stat;

import java.util.concurrent.locks.ReentrantLock;

public class LinearRegression {
    private final ReentrantLock mathLock = new ReentrantLock();
    private int numberDataPoints;
    private double sumxx;
    private double sumyy;
    private double sumxy;
    private double sumx;
    private double sumy;
    private double xIntercept;
    private double yIntercept;
    private double slope;
    private double correlationCoefficient;

    public LinearRegression() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataPoint(double x, double y) {
        try {
            this.mathLock.lock();
            ++this.numberDataPoints;
            this.sumx += x;
            this.sumy += y;
            this.sumxx += x * x;
            this.sumyy += y * y;
            this.sumxy += x * y;
        }
        finally {
            this.mathLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataPoints(double[] x, double[] y) {
        assert (x.length == y.length);
        try {
            this.mathLock.lock();
            for (int i = 0; i < x.length; ++i) {
                this.addDataPoint(x[i], y[i]);
            }
        }
        finally {
            this.mathLock.unlock();
        }
    }

    public void reset() {
        try {
            this.mathLock.lock();
            this.xIntercept = Double.NaN;
            this.yIntercept = Double.NaN;
            this.slope = Double.NaN;
            this.correlationCoefficient = 0.0;
            this.numberDataPoints = 0;
            this.sumxx = 0.0;
            this.sumyy = 0.0;
            this.sumxy = 0.0;
            this.sumx = 0.0;
            this.sumy = 0.0;
        }
        finally {
            this.mathLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regress() {
        try {
            this.mathLock.lock();
            if (this.numberDataPoints > 1) {
                double top = (double)this.numberDataPoints * this.sumxy - this.sumx * this.sumy;
                double bottom = (double)this.numberDataPoints * this.sumxx - this.sumx * this.sumx;
                this.slope = top / bottom;
                this.yIntercept = (this.sumy - this.slope * this.sumx) / (double)this.numberDataPoints;
                this.xIntercept = -this.yIntercept / this.slope;
                double corTop = (double)this.numberDataPoints * this.sumxy - this.sumx * this.sumy;
                double corBottomLeft = (double)this.numberDataPoints * this.sumxx - this.sumx * this.sumx;
                double corBottomRight = (double)this.numberDataPoints * this.sumyy - this.sumy * this.sumy;
                this.correlationCoefficient = corTop / Math.sqrt(corBottomLeft * corBottomRight);
            }
        }
        finally {
            this.mathLock.unlock();
        }
    }

    public double getXIntercept() {
        return this.xIntercept;
    }

    public double getYIntercept() {
        return this.yIntercept;
    }

    public double getSlope() {
        return this.slope;
    }

    public double getCorrelationCoefficient() {
        return this.correlationCoefficient;
    }
}

