/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JTabbedPane
extends JComponent
implements Serializable,
Accessible,
SwingConstants {
    private static final long serialVersionUID = 1614381073220130939L;
    public static final int SCROLL_TAB_LAYOUT = 1;
    public static final int WRAP_TAB_LAYOUT = 0;
    protected ChangeEvent changeEvent;
    protected ChangeListener changeListener;
    protected SingleSelectionModel model;
    protected int tabPlacement;
    private transient int layoutPolicy;
    transient Vector tabs;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public void setUI(TabbedPaneUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "TabbedPaneUI";
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener l) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JTabbedPane.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JTabbedPane.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireStateChanged() {
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int i = changeListeners.length - 2;
        while (i >= 0) {
            Object object = changeListeners[i];
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = JTabbedPane.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            if (object == clazz) {
                ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JTabbedPane.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])super.getListeners(clazz);
    }

    public SingleSelectionModel getModel() {
        return this.model;
    }

    public void setModel(SingleSelectionModel model) {
        if (model != this.model) {
            SingleSelectionModel oldModel = this.model;
            this.model.removeChangeListener(this.changeListener);
            this.model = model;
            this.model.addChangeListener(this.changeListener);
            this.firePropertyChange("model", oldModel, this.model);
        }
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement != 1 && tabPlacement != 3 && tabPlacement != 4 && tabPlacement != 2) {
            throw new IllegalArgumentException("tabPlacement is not valid.");
        }
        if (tabPlacement != this.tabPlacement) {
            int oldPlacement = this.tabPlacement;
            this.tabPlacement = tabPlacement;
            this.firePropertyChange("tabPlacement", oldPlacement, this.tabPlacement);
        }
    }

    public int getTabLayoutPolicy() {
        return this.layoutPolicy;
    }

    public void setTabLayoutPolicy(int tabLayoutPolicy) {
        if (tabLayoutPolicy != 1 && tabLayoutPolicy != 0) {
            throw new IllegalArgumentException("tabLayoutPolicy is not valid.");
        }
        if (tabLayoutPolicy != this.layoutPolicy) {
            int oldPolicy = this.layoutPolicy;
            this.layoutPolicy = tabLayoutPolicy;
            this.firePropertyChange("tabLayoutPolicy", oldPolicy, this.layoutPolicy);
        }
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    private final void checkIndex(int index, int start, int end) {
        if (index < start || index >= end) {
            throw new IndexOutOfBoundsException("Index < " + start + " || Index >= " + end);
        }
    }

    public void setSelectedIndex(int index) {
        this.checkIndex(index, -1, this.tabs.size());
        if (index != this.getSelectedIndex()) {
            if (this.getSelectedIndex() != -1 && this.getSelectedComponent() != null) {
                this.getSelectedComponent().hide();
            }
            if (index != -1 && this.getComponentAt(index) != null) {
                this.getComponentAt(index).show();
            }
            this.model.setSelectedIndex(index);
        }
    }

    public Component getSelectedComponent() {
        return this.getComponentAt(this.getSelectedIndex());
    }

    public void setSelectedComponent(Component c) {
        if (c.getParent() == this) {
            this.setSelectedIndex(this.indexOfComponent(c));
        } else {
            this.setComponentAt(this.getSelectedIndex(), c);
        }
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        if (title == null) {
            title = "";
        }
        Page p = new Page(title, icon, component, tip);
        this.tabs.insertElementAt(p, index);
        if (component != null) {
            component.hide();
            super.add(component);
        }
        if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
        this.layout();
        this.repaint();
    }

    public void addTab(String title, Icon icon, Component component, String tip) {
        this.insertTab(title, icon, component, tip, this.tabs.size());
    }

    public void addTab(String title, Icon icon, Component component) {
        this.insertTab(title, icon, component, null, this.tabs.size());
    }

    public void addTab(String title, Component component) {
        this.insertTab(title, null, component, null, this.tabs.size());
    }

    public Component add(Component component) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(component.getName(), null, component, null, this.tabs.size());
        }
        return component;
    }

    public Component add(String title, Component component) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(title, null, component, null, this.tabs.size());
        }
        return component;
    }

    public Component add(Component component, int index) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(component.getName(), null, component, null, index);
        }
        return component;
    }

    public void add(Component component, Object constraints) {
        this.add(component, constraints, this.tabs.size());
    }

    public void add(Component component, Object constraints, int index) {
        if (component instanceof UIResource) {
            super.add(component);
        } else if (constraints instanceof String) {
            this.insertTab((String)constraints, null, component, null, index);
        } else {
            this.insertTab(component.getName(), constraints instanceof Icon ? (Icon)constraints : null, component, null, index);
        }
    }

    public void removeTabAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        Component c = this.getComponentAt(index);
        super.remove(index);
        c.show();
        this.tabs.remove(index);
    }

    public void remove(Component component) {
        int index = this.indexOfComponent(component);
        super.remove(component);
        component.show();
        this.setComponentAt(index, null);
    }

    public void remove(int index) {
        this.removeTabAt(index);
    }

    public void removeAll() {
        int i = this.tabs.size() - 1;
        while (i >= 0) {
            this.removeTabAt(i);
            --i;
        }
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public int getTabRunCount() {
        return ((TabbedPaneUI)this.ui).getTabRunCount(this);
    }

    public String getTitleAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getTitle();
    }

    public Icon getIconAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getIcon();
    }

    public Icon getDisabledIconAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getDisabledIcon();
    }

    public String getToolTipTextAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getTip();
    }

    public Color getForegroundAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getForeground();
    }

    public Color getBackgroundAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getBackground();
    }

    public Component getComponentAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).getComponent();
    }

    public boolean isEnabledAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(index)).isEnabled();
    }

    public int getMnemonicAt(int tabIndex) {
        this.checkIndex(tabIndex, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(tabIndex)).getMnemonic();
    }

    public int getDisplayedMnemonicIndexAt(int tabIndex) {
        this.checkIndex(tabIndex, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(tabIndex)).getDisplayedMnemonicIndex();
    }

    public Rectangle getBoundsAt(int index) {
        this.checkIndex(index, 0, this.tabs.size());
        return ((TabbedPaneUI)this.ui).getTabBounds(this, index);
    }

    public void setTitleAt(int index, String title) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setTitle(title);
    }

    public void setIconAt(int index, Icon icon) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setIcon(icon);
    }

    public void setDisabledIconAt(int index, Icon disabledIcon) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setDisabledIcon(disabledIcon);
    }

    public void setToolTipTextAt(int index, String toolTipText) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setTip(toolTipText);
    }

    public void setBackgroundAt(int index, Color background) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setBackground(background);
    }

    public void setForegroundAt(int index, Color foreground) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setForeground(foreground);
    }

    public void setEnabledAt(int index, boolean enabled) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setEnabled(enabled);
    }

    public void setComponentAt(int index, Component component) {
        this.checkIndex(index, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(index)).setComponent(component);
    }

    public void setDisplayedMnemonicIndexAt(int tabIndex, int mnemonicIndex) {
        this.checkIndex(tabIndex, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(tabIndex)).setDisplayedMnemonicIndex(mnemonicIndex);
    }

    public void setMnemonicAt(int tabIndex, int mnemonic) {
        this.checkIndex(tabIndex, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(tabIndex)).setMnemonic(mnemonic);
    }

    public int indexOfTab(String title) {
        int index = -1;
        int i = 0;
        while (i < this.tabs.size()) {
            if (((Page)this.tabs.elementAt(i)).getTitle().equals(title)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int indexOfTab(Icon icon) {
        int index = -1;
        int i = 0;
        while (i < this.tabs.size()) {
            if (((Page)this.tabs.elementAt(i)).getIcon() == icon) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int indexOfComponent(Component component) {
        int index = -1;
        int i = 0;
        while (i < this.tabs.size()) {
            if (((Page)this.tabs.elementAt(i)).getComponent() == component) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int indexAtLocation(int x, int y) {
        return ((TabbedPaneUI)this.ui).tabForCoordinate(this, x, y);
    }

    public String getToolTipText(MouseEvent event) {
        int index = this.indexAtLocation(event.getX(), event.getY());
        return ((Page)this.tabs.elementAt(index)).getTip();
    }

    protected String paramString() {
        return "JTabbedPane";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.tabPlacement = 1;
        this.tabs = new Vector();
    }

    public JTabbedPane() {
        this(1, 0);
    }

    public JTabbedPane(int tabPlacement) {
        this(tabPlacement, 0);
    }

    public JTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        this.this();
        if (tabPlacement != 1 && tabPlacement != 3 && tabPlacement != 4 && tabPlacement != 2) {
            throw new IllegalArgumentException("tabPlacement is not valid.");
        }
        if (tabLayoutPolicy != 1 && tabLayoutPolicy != 0) {
            throw new IllegalArgumentException("tabLayoutPolicy is not valid.");
        }
        this.tabPlacement = tabPlacement;
        this.layoutPolicy = tabLayoutPolicy;
        this.changeEvent = new ChangeEvent(this);
        this.changeListener = this.createChangeListener();
        this.model = new DefaultSingleSelectionModel();
        this.model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ModelListener
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = 497359819958114132L;

        public void stateChanged(ChangeEvent e) {
            JTabbedPane.this.fireStateChanged();
        }

        protected ModelListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Page {
        private static final long serialVersionUID = 1614381073220130939L;
        private String tip;
        private Component component;
        private transient Icon icon;
        private transient Icon disabledIcon;
        private transient boolean enabled;
        private transient String title;
        private transient Color bg;
        private transient Color fg;
        private transient int mnemonicKey;
        private transient int underlinedChar;

        public Component getComponent() {
            return this.component;
        }

        public void setComponent(Component c) {
            JTabbedPane.this.remove(this.component);
            this.component = c;
            JTabbedPane.this.add(c);
        }

        public String getTip() {
            return this.tip;
        }

        public void setTip(String tip) {
            this.tip = tip;
        }

        public Color getBackground() {
            return this.bg;
        }

        public void setBackground(Color background) {
            this.bg = background;
        }

        public Color getForeground() {
            return this.fg;
        }

        public void setForeground(Color foreground) {
            this.fg = foreground;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String text) {
            this.title = text;
            if (this.title != null && this.title.length() <= this.underlinedChar) {
                this.setDisplayedMnemonicIndex(this.title.length() - 1);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getDisabledIcon() {
            if (this.disabledIcon == null && this.icon instanceof ImageIcon) {
                this.setDisabledIcon(this.icon);
            }
            return this.disabledIcon;
        }

        public void setDisabledIcon(Icon disabledIcon) {
            this.disabledIcon = disabledIcon;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getMnemonic() {
            return this.mnemonicKey;
        }

        public void setMnemonic(int key) {
            this.setMnemonic((char)key);
        }

        public void setMnemonic(char aChar) {
            this.mnemonicKey = aChar;
            if (this.title != null) {
                this.setDisplayedMnemonicIndex(this.title.indexOf(this.mnemonicKey));
            }
        }

        public int getDisplayedMnemonicIndex() {
            return this.underlinedChar;
        }

        public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
            if (index < -1 || this.title != null && index >= this.title.length()) {
                throw new IllegalArgumentException();
            }
            if (this.title == null || this.mnemonicKey == 0 || index > -1 && this.title.charAt(index) != this.mnemonicKey) {
                index = -1;
            }
            this.underlinedChar = index;
        }

        private final /* synthetic */ void this() {
            this.enabled = true;
            this.underlinedChar = -1;
        }

        protected Page(String title, Icon icon, Component component, String tip) {
            this.this();
            this.title = title;
            this.icon = icon;
            this.component = component;
            this.tip = tip;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        private static final long serialVersionUID = 7610530885966830483L;

        public void stateChanged(ChangeEvent e) {
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return null;
        }

        public Accessible getAccessibleAt(Point p) {
            return null;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public Accessible getAccessibleSelection(int i) {
            return null;
        }

        public boolean isAccessibleChildSelected(int i) {
            return false;
        }

        public void addAccessibleSelection(int i) {
        }

        public void removeAccessibleSelection(int i) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

